/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class RawTypeBinding
extends ParameterizedTypeBinding {
    public RawTypeBinding(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        super(referenceBinding, null, referenceBinding2, lookupEnvironment);
        ParameterizedTypeBinding parameterizedTypeBinding;
        this.tagBits &= 0xFFFFFFFFFFFFFF7FL;
        if ((referenceBinding.tagBits & 0x80L) != 0L) {
            if (referenceBinding instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            } else if (referenceBinding instanceof ParameterizedTypeBinding && (parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding).genericType() instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            }
        }
        if (referenceBinding2 != null && (referenceBinding2.tagBits & 0x80L) != 0L) {
            if (referenceBinding2 instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            } else if (referenceBinding2 instanceof ParameterizedTypeBinding && (parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding2).genericType() instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            }
        }
        if (referenceBinding2 == null || !this.hasEnclosingInstanceContext() || (referenceBinding2.modifiers & 0x40000000) == 0) {
            this.modifiers &= 0xBFFFFFFF;
        }
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && (this.enclosingType().isParameterizedType() || this.enclosingType().isRawType())) {
            char[] cArray;
            if (!this.hasEnclosingInstanceContext()) {
                cArray = this.enclosingType().signature();
                stringBuffer.append(cArray, 0, cArray.length - 1);
                stringBuffer.append('$');
            } else {
                cArray = this.enclosingType().computeUniqueKey(false);
                stringBuffer.append(cArray, 0, cArray.length - 1);
                stringBuffer.append('.');
            }
            stringBuffer.append(this.sourceName());
            if (this.genericType().typeVariables() != Binding.NO_TYPE_VARIABLES) {
                stringBuffer.append('<').append('>');
            }
            stringBuffer.append(';');
        } else {
            stringBuffer.append(this.genericType().computeUniqueKey(false));
            stringBuffer.insert(stringBuffer.length() - 1, "<>");
        }
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        return new RawTypeBinding(this.actualType(), (ReferenceBinding)typeBinding, this.environment);
    }

    @Override
    public TypeBinding withoutToplevelNullAnnotation() {
        if (!this.hasNullTypeAnnotations()) {
            return this;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.environment.getUnannotatedType(this.genericType());
        AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
        return this.environment.createRawType(referenceBinding, this.enclosingType(), annotationBindingArray);
    }

    @Override
    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        if (methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES || methodBinding.isStatic()) {
            return super.createParameterizedMethod(methodBinding);
        }
        return this.environment.createParameterizedGenericMethod(methodBinding, this);
    }

    @Override
    public boolean isParameterizedType() {
        return false;
    }

    @Override
    public int kind() {
        return 1028;
    }

    @Override
    public String debugName() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.actualType().sourceName()).append("#RAW");
        return stringBuffer.toString();
    }

    @Override
    public String annotatedDebugName() {
        StringBuffer stringBuffer = new StringBuffer(super.annotatedDebugName());
        stringBuffer.append("#RAW");
        return stringBuffer.toString();
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            if ((this.modifiers & 0x40000000) == 0) {
                this.genericTypeSignature = this.genericType().signature();
            } else {
                Object object;
                StringBuffer stringBuffer = new StringBuffer(10);
                if (this.isMemberType() && this.hasEnclosingInstanceContext()) {
                    object = this.enclosingType();
                    char[] cArray = ((TypeBinding)object).genericTypeSignature();
                    stringBuffer.append(cArray, 0, cArray.length - 1);
                    if ((((ReferenceBinding)object).modifiers & 0x40000000) != 0) {
                        stringBuffer.append('.');
                    } else {
                        stringBuffer.append('$');
                    }
                    stringBuffer.append(this.sourceName());
                } else {
                    object = this.genericType().signature();
                    stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
                }
                stringBuffer.append(';');
                int n = stringBuffer.length();
                this.genericTypeSignature = new char[n];
                stringBuffer.getChars(0, n, this.genericTypeSignature, 0);
            }
        }
        return this.genericTypeSignature;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (RawTypeBinding.equalsEquals(this, typeBinding) || RawTypeBinding.equalsEquals(this.erasure(), typeBinding)) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: 
            case 1028: 
            case 2052: {
                return TypeBinding.equalsEquals(this.erasure(), typeBinding.erasure());
            }
        }
        return false;
    }

    @Override
    public boolean isProvablyDistinct(TypeBinding typeBinding) {
        if (TypeBinding.equalsEquals(this, typeBinding) || TypeBinding.equalsEquals(this.erasure(), typeBinding)) {
            return false;
        }
        if (typeBinding == null) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 260: 
            case 1028: 
            case 2052: {
                return TypeBinding.notEquals(this.erasure(), typeBinding.erasure());
            }
        }
        return true;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding, boolean bl) {
        if (bl) {
            typeBinding = this.environment.convertToRawType(typeBinding.erasure(), false);
        }
        return super.isSubtypeOf(typeBinding, bl);
    }

    @Override
    public boolean isProperType(boolean bl) {
        ReferenceBinding referenceBinding = this.actualType();
        return referenceBinding != null && ((TypeBinding)referenceBinding).isProperType(bl);
    }

    @Override
    protected void initializeArguments() {
        TypeVariableBinding[] typeVariableBindingArray = this.genericType().typeVariables();
        int n = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            typeBindingArray[i] = this.environment.convertToRawType(typeVariableBindingArray[i].erasure(), false);
        }
        this.arguments = typeBindingArray;
    }

    @Override
    public ParameterizedTypeBinding capture(Scope scope, int n, int n2) {
        return this;
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        return this;
    }

    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        return this;
    }

    @Override
    public MethodBinding getSingleAbstractMethod(Scope scope, boolean bl) {
        ReferenceBinding referenceBinding;
        MethodBinding methodBinding;
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[n] != null) {
                return this.singleAbstractMethod[n];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[2];
        }
        if ((methodBinding = (referenceBinding = this.genericType()).getSingleAbstractMethod(scope, bl)) == null || !methodBinding.isValidBinding()) {
            this.singleAbstractMethod[n] = methodBinding;
            return this.singleAbstractMethod[n];
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)scope.environment().convertToRawType(referenceBinding, true);
        referenceBinding2 = (ReferenceBinding)referenceBinding2.findSuperTypeOriginatingFrom(methodBinding.declaringClass);
        for (MethodBinding methodBinding2 : referenceBinding2.getMethods(methodBinding.selector)) {
            if (!methodBinding2.isAbstract() || methodBinding2.redeclaresPublicObjectMethod(scope)) continue;
            this.singleAbstractMethod[n] = methodBinding2;
            break;
        }
        return this.singleAbstractMethod[n];
    }

    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        return false;
    }

    @Override
    public char[] readableName(boolean bl) {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(bl && this.hasEnclosingInstanceContext()), this.sourceName, '.') : CharOperation.concatWith(this.actualType().compoundName, '.');
        return cArray;
    }

    @Override
    public char[] shortReadableName(boolean bl) {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(bl && this.hasEnclosingInstanceContext()), this.sourceName, '.') : this.actualType().sourceName;
        return cArray;
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
    }

    @Override
    public ReferenceBinding upwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        return this;
    }

    @Override
    public ReferenceBinding downwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        return this;
    }

    @Override
    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }
}

