/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class LongCache {
    public long[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public LongCache() {
        this(13);
    }

    public LongCache(int n) {
        this.threshold = (int)((double)n * 0.66);
        this.keyTable = new long[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = 0L;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(long l2) {
        int n = this.hash(l2);
        int n2 = this.keyTable.length;
        while (this.keyTable[n] != 0L || this.keyTable[n] == 0L && this.valueTable[n] != 0) {
            if (this.keyTable[n] == l2) {
                return true;
            }
            if (++n != n2) continue;
            n = 0;
        }
        return false;
    }

    public int hash(long l2) {
        return ((int)l2 & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(long l2, int n) {
        int n2 = this.hash(l2);
        int n3 = this.keyTable.length;
        while (this.keyTable[n2] != 0L || this.keyTable[n2] == 0L && this.valueTable[n2] != 0) {
            if (this.keyTable[n2] == l2) {
                this.valueTable[n2] = n;
                return this.valueTable[n2];
            }
            if (++n2 != n3) continue;
            n2 = 0;
        }
        this.keyTable[n2] = l2;
        this.valueTable[n2] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    public int putIfAbsent(long l2, int n) {
        int n2 = this.hash(l2);
        int n3 = this.keyTable.length;
        while (this.keyTable[n2] != 0L || this.keyTable[n2] == 0L && this.valueTable[n2] != 0) {
            if (this.keyTable[n2] == l2) {
                return this.valueTable[n2];
            }
            if (++n2 != n3) continue;
            n2 = 0;
        }
        this.keyTable[n2] = l2;
        this.valueTable[n2] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return -n;
    }

    private void rehash() {
        LongCache longCache = new LongCache(this.keyTable.length * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            long l2 = this.keyTable[n];
            int n2 = this.valueTable[n];
            if (l2 == 0L && (l2 != 0L || n2 == 0)) continue;
            longCache.put(l2, n2);
        }
        this.keyTable = longCache.keyTable;
        this.valueTable = longCache.valueTable;
        this.threshold = longCache.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < n; ++i) {
            if (this.keyTable[i] != 0L || this.keyTable[i] == 0L && this.valueTable[i] != 0) {
                stringBuffer.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

