/*
 * Copyright 2009 Vasilkin Andrew <digi@os2.snc.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//#define INCL_LONGLONG
#include <ndfs.h>
#define NDPL_LARGEFILES
#include <ndextpl2.h>
#include <stdlib.h>
#include "resource.h"


typedef struct _CONNECTION {
  PRES		psRes;
} CONNECTION, *PCONNECTION;


const NDPROPERTYINFO asProperties[] =
{
  { ND_PROP_STRING, 0, "CONFIG",	""   },
  { ND_PROP_STRING, 0, NULL,		NULL },
};

const char *NdpTypes[] = { "LQTREE", NULL };
const NDPROPERTYINFO *NdpPropertiesInfo[] = { asProperties };
const unsigned long NdpAttribute = NDPA_REUSE_FILE_CONNECTIONS;

static PLUGINHELPERTABLE2	*ph = NULL;


int APIENTRY NdpPluginLoad(PLUGINHELPERTABLE2 *pPHT2)
{
  DebugInit( DEBUG_FILE );
  ph = pPHT2;
    
  if ( ph->cb < sizeof(PLUGINHELPERTABLE2) )
  {
    debug( "failed" );
    return ERROR_INVALID_FUNCTION;
  }

  resInit();

  return NO_ERROR;
}

int APIENTRY NdpPluginFree()
{
  resDone();
  DebugDone();

  return NO_ERROR;
}

int APIENTRY NdpMountResource(HRESOURCE *presource, int type,
                              NDPROPERTYHANDLE properties)
{
  char const	*pcConfig;
  ULONG		cbConfig;

  ph->fsphQueryStringProperty( properties, "config", &pcConfig, &cbConfig );
  
  return resNew( (PCHAR)pcConfig, (PRES *)presource);
}

int APIENTRY NdpFreeResource(HRESOURCE resource)
{
  PRES		psRes = (PRES)resource;

  resFree( psRes );

  return NO_ERROR;
}

int APIENTRY NdpCreateConnection(HRESOURCE resource, HCONNECTION *pconn)
{
  PRES		psRes = (PRES)resource;
  PCONNECTION	psConnection;

  psConnection = (PCONNECTION)malloc( sizeof( CONNECTION ) );
  psConnection->psRes = psRes;

  *(PCONNECTION *)pconn = psConnection;
  resConnectionNew( psRes );

  return NO_ERROR;
}

int APIENTRY NdpFreeConnection(HCONNECTION conn)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;

  if ( psConnection != NULL )
  {
    resConnectionFree( psConnection->psRes );
    free( psConnection );
  }

  return NO_ERROR;
}

int APIENTRY NdpRsrcCompare(HRESOURCE resource, HRESOURCE resource2)
{
  PRES		psRes = (PRES)resource;
  PRES		psRes2 = (PRES)resource2;
  ULONG		ulRC;

  ulRC = resCompare( psRes, psRes2 );

  return ulRC == NO_ERROR ? ND_RSRC_EQUAL : ND_RSRC_DIFFERENT;
}

int APIENTRY NdpRsrcUpdate(HRESOURCE resource, HRESOURCE resource2)
{
//dbg  debug( "Enter" );
  return NO_ERROR;
}

int APIENTRY NdpRsrcQueryInfo(HRESOURCE resource, ULONG *pulFlags, void *pdata,
                              ULONG insize, ULONG *poutlen)
{
  PRES		psRes = (PRES)resource;
  ULONG		ulRC;
  ULONG		ulMounPoints;

  ulRC = resGetInfo( psRes, (PCHAR)pdata, insize, poutlen, &ulMounPoints );

  if ( (ulRC == NO_ERROR) && (ulMounPoints != 0) )
    *pulFlags = ND_RSRC_AVAILABLE;

  return ulRC;
}

int APIENTRY NdpRsrcQueryFSAttach(HRESOURCE resource, void *pdata, ULONG insize,
                                  ULONG *poutlen)
{
  ULONG		ulFlags;
  ULONG		ulRC;

  ulRC = NdpRsrcQueryInfo( resource, &ulFlags, pdata, insize, poutlen );

  return ulRC;
}

int APIENTRY NdpRsrcQueryFSAllocate(HRESOURCE resource, NDFSALLOCATE *pfsa)
{
  PRES		psRes = (PRES)resource;
  ULONG		ulRC;

  ulRC = resQueryFSAllocate( psRes, &pfsa->cSectorUnit, &pfsa->cUnit,
                             &pfsa->cUnitAvail, &pfsa->cbSector);

  return ulRC;
}


int APIENTRY NdpRefresh(HCONNECTION conn, char *path, int tree)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resRefresh( psConnection->psRes, path, (BOOL)tree );

  return ulRC;
}

int APIENTRY NdpQueryPathInfo(HCONNECTION conn, void *plist, char *szPath)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;
  FILESTATUS3L	sStat;
  NDPATHELEMENT	*psPathElement = ph->fsphNameElem( 0 );

  ulRC = resQueryPathInfo( psConnection->psRes, szPath, &sStat );

  if ( ulRC == NO_ERROR )
  {
    ph->fsphAddFile32L( plist, &sStat, psPathElement->name,
                        psPathElement->length, NULL, 0, 0 );
  }

  return ulRC;
}

int APIENTRY NdpDeletePathInfo(HRESOURCE resource, NDFILEINFO *pfi)
{
  return NO_ERROR;
}

int APIENTRY NdpDiscardResourceData(HRESOURCE resource, NDDATABUF *pdatabuf)
{
  return NO_ERROR;
}

int APIENTRY NdpSetPathInfo(HCONNECTION conn, NDFILEINFO *pfi, char *szPathName)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resSetPathInfo( psConnection->psRes, szPathName, &pfi->stat );

  return ulRC;
}

int APIENTRY NdpSetCurrentDir(HCONNECTION conn, NDFILEINFO *pfi, char *szPath)
{
//dbg  debug( "Enter" );
  return NO_ERROR;
}

int APIENTRY NdpCopy(HCONNECTION conn, NDFILEINFO *pfiDst, char *szDst,
                     NDFILEINFO *pfiSrc, char *szSrc, ULONG ulOption)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  PRES		psRes = psConnection->psRes;
  ULONG		ulRC;

  ulRC = resCopy( psRes, psRes, szSrc, szDst, ulOption );

  return ulRC;
}

int APIENTRY NdpCopy2(HCONNECTION conn, HRESOURCE resDst, NDFILEINFO *pfiDst,
                      char *szDst, NDFILEINFO *pfiSrc, char *szSrc,
                      ULONG ulOption)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  PRES		psResDst = (PRES)resDst;
  ULONG		ulRC;

  ulRC = resCopy( psConnection->psRes, psResDst, szSrc, szDst, ulOption );

  return ulRC;
}

int APIENTRY NdpForceDelete(HCONNECTION conn, NDFILEINFO *pfi, char *szFile)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resDelete( psConnection->psRes, szFile );

  return ulRC;
}

int APIENTRY NdpCreateDir(HCONNECTION conn, NDFILEINFO *pfiparent,
                          char *szDirName, FEALIST *pFEAList)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resCreateDir( psConnection->psRes, szDirName );

  return ulRC;
}


static BOOL _ndpFileListItem(PFILEFINDBUF3L psFind, PVOID pFNData)
{
  ph->fsphAddFile32L( pFNData, (FILESTATUS3L *)&psFind->fdateCreation,
                      psFind->achName, psFind->cchName, NULL, 0, 0 );

  return TRUE;
}

int APIENTRY NdpFindStart(HCONNECTION conn, void *plist, NDFILEINFO *pfiparent,
                          char *szPath, ULONG ulAttribute)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resList( psConnection->psRes, szPath, ulAttribute, _ndpFileListItem,
                  plist );

  return ulRC;
}


int APIENTRY NdpMove(HCONNECTION conn, NDFILEINFO *pfiDst, char *szDst,
                     NDFILEINFO *pfiSrc, char *szSrc)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  PRES		psRes = psConnection->psRes;
  ULONG		ulRC;

  ulRC = resMove( psRes, psRes, szSrc, szDst );

  return ulRC;
}

int APIENTRY NdpMove2(HCONNECTION conn, HRESOURCE resDst, NDFILEINFO *pfiDst,
                      char *szDst, NDFILEINFO *pfiSrc, char *szSrc)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  PRES		psResDst = (PRES)resDst;
  ULONG		ulRC;

  ulRC = resMove( psConnection->psRes, psResDst, szSrc, szDst );

  return ulRC;
}

int APIENTRY NdpChangeCase(HCONNECTION conn, char *szDst, NDFILEINFO *pfiSrc,
                           char *szSrc, char *szNewName, ULONG ulNameLen)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  PRES		psRes = psConnection->psRes;
  ULONG		ulRC;

  ulRC = resMove( psRes, psRes, szSrc, szDst );

  return ulRC;
}

int APIENTRY NdpRename(HCONNECTION conn, char *szDst, NDFILEINFO *pfiSrc,
                       char *szSrc, char *szNewName, ULONG ulNameLen)
{
  return NdpChangeCase( conn, szDst, pfiSrc, szSrc, szNewName, ulNameLen );
}

int APIENTRY NdpOpenExisting(HCONNECTION conn, NDFILEINFO *pfi,
                             NDFILEHANDLE *phandle, char *szFileName,
                             ULONG ulOpenMode, USHORT *pfNeedEA)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;
  LONGLONG	llSize = { 0 };

  ulRC = resOpen( psConnection->psRes, szFileName, (PHFILE)phandle, llSize,
                  FILE_NORMAL, OPEN_EXISTING, ulOpenMode & 0xFFFF );

  return ulRC;
}

int APIENTRY NdpOpenReplaceL(HCONNECTION conn, NDFILEINFO *pfi,
                             NDFILEHANDLE *phandle, char *szFileName,
                             LONGLONG llSize, ULONG ulOpenMode,
                             ULONG ulAttribute, FEALIST *pFEAList)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resOpen( psConnection->psRes, szFileName, (PHFILE)phandle, llSize,
                  ulAttribute, OPEN_REPLACE, ulOpenMode & 0xFFFF );

  return ulRC;
}

int APIENTRY NdpOpenCreateL(HCONNECTION conn, NDFILEINFO *pfiparent,
                            NDFILEHANDLE *phandle, char *szFileName,
                            LONGLONG llSize, ULONG ulOpenMode,
                            ULONG ulAttribute, FEALIST *pFEAList)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resOpen( psConnection->psRes, szFileName, (PHFILE)phandle, llSize,
                  ulAttribute, OPEN_CREATE, ulOpenMode & 0xFFFF );

  return ulRC;
}

int APIENTRY NdpDeleteDir(HCONNECTION conn, NDFILEINFO *pfi, char *szDir)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resDeleteDir( psConnection->psRes, szDir );

  return ulRC;
}

int APIENTRY NdpSetFileAttribute(HCONNECTION conn, NDFILEINFO *pfi,
                                 char *szFileName, USHORT usAttr)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resSetFileAttribute( psConnection->psRes, szFileName, usAttr );

  return ulRC;
}

int APIENTRY NdpFlush(HRESOURCE resource)
{
  PRES		psRes = (PRES)resource;
  ULONG		ulRC;

  ulRC = resFlush( psRes );

  return ulRC;
}

//#pragma off(unreferenced)
int APIENTRY NdpIOCTL(int type, HRESOURCE resource, char *path, int function,
                       void *in, ULONG insize, PULONG poutlen)
//#pragma on(unreferenced)
{
//  return ERROR_NOT_SUPPORTED;
  return NO_ERROR;
}

int APIENTRY NdpFileQueryInfo(HCONNECTION conn, NDFILEHANDLE handle,
                              void *plist)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;
  FILESTATUS3L	sStat;

  ulRC = resFileQueryInfo( psConnection->psRes, (HFILE)handle, &sStat );

  if ( ulRC == NO_ERROR )
    ulRC = ph->fsphAddFile32L( plist, &sStat, NULL, 0, NULL, 0, 0 );

  return ulRC;
}

int APIENTRY NdpFileEAQuery(HCONNECTION conn, NDFILEHANDLE handle, GEALIST *pGEAList, FEALIST *pFEAList)
{
  return ERROR_NOT_SUPPORTED;
}

int APIENTRY NdpFileEASet(HCONNECTION conn, NDFILEHANDLE handle, FEALIST *pFEAList)
{
  return ERROR_NOT_SUPPORTED;
}

int APIENTRY NdpFileSetInfo(HCONNECTION conn, NDFILEHANDLE handle,
                            NDFILEINFO *pfi)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resFileSetInfo( psConnection->psRes, (HFILE)handle, &pfi->stat );

  return ulRC;
}

int APIENTRY NdpFileSetFilePtrL(HCONNECTION conn, NDFILEHANDLE handle,
                                LONGLONG llOffset, ULONG ulMethod,
                                LONGLONG *pllActual)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resFileSetFilePtr( psConnection->psRes, (HFILE)handle, llOffset,
                            ulMethod, pllActual );

  return ulRC;
}

int APIENTRY NdpFileClose(HCONNECTION conn, NDFILEHANDLE handle)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resFileClose( psConnection->psRes, (HFILE)handle );

  return ulRC;
}

int APIENTRY NdpFileCommit(HCONNECTION conn, NDFILEHANDLE handle)
{
  return NO_ERROR;
}

int APIENTRY NdpFileNewSizeL(HCONNECTION conn, NDFILEHANDLE handle,
                             LONGLONG llLen)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resFileNewSize( psConnection->psRes, (HFILE)handle, llLen );

  return ulRC;
}

int APIENTRY NdpFileRead(HCONNECTION conn, NDFILEHANDLE handle, void *pBuffer,
                         ULONG ulRead, ULONG *pulActual)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resFileRead( psConnection->psRes, (HFILE)handle, pBuffer, ulRead,
                      pulActual );

  return ulRC;
}

int APIENTRY NdpFileWrite(HCONNECTION conn, NDFILEHANDLE handle, void *pBuffer,
                          ULONG ulWrite, ULONG *pulActual)
{
  PCONNECTION	psConnection = (PCONNECTION)conn;
  ULONG		ulRC;

  ulRC = resFileWrite( psConnection->psRes, (HFILE)handle, pBuffer, ulWrite,
                       pulActual );

  return ulRC;
}

int APIENTRY NdpEAQuery(HCONNECTION conn, GEALIST *pGEAList, NDFILEINFO *pfi, FEALIST *pFEAList)
{
  return ERROR_NOT_SUPPORTED;
}

int APIENTRY NdpEASet(HCONNECTION conn, FEALIST *pFEAList, NDFILEINFO *pfi)
{
  return ERROR_NOT_SUPPORTED;
}

int APIENTRY NdpEASize(HCONNECTION conn, NDFILEINFO *pfi, ULONG *pulEASize)
{
  *pulEASize = 0;
  return ERROR_NOT_SUPPORTED;
}

int APIENTRY NdpFileEASize(HCONNECTION conn, NDFILEHANDLE handle, ULONG *pulEASize)
{
  return ERROR_NOT_SUPPORTED;
}
