/*
 * Copyright 2009 Vasilkin Andrew <digi@os2.snc.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define INCL_BASE
#define INCL_DOSSEMAPHORES
#define INCL_DOSNMPIPES
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <lqlib.h>

#define LQ_PIPE_NAME		"\\PIPE\\LQ"
#define LQTREE_PIPE_NAME	"\\PIPE\\LQTREE"

static HFILE		hPipe;

static ULONG _ctlOpenPipe(PSZ pszPipeName)
{
  ULONG		ulRC;
  ULONG		ulAction;

  ulRC = DosOpen( pszPipeName, &hPipe, &ulAction,
                  0, FILE_NORMAL, OPEN_ACTION_OPEN_IF_EXISTS,
                  OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, NULL );
  return ulRC;
}

int main(int argc, char *argv[])
{
  ULONG		ulRC;
  ULONG		ulActual;
  CHAR		acBuf[1024];
  PSZ		pszPipeName;
  PSZ		pszCommand;


  if ( argc < 2 )
  {
    printf( "Usage: lqinfo <LQ|LQTREE> [/C]\n" );
    return 1;
  }

  if ( stricmp( argv[1], "LQ" ) == 0 )
  {
    pszPipeName = LQ_PIPE_NAME;
  }
  else if ( stricmp( argv[1], "LQTREE" ) == 0 )
  {
    pszPipeName = LQTREE_PIPE_NAME;
  }
  else
  {
    printf( "Invalid plugin name.\n" );
    return 1;
  }

  if ( ( argc < 3 ) || ( stricmp( argv[2], "/C" ) != 0 ) )
  {
    pszCommand = PIPE_CMD_STAT;
  }
  else
    pszCommand = PIPE_CMD_STAT_COMPACT;


  ulRC = _ctlOpenPipe( pszPipeName );

  if ( ( ulRC == ERROR_PIPE_BUSY ) &&
       ( DosWaitNPipe( pszPipeName, 1000 ) == NO_ERROR ) )
  {
     ulRC = _ctlOpenPipe( pszPipeName );
  }

  if ( ulRC != NO_ERROR )
  {
    printf( "Cannot open pipe. RC=%u\n", ulRC );
    return 1;
  }

  ulRC = DosSetNPHState( hPipe, NP_WAIT );
  if ( ulRC != NO_ERROR )
  {
    printf( "DosSetNPHState(), RC=%u\n", ulRC );
    DosClose( hPipe );
    return 1;
  }
  
  ulRC = lqlibPipeWriteMessage( hPipe, pszCommand );
  if ( ulRC != NO_ERROR )
  {
    printf( "lqlibPipeWriteMessage(), RC=%u\n", ulRC );
    DosClose( hPipe );
    return 1;
  }

  for( pszCommand = "\n%s"; ; )
  {
    ulRC = DosRead( hPipe, &acBuf, sizeof(acBuf) - 1, &ulActual );
    if ( ulRC != NO_ERROR )
    {
      printf( "DosRead(), RC=%u\n", ulRC );
      break;
    }

    acBuf[ulActual] = '\0';

    if ( strcmp( &acBuf, PIPE_REPLY_EOF ) == 0 )
      break;

    printf( pszCommand, &acBuf );
  }

  DosClose( hPipe );
  return 0;
}

