/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import com.sun.jimi.core.filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Shear
extends RGBAllFilter {
    private double angle;

    public Shear(ImageProducer imageProducer, double d) {
        super(imageProducer);
        this.angle = d * Math.PI / 180.0;
    }

    public void filterRGBAll(int n, int n2, int[][] nArray) {
        if (this.angle == 0.0) {
            this.setPixels(n, n2, nArray);
            return;
        }
        double d = Math.tan(this.angle);
        if (d < 0.0) {
            d = -d;
        }
        int n3 = (int)((double)n2 * d + (double)n + 0.999999);
        int[][] nArray2 = new int[n2][n3];
        int n4 = 0;
        while (n4 < n2) {
            double d2 = this.angle > 0.0 ? (double)n4 * d : (double)(n2 - n4) * d;
            int n5 = (int)d2;
            double d3 = d2 - (double)n5;
            double d4 = 1.0 - d3;
            int n6 = 0;
            while (n6 < n3) {
                nArray2[n4][n6] = 0;
                ++n6;
            }
            int n7 = 0;
            int n8 = nArray[n4][0] >> 16 & 0xFF;
            int n9 = nArray[n4][0] >> 8 & 0xFF;
            int n10 = nArray[n4][0] & 0xFF;
            int n11 = 0;
            while (n11 < n) {
                int n12 = nArray[n4][n11];
                int n13 = n12 >> 24 & 0xFF;
                int n14 = n12 >> 16 & 0xFF;
                int n15 = n12 >> 8 & 0xFF;
                int n16 = n12 & 0xFF;
                nArray2[n4][n5 + n11] = (int)(d3 * (double)n7 + d4 * (double)n13) << 24 | (int)(d3 * (double)n8 + d4 * (double)n14) << 16 | (int)(d3 * (double)n9 + d4 * (double)n15) << 8 | (int)(d3 * (double)n10 + d4 * (double)n16);
                n7 = n13;
                n8 = n14;
                n9 = n15;
                n10 = n16;
                ++n11;
            }
            nArray2[n4][n5 + n] = (int)(d3 * (double)n7) << 24 | n8 << 16 | n9 << 8 | n10;
            ++n4;
        }
        this.setPixels(n3, n2, nArray2);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Shear.usage();
        }
        Shear shear = new Shear(null, Integer.parseInt(stringArray[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, shear));
    }

    private static void usage() {
        System.err.println("usage: Shear <angle>");
        System.exit(1);
    }
}

