/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiWriter;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class NDNoise
extends JFrame
implements ActionListener,
ItemListener,
AdjustmentListener,
Runnable {
    static final String _VERSION = "0.4";
    static final String _TITLE = "NDNoise V0.4";
    static final boolean _VIEWALL = false;
    String debugString = "";
    private static final double SCALE = 1.8;
    private static final int _WOBBLE_DELAY = 1000;
    private static final int _ADVANCE_DELAY = 500;
    JFileChooser chooser = new JFileChooser();
    String inputFileName;
    JScrollPane scrollPanel;
    JPanel imgPanel;
    JSlider cSlider;
    JSlider eSlider;
    JSlider qSlider;
    JSlider shSlider;
    JSlider sSlider;
    JSlider tSlider;
    JSlider rSlider;
    JSlider fSlider;
    JButton expertButton;
    JButton loadButton;
    JButton defaultButton;
    JButton processFastButton;
    JButton processButton;
    JButton saveButton;
    JLabel zoomLabel;
    JButton zoomPButton;
    JButton zoomMButton;
    double zoomFactor = 1.0;
    ExpertFrame expertFrame;
    String imgName = "(no image)";
    int imgW;
    int imgH;
    BufferedImage img;
    BufferedImage imgEdges;
    BufferedImage imgQuant;
    BufferedImage imgFiltered;
    BufferedImage imgDiff;
    Rectangle clipRect;
    boolean FAST = false;
    int clipW = 320;
    int clipH = 240;
    boolean analyzing = false;
    int wobbleIndex = 0;
    int percent = 0;
    Choice viewChoice;
    static final int VC_ORIG = 0;
    static final int VC_FILTERED = 1;
    static final int VC_ALTERNATE = 2;
    static final int VC_DIFF = 3;
    int RADIUS = 3;
    double FACTOR_S = 2.0;
    double FACTOR_H = 5.0;
    double FACTOR_E = 5.0;
    double FACTOR_Q = 5.0;
    double FACTOR_T = 10.0;
    double FACTOR_SH = 24.0;
    int SUBSAMPLE = 10;

    public NDNoise(String[] args) {
        NDNoise.setDefaultLookAndFeelDecorated(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }
        });
        this.setTitle(_TITLE);
        this.setIconImage(new ImageIcon(this.getClass().getResource("Icons/Logo32.png")).getImage());
        this.chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "Prefer PNG lossless format !";
            }
        };
        this.chooser.setFileFilter(filter);
        JPanel aMainP = new JPanel();
        aMainP.setOpaque(true);
        aMainP.setLayout(new BorderLayout());
        this.setContentPane(aMainP);
        this.imgPanel = new JPanel(){

            public void repaint() {
                NDNoise.this.paintPanel();
            }
        };
        this.imgPanel.setBackground(Color.BLACK);
        this.scrollPanel = new JScrollPane(this.imgPanel);
        aMainP.add((Component)this.scrollPanel, "Center");
        this.scrollPanel.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollPanel.getVerticalScrollBar().addAdjustmentListener(this);
        JPanel aControlPanel = new JPanel();
        aControlPanel.setLayout(new BorderLayout());
        aMainP.add((Component)aControlPanel, "North");
        JPanel aExtraPanel = new JPanel();
        aControlPanel.add((Component)aExtraPanel, "East");
        aExtraPanel.setLayout(new GridLayout(0, 1));
        this.defaultButton = new JButton("Reset", new ImageIcon(this.getClass().getResource("Icons/resetBut.gif")));
        aExtraPanel.add(this.defaultButton);
        this.defaultButton.addActionListener(this);
        this.expertButton = new JButton("Expert", new ImageIcon(this.getClass().getResource("Icons/expertBut.gif")));
        aExtraPanel.add(this.expertButton);
        this.expertButton.addActionListener(this);
        JPanel aLabelPanel = new JPanel();
        aControlPanel.add((Component)aLabelPanel, "West");
        aLabelPanel.setLayout(new GridLayout(0, 1));
        JPanel aSliderPanel = new JPanel();
        aControlPanel.add((Component)aSliderPanel, "Center");
        aSliderPanel.setLayout(new GridLayout(0, 1));
        aLabelPanel.add(new JLabel("Noise filtering"));
        this.qSlider = new JSlider(0);
        aSliderPanel.add(this.qSlider);
        this.qSlider.setMajorTickSpacing(5);
        this.qSlider.setMinorTickSpacing(1);
        this.qSlider.setPaintLabels(true);
        aLabelPanel.add(new JLabel("Dots/spots/edges smoothing"));
        this.eSlider = new JSlider(0);
        aSliderPanel.add(this.eSlider);
        this.eSlider.setMajorTickSpacing(5);
        this.eSlider.setMinorTickSpacing(1);
        this.eSlider.setPaintLabels(true);
        aLabelPanel.add(new JLabel("Resharpening"));
        this.shSlider = new JSlider(0);
        aSliderPanel.add(this.shSlider);
        this.shSlider.setMajorTickSpacing(5);
        this.shSlider.setMinorTickSpacing(1);
        this.shSlider.setPaintLabels(true);
        aLabelPanel.add(new JLabel("Retexturing"));
        this.tSlider = new JSlider(0);
        aSliderPanel.add(this.tSlider);
        this.tSlider.setMajorTickSpacing(5);
        this.tSlider.setMinorTickSpacing(1);
        this.tSlider.setPaintLabels(true);
        this.expertFrame = new ExpertFrame(this);
        this.expertFrame.labelPanel.add(new JLabel("Color separation"));
        this.sSlider = new JSlider(0);
        this.expertFrame.sliderPanel.add(this.sSlider);
        this.sSlider.setMajorTickSpacing(5);
        this.sSlider.setMinorTickSpacing(1);
        this.sSlider.setPaintLabels(true);
        this.expertFrame.labelPanel.add(new JLabel("Color precision"));
        this.cSlider = new JSlider(0);
        this.expertFrame.sliderPanel.add(this.cSlider);
        this.cSlider.setMajorTickSpacing(5);
        this.cSlider.setMinorTickSpacing(1);
        this.cSlider.setPaintLabels(true);
        this.expertFrame.labelPanel.add(new JLabel("Influence radius (nb pix)"));
        this.rSlider = new JSlider(0);
        this.expertFrame.sliderPanel.add(this.rSlider);
        this.rSlider.setMaximum(50);
        this.rSlider.setMajorTickSpacing(5);
        this.rSlider.setMinorTickSpacing(1);
        this.rSlider.setPaintLabels(true);
        this.expertFrame.labelPanel.add(new JLabel("'Fast' factor"));
        this.fSlider = new JSlider(0);
        this.expertFrame.sliderPanel.add(this.fSlider);
        this.fSlider.setMaximum(50);
        this.fSlider.setMajorTickSpacing(5);
        this.fSlider.setMinorTickSpacing(1);
        this.fSlider.setPaintLabels(true);
        this.defaultValues();
        JPanel aButtonPanel = new JPanel();
        aMainP.add((Component)aButtonPanel, "West");
        aButtonPanel.setLayout(new GridLayout(0, 1));
        this.loadButton = new JButton("Load", new ImageIcon(this.getClass().getResource("Icons/openBut.gif")));
        aButtonPanel.add(this.loadButton);
        this.loadButton.addActionListener(this);
        this.loadButton.setHorizontalAlignment(2);
        this.processFastButton = new JButton("Fast", new ImageIcon(this.getClass().getResource("Icons/processBut.gif")));
        aButtonPanel.add(this.processFastButton);
        this.processFastButton.addActionListener(this);
        this.processFastButton.setHorizontalAlignment(2);
        this.processButton = new JButton("Calc", new ImageIcon(this.getClass().getResource("Icons/processBut.gif")));
        aButtonPanel.add(this.processButton);
        this.processButton.addActionListener(this);
        this.processButton.setHorizontalAlignment(2);
        JPanel aSmallPanel = new JPanel();
        aSmallPanel.setLayout(new GridLayout(0, 1));
        aButtonPanel.add(aSmallPanel);
        this.viewChoice = new Choice();
        aSmallPanel.add(this.viewChoice);
        this.viewChoice.addItemListener(this);
        this.viewChoice.add("Original");
        this.viewChoice.add("Filtered");
        this.viewChoice.add("Original/Filtered");
        this.viewChoice.add("Control (Diff)");
        this.zoomLabel = new JLabel("Zoom=1.0");
        aSmallPanel.add(this.zoomLabel);
        this.zoomLabel.setHorizontalAlignment(0);
        this.zoomPButton = new JButton("Zoom +", new ImageIcon(this.getClass().getResource("Icons/zoomPlusBut.gif")));
        aButtonPanel.add(this.zoomPButton);
        this.zoomPButton.addActionListener(this);
        this.zoomPButton.setHorizontalAlignment(2);
        this.zoomMButton = new JButton("Zoom -", new ImageIcon(this.getClass().getResource("Icons/zoomMinBut.gif")));
        aButtonPanel.add(this.zoomMButton);
        this.zoomMButton.addActionListener(this);
        this.zoomMButton.setHorizontalAlignment(2);
        this.saveButton = new JButton("Save", new ImageIcon(this.getClass().getResource("Icons/saveBut.gif")));
        aButtonPanel.add(this.saveButton);
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        this.saveButton.setHorizontalAlignment(2);
        Dimension aScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        this.setSize((int)((double)aScreenSize.width * 0.8), (int)((double)aScreenSize.height * 0.8));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        Thread aWobbleThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        if (NDNoise.this.viewChoice.getSelectedIndex() == 2) {
                            ++NDNoise.this.wobbleIndex;
                            NDNoise.this.wobbleIndex %= 2;
                            NDNoise.this.paintPanel();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        };
        aWobbleThread.start();
        Thread aAdvanceThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        if (NDNoise.this.analyzing) {
                            NDNoise.this.setTitle("Analyzing : " + NDNoise.this.debugString + " " + NDNoise.this.percent + "%");
                        } else {
                            NDNoise.this.setTitle("NDNoise V0.4 - " + NDNoise.this.imgName + " - " + NDNoise.this.imgW + " x " + NDNoise.this.imgH);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        };
        aAdvanceThread.start();
        this.loadFile();
    }

    void log(String aString, Throwable t) {
        System.err.print(String.valueOf(aString) + "\n");
        if (t != null) {
            t.printStackTrace();
        }
    }

    void defaultValues() {
        this.sSlider.setValue(60);
        this.cSlider.setValue(12);
        this.rSlider.setValue(3);
        this.fSlider.setValue(10);
        this.eSlider.setValue(5);
        this.qSlider.setValue(10);
        this.tSlider.setValue(0);
        this.shSlider.setValue(0);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.processButton) {
            try {
                this.FAST = false;
                new Thread(this).start();
            }
            catch (Throwable t) {
                this.log("Error : ", t);
            }
        } else if (e.getSource() == this.processFastButton) {
            try {
                this.FAST = true;
                new Thread(this).start();
            }
            catch (Throwable t) {
                this.log("Error : ", t);
            }
        } else if (e.getSource() == this.loadButton) {
            this.loadFile();
        } else if (e.getSource() == this.defaultButton) {
            this.defaultValues();
        } else if (e.getSource() == this.expertButton) {
            this.expertFrame.show();
        } else if (e.getSource() == this.zoomPButton) {
            this.zoomFactor = this.zoomFactor < 1.0 ? (this.zoomFactor *= 1.2) : (this.zoomFactor += 1.0);
            if (Math.abs(this.zoomFactor - (double)((int)(this.zoomFactor + 0.5))) < 0.1) {
                this.zoomFactor = (int)(this.zoomFactor + 0.5);
            }
            this.zoomFactor = (double)((int)(this.zoomFactor * 100.0)) / 100.0;
            this.zoomLabel.setText("Zoom=" + this.zoomFactor);
            this.imgPanel.setPreferredSize(new Dimension((int)((double)this.imgW * this.zoomFactor), (int)((double)this.imgH * this.zoomFactor)));
            this.imgPanel.revalidate();
            this.repaint();
        } else if (e.getSource() == this.zoomMButton) {
            this.zoomFactor = this.zoomFactor <= 1.0 ? (this.zoomFactor /= 1.2) : (this.zoomFactor -= 1.0);
            if (Math.abs(this.zoomFactor - (double)((int)(this.zoomFactor + 0.5))) < 0.1) {
                this.zoomFactor = (int)(this.zoomFactor + 0.5);
            }
            this.zoomFactor = (double)((int)(this.zoomFactor * 100.0)) / 100.0;
            this.zoomLabel.setText("Zoom=" + this.zoomFactor);
            this.imgPanel.setPreferredSize(new Dimension((int)((double)this.imgW * this.zoomFactor), (int)((double)this.imgH * this.zoomFactor)));
            this.imgPanel.revalidate();
            this.repaint();
        } else if (e.getSource() == this.saveButton) {
            this.saveFile();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.viewChoice) {
            this.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    void loadFile() {
        int returnVal = this.chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.debugString = "Loading";
            String aFileName = this.chooser.getSelectedFile().getAbsolutePath();
            this.imgName = this.chooser.getSelectedFile().getName();
            this.log("Loading file : " + aFileName + "...", null);
            try {
                Image aImg = Jimi.getImage(aFileName);
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(aImg, 0);
                tracker.addImage(aImg, 0);
                tracker.waitForID(0);
                this.imgW = aImg.getWidth(null);
                this.imgH = aImg.getHeight(null);
                this.img = new BufferedImage(this.imgW, this.imgH, 1);
                this.img.getGraphics().drawImage(aImg, 0, 0, null);
                this.imgFiltered = null;
                this.imgQuant = null;
                this.imgEdges = null;
                this.saveButton.setEnabled(false);
                this.viewChoice.select(0);
                this.imgPanel.setPreferredSize(new Dimension((int)((double)this.imgW * this.zoomFactor), (int)((double)this.imgH * this.zoomFactor)));
                this.imgPanel.revalidate();
                this.inputFileName = aFileName;
            }
            catch (Throwable t) {
                this.log("Error, can't load image... ", t);
            }
        }
    }

    void saveFile() {
        String aFileName = this.inputFileName;
        if (aFileName != null) {
            if (aFileName.lastIndexOf(".") > 0) {
                aFileName = aFileName.substring(0, aFileName.lastIndexOf("."));
            }
            aFileName = String.valueOf(aFileName) + "-NDN.png";
        }
        this.chooser.setSelectedFile(new File(aFileName));
        int returnVal = this.chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.debugString = "Saving";
            aFileName = this.chooser.getSelectedFile().getAbsolutePath();
            this.log("Saving file : " + aFileName + "...\n", null);
            try {
                JimiWriter writer = Jimi.createJimiWriter(aFileName);
                writer.setSource(this.imgFiltered);
                writer.putImage(aFileName);
            }
            catch (Throwable t) {
                this.log("Error, can't save image... ", t);
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintPanel();
    }

    void paintPanel() {
        if (this.imgPanel == null) {
            return;
        }
        Graphics aG = this.imgPanel.getGraphics();
        if (aG == null) {
            return;
        }
        aG.setColor(Color.BLACK);
        if (this.img == null) {
            aG.fillRect(0, 0, this.imgPanel.getWidth(), this.imgPanel.getHeight());
            return;
        }
        BufferedImage aImg = this.img;
        switch (this.viewChoice.getSelectedIndex()) {
            case 1: {
                if (this.imgFiltered != null) {
                    aImg = this.imgFiltered;
                }
            }
            case 2: {
                if (this.imgFiltered == null || this.wobbleIndex <= 0) break;
                aImg = this.imgFiltered;
                break;
            }
            case 3: {
                if (this.imgDiff == null) {
                    this.evalDiff();
                }
                if (this.imgDiff == null) break;
                aImg = this.imgDiff;
                break;
            }
        }
        aG.drawImage(aImg, 0, 0, (int)((double)this.imgW * this.zoomFactor), (int)((double)this.imgH * this.zoomFactor), null);
        if (this.clipRect != null) {
            aG.setXORMode(Color.WHITE);
            aG.drawRect((int)((double)this.clipRect.x * this.zoomFactor), (int)((double)this.clipRect.y * this.zoomFactor), (int)((double)this.clipRect.width * this.zoomFactor), (int)((double)this.clipRect.height * this.zoomFactor));
        }
    }

    void evalDiff() {
        int[] aSPix = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        int[] aFPix = ((DataBufferInt)this.imgFiltered.getRaster().getDataBuffer()).getData();
        this.imgDiff = new BufferedImage(this.imgW, this.imgH, 1);
        int[] aDPix = ((DataBufferInt)this.imgDiff.getRaster().getDataBuffer()).getData();
        int aCont = 1;
        int i = 0;
        while (i < aSPix.length) {
            int r = (aSPix[i] >> 16 & 255 - (aFPix[i] >> 16) & 0xFF) * aCont;
            r = 127 + (r >= 127 ? 127 : (r <= -127 ? -127 : r));
            int g = (aSPix[i] >> 8 & 255 - (aFPix[i] >> 8) & 0xFF) * aCont;
            g = 127 + (g >= 127 ? 127 : (g <= -127 ? -127 : g));
            int b = (aSPix[i] & 255 - aFPix[i] & 0xFF) * aCont;
            b = 127 + (b >= 127 ? 127 : (b <= -127 ? -127 : b));
            aDPix[i] = -16777216 + (r << 16) + (g << 8) + b;
            ++i;
        }
    }

    int colorComplexity(BufferedImage aSrc) {
        int[] aSPix = ((DataBufferInt)aSrc.getRaster().getDataBuffer()).getData();
        HashSet<String> aHS = new HashSet<String>(256);
        int aSize = 10;
        int i = 0;
        while (i < aSPix.length) {
            this.percent = 100 * i / aSPix.length;
            int aCoul = aSPix[i];
            int r = aCoul >> 16 & 0xFF;
            int g = aCoul >> 8 & 0xFF;
            int b = aCoul & 0xFF;
            String aSign = r / aSize + ":" + g / aSize + ":" + b / aSize;
            if (!aHS.contains(aSign)) {
                aHS.add(aSign);
            }
            ++i;
        }
        return aHS.size();
    }

    void blurWeighted(BufferedImage aSrc, BufferedImage aE, BufferedImage aQual, BufferedImage aDest, boolean aFast) {
        int aYMax;
        int aYMin;
        int aXMax;
        int aXMin;
        int[] aSPix = ((DataBufferInt)aSrc.getRaster().getDataBuffer()).getData();
        int[] aEPix = ((DataBufferInt)aE.getRaster().getDataBuffer()).getData();
        int[] aQPix = ((DataBufferInt)aQual.getRaster().getDataBuffer()).getData();
        int[] aDPix = ((DataBufferInt)aDest.getRaster().getDataBuffer()).getData();
        int w = aSrc.getWidth();
        int h = aSrc.getHeight();
        boolean aOrig = false;
        double[] aEFact = new double[256];
        double[] aQFact = new double[256];
        aEFact[0] = 1.0;
        aQFact[0] = 1.0;
        int p = 1;
        while (p < 256) {
            aEFact[p] = Math.exp(-((double)p) * (double)p / (1.0 + this.FACTOR_E * this.FACTOR_E));
            aQFact[p] = Math.exp(-((double)p) * (double)p / (1.0 + this.FACTOR_Q * this.FACTOR_Q));
            aQFact[p] = Math.pow(aQFact[p], this.FACTOR_S);
            ++p;
        }
        int[] aAbs255 = new int[511];
        int p2 = 0;
        while (p2 < 256) {
            aAbs255[255 + p2] = p2;
            aAbs255[255 - p2] = p2;
            ++p2;
        }
        int aTh = (int)Math.sqrt(this.SUBSAMPLE);
        Date aDate = new Date();
        if (this.clipRect == null) {
            aXMin = 0;
            aXMax = this.imgW;
            aYMin = 0;
            aYMax = this.imgH;
        } else {
            aXMin = this.clipRect.x;
            aXMax = this.clipRect.x + this.clipRect.width;
            aYMin = this.clipRect.y;
            aYMax = this.clipRect.y + this.clipRect.height;
        }
        int x = aXMin;
        while (x < aXMax) {
            this.percent = (x - aXMin) * 100 / (aXMax - aXMin);
            int y = aYMin;
            while (y < aYMax) {
                int aSum;
                double b = 0.0;
                double g = 0.0;
                double r = 0.0;
                int i = x + y * this.imgW;
                int aCoul = aSPix[i];
                int rS = aCoul >> 16 & 0xFF;
                int gS = aCoul >> 8 & 0xFF;
                int bS = aCoul & 0xFF;
                aCoul = aEPix[i];
                int rE = aCoul >> 16 & 0xFF;
                int gE = aCoul >> 8 & 0xFF;
                int bE = aCoul & 0xFF;
                aCoul = aQPix[i];
                int rQ = aCoul >> 16 & 0xFF;
                int gQ = aCoul >> 8 & 0xFF;
                int bQ = aCoul & 0xFF;
                int aQ = aCoul >> 24 & 0xFF;
                if (aFast && aQ < aTh) {
                    r = rS;
                    g = gS;
                    b = bS;
                } else {
                    double wB = 1.0 / (1.0 + (double)aQ);
                    double wTot = 0.0;
                    int xxx = -this.RADIUS;
                    while (xxx <= this.RADIUS) {
                        int xx = x + xxx < 0 ? 0 : (x + xxx >= this.imgW ? this.imgW - 1 : x + xxx);
                        int yyy = -this.RADIUS;
                        while (yyy <= this.RADIUS) {
                            int yy = y + yyy < 0 ? 0 : (y + yyy >= this.imgH ? this.imgH - 1 : y + yyy);
                            int j = xx + yy * this.imgW;
                            double wQ = 0.0;
                            double wE = 0.0;
                            double wH = xxx == 0 && yyy == 0 ? aQFact[(int)this.FACTOR_H] : 1.0;
                            aSum = 0;
                            aCoul = aEPix[j];
                            int rEE = aCoul >> 16 & 0xFF;
                            aSum += aAbs255[255 + rE - rEE];
                            int gEE = aCoul >> 8 & 0xFF;
                            aSum += aAbs255[255 + gE - gEE];
                            int bEE = aCoul & 0xFF;
                            wE = aEFact[(aSum += aAbs255[255 + bE - bEE]) / 3];
                            aSum = 0;
                            aCoul = aQPix[j];
                            int rQQ = aCoul >> 16 & 0xFF;
                            aSum += aAbs255[255 + rQ - rQQ];
                            int gQQ = aCoul >> 8 & 0xFF;
                            aSum += aAbs255[255 + gQ - gQQ];
                            int bQQ = aCoul & 0xFF;
                            wQ = aQFact[(aSum += aAbs255[255 + bQ - bQQ]) / 3];
                            aCoul = aSPix[j];
                            double wX = wQ * wE * wH;
                            r += (double)(aCoul >> 16 & 0xFF) * wX;
                            g += (double)(aCoul >> 8 & 0xFF) * wX;
                            b += (double)(aCoul & 0xFF) * wX;
                            wTot += wX;
                            ++yyy;
                        }
                        ++xxx;
                    }
                    r /= wTot;
                    g /= wTot;
                    b /= wTot;
                    r = (int)((double)rS * wB + r * (1.0 - wB));
                    g = (int)((double)gS * wB + g * (1.0 - wB));
                    b = (int)((double)bS * wB + b * (1.0 - wB));
                }
                aSum = 0;
                aSum += aAbs255[255 + (int)((double)rS - r)];
                aSum += aAbs255[255 + (int)((double)gS - g)];
                aSum += aAbs255[255 + (int)((double)bS - b)];
                aDPix[x + y * this.imgW] = (((aSum /= 3) & 0xFF) << 24) + (((int)r & 0xFF) << 16) + (((int)g & 0xFF) << 8) + ((int)b & 0xFF);
                ++y;
            }
            ++x;
        }
        this.log("Blur processing time : " + (new Date().getTime() - aDate.getTime()) / 1000L, null);
    }

    void edgesFilterRGBAll(BufferedImage aSrc, BufferedImage aDest, BufferedImage aTmp) {
        int aYMax;
        int aYMin;
        int aXMax;
        int aXMin;
        int[] rgbPixels = ((DataBufferInt)aSrc.getRaster().getDataBuffer()).getData();
        int[] newPixels = ((DataBufferInt)aDest.getRaster().getDataBuffer()).getData();
        int[] tmpPixels = ((DataBufferInt)aTmp.getRaster().getDataBuffer()).getData();
        if (this.clipRect == null) {
            aXMin = 0;
            aXMax = this.imgW;
            aYMin = 0;
            aYMax = this.imgH;
        } else {
            aXMin = this.clipRect.x;
            aXMax = this.clipRect.x + this.clipRect.width;
            aYMin = this.clipRect.y;
            aYMax = this.clipRect.y + this.clipRect.height;
        }
        int col = aXMin;
        while (col < aXMax) {
            newPixels[this.imgW * aYMin + col] = -16777216;
            newPixels[this.imgW * (aYMax - 1) + col] = -16777216;
            ++col;
        }
        int row = aYMin + 1;
        while (row < aYMax - 1) {
            newPixels[this.imgW * row + aXMin] = -16777216;
            newPixels[this.imgW * row + (aXMax - 1)] = -16777216;
            int col2 = aXMin + 1;
            while (col2 < aXMax - 1) {
                long sum1 = (rgbPixels[this.imgW * (row - 1) + (col2 + 1)] >> 16 & 0xFF) - (rgbPixels[this.imgW * (row - 1) + (col2 - 1)] >> 16 & 0xFF) + 2 * ((rgbPixels[this.imgW * row + (col2 + 1)] >> 16 & 0xFF) - (rgbPixels[this.imgW * row + (col2 - 1)] >> 16 & 0xFF)) + (rgbPixels[this.imgW * (row + 1) + (col2 + 1)] >> 16 & 0xFF) - (rgbPixels[this.imgW * (row + 1) + (col2 - 1)] >> 16 & 0xFF);
                long sum2 = (rgbPixels[this.imgW * (row + 1) + (col2 - 1)] >> 16 & 0xFF) + 2 * (rgbPixels[this.imgW * (row + 1) + col2] >> 16 & 0xFF) + (rgbPixels[this.imgW * (row + 1) + (col2 + 1)] >> 16 & 0xFF) - ((rgbPixels[this.imgW * (row - 1) + (col2 - 1)] >> 16 & 0xFF) + 2 * (rgbPixels[this.imgW * (row - 1) + col2] >> 16 & 0xFF) + (rgbPixels[this.imgW * (row - 1) + (col2 + 1)] >> 16 & 0xFF));
                double sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int r = (int)sum < 255 ? (int)sum : 255;
                sum1 = (rgbPixels[this.imgW * (row - 1) + (col2 + 1)] >> 8 & 0xFF) - (rgbPixels[this.imgW * (row - 1) + (col2 - 1)] >> 8 & 0xFF) + 2 * ((rgbPixels[this.imgW * row + (col2 + 1)] >> 8 & 0xFF) - (rgbPixels[this.imgW * row + (col2 - 1)] >> 8 & 0xFF)) + (rgbPixels[this.imgW * (row + 1) + (col2 + 1)] >> 8 & 0xFF) - (rgbPixels[this.imgW * (row + 1) + (col2 - 1)] >> 8 & 0xFF);
                sum2 = (rgbPixels[this.imgW * (row + 1) + (col2 - 1)] >> 8 & 0xFF) + 2 * (rgbPixels[this.imgW * (row + 1) + col2] >> 8 & 0xFF) + (rgbPixels[this.imgW * (row + 1) + (col2 + 1)] >> 8 & 0xFF) - ((rgbPixels[this.imgW * (row - 1) + (col2 - 1)] >> 8 & 0xFF) + 2 * (rgbPixels[this.imgW * (row - 1) + col2] >> 8 & 0xFF) + (rgbPixels[this.imgW * (row - 1) + (col2 + 1)] >> 8 & 0xFF));
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int g = (int)sum < 255 ? (int)sum : 255;
                sum1 = (rgbPixels[this.imgW * (row - 1) + (col2 + 1)] & 0xFF) - (rgbPixels[this.imgW * (row - 1) + (col2 - 1)] & 0xFF) + 2 * ((rgbPixels[this.imgW * row + (col2 + 1)] & 0xFF) - (rgbPixels[this.imgW * row + (col2 - 1)] & 0xFF)) + (rgbPixels[this.imgW * (row + 1) + (col2 + 1)] & 0xFF) - (rgbPixels[this.imgW * (row + 1) + (col2 - 1)] & 0xFF);
                sum2 = (rgbPixels[this.imgW * (row + 1) + (col2 - 1)] & 0xFF) + 2 * (rgbPixels[this.imgW * (row + 1) + col2] & 0xFF) + (rgbPixels[this.imgW * (row + 1) + (col2 + 1)] & 0xFF) - ((rgbPixels[this.imgW * (row - 1) + (col2 - 1)] & 0xFF) + 2 * (rgbPixels[this.imgW * (row - 1) + col2] & 0xFF) + (rgbPixels[this.imgW * (row - 1) + (col2 + 1)] & 0xFF));
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int b = (int)sum < 255 ? (int)sum : 255;
                tmpPixels[this.imgW * row + col2] = 0xFF000000 | r << 16 | g << 8 | b;
                ++col2;
            }
            ++row;
        }
        int row2 = aYMin + 1;
        while (row2 < aYMax - 1) {
            int col3 = aXMin + 1;
            while (col3 < aXMax - 1) {
                int aB = 0;
                int aG = 0;
                int aR = 0;
                int x = -1;
                while (x <= 1) {
                    int y = -1;
                    while (y <= 1) {
                        aR += tmpPixels[this.imgW * (row2 + y) + (col3 + x)] >> 16 & 0xFF;
                        aG += tmpPixels[this.imgW * (row2 + y) + (col3 + x)] >> 8 & 0xFF;
                        aB += tmpPixels[this.imgW * (row2 + y) + (col3 + x)] & 0xFF;
                        ++y;
                    }
                    ++x;
                }
                newPixels[this.imgW * row2 + col3] = 0xFF000000 | (aR /= 9) << 16 | (aG /= 9) << 8 | (aB /= 9);
                ++col3;
            }
            ++row2;
        }
    }

    void sharpening(BufferedImage aSrc, BufferedImage aTmp) {
        int col;
        int aYMax;
        int aYMin;
        int aXMax;
        int aXMin;
        int[] rgbPixels = ((DataBufferInt)aSrc.getRaster().getDataBuffer()).getData();
        int[] tmpPixels = ((DataBufferInt)aTmp.getRaster().getDataBuffer()).getData();
        if (this.clipRect == null) {
            aXMin = 0;
            aXMax = this.imgW;
            aYMin = 0;
            aYMax = this.imgH;
        } else {
            aXMin = this.clipRect.x;
            aXMax = this.clipRect.x + this.clipRect.width;
            aYMin = this.clipRect.y;
            aYMax = this.clipRect.y + this.clipRect.height;
        }
        int aStrong = (int)(100.0 - this.FACTOR_SH);
        int row = aYMin + 1;
        while (row < aYMax - 1) {
            col = aXMin + 1;
            while (col < aXMax - 1) {
                int aB = 0;
                int aG = 0;
                int aR = 0;
                int x = -1;
                while (x <= 1) {
                    int y = -1;
                    while (y <= 1) {
                        if (x == 0 && y == 0) {
                            aR += aStrong * (rgbPixels[this.imgW * (row + y) + (col + x)] >> 16 & 0xFF);
                            aG += aStrong * (rgbPixels[this.imgW * (row + y) + (col + x)] >> 8 & 0xFF);
                            aB += aStrong * (rgbPixels[this.imgW * (row + y) + (col + x)] & 0xFF);
                        } else {
                            aR -= rgbPixels[this.imgW * (row + y) + (col + x)] >> 16 & 0xFF;
                            aG -= rgbPixels[this.imgW * (row + y) + (col + x)] >> 8 & 0xFF;
                            aB -= rgbPixels[this.imgW * (row + y) + (col + x)] & 0xFF;
                        }
                        ++y;
                    }
                    ++x;
                }
                aG /= aStrong - 8;
                int n = (aR /= aStrong - 8) >= 255 ? 255 : (aR = aR <= 0 ? 0 : aR);
                int n2 = aG >= 255 ? 255 : (aG = aG <= 0 ? 0 : aG);
                aB = aB >= 255 ? 255 : (aB <= 0 ? 0 : (aB /= aStrong - 8));
                tmpPixels[this.imgW * row + col] = 0xFF000000 | aR << 16 | aG << 8 | aB;
                ++col;
            }
            ++row;
        }
        row = aYMin + 1;
        while (row < aYMax - 1) {
            col = aXMin + 1;
            while (col < aXMax - 1) {
                rgbPixels[this.imgW * row + col] = tmpPixels[this.imgW * row + col];
                ++col;
            }
            ++row;
        }
    }

    void retexturing(BufferedImage aSrc, BufferedImage aDest) {
        int[] aSPix = ((DataBufferInt)aSrc.getRaster().getDataBuffer()).getData();
        int[] aDPix = ((DataBufferInt)aDest.getRaster().getDataBuffer()).getData();
        double[] aTFact = new double[256];
        aTFact[0] = 1.0;
        int p = 1;
        while (p < 256) {
            aTFact[p] = Math.exp(-((double)p) * (double)p / (1.0 + this.FACTOR_T * this.FACTOR_T));
            ++p;
        }
        int x = 0;
        while (x < aSPix.length) {
            this.percent = 100 * x / aSPix.length;
            int aCoul = aSPix[x];
            int rS = aCoul >> 16 & 0xFF;
            int gS = aCoul >> 8 & 0xFF;
            int bS = aCoul & 0xFF;
            aCoul = aDPix[x];
            int rD = aCoul >> 16 & 0xFF;
            int gD = aCoul >> 8 & 0xFF;
            int bD = aCoul & 0xFF;
            int aSum = 0;
            int aD = rD - rS;
            aSum += aD > 0 ? aD : -aD;
            aD = gD - gS;
            aSum += aD > 0 ? aD : -aD;
            aD = bD - bS;
            double aFact = aTFact[(aSum += aD > 0 ? aD : -aD) / 3];
            rD = (int)((double)rD * (1.0 - aFact) + (double)rS * aFact);
            gD = (int)((double)gD * (1.0 - aFact) + (double)gS * aFact);
            bD = (int)((double)bD * (1.0 - aFact) + (double)bS * aFact);
            aDPix[x] = 0xFF000000 | rD << 16 | gD << 8 | bD;
            ++x;
        }
    }

    public void run() {
        this.analyze();
    }

    void analyze() {
        this.processFastButton.setEnabled(false);
        this.processButton.setEnabled(false);
        this.analyzing = true;
        this.viewChoice.select(0);
        this.paintPanel();
        try {
            this.percent = 0;
            if (this.imgEdges == null) {
                this.imgEdges = new BufferedImage(this.imgW, this.imgH, 1);
                this.imgEdges.getGraphics().drawImage(this.img, 0, 0, null);
            }
            if (this.imgQuant == null) {
                this.imgQuant = new BufferedImage(this.imgW, this.imgH, 1);
            }
            this.imgQuant.getGraphics().fillRect(0, 0, this.imgW, this.imgH);
            if (this.imgFiltered == null) {
                this.imgFiltered = new BufferedImage(this.imgW, this.imgH, 1);
                this.imgFiltered.getGraphics().drawImage(this.img, 0, 0, null);
            }
            this.imgDiff = null;
            if (this.FAST && (double)this.imgW > (double)this.clipW * 1.3 && (double)this.imgH > (double)this.clipH * 1.3) {
                int aXPos = (int)((double)this.imgW * (double)(this.scrollPanel.getHorizontalScrollBar().getValue() + this.scrollPanel.getHorizontalScrollBar().getVisibleAmount() / 2) / (double)this.scrollPanel.getHorizontalScrollBar().getMaximum()) - this.clipW / 2;
                int aYPos = (int)((double)this.imgH * (double)(this.scrollPanel.getVerticalScrollBar().getValue() + this.scrollPanel.getVerticalScrollBar().getVisibleAmount() / 2) / (double)this.scrollPanel.getVerticalScrollBar().getMaximum()) - this.clipH / 2;
                if (aXPos < 0) {
                    aXPos = 0;
                }
                if (aXPos + this.clipW > this.imgW) {
                    aXPos = this.imgW - this.clipW;
                }
                if (aYPos < 0) {
                    aYPos = 0;
                }
                if (aYPos + this.clipH > this.imgH) {
                    aYPos = this.imgH - this.clipH;
                }
                this.clipRect = new Rectangle(aXPos, aYPos, this.clipW, this.clipH);
            } else {
                this.clipRect = null;
            }
            this.debugString = "Edges detection";
            this.edgesFilterRGBAll(this.img, this.imgEdges, this.imgFiltered);
            this.percent = 0;
            this.debugString = "Bluring";
            this.RADIUS = this.rSlider.getValue();
            this.FACTOR_S = this.sSlider.getValue();
            this.FACTOR_S = this.FACTOR_S >= 50.0 ? 1.0 + (this.FACTOR_S - 50.0) / 5.0 : 1.0 / (50.0 - this.FACTOR_S) / 5.0;
            this.FACTOR_H = this.qSlider.getValue();
            this.FACTOR_E = this.eSlider.getValue();
            this.FACTOR_Q = this.qSlider.getValue();
            this.blurWeighted(this.img, this.imgEdges, this.imgQuant, this.imgFiltered, false);
            this.percent = 0;
            this.debugString = "Neural Quantization";
            this.SUBSAMPLE = this.FAST ? this.fSlider.getValue() : 1;
            this.SUBSAMPLE = 1;
            BufferedImage aRefQ = this.imgFiltered;
            int aColPrec = (int)((double)this.cSlider.getValue() * 40.96);
            if (this.clipRect != null) {
                aRefQ = new BufferedImage(this.clipRect.width, this.clipRect.height, 1);
                aRefQ.getGraphics().drawImage(this.imgFiltered.getSubimage(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height), 0, 0, null);
                aColPrec /= 2;
            }
            NeuQuant aNQ = new NeuQuant(this, aRefQ, aColPrec, this.SUBSAMPLE, null);
            aNQ.init();
            this.debugString = "Color Reduction";
            int[] aPixImg = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
            int[] aPixImgQuant = ((DataBufferInt)this.imgQuant.getRaster().getDataBuffer()).getData();
            int[] aPixImgBlur = ((DataBufferInt)this.imgFiltered.getRaster().getDataBuffer()).getData();
            int s = this.imgW * this.imgH;
            this.imgQuant.getGraphics().drawImage(this.img, 0, 0, null);
            if (this.clipRect == null) {
                int i = 0;
                while (i < s) {
                    aPixImgQuant[i] = (0xFFFFFF & aNQ.convert(aPixImg[i])) + (0xFF000000 & aPixImgBlur[i]);
                    ++i;
                }
            } else {
                int x = this.clipRect.x;
                while (x < this.clipRect.x + this.clipRect.width) {
                    int y = this.clipRect.y;
                    while (y < this.clipRect.y + this.clipRect.height) {
                        int i = x + y * this.imgW;
                        aPixImgQuant[i] = (0xFFFFFF & aNQ.convert(aPixImg[i])) + (0xFF000000 & aPixImgBlur[i]);
                        ++y;
                    }
                    ++x;
                }
            }
            this.percent = 0;
            this.debugString = "Filtering";
            this.FACTOR_S = this.sSlider.getValue();
            this.FACTOR_S = this.FACTOR_S >= 50.0 ? 1.0 + (this.FACTOR_S - 50.0) / 5.0 : 1.0 / (50.0 - this.FACTOR_S) / 5.0;
            this.FACTOR_H = this.qSlider.getValue();
            this.FACTOR_E = this.eSlider.getValue();
            this.FACTOR_Q = this.qSlider.getValue();
            this.blurWeighted(this.img, this.imgEdges, this.imgQuant, this.imgFiltered, this.FAST);
            this.debugString = "Sharpening";
            this.FACTOR_SH = this.shSlider.getValue();
            if (this.FACTOR_SH > 0.0) {
                this.sharpening(this.imgFiltered, this.imgEdges);
            }
            this.debugString = "Retexturing";
            this.FACTOR_T = this.tSlider.getValue();
            if (this.FACTOR_T > 0.0) {
                this.retexturing(this.img, this.imgFiltered);
            }
            this.percent = 0;
        }
        catch (Throwable t) {
            this.log("Error while analyzing : ", t);
        }
        this.viewChoice.select(2);
        this.paintPanel();
        this.analyzing = false;
        this.debugString = "";
        this.processFastButton.setEnabled(true);
        this.processButton.setEnabled(true);
        this.saveButton.setEnabled(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Warning, can't load L&F: " + exc);
        }
        NDNoise aNDN = new NDNoise(args);
    }
}

