//*****************************************************************************
//***  NAME              : iptracx.c                                        ***
//***  PART OF           : IpSpy                                            ***
//***  SHORT DESCRIPTION : creates a iptrace file                           ***
//--------------------------------------------------------------------------***
//***  AUTHOR            : E.Buerkle                                        ***
//***  CREATION DATE     : 08.04.97                                         ***
//***  COPYRIGHT         : (C) 1997 E.Buerkle                               ***
//*****************************************************************************

#define INCL_BASE
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <time.h>

#define  OS2
#ifdef __EMX__
#include <sys\types.h>
#else
#include <types.h>
#endif
#include <sys/socket.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <sys/select.h>
#include <sys/ioctl.h>

#include <net\if.h>
#include <net\route.h>
#include <netinet\in.h>
#include <netinet\in_systm.h>
#include <netinet\ip.h>
#include <netinet\ip_icmp.h>
#include <netinet\if_ether.h>
#include <netinet\tcp.h>

#include <ipspy.h>

#ifndef IP_MAXPACKET
#define IP_MAXPACKET    65535           /* maximum packet size */
#endif

typedef struct _STFRAMEDATA {
  USHORT usType;
  USHORT usLength;
  ULONG  ulTimeStamp;
  UCHAR  auchData[IP_MAXPACKET];
} STFRAMEDATA;


ULONG        ulHandle;
UCHAR        auchInterface[IFNAMSIZ+1];
USHORT       usOldMode;
STFRAMEDATA  stFrameData;

//**************************************************************************
//  Name       :  IpExitProc
//  Description:  close interface and reset adapter to normal mode
//  Parameters :  usTermCode - termination info
//  Return     :  none
//**************************************************************************
VOID APIENTRY IpExitProc(ULONG usTermCode)
{
  APIRET rc;

  fflush(NULL);

  // end monitor
  if((rc=IpSpy_Exit(ulHandle)) != RC_IPSPY_NOERROR)
    printf("IpSpyExit Error: %d\n", rc);

  // ip stack relexation
  if((rc=IpSpy_SetReceiveMode(usOldMode,
                              auchInterface,
                              NULL)) != RC_IPSPY_NOERROR)
    printf("IpSpy_SetReceiveMode Error: %d\n", rc);

  printf("IPTracx ends\n");
}

//**************************************************************************
//  Name       :  main
//  Description:
//  Parameters :  argc argv env
//  Return     :  none
//**************************************************************************
VOID main(ULONG argc, UCHAR **argv, UCHAR **env)
{
  APIRET rc;
  UCHAR  *pVersion, **pIFs;
  USHORT usUnknown;
  UCHAR  *pSocketError;
  ULONG  ulSocketError, i;
  FILE   *fp;
  ULONG  ulTime;

  // query all available interfaces
  if((rc=IpSpy_QueryInterfaces(&pIFs)) != RC_IPSPY_NOERROR)
  {
    printf("IpSpyQueryIF Error: %d\n", rc);
    return;
  }

  // check arguments
  if(argc != 2 || IFNAMSIZ < strlen(argv[1]))
  {
    printf("usage: iptracx [interface]\n");
    printf(" where interface is one of:\n");
    // show all available interfaces
    if(pIFs != NULL)
      for(i=0; pIFs[i] != 0; i++)
        printf(" %s\n", pIFs[i]);

    return;
  }

  strcpy(auchInterface, argv[1]);
  printf("IPTracx [%s], quit with Ctrl-C\n", auchInterface);

  // view the version
  if((rc=IpSpy_Version(&pVersion)) != RC_IPSPY_NOERROR)
    printf("IpSpyVersion Error: %d\n", rc);
  else
    printf("IpSpy Version: %s\n", pVersion);

  // save receive mode
  if((rc=IpSpy_QueryReceiveMode(&usOldMode, NULL)) != RC_IPSPY_NOERROR)
    printf("IpSpy_QueryReceiveMode Error: %d\n", rc);

  // we want all packets
  if((rc=IpSpy_SetReceiveMode(DIRECTED_MODE | BROADCAST_MODE | PROMISCUOUS_MODE,
                              auchInterface,
                              NULL)) != RC_IPSPY_NOERROR)
  {
    if(rc == RC_IPSPY_MODE_NOT_SUPPORTED)
      printf("Promiscuous mode not supported\n");
    else if(rc == RC_IPSPY_CANNOT_OPEN_DRIVER)
      printf("IpSpy_SetReceiveMode Error: Cannot open ipspy.os2\n");
    else
      printf("IpSpy_SetReceiveMode Error: %d\n", rc);
  }

  // init monitor
  if((rc=IpSpy_Init(&ulHandle, auchInterface)) != RC_IPSPY_NOERROR)
  {
    if(rc == RC_IPSPY_SOCKET_ERROR)
    {
      IpSpy_GetLastSocketError(&ulSocketError, &pSocketError);
      printf("IpSpyInit SocketError: [%d] %s\n", ulSocketError, pSocketError);
    }
    else
      printf("IpSpyInit Error: %d\n", rc);
    return;
  }

  // good housekeeping
  DosExitList(EXLST_ADD, IpExitProc);

  // opens the iptrace file
  if((fp = fopen ("iptrace.dmp", "w+b")) == NULL)
  {
    printf("Could not open iptrace.dmp");
    return;
  }

  // loop forever
  while(TRUE)
  {
    // read packet
    stFrameData.usLength = sizeof(stFrameData.auchData);
    if((rc=IpSpy_ReadRaw(ulHandle, stFrameData.auchData,
                         &stFrameData.usLength, &stFrameData.usType,
                         &stFrameData.ulTimeStamp, &usUnknown)) != RC_IPSPY_NOERROR)
    {
      printf("IpSpyRead Error: %d\n", rc);
      return;
    }

    // get systemtime
    DosQuerySysInfo( QSV_MS_COUNT, QSV_MS_COUNT, &ulTime, sizeof(ulTime));

    printf("Packet [Type:%d Length:%d Time:%d msec]\t System [Time:%d msec]\n",
              stFrameData.usType, stFrameData.usLength,
              stFrameData.ulTimeStamp , ulTime);

    //
    // if(MyFilter(.....) == FALSE)
    //   continue;
    //

    // write packet to iptrace.dmp
    if(fwrite(&stFrameData, stFrameData.usLength + 8, 1, fp) != 1)
    {
      printf("Could not write to iptrace.dmp");
      return;
    }

  }

}
