#ifndef ACLCTL
#define ACLCTL

#define HRTV ULONG

// #ifdef __CPLUSPLUS
extern "C"
{
// #endif

/* 1 */
/* Initialise the ACL Control Library */
ULONG ACLInitCtl( void );

/* 2 */
/* Create a new rich text control of the given dimensions */
HRTV ACLCreateRichTextView( HWND Parent, LONG X, LONG Y,
 LONG Width, LONG Height, ULONG Visible );

/* 3 */
/* Clear the text in the control */
void ACLRTVClearText( HRTV rtv );

/* 4 */
/* Add the given text to the end of the control */
void ACLRTVAddText( HRTV rtv, char* text );

/* 5 */
/* Add the given text as a new paragraph to the control */
/* (ie. append cr+lf as well) */
void ACLRTVAddParagraph( HRTV rtv, char* text );

/* 6 */
/* Add the given text as a new paragraph, and select it visibly */
void ACLRTVAddSelectedParagraph( HRTV rtv, char* text ); 

/* 7 */
/* Returns the window handle of the control */
HWND ACLRTVGetWindow( HRTV rtv ); 

// #ifdef __CPLUSPLUS
}
// #endif

#pragma aux ACLInitCtl "^" \
 parm reverse routine [] \
 value struct float struct caller [] \
 modify [eax ebx ecx edx ebp esi edi];
#pragma aux ACLCreateRichTextView "^" \
 parm reverse routine [] \
 value struct float struct caller [] \
 modify [eax ebx ecx edx ebp esi edi];
#pragma aux ACLRTVClearText "^" \
 parm reverse routine [] \
 value struct float struct caller [] \
 modify [eax ebx ecx edx ebp esi edi];
#pragma aux ACLRTVAddText "^" \
 parm reverse routine [] \
 value struct float struct caller [] \
 modify [eax ebx ecx edx ebp esi edi];
#pragma aux ACLRTVAddParagraph "^" \
 parm reverse routine [] \
 value struct float struct caller [] \
 modify [eax ebx ecx edx ebp esi edi];
#pragma aux ACLRTVAddSelectedParagraph "^" \
 parm reverse routine [] \
 value struct float struct caller [] \
 modify [eax ebx ecx edx ebp esi edi];
#pragma aux ACLRTVGetWindow "^" \
 parm reverse routine [] \
 value struct float struct caller [] \
 modify [eax ebx ecx edx ebp esi edi];

// Calls into the Sybil-made DLL play free and loose with the registers.
// Make sure the compiler/optimizer understands this.

#endif
