#ifndef _DAVIS_BUFFER_H_
#define _DAVIS_BUFFER_H_

typedef struct
{
   char file[255];            /* filename */
   unsigned char *beg;       /* beginning of buffer */
   unsigned char *end;       /* end of buffer */
   int mark;                 /* marked line in buffer */
   unsigned int flags;
   int fd;			       /* file descriptor--- -1 if closed */
   int size;
#ifdef VMS
   int rec;			       /* record size for reads */
#endif
} Buffer;


extern int NUM_LINES;
extern Buffer *BUF;
extern unsigned char *BEG, *EOB;
extern unsigned char MINI_BUF[132];
/* The buffer.

   The beginning of the first character is at BUF.  The last character
   in the file is located at position EOB-1.  So if we are at position EOB,
   then we can insert a character past the last point.  EOB = BUF + BUF_SIZE;
.
*/
  
extern unsigned char *C_POS;
/* 
 *  current position of point.  Considered to be between the previous
 *  character and the next character.  There is no current character.
 *  If we are at the beginning of the buffer BUF, then its value is BUF.
 *  If we are at the end of the buffer it is BUF + BUF_SIZE = EOB.
 */

extern int C_LINE;
/* 
 *  Current line number.  If at the beginning of the buffer, it is 1.  If
 *  we are at the last point of the buffer it is the number of lines.
 */

/* These two routines do not move the point */  
extern unsigned char *beg_of_line();
extern unsigned char *end_of_line();

extern int forward_line(int);
/* This routine moves the point forward n lines. n can be negative. 
   It returns the number moved. */

extern void goto_line(int);
/* Move the point somewhere on the nth line of the buffer returning
   C_POS */

extern int what_line(unsigned char *);
/* return the line number of position 'argument'. Does not move point */

/* count the number of lines in the region delimited by beg and end.
   Counts lines from beg up to end but does not count end.
   Does not move point. */
extern int count_lines(unsigned char *, unsigned char *);
extern int extract_line(unsigned char **, unsigned char **);

extern Buffer *switch_to_buffer(Buffer *);
extern void delete_buffer(Buffer *);
extern Buffer *create_buffer(char *);
extern void find_row_column(unsigned char *, int *, int *);


#endif
  

