/*
 * Decompiled with CFR 0.152.
 */
package mindbright.vnc;

import java.awt.Event;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import mindbright.application.MindVNC;
import mindbright.ssh.SSHPasswordAuthenticator;
import mindbright.ssh.SSHSocket;
import mindbright.ssh.SSHSocketFactory;
import mindbright.vnc.DesCipher;
import mindbright.vnc.authenticationPanel;

public class rfbProto {
    final String versionMsg = "RFB 003.003\n";
    final int ConnFailed = 0;
    final int NoAuth = 1;
    final int VncAuth = 2;
    final int VncAuthOK = 0;
    final int VncAuthFailed = 1;
    final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int SetPixelFormat = 0;
    static final int FixColourMapEntries = 1;
    static final int SetEncodings = 2;
    static final int FramebufferUpdateRequest = 3;
    static final int KeyEvent = 4;
    static final int PointerEvent = 5;
    static final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    String vncHost;
    int vncPort;
    SSHSocket sock;
    SSHSocketFactory fact;
    DataInputStream is;
    OutputStream os;
    public boolean inNormalProtocol = false;
    MindVNC v;
    int serverMajor;
    int serverMinor;
    public String desktopName;
    public int framebufferWidth;
    public int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    int pointerMask = 0;
    int oldModifiers;

    public rfbProto(String string, int n, String string2, String string3, String string4, int n2, MindVNC mindVNC) throws IOException {
        this.v = mindVNC;
        this.vncHost = string4;
        this.vncPort = n2;
        this.fact = new SSHSocketFactory(string, n, new SSHPasswordAuthenticator(string2, string3));
        this.sock = this.fact.createSocket(string4, n2);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    public void close() {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void readVersionMsg() throws IOException {
        byte[] byArray = new byte[12];
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new IOException("Host " + this.vncHost + " port " + this.vncPort + " is not an RFB server");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
    }

    public boolean connectAndAuthenticate(authenticationPanel authenticationPanel2) throws IOException {
        boolean bl = false;
        this.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.serverMajor + "." + this.serverMinor);
        this.writeVersionMsg();
        block0 : switch (this.readAuthScheme()) {
            case 1: {
                System.out.println("No authentication needed");
                bl = true;
                break;
            }
            case 2: {
                byte[] byArray = new byte[16];
                this.is.readFully(byArray);
                String string = authenticationPanel2.vncPassword.getText();
                if (string.length() > 8) {
                    string = string.substring(0, 8);
                }
                byte[] byArray2 = new byte[8];
                string.getBytes(0, string.length(), byArray2, 0);
                int n = string.length();
                while (n < 8) {
                    byArray2[n] = 0;
                    ++n;
                }
                DesCipher desCipher = new DesCipher(byArray2);
                desCipher.encrypt(byArray, 0, byArray, 0);
                desCipher.encrypt(byArray, 8, byArray, 8);
                this.os.write(byArray);
                int n2 = this.is.readInt();
                switch (n2) {
                    case 0: {
                        System.out.println("VNC authentication succeeded");
                        bl = true;
                        break block0;
                    }
                    case 1: {
                        System.out.println("VNC authentication failed");
                        authenticationPanel2.retry("VNC access denied");
                        break block0;
                    }
                    case 2: {
                        throw new IOException("VNC authentication failed - too many tries");
                    }
                }
                throw new IOException("Unknown VNC authentication result " + n2);
            }
        }
        return bl;
    }

    void writeVersionMsg() throws IOException {
        byte[] byArray = new byte[12];
        "RFB 003.003\n".getBytes(0, 12, byArray, 0);
        this.os.write(byArray);
    }

    int readAuthScheme() throws IOException {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                int n2 = this.is.readInt();
                byte[] byArray = new byte[n2];
                this.is.readFully(byArray);
                throw new IOException(new String(byArray, 0));
            }
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new IOException("Unknown authentication scheme from RFB server " + n);
    }

    public void doProtocolInitialisation(int[] nArray, int n) throws IOException {
        System.out.println("sending client init");
        this.writeClientInit();
        this.readServerInit();
        System.out.println("Desktop name is " + this.desktopName);
        System.out.println("Desktop size is " + this.framebufferWidth + " x " + this.framebufferHeight);
        this.setEncodings(nArray, n);
    }

    void setEncodings(int[] nArray, int n) {
        try {
            if (this.inNormalProtocol) {
                this.writeSetEncodings(nArray, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void writeClientInit() throws IOException {
        if (this.v.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.v.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.read(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2, 0);
        this.inNormalProtocol = true;
    }

    int readServerMessageType() throws IOException {
        return this.is.read();
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
    }

    void readFramebufferUpdateRectHdr() throws IOException {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new IOException("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.read(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2, 0);
    }

    void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = new byte[]{3, bl ? (byte)1 : 0, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = bl ? (byte)1 : 0;
        byArray[7] = bl2 ? (byte)1 : 0;
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        this.os.write(byArray);
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        int n3 = 0;
        while (n3 < n2) {
            byArray[6 + n3 * 6] = (byte)(nArray[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 1] = (byte)(nArray[n3] & 0xFF);
            byArray[6 + n3 * 6 + 2] = (byte)(nArray2[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 3] = (byte)(nArray2[n3] & 0xFF);
            byArray[6 + n3 * 6 + 4] = (byte)(nArray3[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 5] = (byte)(nArray3[n3] & 0xFF);
            ++n3;
        }
        this.os.write(byArray);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        int n2 = 0;
        while (n2 < n) {
            byArray[4 + 4 * n2] = (byte)(nArray[n2] >> 24 & 0xFF);
            byArray[5 + 4 * n2] = (byte)(nArray[n2] >> 16 & 0xFF);
            byArray[6 + 4 * n2] = (byte)(nArray[n2] >> 8 & 0xFF);
            byArray[7 + 4 * n2] = (byte)(nArray[n2] & 0xFF);
            ++n2;
        }
        this.os.write(byArray);
    }

    public void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        string.getBytes(0, string.length(), byArray, 8);
        this.os.write(byArray);
    }

    void writePointerEvent(Event event) throws IOException {
        byte[] byArray = new byte[6];
        if (event.id == 501) {
            this.pointerMask = 1;
            if ((event.modifiers & 8) != 0) {
                this.pointerMask = this.v.options.reverseMouseButtons2And3 ? 4 : 2;
            }
            if ((event.modifiers & 4) != 0) {
                this.pointerMask = this.v.options.reverseMouseButtons2And3 ? 2 : 4;
            }
        } else if (event.id == 502) {
            this.pointerMask = 0;
        }
        event.modifiers &= 0xFFFFFFF3;
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(event.modifiers);
        if (event.x < 0) {
            event.x = 0;
        }
        if (event.y < 0) {
            event.y = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(event.x >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(event.x & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(event.y >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(event.y & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    public void sendCtrlAltDel() {
        try {
            Event event = new Event(null, 0, null);
            event.key = 127;
            event.modifiers = 10;
            event.id = 401;
            this.writeKeyEvent(event);
            event.id = 402;
            this.writeKeyEvent(event);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void writeKeyEvent(Event event) throws IOException {
        boolean bl;
        int n;
        block39: {
            block38: {
                n = event.key;
                bl = false;
                if (event.id == 401 || event.id == 403) {
                    bl = true;
                }
                if (event.id != 403 && event.id != 404) break block38;
                switch (n) {
                    case 1000: {
                        n = 65360;
                        break block39;
                    }
                    case 1006: {
                        n = 65361;
                        break block39;
                    }
                    case 1004: {
                        n = 65362;
                        break block39;
                    }
                    case 1007: {
                        n = 65363;
                        break block39;
                    }
                    case 1005: {
                        n = 65364;
                        break block39;
                    }
                    case 1002: {
                        n = 65365;
                        break block39;
                    }
                    case 1003: {
                        n = 65366;
                        break block39;
                    }
                    case 1001: {
                        n = 65367;
                        break block39;
                    }
                    case 1008: {
                        n = 65470;
                        break block39;
                    }
                    case 1009: {
                        n = 65471;
                        break block39;
                    }
                    case 1010: {
                        n = 65472;
                        break block39;
                    }
                    case 1011: {
                        n = 65473;
                        break block39;
                    }
                    case 1012: {
                        n = 65474;
                        break block39;
                    }
                    case 1013: {
                        n = 65475;
                        break block39;
                    }
                    case 1014: {
                        n = 65476;
                        break block39;
                    }
                    case 1015: {
                        n = 65477;
                        break block39;
                    }
                    case 1016: {
                        n = 65478;
                        break block39;
                    }
                    case 1017: {
                        n = 65479;
                        break block39;
                    }
                    case 1018: {
                        n = 65480;
                        break block39;
                    }
                    case 1019: {
                        n = 65481;
                        break block39;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (n < 32) {
                if ((event.modifiers & 2) != 0) {
                    n += 96;
                } else {
                    switch (n) {
                        case 8: {
                            n = 65288;
                            break;
                        }
                        case 9: {
                            n = 65289;
                            break;
                        }
                        case 10: {
                            n = 65293;
                            break;
                        }
                        case 27: {
                            n = 65307;
                        }
                    }
                }
            } else if (n >= 127) {
                if (n == 127) {
                    n = 65535;
                } else if (n < 65280 || n > 65535) {
                    return;
                }
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(event.modifiers);
        this.writeKeyEvent(n, bl);
        if (!bl) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int n, boolean bl) throws IOException {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = bl ? (byte)1 : 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    void writeModifierKeyEvents(int n) throws IOException {
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }
}

