/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import mindbright.application.MindTunnelCli;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHInteractor;
import mindbright.ssh.SSHMiscDialogs;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.ssh.SSHProxyDialog;
import mindbright.ssh.SSHSCPDialog;
import mindbright.ssh.SSHTunnelDialog;
import mindbright.util.AWTConvenience;

public class SSHTunnelingClient
extends SSHClient
implements Runnable,
SSHInteractor {
    public static final boolean expires = false;
    public static final boolean licensed = false;
    public static final long validFrom = 965157940452L;
    public static final long validTime = 2851200000L;
    public boolean verbose = false;
    public boolean listMode = false;
    public boolean haveTunnelDialog = false;
    public boolean haveSCPDialog = false;
    public boolean haveProxyDialog = false;
    public boolean haveServer = false;
    Thread clientThread = null;
    MindTunnelCli tunnelClient;
    Frame parent;
    int logoPlacement;
    SSHPropertyHandler propsHandler;
    Choice choiceHosts;
    TextField textSrv;
    TextField textUser;
    TextField textPasswd;
    Button connBut;
    Button discBut;
    Button tunnelBut;
    Button scpBut;
    Button proxyBut;

    public SSHTunnelingClient(SSHPropertyHandler sSHPropertyHandler, MindTunnelCli mindTunnelCli) {
        super(sSHPropertyHandler, sSHPropertyHandler);
        this.propsHandler = sSHPropertyHandler;
        this.interactor = this;
        this.tunnelClient = mindTunnelCli;
        sSHPropertyHandler.setInteractor(this);
        sSHPropertyHandler.setClient(this);
    }

    boolean hasExpired() {
        boolean bl = false;
        long l = System.currentTimeMillis();
        int n = (int)((l - 965157940452L) / 86400000L);
        this.alertDialog("This is a demo version of MindTunnel, it is " + n + " days old.");
        return bl;
    }

    public SSHPropertyHandler getPropertyHandler() {
        return this.propsHandler;
    }

    public void run() {
        this.clientThread = Thread.currentThread();
        String string = this.propsHandler.getProperty("server");
        if (string != null && string.trim().length() != 0) {
            this.haveServer = true;
        }
        this.showMainWindow();
        if (this.hasExpired()) {
            this.parent.dispose();
            return;
        }
        while (true) {
            this.parent.setTitle("MindTunnel v1.2.1SCP3 (offline)");
            this.updateButtons();
            if (this.listMode) {
                this.choiceHosts.requestFocus();
            } else if (this.haveServer) {
                this.textUser.requestFocus();
            } else {
                this.textSrv.requestFocus();
            }
            try {
                this.bootSSH(true);
                this.parent.setTitle(this.propsHandler.getProperty("usrname") + "@" + this.propsHandler.getProperty("server") + " (online)");
                this.tunnelClient.online();
                this.controller.waitForExit();
            }
            catch (SSHClient.AuthFailException authFailException) {
                this.alertDialog(authFailException.getMessage());
                this.propsHandler.clearPasswords();
            }
            catch (UnknownHostException unknownHostException) {
                String string2 = unknownHostException.getMessage();
                String string3 = this.propsHandler.getProperty("proxytype").equals("none") ? "Unknown host: " + string2 : "Unknown proxy host: " + string2;
                this.alertDialog(string3);
                this.propsHandler.clearServerSetting();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.alertDialog("File not found: " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                String string4 = exception.getMessage();
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = exception.toString();
                }
                string4 = "Error connecting to " + this.propsHandler.getProperty("server") + ", reason: " + string4;
                if (SSH.DEBUGMORE) {
                    System.out.println("If an error occured, please send the below stacktrace to mats@mindbright.se");
                    exception.printStackTrace();
                }
                this.alertDialog(string4);
            }
            catch (ThreadDeath threadDeath) {
                if (this.controller != null) {
                    this.controller.killAll();
                }
                this.controller = null;
                throw threadDeath;
            }
            this.propsHandler.passivateProperties();
            if (!this.usedOTP) continue;
            this.propsHandler.clearPasswords();
        }
    }

    public void updateButtons() {
        boolean bl = this.isConnected();
        this.connBut.setEnabled(!bl);
        this.discBut.setEnabled(bl);
        if (this.listMode) {
            this.choiceHosts.setEnabled(!bl);
        } else {
            if (!this.haveServer) {
                this.textSrv.setEnabled(!bl);
            }
            this.textUser.setEnabled(!bl);
            this.textPasswd.setEnabled(!bl);
        }
        if (this.tunnelBut != null) {
            this.tunnelBut.setEnabled(bl);
        }
        if (this.scpBut != null) {
            this.scpBut.setEnabled(bl);
        }
        if (this.proxyBut != null) {
            this.proxyBut.setEnabled(!bl);
        }
    }

    public void propsStateChanged(SSHPropertyHandler sSHPropertyHandler) {
    }

    public void startNewSession(SSHClient sSHClient) {
        Object object;
        try {
            object = this;
            synchronized (object) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.listMode) {
            try {
                object = this.choiceHosts.getSelectedItem();
                String string = "";
                while (true) {
                    try {
                        this.propsHandler.setPropertyPassword(string);
                        this.propsHandler.loadAliasFile((String)object, false);
                    }
                    catch (SSHClient.AuthFailException authFailException) {
                        if ((string = this.passwordDialog("Please give file password for " + (String)object, "MindTunnel - File Password")) != null) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.alertDialog("Error loading settings: " + throwable.getMessage());
            }
        } else {
            if (!this.haveServer) {
                this.propsHandler.setProperty("server", this.textSrv.getText());
            }
            this.propsHandler.setProperty("usrname", this.textUser.getText());
            object = this.textPasswd.getText();
            this.propsHandler.setProperty("password", (String)object);
            this.propsHandler.setProperty("rsapassword", (String)object);
            this.propsHandler.setProperty("tispassword", (String)object);
            this.propsHandler.setPropertyPassword((String)object);
            this.textPasswd.setText("");
        }
        this.propsHandler.setProperty("forcpty", "false");
    }

    public void sessionStarted(SSHClient sSHClient) {
    }

    public boolean quietPrompts() {
        return true;
    }

    public String promptLine(String string, String string2) throws IOException {
        return null;
    }

    public String promptPassword(String string) throws IOException {
        String string2 = this.passwordDialog(string, "MindTunnel - Password");
        if (string2 == null) {
            throw new IOException("Login canceled by user");
        }
        return string2;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean askConfirmation(String string, boolean bl) {
        return this.confirmDialog(string, bl);
    }

    public void connected(SSHClient sSHClient) {
    }

    public void open(SSHClient sSHClient) {
        this.updateButtons();
    }

    public void disconnected(SSHClient sSHClient, boolean bl) {
        this.updateButtons();
    }

    public void report(String string) {
        if (this.verbose) {
            System.out.println(string);
            System.out.println("");
        }
    }

    public void alert(String string) {
        this.alertDialog(string);
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!this.isConnected()) {
            this.parent.dispose();
            this.clientThread.stop();
        } else {
            this.alertDialog("Please disconnect before exiting!");
        }
    }

    public final void showMainWindow() {
        this.parent = new Frame();
        this.parent.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SSHTunnelingClient.this.windowClosing(windowEvent);
            }
        });
        if (this.listMode && this.propsHandler.availableAliases() == null) {
            this.listMode = false;
            this.alertDialog("Must have home directory with aliases to use list mode");
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        String[] stringArray = this.propsHandler.availableAliases();
        if (this.listMode && stringArray != null) {
            Label label = new Label("SSH Server:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            this.choiceHosts = new Choice();
            int n = 0;
            while (n < stringArray.length) {
                this.choiceHosts.add(stringArray[n]);
                ++n;
            }
            this.choiceHosts.select(0);
            gridBagLayout.setConstraints(this.choiceHosts, gridBagConstraints);
            panel.add(this.choiceHosts);
            ++gridBagConstraints.gridy;
        } else {
            Label label;
            if (!this.haveServer) {
                gridBagConstraints.weightx = 0.0;
                label = new Label("Server:");
                gridBagLayout.setConstraints(label, gridBagConstraints);
                panel.add(label);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                this.textSrv = new TextField("", 16);
                gridBagLayout.setConstraints(this.textSrv, gridBagConstraints);
                panel.add(this.textSrv);
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            label = new Label("Username:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this.textUser = new TextField("", 16);
            gridBagLayout.setConstraints(this.textUser, gridBagConstraints);
            panel.add(this.textUser);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            label = new Label("Password:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this.textPasswd = new TextField("", 16);
            this.textPasswd.setEchoChar('*');
            gridBagLayout.setConstraints(this.textPasswd, gridBagConstraints);
            panel.add(this.textPasswd);
            if (!this.haveServer) {
                this.textSrv.setText(this.propsHandler.getProperty("server"));
            }
            this.textUser.setText(this.propsHandler.getProperty("usrname"));
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Connect")) {
                    Object object;
                    if (!SSHTunnelingClient.this.listMode) {
                        object = "dummy";
                        if (!SSHTunnelingClient.this.haveServer) {
                            object = SSHTunnelingClient.this.textSrv.getText();
                        }
                        String string = SSHTunnelingClient.this.textUser.getText();
                        if (object == null || ((String)object).trim().length() == 0 || string == null || string.trim().length() == 0) {
                            return;
                        }
                    }
                    object = SSHTunnelingClient.this;
                    synchronized (object) {
                        SSHTunnelingClient.this.notify();
                    }
                    SSHTunnelingClient.this.connBut.setEnabled(false);
                    SSHTunnelingClient.this.discBut.requestFocus();
                } else if (actionEvent.getActionCommand().equals("Disconnect")) {
                    SSHTunnelingClient.this.forcedDisconnect();
                    SSHTunnelingClient.this.discBut.setEnabled(false);
                } else if (actionEvent.getActionCommand().equals("Tunnels Setup")) {
                    SSHTunnelDialog.show("MindTunnel - Basic Tunnels Setup", SSHTunnelingClient.this, SSHTunnelingClient.this.propsHandler, SSHTunnelingClient.this.parent);
                } else if (actionEvent.getActionCommand().equals("File Transfer")) {
                    SSHSCPDialog.show("MindTunnel - File Transfer", SSHTunnelingClient.this.parent, SSHTunnelingClient.this.propsHandler, SSHTunnelingClient.this);
                } else if (actionEvent.getActionCommand().equals("Configure Proxy")) {
                    SSHProxyDialog.show("MindTunnel - Proxy Settings", SSHTunnelingClient.this.parent, SSHTunnelingClient.this.propsHandler);
                }
            }
        };
        if (this.haveTunnelDialog || this.haveSCPDialog || this.haveProxyDialog) {
            Panel panel2 = new Panel(new FlowLayout());
            if (this.haveTunnelDialog) {
                this.tunnelBut = new Button("Tunnels Setup");
                this.tunnelBut.addActionListener(actionListener);
                panel2.add(this.tunnelBut);
            }
            if (this.haveSCPDialog) {
                this.scpBut = new Button("File Transfer");
                this.scpBut.addActionListener(actionListener);
                panel2.add(this.scpBut);
            }
            if (this.haveProxyDialog) {
                this.proxyBut = new Button("Configure Proxy");
                this.proxyBut.addActionListener(actionListener);
                panel2.add(this.proxyBut);
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(panel2, gridBagConstraints);
            panel.add(panel2);
        }
        Panel panel3 = new Panel(new FlowLayout());
        this.connBut = new Button("Connect");
        panel3.add(this.connBut);
        this.connBut.addActionListener(actionListener);
        this.discBut = new Button("Disconnect");
        panel3.add(this.discBut);
        this.discBut.addActionListener(actionListener);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        panel.add(panel3);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        this.parent.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        Image image = this.getLogo();
        if (image != null) {
            Logo logo = new Logo(image);
            switch (this.logoPlacement) {
                case 11: {
                    gridBagConstraints.fill = 0;
                    gridBagLayout.setConstraints(logo, gridBagConstraints);
                    this.parent.add(logo);
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridy = 1;
                    gridBagLayout.setConstraints(panel, gridBagConstraints);
                    this.parent.add(panel);
                    break;
                }
                case 17: {
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagLayout.setConstraints(logo, gridBagConstraints);
                    this.parent.add(logo);
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(panel, gridBagConstraints);
                    this.parent.add(panel);
                    break;
                }
                case 13: {
                    gridBagConstraints.gridwidth = 1;
                    gridBagLayout.setConstraints(panel, gridBagConstraints);
                    this.parent.add(panel);
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(logo, gridBagConstraints);
                    this.parent.add(logo);
                    break;
                }
                case 15: {
                    gridBagLayout.setConstraints(panel, gridBagConstraints);
                    this.parent.add(panel);
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.fill = 0;
                    gridBagLayout.setConstraints(logo, gridBagConstraints);
                    this.parent.add(logo);
                }
            }
        } else {
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.parent.add(panel);
        }
        AWTConvenience.setKeyListenerOfChildren(this.parent, new AWTConvenience.OKCancelAdapter(this.connBut, this.discBut), null);
        AWTConvenience.setBackgroundOfChildren(this.parent);
        this.parent.pack();
        this.parent.show();
    }

    Image getLogo() {
        Image image = null;
        InputStream inputStream = this.getClass().getResourceAsStream("/images/logo_top.gif");
        if (inputStream != null) {
            this.logoPlacement = 11;
        } else {
            inputStream = this.getClass().getResourceAsStream("/images/logo_left.gif");
            if (inputStream != null) {
                this.logoPlacement = 17;
            } else {
                inputStream = this.getClass().getResourceAsStream("/images/logo_right.gif");
                if (inputStream != null) {
                    this.logoPlacement = 13;
                } else {
                    inputStream = this.getClass().getResourceAsStream("/images/logo_bottom.gif");
                    if (inputStream != null) {
                        this.logoPlacement = 15;
                    } else {
                        return null;
                    }
                }
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public final boolean confirmDialog(String string, boolean bl) {
        return SSHMiscDialogs.confirm("MindTunnel - Confirmation", string, true, this.parent);
    }

    public final void alertDialog(String string) {
        SSHMiscDialogs.alert("MindTunnel - Alert", string, this.parent);
    }

    public final String passwordDialog(String string, String string2) {
        return SSHMiscDialogs.password(string2, string, this.parent);
    }

    public static class Logo
    extends Component {
        Image logo;

        public Logo(Image image) {
            this.logo = image;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            int n = -1;
            int n2 = -1;
            boolean bl = false;
            while (!bl) {
                n = this.logo.getWidth(null);
                n2 = this.logo.getHeight(null);
                if (n != -1 && n2 != -1) {
                    bl = true;
                }
                Thread.yield();
            }
            Dimension dimension = new Dimension(n, n2);
            return dimension;
        }

        public void paint(Graphics graphics) {
            if (this.logo == null) {
                return;
            }
            Dimension dimension = this.getSize();
            graphics.drawImage(this.logo, 0, 0, dimension.width, dimension.height, this);
        }
    }
}

