/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import com.isnetworks.ssh.FileDisplay;
import com.isnetworks.ssh.FileListItem;
import com.isnetworks.ssh.LocalFileBrowser;
import com.isnetworks.ssh.SSHException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHInteractor;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.ssh.SSHRemoteFileBrowsingConsole;
import mindbright.ssh.SSHSCPGUIThread;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class SSHSCPDialog
extends Dialog {
    private Button mUploadButton;
    private Button mDownloadButton;
    private Panel mFileDisplayPanel;
    private Panel mMainBottomSectionPanel;
    private TextArea mMessageTextArea;
    private FileDisplay mLocalFileDisplay;
    private FileDisplay mRemoteFileDisplay;
    private SSHRemoteFileBrowsingConsole mRemoteFileBrowser;
    private LocalFileBrowser mLocalFileBrowser;
    private Frame mOwnerFrame;
    private SSHPropertyHandler mPropertyHandler;
    private SSHInteractor mInterator;

    private SSHSCPDialog(Frame frame, SSHPropertyHandler sSHPropertyHandler, SSHInteractor sSHInteractor) {
        super(frame, "SCP Files", false);
        this.mOwnerFrame = frame;
        this.mPropertyHandler = sSHPropertyHandler;
        this.mInterator = sSHInteractor;
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        this.add("South", this.getMainBottomSectionPanel());
        this.add("Center", this.getFileDisplayPanel());
        this.pack();
        this.mRemoteFileBrowser = new SSHRemoteFileBrowsingConsole(this.getRemoteFileDisplay(), this.mPropertyHandler, this);
        this.mLocalFileBrowser = new LocalFileBrowser(this.getLocalFileDisplay(), this.mPropertyHandler);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)SSHSCPDialog.this).setVisible(false);
                SSHSCPDialog.this.mRemoteFileBrowser.disconnect();
            }
        });
    }

    private Panel getMainBottomSectionPanel() {
        if (this.mMainBottomSectionPanel == null) {
            this.mMainBottomSectionPanel = new Panel(new BorderLayout());
            this.getMainBottomSectionPanel().add("Center", this.getMessageTextArea());
        }
        return this.mMainBottomSectionPanel;
    }

    private TextArea getMessageTextArea() {
        if (this.mMessageTextArea == null) {
            this.mMessageTextArea = new TextArea("", 3, 30, 1);
            this.mMessageTextArea.setEditable(false);
            this.mMessageTextArea.setFont(new Font("Monospaced", 0, 11));
            this.mMessageTextArea.setBackground(Color.white);
        }
        return this.mMessageTextArea;
    }

    private Panel getFileDisplayPanel() {
        if (this.mFileDisplayPanel == null) {
            this.mFileDisplayPanel = new Panel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.mFileDisplayPanel.add((Component)this.getLocalFileDisplay(), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.mFileDisplayPanel.add((Component)this.getRemoteFileDisplay(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new Insets(0, 4, 2, 4);
            this.mFileDisplayPanel.add((Component)this.getDownloadButton(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new Insets(2, 4, 0, 4);
            this.mFileDisplayPanel.add((Component)this.getUploadButton(), gridBagConstraints);
        }
        return this.mFileDisplayPanel;
    }

    private FileDisplay getLocalFileDisplay() {
        if (this.mLocalFileDisplay == null) {
            this.mLocalFileDisplay = new FileDisplay(this.mOwnerFrame, "Local System", this);
        }
        return this.mLocalFileDisplay;
    }

    private FileDisplay getRemoteFileDisplay() {
        if (this.mRemoteFileDisplay == null) {
            this.mRemoteFileDisplay = new FileDisplay(this.mOwnerFrame, "Remote System", this);
        }
        return this.mRemoteFileDisplay;
    }

    private Button getDownloadButton() {
        if (this.mDownloadButton == null) {
            this.mDownloadButton = new Button("<--");
            this.mDownloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string = SSHSCPDialog.this.mPropertyHandler.getSrvHost();
                        int n = SSHSCPDialog.this.mPropertyHandler.getSrvPort();
                        String string2 = "";
                        String string3 = "";
                        FileListItem[] fileListItemArray = SSHSCPDialog.this.mRemoteFileDisplay.getSelectedFiles();
                        int n2 = 0;
                        while (n2 < fileListItemArray.length) {
                            string3 = string3 + "\"" + SSHSCPDialog.this.getRemoteFileDisplay().getFileSystemLocationLabelText() + fileListItemArray[n2].getName() + "\" ";
                            string2 = string2 + "\"" + fileListItemArray[n2].getName() + "\" ";
                            ++n2;
                        }
                        string3 = string3.trim();
                        String string4 = SSHSCPDialog.this.getLocalFileDisplay().getFileSystemLocationLabelText();
                        boolean bl = true;
                        boolean bl2 = false;
                        SSHSCPGUIThread sSHSCPGUIThread = new SSHSCPGUIThread(string, n, SSHSCPDialog.this.mPropertyHandler, SSHSCPDialog.this.mPropertyHandler, SSHSCPDialog.this.mInterator, SSHSCPDialog.this.mOwnerFrame, string4, string2, string3, bl, bl2, false, SSHSCPDialog.this);
                        try {
                            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
                            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
                        }
                        catch (ForbiddenTargetException forbiddenTargetException) {
                            forbiddenTargetException.printStackTrace();
                        }
                        Thread thread = new Thread(SSH.getThreadGroup(), sSHSCPGUIThread, SSH.createThreadName());
                        thread.start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        SSHSCPDialog.this.logError(exception);
                    }
                }
            });
        }
        return this.mDownloadButton;
    }

    private Button getUploadButton() {
        if (this.mUploadButton == null) {
            this.mUploadButton = new Button("-->");
            this.mUploadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        FileListItem fileListItem = SSHSCPDialog.this.getLocalFileDisplay().getSelectedFile();
                        String string = SSHSCPDialog.this.mPropertyHandler.getSrvHost();
                        int n = SSHSCPDialog.this.mPropertyHandler.getSrvPort();
                        String string2 = "";
                        FileListItem[] fileListItemArray = SSHSCPDialog.this.mLocalFileDisplay.getSelectedFiles();
                        int n2 = 0;
                        while (n2 < fileListItemArray.length) {
                            string2 = string2 + "\"" + fileListItemArray[n2].getName() + "\" ";
                            ++n2;
                        }
                        string2 = string2.trim();
                        String string3 = "\"" + SSHSCPDialog.this.getRemoteFileDisplay().getFileSystemLocationLabelText() + "\"";
                        String string4 = SSHSCPDialog.this.getLocalFileDisplay().getFileSystemLocationLabelText();
                        boolean bl = true;
                        boolean bl2 = false;
                        SSHSCPGUIThread sSHSCPGUIThread = new SSHSCPGUIThread(string, n, SSHSCPDialog.this.mPropertyHandler, SSHSCPDialog.this.mPropertyHandler, SSHSCPDialog.this.mInterator, SSHSCPDialog.this.mOwnerFrame, string4, string2, string3, bl, bl2, true, SSHSCPDialog.this);
                        try {
                            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
                            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
                        }
                        catch (ForbiddenTargetException forbiddenTargetException) {
                            forbiddenTargetException.printStackTrace();
                        }
                        Thread thread = new Thread(SSH.getThreadGroup(), sSHSCPGUIThread, SSH.createThreadName());
                        thread.start();
                    }
                    catch (Exception exception) {
                        SSHSCPDialog.this.logError(exception);
                    }
                }
            });
        }
        return this.mUploadButton;
    }

    public void refresh() {
        try {
            this.mRemoteFileBrowser.refresh();
            this.mLocalFileBrowser.refresh();
        }
        catch (SSHException sSHException) {
            this.logError(sSHException);
        }
    }

    public void show(SSHPropertyHandler sSHPropertyHandler) {
        try {
            PrivilegeManager.enablePrivilege("UniversalFileAccess");
            PrivilegeManager.enablePrivilege("TerminalEmulator");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        ((Component)this).setSize(600, 500);
        try {
            this.mRemoteFileBrowser.initialize();
            this.mLocalFileBrowser.initialize();
        }
        catch (SSHException sSHException) {
            this.logError(sSHException);
        }
        super.show();
    }

    public void logError(Exception exception) {
        this.mMessageTextArea.append(exception.getMessage() + "\n");
    }

    public static void show(String string, Frame frame, SSHPropertyHandler sSHPropertyHandler, SSHInteractor sSHInteractor) {
        SSHSCPDialog sSHSCPDialog = new SSHSCPDialog(frame, sSHPropertyHandler, sSHInteractor);
        sSHSCPDialog.show(sSHPropertyHandler);
    }
}

