/*
 * Decompiled with CFR 0.152.
 */
package mindbright.application;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.PopupMenu;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHInteractiveClient;
import mindbright.ssh.SSHMenuHandler;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.ssh.SSHSCP;
import mindbright.ssh.SSHSCPStdoutIndicator;
import mindbright.ssh.SSHStdIO;
import mindbright.terminal.TerminalDefProps;
import mindbright.terminal.TerminalMenuHandler;
import mindbright.terminal.TerminalMenuListener;
import mindbright.terminal.TerminalWin;
import mindbright.terminal.TerminalXTerm;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class MindTerm
extends Applet
implements Runnable {
    static Properties paramTermProps = new Properties();
    static Properties paramSSHProps = new Properties();
    public static String javaVersion = "<unknown>";
    public static String javaVendor = "<unknown>";
    public static String osName = "<unknown>";
    public static String osArch = "<unknown>";
    public static String osVersion = "<unknown>";
    Frame frame;
    TerminalWin term;
    SSHInteractiveClient client;
    SSHInteractiveClient sshClone;
    SSHStdIO console;
    Thread clientThread;
    boolean mergedTermProps;
    Properties sshProps;
    Properties termProps;
    String[] cmdLineArgs;
    String commandLine = null;
    String sshHomeDir = null;
    String propsFile = null;
    boolean usePopMenu = false;
    boolean haveMenus = true;
    boolean haveGUI = true;
    boolean cmdsh = false;
    boolean quiet = true;
    boolean helpinfo = true;
    String startupMsg = null;
    boolean doSCP = false;
    boolean recursiveSCP = false;
    boolean toRemote = true;
    int firstArg = 0;
    boolean autoSaveProps = true;
    boolean autoLoadProps = true;
    boolean savePasswords = false;
    int popButtonNum = 3;
    boolean isClosing = false;
    boolean separateFrame = true;
    boolean weAreAnApplet = false;
    static Hashtable terminals = new Hashtable();
    boolean confirmedClose = false;

    static synchronized boolean isLastTerminal() {
        return terminals.isEmpty();
    }

    static synchronized void addTerminal(MindTerm mindTerm) {
        terminals.put(mindTerm, mindTerm);
    }

    static synchronized void removeTerminal(MindTerm mindTerm) {
        terminals.remove(mindTerm);
    }

    public MindTerm() {
        this.sshProps = paramSSHProps;
        this.termProps = paramTermProps;
        MindTerm.addTerminal(this);
    }

    public MindTerm(Properties properties, Properties properties2) {
        this.sshProps = properties;
        this.termProps = properties2;
        MindTerm.addTerminal(this);
    }

    public static void main(String[] stringArray) {
        MindTerm mindTerm = new MindTerm(paramSSHProps, paramTermProps);
        mindTerm.cmdLineArgs = stringArray;
        try {
            mindTerm.getApplicationParams();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            System.exit(1);
        }
        try {
            mindTerm.run();
        }
        catch (Exception exception) {
            System.out.println("Error, please mail below stack-trace to mats@mindbright.se");
            exception.printStackTrace();
        }
    }

    public void init() {
        try {
            PrivilegeManager.enablePrivilege("TerminalEmulator");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            forbiddenTargetException.printStackTrace();
        }
        this.weAreAnApplet = true;
        this.autoSaveProps = false;
        this.autoLoadProps = false;
        this.savePasswords = false;
        this.getAppletParams();
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
            System.out.println("got permissions");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            forbiddenTargetException.printStackTrace();
        }
        new Thread(SSH.getThreadGroup(), this).start();
    }

    public void run() {
        block33: {
            try {
                String string;
                Object object;
                String[] stringArray;
                if (this.sshClone != null) {
                    this.client = new SSHInteractiveClient(this.sshClone);
                    this.sshClone = null;
                } else {
                    if (this.commandLine != null && this.sshProps.getProperty("forcpty") == null) {
                        ((Hashtable)this.sshProps).put("forcpty", "false");
                    }
                    stringArray = new SSHPropertyHandler(this.sshProps);
                    if (this.propsFile != null) {
                        try {
                            stringArray = SSHPropertyHandler.fromFile(this.propsFile, "");
                        }
                        catch (SSHClient.AuthFailException authFailException) {
                            throw new Exception("Sorry, can only use passwordless settings files for now");
                        }
                        stringArray.mergeProperties(this.sshProps);
                    }
                    this.client = new SSHInteractiveClient(this.quiet, this.cmdsh, (SSHPropertyHandler)stringArray);
                }
                this.console = (SSHStdIO)this.client.getConsole();
                if (this.client.getPropertyHandler().getInitTerminalProperties() != null) {
                    stringArray = new Properties(this.client.getPropertyHandler().getInitTerminalProperties());
                    if (this.termProps != null && !((Hashtable)this.termProps).isEmpty()) {
                        object = ((Hashtable)this.termProps).keys();
                        while (object.hasMoreElements()) {
                            string = (String)object.nextElement();
                            stringArray.put(string, this.termProps.getProperty(string));
                        }
                        this.mergedTermProps = true;
                    }
                    this.termProps = stringArray;
                }
                if (this.haveGUI) {
                    this.initGUI();
                    this.console.setTerminal(this.term);
                    this.console.setOwnerContainer(this.frame);
                    this.console.setOwnerName("MindTerm v1.2.1SCP3");
                    this.console.updateTitle();
                    try {
                        while (!this.frame.isShowing()) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.separateFrame) {
                        this.term.emulateComponentShown();
                    }
                }
                this.client.printCopyright();
                this.client.getPropertyHandler().setSSHHomeDir(this.sshHomeDir);
                this.client.getPropertyHandler().setAutoSaveProps(this.autoLoadProps);
                this.client.getPropertyHandler().setAutoLoadProps(this.autoSaveProps);
                this.client.getPropertyHandler().setSavePasswords(this.savePasswords);
                this.client.updateMenus();
                if (this.commandLine != null) {
                    if (!this.doSCP) {
                        this.client.doSingleCommand(this.commandLine, false, 0L);
                    } else {
                        if (this.cmdLineArgs.length - this.firstArg < 2) {
                            throw new Exception("scp must have at least two arguments (<source> <destination>)");
                        }
                        stringArray = new String[this.cmdLineArgs.length - this.firstArg - 1];
                        string = this.commandLine.substring(0, this.commandLine.lastIndexOf(32));
                        int n = this.firstArg;
                        while (n < this.cmdLineArgs.length - 1) {
                            stringArray[n - this.firstArg] = this.cmdLineArgs[n];
                            ++n;
                        }
                        object = this.cmdLineArgs[this.cmdLineArgs.length - 1];
                        String string2 = this.client.getPropertyHandler().getSrvHost();
                        int n2 = this.client.getPropertyHandler().getSrvPort();
                        SSHSCP sSHSCP = new SSHSCP(string2, n2, this.client.getPropertyHandler(), new File("."), SSH.DEBUG, this.recursiveSCP);
                        if (SSH.DEBUG) {
                            sSHSCP.setInteractor(this.client);
                            sSHSCP.setIndicator(new SSHSCPStdoutIndicator());
                        }
                        if (this.toRemote) {
                            sSHSCP.copyToRemote(stringArray, (String)object);
                        } else {
                            sSHSCP.copyToLocal((String)object, string);
                        }
                    }
                    break block33;
                }
                try {
                    try {
                        PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
                        PrivilegeManager.enablePrivilege("UniversalThreadAccess");
                    }
                    catch (ForbiddenTargetException forbiddenTargetException) {
                        // empty catch block
                    }
                    this.clientThread = new Thread(SSH.getThreadGroup(), this.client);
                    this.clientThread.start();
                    this.clientThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.client != null) {
                    this.client.alert(illegalArgumentException.getMessage());
                }
                System.out.println(illegalArgumentException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Settings-file not found: " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                if (this.client != null) {
                    this.client.alert("Error: " + exception.getMessage());
                }
                System.out.println("Error: " + exception.getMessage());
                if (!SSH.DEBUGMORE) break block33;
                System.out.println("Please send the below stack-trace to mats@mindbright.se");
                exception.printStackTrace();
            }
        }
        this.windowClosing(null);
        if (MindTerm.isLastTerminal()) {
            this.doExit();
        }
    }

    public void getAppletParams() {
        String string;
        String string2;
        try {
            this.separateFrame = new Boolean(this.getParameter("sepframe"));
        }
        catch (Exception exception) {
            this.separateFrame = true;
        }
        try {
            SSH.DEBUG = new Boolean(this.getParameter("verbose"));
        }
        catch (Exception exception) {
            SSH.DEBUG = false;
        }
        try {
            SSH.DEBUG = SSH.DEBUGMORE = new Boolean(this.getParameter("debug")).booleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.quiet = new Boolean(this.getParameter("quiet"));
        }
        catch (Exception exception) {
            this.quiet = true;
        }
        try {
            this.savePasswords = new Boolean(this.getParameter("savepasswords"));
        }
        catch (Exception exception) {
            this.savePasswords = false;
        }
        try {
            this.cmdsh = new Boolean(this.getParameter("cmdsh"));
        }
        catch (Exception exception) {
            this.cmdsh = false;
        }
        try {
            this.helpinfo = new Boolean(this.getParameter("helpinfo"));
        }
        catch (Exception exception) {
            this.helpinfo = true;
        }
        this.startupMsg = this.getParameter("startmsg");
        String string3 = this.getParameter("menus");
        if (string3 != null) {
            if (string3.equals("no")) {
                this.haveMenus = false;
            } else if (string3.startsWith("pop")) {
                this.getPopupButtonNumber(string3);
                this.usePopMenu = true;
            }
        }
        if ((string3 = this.getParameter("autoprops")) != null) {
            if (string3.equals("save")) {
                this.autoSaveProps = true;
                this.autoLoadProps = false;
            } else if (string3.equals("load")) {
                this.autoSaveProps = false;
                this.autoLoadProps = true;
            } else if (string3.equals("both")) {
                this.autoSaveProps = true;
                this.autoLoadProps = true;
            }
        }
        this.sshHomeDir = this.getParameter("sshhome");
        this.propsFile = this.getParameter("propsfile");
        this.commandLine = this.getParameter("commandline");
        this.getDefaultParams();
        int n = 0;
        while (n < SSHPropertyHandler.defaultPropDesc.length) {
            string2 = SSHPropertyHandler.defaultPropDesc[n][0];
            string = this.getParameter(string2);
            if (string != null) {
                ((Hashtable)paramSSHProps).put(string2, string);
            }
            ++n;
        }
        n = 0;
        while ((string = this.getParameter("local" + n)) != null) {
            ((Hashtable)paramSSHProps).put("local" + n, string);
            ++n;
        }
        n = 0;
        while ((string = this.getParameter("remote" + n)) != null) {
            ((Hashtable)paramSSHProps).put("remote" + n, string);
            ++n;
        }
        n = 0;
        while (n < TerminalDefProps.defaultPropDesc.length) {
            string2 = TerminalDefProps.defaultPropDesc[n][0];
            string = this.getParameter(string2);
            if (string != null) {
                ((Hashtable)this.termProps).put(string2, string);
            }
            ++n;
        }
        string3 = this.getParameter("appletbg");
        if (string3 != null) {
            Color color;
            try {
                color = TerminalWin.getTermColor(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    color = TerminalWin.getTermRGBColor(string3);
                }
                catch (Throwable throwable) {
                    color = null;
                }
            }
            if (color != null) {
                this.setBackground(color);
            }
        }
    }

    public void getApplicationParams() throws Exception {
        int n;
        int n2;
        try {
            n2 = 0;
            while (n2 < this.cmdLineArgs.length) {
                String string = this.cmdLineArgs[n2];
                if (string.startsWith("--")) {
                    switch (string.charAt(2)) {
                        case 'h': {
                            this.sshHomeDir = this.cmdLineArgs[++n2];
                            break;
                        }
                        case 'f': {
                            this.propsFile = this.cmdLineArgs[++n2];
                            break;
                        }
                        case 'c': {
                            this.cmdsh = true;
                            break;
                        }
                        case 'd': {
                            this.haveGUI = false;
                            break;
                        }
                        case 'm': {
                            String string2 = this.cmdLineArgs[++n2];
                            if (string2.equals("no")) {
                                this.haveMenus = false;
                                break;
                            }
                            if (string2.startsWith("pop")) {
                                this.getPopupButtonNumber(string2);
                                this.usePopMenu = true;
                                break;
                            }
                            throw new Exception("value of '--m' must be 'no', 'pop1', 'pop2', or 'pop3'");
                        }
                        case 'p': {
                            String string2 = this.cmdLineArgs[++n2];
                            if (string2.equals("save")) {
                                this.autoSaveProps = true;
                                break;
                            }
                            if (string2.equals("load")) {
                                this.autoLoadProps = true;
                                break;
                            }
                            if (string2.equals("both")) {
                                this.autoSaveProps = true;
                                this.autoLoadProps = true;
                                break;
                            }
                            if (string2.equals("none")) {
                                this.autoSaveProps = false;
                                this.autoLoadProps = false;
                                break;
                            }
                            throw new Exception("value of '--p' must be 'save', 'load', 'both', or 'none'");
                        }
                        case 'q': {
                            String string2 = this.cmdLineArgs[++n2];
                            if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false")) {
                                this.quiet = Boolean.valueOf(string2);
                                break;
                            }
                            throw new Exception("value of '--q' must be 'true' or 'false'");
                        }
                        case 'r': {
                            this.recursiveSCP = true;
                            break;
                        }
                        case 's': {
                            this.haveGUI = false;
                            this.doSCP = true;
                            String string3 = this.cmdLineArgs[++n2];
                            if (string3.equalsIgnoreCase("toremote")) {
                                this.toRemote = true;
                                break;
                            }
                            if (string3.equalsIgnoreCase("tolocal")) {
                                this.toRemote = false;
                                break;
                            }
                            throw new Exception("value of '--s' must be 'toremote' or 'tolocal'");
                        }
                        case 'v': {
                            System.out.println("verbose mode selected...");
                            SSH.DEBUG = true;
                            break;
                        }
                        case 'x': {
                            this.savePasswords = true;
                            break;
                        }
                        case 'V': {
                            System.out.println("MindTerm v1.2.1SCP3");
                            System.out.println("SSH protocol version 1.5");
                            System.exit(0);
                            break;
                        }
                        case 'D': {
                            SSH.DEBUG = true;
                            SSH.DEBUGMORE = true;
                            break;
                        }
                        case '?': {
                            this.printHelp();
                            System.exit(0);
                        }
                        default: {
                            throw new Exception("unknown parameter '" + string + "'");
                        }
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.printHelp();
            throw exception;
        }
        this.getDefaultParams();
        n2 = n = n2;
        while (n2 < this.cmdLineArgs.length) {
            String string = this.cmdLineArgs[n2];
            if (string.charAt(0) != '-' || n2 + 1 == this.cmdLineArgs.length) break;
            string = string.substring(1);
            String string4 = this.cmdLineArgs[n2 + 1];
            if (SSHPropertyHandler.isProperty(string)) {
                ((Hashtable)paramSSHProps).put(string, string4);
            } else if (TerminalDefProps.isProperty(string)) {
                ((Hashtable)paramTermProps).put(string, string4);
            } else {
                System.out.println("Unknown property '" + string + "'");
            }
            n2 += 2;
        }
        if (n2 < this.cmdLineArgs.length) {
            this.firstArg = n2;
            this.commandLine = "";
            while (n2 < this.cmdLineArgs.length) {
                this.commandLine = this.commandLine + this.cmdLineArgs[n2] + " ";
                ++n2;
            }
            this.commandLine = this.commandLine.trim();
        }
    }

    void printHelp() {
        System.out.println("usage: MindTerm [options] [properties] [command]");
        System.out.println("Options:");
        System.out.println("  --c            Enable local command-shell.");
        System.out.println("  --d            No terminal-window, only dumb command-line and port-forwarding.");
        System.out.println("  --f <file>     Use settings from the given file.");
        System.out.println("  --h dir        Name of the MindTerm home-dir (default: ~/mindterm/).");
        System.out.println("  --m <no | pop | popN>");
        System.out.println("                 Use no menus or popup (on mouse-button N) menu instead of menubar.");
        System.out.println("  --p <save | load | both | none>");
        System.out.println("                 Sets automatic save/load flags for property-files.");
        System.out.println("  --q <true | false>");
        System.out.println("                 Quiet; don't query for server/username if given.");
        System.out.println("  --v            Verbose; display verbose messages.");
        System.out.println("  --x            Save passwords in property-files.");
        System.out.println("  --D            Debug; display extra debug info.");
        System.out.println("  --V            Version; display version number only.");
        System.out.println("  --?            Help; display this help.");
    }

    void getPopupButtonNumber(String string) {
        if (string.length() == 4) {
            try {
                this.popButtonNum = Integer.valueOf(string.substring(3));
                if (this.popButtonNum < 1 || this.popButtonNum > 3) {
                    this.popButtonNum = 3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void getDefaultParams() {
        try {
            if (this.sshHomeDir == null) {
                String string = System.getProperty("user.home");
                if (string == null) {
                    string = System.getProperty("user.dir");
                }
                if (string == null) {
                    string = System.getProperty("java.home");
                }
                this.sshHomeDir = string + File.separator + "mindterm" + File.separator;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.weAreAnApplet) {
            ((Hashtable)paramSSHProps).put("server", this.getCodeBase().getHost());
        }
        try {
            if (!this.quiet) {
                ((Hashtable)paramSSHProps).put("usrname", System.getProperty("user.name", ""));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            javaVersion = System.getProperty("java.version");
            javaVendor = System.getProperty("java.vendor");
            osName = System.getProperty("os.name");
            osArch = System.getProperty("os.arch");
            osVersion = System.getProperty("os.version");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void initGUI() {
        Object object;
        Container container;
        MenuBar menuBar = null;
        if (this.separateFrame) {
            this.frame = new Frame();
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MindTerm.this.windowClosing(windowEvent);
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                    MindTerm.this.term.requestFocus();
                }
            });
            container = this.frame;
            if (this.haveMenus && !this.usePopMenu) {
                menuBar = new MenuBar();
                this.frame.setMenuBar(menuBar);
                this.frame.addNotify();
                this.frame.validate();
            }
        } else {
            object = this;
            while (!((object = ((Component)object).getParent()) instanceof Frame)) {
            }
            this.frame = (Frame)object;
            container = this;
        }
        this.term = new TerminalWin(this.frame, new TerminalXTerm(), this.termProps);
        if (this.mergedTermProps) {
            this.term.setPropsChanged(true);
        }
        if (this.haveMenus) {
            try {
                Class<?> clazz = Class.forName("mindbright.ssh.SSHMenuHandlerFull");
                object = (SSHMenuHandler)clazz.newInstance();
                ((SSHMenuHandler)object).init(this, this.client, this.frame, this.term);
                clazz = Class.forName("mindbright.terminal.TerminalMenuHandlerFull");
                TerminalMenuHandler terminalMenuHandler = (TerminalMenuHandler)clazz.newInstance();
                terminalMenuHandler.setTerminalWin(this.term);
                this.term.setMenus(terminalMenuHandler);
                this.client.setMenus((SSHMenuHandler)object);
                if (menuBar == null) {
                    PopupMenu popupMenu = this.term.getPopupMenu("MindTerm Menu");
                    ((SSHMenuHandler)object).preparePopupMenu(popupMenu);
                    ((SSHMenuHandler)object).setPopupButton(this.popButtonNum);
                } else {
                    ((SSHMenuHandler)object).prepareMenuBar(menuBar);
                }
                terminalMenuHandler.setTerminalMenuListener((TerminalMenuListener)object);
            }
            catch (Throwable throwable) {
                System.out.println("Full menus can't be enabled since classes are missing");
                this.term.setMenus(null);
                this.client.setMenus(null);
            }
        }
        container.setLayout(new BorderLayout());
        container.add((Component)this.term.getPanelWithScrollbar(), "Center");
        this.frame.pack();
        this.frame.show();
        this.term.requestFocus();
    }

    public synchronized void windowClosing(WindowEvent windowEvent) {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        if (!this.confirmClose()) {
            this.isClosing = false;
            return;
        }
        if (this.separateFrame && this.haveGUI && this.frame != null) {
            this.frame.dispose();
        }
        if (this.clientThread != null && this.clientThread.isAlive()) {
            this.clientThread.stop();
        }
        MindTerm.removeTerminal(this);
    }

    public void doExit() {
        System.out.println("Thank you for using MindTerm...");
        if (!this.separateFrame && this.term != null) {
            try {
                this.term.cursorSetPos(this.term.rows() - 1, 0, false);
                int n = 0;
                while (n < this.term.rows()) {
                    this.term.write("\n\r");
                    Thread.sleep(50L);
                    ++n;
                }
                this.term.cursorSetPos(0, 0, false);
                n = 0;
                while (n < this.term.rows() - 1) {
                    this.term.write(".\n\r");
                    Thread.sleep(50L);
                    ++n;
                }
                this.term.write("Thank you for using MindTerm...");
                n = 0;
                while (n < this.term.rows() - 1) {
                    this.term.write("\n\r");
                    Thread.sleep(50L);
                    ++n;
                }
                this.term.cursorSetPos(2, 0, false);
                this.term.setAttribute(1, true);
                this.term.write("Visit <http://www.mindbright.se/mindterm> for more information.");
                this.term.cursorSetPos(this.term.rows() - 1, this.term.cols() - 1, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (SSH.secureRandom != null && SSH.secureRandom().updater != null && SSH.secureRandom().updater.isAlive()) {
            SSH.secureRandom().updater.stop();
        }
        if (!this.weAreAnApplet) {
            System.exit(0);
        }
    }

    public boolean confirmClose() {
        if (this.client != null && !this.confirmedClose) {
            try {
                this.client.getPropertyHandler().checkSave();
            }
            catch (IOException iOException) {
                this.client.alert("Error saving settings: " + iOException.getMessage());
            }
            this.confirmedClose = !this.client.isOpened() || this.client.askConfirmation("Do you really want to disconnect from " + this.client.getPropertyHandler().getProperty("server") + "?", false);
        }
        return this.confirmedClose;
    }

    void initParams(MindTerm mindTerm) {
        this.sshHomeDir = mindTerm.sshHomeDir;
        this.propsFile = mindTerm.propsFile;
        this.usePopMenu = mindTerm.usePopMenu;
        this.haveMenus = mindTerm.haveMenus;
        this.haveGUI = mindTerm.haveGUI;
        this.cmdsh = mindTerm.cmdsh;
        this.quiet = mindTerm.quiet;
        this.separateFrame = true;
        this.weAreAnApplet = mindTerm.weAreAnApplet;
        this.autoLoadProps = mindTerm.autoLoadProps;
        this.popButtonNum = mindTerm.popButtonNum;
    }

    public void cloneWindow() {
        MindTerm mindTerm = new MindTerm(this.sshProps, this.termProps);
        mindTerm.initParams(this);
        mindTerm.sshClone = this.client;
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        new Thread(SSH.getThreadGroup(), mindTerm).start();
    }

    public void newWindow() {
        MindTerm mindTerm = new MindTerm(paramSSHProps, paramTermProps);
        mindTerm.initParams(this);
        new Thread(SSH.getThreadGroup(), mindTerm).start();
    }

    public void close() {
        if (!this.confirmClose()) {
            return;
        }
        this.clientThread.stop();
    }

    public void exit() {
        if (!this.confirmClose()) {
            return;
        }
        Enumeration enumeration = terminals.elements();
        while (enumeration.hasMoreElements()) {
            MindTerm mindTerm = (MindTerm)enumeration.nextElement();
            if (mindTerm.clientThread == null) continue;
            mindTerm.clientThread.stop();
        }
    }
}

