/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.ui.TaskProgressEditor;
import net.sf.memoranda.ui.TaskTableModel;
import net.sf.memoranda.ui.TaskTableSorter;
import net.sf.memoranda.ui.TaskTreeTableCellRenderer;
import net.sf.memoranda.ui.treetable.AbstractCellEditor;
import net.sf.memoranda.ui.treetable.TreeTableModel;
import net.sf.memoranda.ui.treetable.TreeTableModelAdapter;
import net.sf.memoranda.util.Local;

public class TaskTable
extends JTable {
    public static final int TASK_ID = 100;
    public static final int TASK = 101;
    protected TreeTableCellRenderer tree;
    protected TaskTableModel model;
    protected TreeTableModelAdapter modelAdapter;
    protected TaskTreeTableCellRenderer renderer;
    protected ExpansionHandler expansion;

    public TaskTable() {
        this.initTable();
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                TaskTable.this.tableChanged();
            }
        });
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
            }

            public void projectWasChanged() {
                TaskTable.this.tableChanged();
            }
        });
    }

    private void initTable() {
        this.model = new TaskTableSorter(this);
        this.tree = new TreeTableCellRenderer(this.model);
        this.expansion = new ExpansionHandler();
        this.tree.addTreeExpansionListener(this.expansion);
        this.modelAdapter = new TreeTableModelAdapter(this.model, this.tree);
        super.setModel(this.modelAdapter);
        this.renderer = new TaskTreeTableCellRenderer(this);
        this.tree.setCellRenderer(this.renderer);
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultRenderer(Integer.class, this.renderer);
        this.setDefaultRenderer(TaskTable.class, this.renderer);
        this.setDefaultRenderer(String.class, this.renderer);
        this.setDefaultRenderer(Date.class, this.renderer);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.getColumn("% " + Local.getString("done")).setCellEditor(new TaskProgressEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(18);
        this.initColumnWidths();
        this.getTableHeader().setReorderingAllowed(false);
    }

    void initColumnWidths() {
        for (int i = 0; i < 7; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(8);
                continue;
            }
            if (i == 1) {
                tableColumn.setPreferredWidth(Short.MAX_VALUE);
                continue;
            }
            if (i == 6) {
                tableColumn.setPreferredWidth(100);
                tableColumn.setMinWidth(100);
                continue;
            }
            tableColumn.setMinWidth(67);
            tableColumn.setPreferredWidth(67);
        }
    }

    public void tableChanged() {
        this.model.fireUpdateCache();
        this.model.fireTreeStructureChanged();
        this.expansion.expand(this.tree);
        this.updateUI();
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public TreeTableCellRenderer getTree() {
        return this.tree;
    }

    class ExpansionHandler
    implements TreeExpansionListener {
        private Set expanded = new HashSet();

        ExpansionHandler() {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.expanded.add(treeExpansionEvent.getPath());
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = treePath.getPathCount() - 1;
            Object object = treePath.getLastPathComponent();
            Object[] objectArray = this.expanded.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                TreePath treePath2 = (TreePath)objectArray[i];
                if (treePath2.getPathCount() <= n || !treePath2.getPathComponent(n).equals(object)) continue;
                this.expanded.remove(treePath2);
            }
        }

        public void expand(JTree jTree) {
            Iterator iterator = this.expanded.iterator();
            while (iterator.hasNext()) {
                jTree.expandPath((TreePath)iterator.next());
            }
            System.out.println(this.expanded.size());
        }
    }

    public class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        public ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = TaskTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return TaskTable.this.tree;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int i = TaskTable.this.getColumnCount() - 1; i >= 0; --i) {
                    if (TaskTable.this.getColumnClass(i) != (class$net$sf$memoranda$ui$treetable$TreeTableModel == null ? TaskTable.class$("net.sf.memoranda.ui.treetable.TreeTableModel") : class$net$sf$memoranda$ui$treetable$TreeTableModel)) continue;
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(TaskTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - TaskTable.this.getCellRect((int)0, (int)i, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    TaskTable.this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setCellRenderer(TaskTable.this.renderer);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setBorderSelectionColor(null);
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (TaskTable.this != null && TaskTable.this.getRowHeight() != n) {
                    TaskTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, TaskTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this;
        }
    }
}

