/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.Resource;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.table.TableSorter;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.MimeType;
import net.sf.memoranda.util.MimeTypesList;

public class ResourcesTable
extends JTable {
    Vector files = null;
    TableSorter sorter = null;
    ImageIcon inetIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/mimetypes/inetshortcut.png"));
    public static final int _RESOURCE = 100;

    public ResourcesTable() {
        this.initTable();
        this.sorter = new TableSorter(new ResourcesTableModel());
        this.sorter.addMouseListenerToHeaderInTable(this);
        this.setModel(this.sorter);
        this.setShowGrid(false);
        this.setFont(new Font("Dialog", 0, 11));
        this.initColumsWidth();
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
            }

            public void projectWasChanged() {
                ResourcesTable.this.tableChanged();
            }
        });
    }

    void initColumsWidth() {
        for (int i = 0; i < 4; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(Short.MAX_VALUE);
                continue;
            }
            tableColumn.setMinWidth(100);
            tableColumn.setPreferredWidth(100);
        }
    }

    public void tableChanged() {
        this.initTable();
        this.sorter.tableChanged(null);
        this.initColumsWidth();
        this.updateUI();
    }

    public void initTable() {
        Vector vector = CurrentProject.getResourcesList().getAllResources();
        this.files = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Resource resource = (Resource)vector.get(i);
            if (!resource.isInetShortcut()) {
                File file = new File(resource.getPath());
                if (!file.isFile()) continue;
                this.files.add(resource);
                continue;
            }
            this.files.add(resource);
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 0) {
                    Resource resource = (Resource)ResourcesTable.this.getModel().getValueAt(n, 100);
                    if (!resource.isInetShortcut()) {
                        jLabel.setIcon(MimeTypesList.getMimeTypeForFile((String)object).getIcon());
                    } else {
                        jLabel.setIcon(ResourcesTable.this.inetIcon);
                    }
                }
                return jLabel;
            }
        };
    }

    class ResourcesTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{Local.getString("Name"), Local.getString("Type"), Local.getString("Date modified"), Local.getString("Path")};

        ResourcesTableModel() {
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return ResourcesTable.this.files.size();
        }

        public Object getValueAt(int n, int n2) {
            Resource resource = (Resource)ResourcesTable.this.files.get(n);
            if (n2 == 100) {
                return resource;
            }
            if (!resource.isInetShortcut()) {
                File file = new File(resource.getPath());
                switch (n2) {
                    case 0: {
                        return file.getName();
                    }
                    case 1: {
                        MimeType mimeType = MimeTypesList.getMimeTypeForFile(file.getName());
                        if (mimeType != null) {
                            return mimeType.getLabel();
                        }
                        return "unknown";
                    }
                    case 2: {
                        Date date = new Date(file.lastModified());
                        return date;
                    }
                    case 3: {
                        return file.getPath();
                    }
                }
            } else {
                if (n2 == 0) {
                    return resource.getPath();
                }
                if (n2 == 1) {
                    return Local.getString("Internet shortcut");
                }
                return "";
            }
            return null;
        }

        public Class getColumnClass(int n) {
            try {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 3: {
                        return Class.forName("java.lang.String");
                    }
                    case 2: {
                        return Class.forName("java.util.Date");
                    }
                }
            }
            catch (Exception exception) {
                new ExceptionDialog(exception);
            }
            return null;
        }
    }
}

