/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.ExpandablePanel;
import net.sf.memoranda.ui.ProjectDialog;
import net.sf.memoranda.ui.ProjectsTablePanel;
import net.sf.memoranda.util.Context;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;

public class ProjectsPanel
extends JPanel
implements ExpandablePanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar topBar = new JToolBar();
    JPanel toolbarPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel buttonsPanel = new JPanel();
    JButton toggleButton = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    Vector expListeners = new Vector();
    boolean expanded = false;
    ImageIcon expIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/exp_panel.png"));
    ImageIcon collIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/coll_panel.png"));
    JLabel curProjectTitle = new JLabel();
    Component component1;
    JPopupMenu projectsPPMenu = new JPopupMenu();
    JMenuItem ppNewProject = new JMenuItem();
    JMenuItem ppProperties = new JMenuItem();
    JMenuItem ppDeleteProject = new JMenuItem();
    JMenuItem ppOpenProject = new JMenuItem();
    JCheckBoxMenuItem ppShowActiveOnlyChB = new JCheckBoxMenuItem();
    JButton ppOpenB = new JButton();
    ProjectsTablePanel prjTablePanel = new ProjectsTablePanel();
    public Action newProjectAction = new AbstractAction(Local.getString("New project") + "...", new ImageIcon(AppFrame.class.getResource("resources/icons/newproject.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            ProjectsPanel.this.ppNewProject_actionPerformed(actionEvent);
        }
    };

    public ProjectsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(20);
        this.setLayout(this.borderLayout1);
        this.topBar.setBackground(new Color(215, 225, 250));
        this.topBar.setAlignmentX(0.0f);
        this.topBar.setFloatable(false);
        this.toolbarPanel.setLayout(this.borderLayout2);
        this.toggleButton.setMaximumSize(new Dimension(20, 20));
        this.toggleButton.setMinimumSize(new Dimension(20, 20));
        this.toggleButton.setOpaque(false);
        this.toggleButton.setPreferredSize(new Dimension(20, 20));
        this.toggleButton.setBorderPainted(false);
        this.toggleButton.setContentAreaFilled(false);
        this.toggleButton.setFocusPainted(false);
        this.toggleButton.setVerticalAlignment(1);
        this.toggleButton.setVerticalTextPosition(3);
        this.toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectsPanel.this.toggleButton_actionPerformed(null);
            }
        });
        this.toggleButton.setIcon(this.expIcon);
        this.toggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonsPanel.setMinimumSize(new Dimension(70, 22));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setPreferredSize(new Dimension(80, 22));
        this.buttonsPanel.setRequestFocusEnabled(false);
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.toolbarPanel.setBackground(SystemColor.textHighlight);
        this.toolbarPanel.setMinimumSize(new Dimension(91, 22));
        this.toolbarPanel.setOpaque(false);
        this.toolbarPanel.setPreferredSize(new Dimension(91, 22));
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.curProjectTitle.setFont(new Font("Dialog", 1, 11));
        this.curProjectTitle.setForeground(new Color(64, 70, 128));
        this.curProjectTitle.setMaximumSize(new Dimension(Short.MAX_VALUE, 22));
        this.curProjectTitle.setPreferredSize(new Dimension(Short.MAX_VALUE, 22));
        this.curProjectTitle.setText(CurrentProject.get().getTitle());
        this.curProjectTitle.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ProjectsPanel.this.toggleButton_actionPerformed(null);
            }
        });
        this.ppNewProject.setFont(new Font("Dialog", 1, 11));
        this.ppNewProject.setAction(this.newProjectAction);
        this.ppProperties.setFont(new Font("Dialog", 1, 11));
        this.ppProperties.setText(Local.getString("Project properties"));
        this.ppProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectsPanel.this.ppProperties_actionPerformed(actionEvent);
            }
        });
        this.ppProperties.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/editproject.png")));
        this.ppProperties.setEnabled(false);
        this.ppDeleteProject.setFont(new Font("Dialog", 1, 11));
        this.ppDeleteProject.setText(Local.getString("Delete project"));
        this.ppDeleteProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectsPanel.this.ppDeleteProject_actionPerformed(actionEvent);
            }
        });
        this.ppDeleteProject.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/removeproject.png")));
        this.ppDeleteProject.setEnabled(false);
        this.ppOpenProject.setFont(new Font("Dialog", 1, 11));
        this.ppOpenProject.setText(" " + Local.getString("Open project"));
        this.ppOpenProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectsPanel.this.ppOpenProject_actionPerformed(actionEvent);
            }
        });
        this.ppOpenProject.setEnabled(false);
        this.ppShowActiveOnlyChB.setFont(new Font("Dialog", 1, 11));
        this.ppShowActiveOnlyChB.setText(Local.getString("Show active projects only"));
        this.ppShowActiveOnlyChB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectsPanel.this.ppShowActiveOnlyChB_actionPerformed(actionEvent);
            }
        });
        boolean bl = Context.get("SHOW_ACTIVE_PROJECTS_ONLY") != null && Context.get("SHOW_ACTIVE_PROJECTS_ONLY").equals("true");
        this.ppShowActiveOnlyChB.setSelected(bl);
        this.ppShowActiveOnlyChB_actionPerformed(null);
        this.projectsPPMenu.setFont(new Font("Dialog", 1, 10));
        this.ppOpenB.setMaximumSize(new Dimension(34, 20));
        this.ppOpenB.setMinimumSize(new Dimension(24, 10));
        this.ppOpenB.setOpaque(false);
        this.ppOpenB.setPreferredSize(new Dimension(24, 20));
        this.ppOpenB.setBorderPainted(false);
        this.ppOpenB.setFocusPainted(false);
        this.ppOpenB.setMargin(new Insets(0, 0, 0, 0));
        this.ppOpenB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectsPanel.this.ppOpenB_actionPerformed(actionEvent);
            }
        });
        this.ppOpenB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/ppopen.png")));
        this.buttonsPanel.add((Component)this.ppOpenB, null);
        this.buttonsPanel.add(this.component1, null);
        this.add((Component)this.topBar, "North");
        this.add((Component)this.prjTablePanel, "Center");
        this.topBar.add((Component)this.toolbarPanel, null);
        this.toolbarPanel.add((Component)this.buttonsPanel, "East");
        this.buttonsPanel.add((Component)this.toggleButton, null);
        this.toolbarPanel.add((Component)this.curProjectTitle, "Center");
        this.projectsPPMenu.add(this.ppOpenProject);
        this.projectsPPMenu.addSeparator();
        this.projectsPPMenu.add(this.ppNewProject);
        this.projectsPPMenu.add(this.ppDeleteProject);
        this.projectsPPMenu.addSeparator();
        this.projectsPPMenu.add(this.ppProperties);
        this.projectsPPMenu.addSeparator();
        this.projectsPPMenu.add(this.ppShowActiveOnlyChB);
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
            }

            public void projectWasChanged() {
                ProjectsPanel.this.curProjectTitle.setText(CurrentProject.get().getTitle());
                ProjectsPanel.this.prjTablePanel.updateUI();
            }
        });
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                ProjectsPanel.this.prjTablePanel.updateUI();
            }
        });
        this.prjTablePanel.projectsTable.addMouseListener(new PopupListener());
        this.prjTablePanel.projectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = !ProjectsPanel.this.prjTablePanel.projectsTable.getModel().getValueAt(ProjectsPanel.this.prjTablePanel.projectsTable.getSelectedRow(), 100).toString().equals(CurrentProject.get().getID());
                ProjectsPanel.this.ppDeleteProject.setEnabled(bl);
                ProjectsPanel.this.ppOpenProject.setEnabled(bl);
                ProjectsPanel.this.ppProperties.setEnabled(true);
            }
        });
        this.prjTablePanel.projectsTable.setToolTipText(Local.getString("Double-click to set a current project"));
        this.prjTablePanel.projectsTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ProjectsPanel.this.prjTablePanel.projectsTable.getSelectedRows().length > 0 && keyEvent.getKeyCode() == 127) {
                    ProjectsPanel.this.ppDeleteProject_actionPerformed(null);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    void toggleButton_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.expListeners.size(); ++i) {
            ((ActionListener)this.expListeners.get(i)).actionPerformed(new ActionEvent(this, 0, "Panel expanded (collapsed)"));
        }
        if (this.expanded) {
            this.expanded = false;
            this.toggleButton.setIcon(this.expIcon);
        } else {
            this.expanded = true;
            this.toggleButton.setIcon(this.collIcon);
        }
    }

    public void AddExpandListener(ActionListener actionListener) {
        this.expListeners.add(actionListener);
    }

    void ppOpenB_actionPerformed(ActionEvent actionEvent) {
        this.projectsPPMenu.show(this.buttonsPanel, (int)(this.ppOpenB.getLocation().getX() + 24.0) - this.projectsPPMenu.getWidth(), (int)this.ppOpenB.getLocation().getY() + 24);
    }

    void ppOpenProject_actionPerformed(ActionEvent actionEvent) {
        CurrentProject.set(this.prjTablePanel.getSelectedProject());
        this.prjTablePanel.updateUI();
        this.ppDeleteProject.setEnabled(false);
        this.ppOpenProject.setEnabled(false);
    }

    void ppNewProject_actionPerformed(ActionEvent actionEvent) {
        ProjectDialog.newProject();
        this.prjTablePanel.updateUI();
    }

    void ppDeleteProject_actionPerformed(ActionEvent actionEvent) {
        int n;
        Project project;
        String string;
        Vector<String> vector = new Vector<String>();
        if (this.prjTablePanel.projectsTable.getSelectedRows().length > 1) {
            string = Local.getString("Delete") + " " + this.prjTablePanel.projectsTable.getSelectedRows().length + " " + Local.getString("projects") + "\n" + Local.getString("Are you sure?");
        } else {
            project = this.prjTablePanel.getSelectedProject();
            string = Local.getString("Delete project") + " '" + project.getTitle() + "'.\n" + Local.getString("Are you sure?");
        }
        int n2 = JOptionPane.showConfirmDialog(App.getFrame(), string, Local.getString("Delete project"), 0);
        if (n2 != 0) {
            return;
        }
        for (n = 0; n < this.prjTablePanel.projectsTable.getSelectedRows().length; ++n) {
            project = (Project)this.prjTablePanel.projectsTable.getModel().getValueAt(this.prjTablePanel.projectsTable.getSelectedRows()[n], 101);
            vector.add(project.getID());
        }
        for (n = 0; n < vector.size(); ++n) {
            ProjectManager.removeProject((String)vector.get(n));
        }
        CurrentStorage.get().storeProjectManager();
        this.prjTablePanel.projectsTable.clearSelection();
        this.prjTablePanel.updateUI();
        this.setMenuEnabled(false);
    }

    void ppProperties_actionPerformed(ActionEvent actionEvent) {
        Project project = this.prjTablePanel.getSelectedProject();
        ProjectDialog projectDialog = new ProjectDialog(null, Local.getString("Project properties"));
        Dimension dimension = projectDialog.getSize();
        Dimension dimension2 = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        projectDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        projectDialog.prTitleField.setText(project.getTitle());
        projectDialog.startDate.getModel().setValue(project.getStartDate().getCalendar().getTime());
        if (project.getEndDate() != null) {
            projectDialog.edButton.setEnabled(true);
            projectDialog.endDateChB.setForeground(Color.BLACK);
            projectDialog.endDateChB.setSelected(true);
            projectDialog.endDate.setEnabled(true);
            projectDialog.endDate.getModel().setValue(project.getEndDate().getCalendar().getTime());
        }
        projectDialog.setVisible(true);
        if (projectDialog.CANCELLED) {
            return;
        }
        project.setTitle(projectDialog.prTitleField.getText());
        project.setStartDate(new CalendarDate((Date)projectDialog.startDate.getModel().getValue()));
        if (projectDialog.endDateChB.isSelected()) {
            project.setEndDate(new CalendarDate((Date)projectDialog.endDate.getModel().getValue()));
        } else {
            project.setEndDate(null);
        }
        this.prjTablePanel.updateUI();
    }

    void ppShowActiveOnlyChB_actionPerformed(ActionEvent actionEvent) {
        this.prjTablePanel.setShowActiveOnly(this.ppShowActiveOnlyChB.isSelected());
        Context.put("SHOW_ACTIVE_PROJECTS_ONLY", new Boolean(this.ppShowActiveOnlyChB.isSelected()));
    }

    void setMenuEnabled(boolean bl) {
        this.ppDeleteProject.setEnabled(bl);
        this.ppOpenProject.setEnabled(bl);
        this.ppProperties.setEnabled(bl);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ProjectsPanel.this.ppOpenProject_actionPerformed(null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ProjectsPanel.this.projectsPPMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

