/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.sf.memoranda.Project;
import net.sf.memoranda.Task;
import net.sf.memoranda.TaskImpl;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.util.Util;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;

public class TaskListImpl
implements TaskList {
    private Project _project = null;
    private Document _doc = null;
    private Element _root = null;
    private Hashtable elements = new Hashtable();

    public TaskListImpl(Document document, Project project) {
        this._doc = document;
        this._root = this._doc.getRootElement();
        this._project = project;
        this.buildElements(this._root);
    }

    public TaskListImpl(Project project) {
        this._root = new Element("tasklist");
        this._doc = new Document(this._root);
        this._project = project;
    }

    public Project getProject() {
        return this._project;
    }

    private void buildElements(Element element) {
        Elements elements = element.getChildElements("task");
        for (int i = 0; i < elements.size(); ++i) {
            Element element2 = elements.get(i);
            this.elements.put(element2.getAttribute("id").getValue(), element2);
            this.buildElements(element2);
        }
    }

    public Collection getAllSubTasks(String string) {
        if (string == null || string.length() == 0) {
            return this.getAllRootTasks();
        }
        Element element = this.getTaskElement(string);
        if (element == null) {
            return new Vector();
        }
        Elements elements = element.getChildElements("task");
        return this.convertToTaskObjects(elements);
    }

    public Collection getTopLevelTasks() {
        return this.getAllRootTasks();
    }

    public Collection getActiveSubTasks(String string, CalendarDate calendarDate) {
        Collection collection = this.getAllSubTasks(string);
        return this.filterActiveTasks(collection, calendarDate);
    }

    public Task createTask(CalendarDate calendarDate, CalendarDate calendarDate2, String string, int n, long l, String string2, String string3) {
        Element element = new Element("task");
        element.addAttribute(new Attribute("startDate", calendarDate.toString()));
        element.addAttribute(new Attribute("endDate", calendarDate2 != null ? calendarDate2.toString() : ""));
        String string4 = Util.generateId();
        element.addAttribute(new Attribute("id", string4));
        element.addAttribute(new Attribute("progress", "0"));
        element.addAttribute(new Attribute("effort", String.valueOf(l)));
        element.addAttribute(new Attribute("priority", String.valueOf(n)));
        Element element2 = new Element("text");
        element2.appendChild(string);
        element.appendChild((Node)element2);
        Element element3 = new Element("description");
        element3.appendChild(string2);
        element.appendChild((Node)element3);
        if (string3 == null) {
            this._root.appendChild((Node)element);
        } else {
            Element element4 = this.getTaskElement(string3);
            element4.appendChild((Node)element);
        }
        this.elements.put(string4, element);
        Util.debug("Created task with parent " + string3);
        return new TaskImpl(element, this);
    }

    public void removeTask(Task task) {
        String string = task.getParentId();
        if (string == null) {
            this._root.removeChild((Node)task.getContent());
        } else {
            Element element = this.getTaskElement(string);
            element.removeChild((Node)task.getContent());
        }
        this.elements.remove(task.getID());
    }

    public boolean hasSubTasks(String string) {
        Element element = this.getTaskElement(string);
        if (element == null) {
            return false;
        }
        return element.getChildElements("task").size() > 0;
    }

    public Task getTask(String string) {
        Util.debug("Getting task " + string);
        return new TaskImpl(this.getTaskElement(string), this);
    }

    public boolean hasParentTask(String string) {
        Element element = this.getTaskElement(string);
        ParentNode parentNode = element.getParent();
        if (parentNode instanceof Element) {
            Element element2 = (Element)parentNode;
            return element2.getLocalName().equalsIgnoreCase("task");
        }
        return false;
    }

    public Document getXMLContent() {
        return this._doc;
    }

    public long calculateTotalEffortFromSubTasks(Task task) {
        long l = 0L;
        if (this.hasSubTasks(task.getID())) {
            Collection collection = this.getAllSubTasks(task.getID());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Task task2 = (Task)iterator.next();
                l += this.calculateTotalEffortFromSubTasks(task2);
            }
            task.setEffort(l);
            return l;
        }
        return task.getEffort();
    }

    public CalendarDate getEarliestStartDateFromSubTasks(Task task) {
        CalendarDate calendarDate = task.getStartDate();
        if (this.hasSubTasks(task.getID())) {
            Collection collection = this.getAllSubTasks(task.getID());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Task task2 = (Task)iterator.next();
                CalendarDate calendarDate2 = this.getEarliestStartDateFromSubTasks(task2);
                if (!calendarDate2.before(calendarDate)) continue;
                calendarDate = calendarDate2;
            }
            task.setStartDate(calendarDate);
            return calendarDate;
        }
        return task.getStartDate();
    }

    public CalendarDate getLatestEndDateFromSubTasks(Task task) {
        CalendarDate calendarDate = task.getEndDate();
        if (this.hasSubTasks(task.getID())) {
            Collection collection = this.getAllSubTasks(task.getID());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Task task2 = (Task)iterator.next();
                CalendarDate calendarDate2 = this.getLatestEndDateFromSubTasks(task2);
                if (!calendarDate2.after(calendarDate)) continue;
                calendarDate = calendarDate2;
            }
            task.setEndDate(calendarDate);
            return calendarDate;
        }
        return task.getEndDate();
    }

    public long[] calculateCompletionFromSubTasks(Task task) {
        long[] lArray = new long[2];
        long l = 0L;
        long l2 = 0L;
        if (this.hasSubTasks(task.getID())) {
            Collection collection = this.getAllSubTasks(task.getID());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Task task2 = (Task)iterator.next();
                long[] lArray2 = this.calculateCompletionFromSubTasks(task2);
                l += lArray2[0];
                l2 += lArray2[1];
            }
            int n = (int)Math.round((double)l / (double)l2 * 100.0);
            task.setProgress(n);
            lArray[0] = l;
            lArray[1] = l2;
            return lArray;
        }
        long l3 = task.getEffort();
        if (l3 == 0L) {
            l3 = 1L;
        }
        lArray[0] = Math.round((double)((long)task.getProgress() * l3) / 100.0);
        lArray[1] = l3;
        return lArray;
    }

    private Element getTaskElement(String string) {
        Element element = (Element)this.elements.get(string);
        if (element == null) {
            Util.debug("Task " + string + " cannot be found in project " + this._project.getTitle());
        }
        return element;
    }

    private Collection getAllRootTasks() {
        Elements elements = this._root.getChildElements("task");
        return this.convertToTaskObjects(elements);
    }

    private Collection convertToTaskObjects(Elements elements) {
        Vector<TaskImpl> vector = new Vector<TaskImpl>();
        for (int i = 0; i < elements.size(); ++i) {
            TaskImpl taskImpl = new TaskImpl(elements.get(i), this);
            vector.add(taskImpl);
        }
        return vector;
    }

    private Collection filterActiveTasks(Collection collection, CalendarDate calendarDate) {
        Vector<Task> vector = new Vector<Task>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (!this.isActive(task, calendarDate)) continue;
            vector.add(task);
        }
        return vector;
    }

    private boolean isActive(Task task, CalendarDate calendarDate) {
        return task.getStatus(calendarDate) == 1 || task.getStatus(calendarDate) == 7 || task.getStatus(calendarDate) == 5;
    }
}

