/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.util.Collection;
import java.util.Vector;
import net.sf.memoranda.Note;
import net.sf.memoranda.NoteImpl;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.util.Util;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public class NoteListImpl
implements NoteList {
    private Project _project = null;
    private Document _doc = null;
    private Element _root = null;

    public NoteListImpl(Document document, Project project) {
        this._doc = document;
        this._root = this._doc.getRootElement();
        this._project = project;
    }

    public NoteListImpl(Project project) {
        this._root = new Element("noteslist");
        this._doc = new Document(this._root);
        this._project = project;
    }

    public Collection getAllNotes() {
        Vector<NoteImpl> vector = new Vector<NoteImpl>();
        Elements elements = this._root.getChildElements("year");
        for (int i = 0; i < elements.size(); ++i) {
            Year year = new Year(elements.get(i));
            Vector vector2 = year.getMonths();
            for (int j = 0; j < vector2.size(); ++j) {
                Month month = (Month)vector2.get(j);
                Vector vector3 = month.getDays();
                for (int k = 0; k < vector3.size(); ++k) {
                    Day day = (Day)vector3.get(k);
                    Vector vector4 = day.getNotes();
                    for (int i2 = 0; i2 < vector4.size(); ++i2) {
                        NoteElement noteElement = (NoteElement)vector4.get(i2);
                        vector.add(new NoteImpl(noteElement.getElement(), this._project));
                    }
                }
            }
        }
        return vector;
    }

    public Collection getMarkedNotes() {
        Vector<NoteImpl> vector = new Vector<NoteImpl>();
        Elements elements = this._root.getChildElements("year");
        for (int i = 0; i < elements.size(); ++i) {
            Year year = new Year(elements.get(i));
            Vector vector2 = year.getMonths();
            for (int j = 0; j < vector2.size(); ++j) {
                Month month = (Month)vector2.get(j);
                Vector vector3 = month.getDays();
                for (int k = 0; k < vector3.size(); ++k) {
                    Day day = (Day)vector3.get(k);
                    Vector vector4 = day.getNotes();
                    for (int i2 = 0; i2 < vector4.size(); ++i2) {
                        NoteElement noteElement = (NoteElement)vector4.get(i2);
                        NoteImpl noteImpl = new NoteImpl(noteElement.getElement(), this._project);
                        if (!noteImpl.isMarked()) continue;
                        vector.add(noteImpl);
                    }
                }
            }
        }
        return vector;
    }

    public Collection getNotesForPeriod(CalendarDate calendarDate, CalendarDate calendarDate2) {
        Vector<NoteImpl> vector = new Vector<NoteImpl>();
        Elements elements = this._root.getChildElements("year");
        for (int i = 0; i < elements.size(); ++i) {
            Year year = new Year(elements.get(i));
            if (year.getValue() < calendarDate.getYear() || year.getValue() > calendarDate2.getYear()) continue;
            Vector vector2 = year.getMonths();
            for (int j = 0; j < vector2.size(); ++j) {
                Month month = (Month)vector2.get(j);
                if (year.getValue() == calendarDate.getYear() && month.getValue() < calendarDate.getMonth() && year.getValue() == calendarDate2.getYear() && month.getValue() > calendarDate2.getMonth()) continue;
                Vector vector3 = month.getDays();
                for (int k = 0; k < vector3.size(); ++k) {
                    Day day = (Day)vector3.get(k);
                    if (month.getValue() == calendarDate.getMonth() && day.getValue() < calendarDate.getDay() && month.getValue() == calendarDate2.getMonth() && day.getValue() > calendarDate2.getDay()) continue;
                    Vector vector4 = day.getNotes();
                    for (int i2 = 0; i2 < vector4.size(); ++i2) {
                        NoteElement noteElement = (NoteElement)vector4.get(i2);
                        vector.add(new NoteImpl(noteElement.getElement(), this._project));
                    }
                }
            }
        }
        return vector;
    }

    public Note getNoteForDate(CalendarDate calendarDate) {
        Day day = this.getDay(calendarDate);
        if (day == null) {
            return null;
        }
        Vector vector = day.getNotes();
        if (vector.size() > 0) {
            NoteElement noteElement = (NoteElement)vector.get(0);
            NoteImpl noteImpl = new NoteImpl(noteElement.getElement(), this._project);
            return noteImpl;
        }
        return null;
    }

    public Note createNoteForDate(CalendarDate calendarDate) {
        Day day;
        Month month;
        Year year = this.getYear(calendarDate.getYear());
        if (year == null) {
            year = this.createYear(calendarDate.getYear());
        }
        if ((month = year.getMonth(calendarDate.getMonth())) == null) {
            month = year.createMonth(calendarDate.getMonth());
        }
        if ((day = month.getDay(calendarDate.getDay())) == null) {
            day = month.createDay(calendarDate.getDay());
        }
        NoteElement noteElement = day.createNote(Util.generateId());
        return new NoteImpl(noteElement.getElement(), this._project);
    }

    public void removeNote(CalendarDate calendarDate, String string) {
        Day day = this.getDay(calendarDate);
        if (day == null) {
            return;
        }
        Vector vector = day.getNotes();
        for (int i = 0; i < vector.size(); ++i) {
            NoteElement noteElement = (NoteElement)vector.get(i);
            Element element = noteElement.getElement();
            if (!element.getAttribute("refid").getValue().equals(string)) continue;
            day.getElement().removeChild((Node)noteElement.getElement());
        }
    }

    public Note getActiveNote() {
        return this.getNoteForDate(CurrentDate.get());
    }

    private Year getYear(int n) {
        Elements elements = this._root.getChildElements("year");
        String string = new Integer(n).toString();
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("year").getValue().equals(string)) continue;
            return new Year(elements.get(i));
        }
        return null;
    }

    private Year createYear(int n) {
        Element element = new Element("year");
        element.addAttribute(new Attribute("year", new Integer(n).toString()));
        this._root.appendChild((Node)element);
        return new Year(element);
    }

    private Day getDay(CalendarDate calendarDate) {
        Year year = this.getYear(calendarDate.getYear());
        if (year == null) {
            return null;
        }
        Month month = year.getMonth(calendarDate.getMonth());
        if (month == null) {
            return null;
        }
        return month.getDay(calendarDate.getDay());
    }

    public Document getXMLContent() {
        return this._doc;
    }

    private class NoteElement {
        Element nEl;

        public NoteElement(Element element) {
            this.nEl = element;
        }

        public Element getElement() {
            return this.nEl;
        }
    }

    private class Day {
        Element dEl = null;

        public Day(Element element) {
            this.dEl = element;
            if (this.dEl.getAttribute("date") != null) {
                Attribute attribute = this.dEl.getAttribute("date");
                Attribute attribute2 = this.dEl.getAttribute("title");
                Element element2 = new Element("note");
                String string = attribute.getValue().replace('/', '-');
                element2.addAttribute(new Attribute("refid", string));
                element2.addAttribute(new Attribute("title", attribute2.getValue()));
                this.dEl.appendChild((Node)element2);
                this.dEl.removeAttribute(attribute);
                this.dEl.removeAttribute(attribute2);
            }
        }

        public int getValue() {
            return new Integer(this.dEl.getAttribute("day").getValue());
        }

        public NoteElement getNote(String string) {
            if (this.dEl == null) {
                return null;
            }
            Elements elements = this.dEl.getChildElements("note");
            for (int i = 0; i < elements.size(); ++i) {
                if (!elements.get(i).getAttribute("refid").getValue().equals(string)) continue;
                return new NoteElement(elements.get(i));
            }
            return null;
        }

        public NoteElement createNote(String string) {
            Element element = new Element("note");
            this.dEl.appendChild((Node)element);
            return new NoteElement(element);
        }

        public Vector getNotes() {
            if (this.dEl == null) {
                return null;
            }
            Vector<NoteElement> vector = new Vector<NoteElement>();
            Elements elements = this.dEl.getChildElements("note");
            for (int i = 0; i < elements.size(); ++i) {
                vector.add(new NoteElement(elements.get(i)));
            }
            return vector;
        }

        public Element getElement() {
            return this.dEl;
        }
    }

    private class Month {
        Element mElement = null;

        public Month(Element element) {
            this.mElement = element;
        }

        public int getValue() {
            return new Integer(this.mElement.getAttribute("month").getValue());
        }

        public Day getDay(int n) {
            if (this.mElement == null) {
                return null;
            }
            Elements elements = this.mElement.getChildElements("day");
            String string = new Integer(n).toString();
            for (int i = 0; i < elements.size(); ++i) {
                if (!elements.get(i).getAttribute("day").getValue().equals(string)) continue;
                return new Day(elements.get(i));
            }
            return null;
        }

        private Day createDay(int n) {
            Element element = new Element("day");
            element.addAttribute(new Attribute("day", new Integer(n).toString()));
            this.mElement.appendChild((Node)element);
            return new Day(element);
        }

        public Vector getDays() {
            if (this.mElement == null) {
                return null;
            }
            Vector<Day> vector = new Vector<Day>();
            Elements elements = this.mElement.getChildElements("day");
            for (int i = 0; i < elements.size(); ++i) {
                vector.add(new Day(elements.get(i)));
            }
            return vector;
        }

        public Element getElement() {
            return this.mElement;
        }
    }

    private class Year {
        Element yearElement = null;

        public Year(Element element) {
            this.yearElement = element;
        }

        public int getValue() {
            return new Integer(this.yearElement.getAttribute("year").getValue());
        }

        public Month getMonth(int n) {
            Elements elements = this.yearElement.getChildElements("month");
            String string = new Integer(n).toString();
            for (int i = 0; i < elements.size(); ++i) {
                if (!elements.get(i).getAttribute("month").getValue().equals(string)) continue;
                return new Month(elements.get(i));
            }
            return null;
        }

        private Month createMonth(int n) {
            Element element = new Element("month");
            element.addAttribute(new Attribute("month", new Integer(n).toString()));
            this.yearElement.appendChild((Node)element);
            return new Month(element);
        }

        public Vector getMonths() {
            Vector<Month> vector = new Vector<Month>();
            Elements elements = this.yearElement.getChildElements("month");
            for (int i = 0; i < elements.size(); ++i) {
                vector.add(new Month(elements.get(i)));
            }
            return vector;
        }

        public Element getElement() {
            return this.yearElement;
        }
    }
}

