/*
 * Decompiled with CFR 0.152.
 */
package snoozesoft.systray4j;

import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import snoozesoft.systray4j.CheckableMenuItem;
import snoozesoft.systray4j.DaemonSysTray;
import snoozesoft.systray4j.NativeSysTray;
import snoozesoft.systray4j.NotAvailable;
import snoozesoft.systray4j.SubMenu;
import snoozesoft.systray4j.SysTrayAccess;
import snoozesoft.systray4j.SysTrayMenu;
import snoozesoft.systray4j.SysTrayMenuItem;

class SysTrayManager {
    static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    static final boolean isLinux = System.getProperty("os.name").equals("Linux");
    static Properties properties = new Properties();
    static SysTrayManager manager = new SysTrayManager();
    private static SysTrayAccess interfaze = SysTrayManager.loadInterface();

    private SysTrayManager() {
        try {
            properties.load(this.getClass().getResourceAsStream("systray4j.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static boolean isAvailable() {
        if (interfaze != null) {
            return interfaze.isAvailable();
        }
        return false;
    }

    static void addMainMenu(SysTrayMenu menu) {
        if (!(interfaze instanceof NotAvailable || interfaze != null && SysTrayManager.isAvailable())) {
            interfaze = new NotAvailable();
        }
        interfaze.addMainMenu(menu, menu.icon.iconFile.getAbsolutePath(), menu.toolTip);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            SysTrayManager.addItem(menu.id, i, menu.getItemAt(i));
        }
    }

    static void addSubMenu(SubMenu menu) {
        if (!(interfaze instanceof NotAvailable || interfaze != null && SysTrayManager.isAvailable())) {
            interfaze = new NotAvailable();
        }
        interfaze.addSubMenu(menu);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            SysTrayManager.addItem(menu.id, i, menu.getItemAt(i));
        }
    }

    static void setToolTip(int menuId, String newTip) {
        interfaze.setToolTip(menuId, newTip);
    }

    static void showIcon(int menuId, boolean show) {
        interfaze.showIcon(menuId, show);
    }

    static void setIcon(int menuId, String newFileName) {
        interfaze.setIcon(menuId, newFileName);
    }

    static void enableItem(int menuId, int itemIndex, boolean enable) {
        interfaze.enableItem(menuId, itemIndex, enable);
    }

    static void checkItem(int menuId, int itemIndex, boolean enable) {
        interfaze.checkItem(menuId, itemIndex, enable);
    }

    static void addItem(int menuId, int itemIndex, Object item) {
        if (item instanceof SysTrayMenuItem) {
            boolean checkable = false;
            boolean checked = false;
            if (item instanceof CheckableMenuItem) {
                checkable = true;
                CheckableMenuItem checkableItem = (CheckableMenuItem)item;
                checked = checkableItem.getState();
            }
            if (item instanceof SubMenu) {
                SubMenu subMenu = (SubMenu)item;
                String sub = "#SUB<" + subMenu.id + "><" + subMenu.label + ">";
                interfaze.addItem(menuId, itemIndex, sub, checkable, checked, subMenu.enabled);
            } else {
                SysTrayMenuItem menuItem = (SysTrayMenuItem)item;
                interfaze.addItem(menuId, itemIndex, menuItem.label, checkable, checked, menuItem.enabled);
            }
        } else {
            interfaze.addItem(menuId, itemIndex, "#SEP", false, false, true);
        }
    }

    static void removeItem(int menuId, int itemIndex) {
        interfaze.removeItem(menuId, itemIndex);
    }

    static void setItemLabel(int menuId, int itemIndex, String label) {
        interfaze.setItemLabel(menuId, itemIndex, label);
    }

    static void replaceItems(int menuId, Vector items) {
        interfaze.removeAll(menuId);
        for (int i = 0; i < items.size(); ++i) {
            SysTrayManager.addItem(menuId, i, items.get(i));
        }
    }

    static void dispose() {
        interfaze.dispose();
        interfaze = null;
    }

    private static SysTrayAccess loadInterface() {
        SysTrayAccess interfaze = null;
        if (isWindows) {
            interfaze = new NativeSysTray();
        } else if (isLinux && !(interfaze = new NativeSysTray()).isAvailable()) {
            interfaze = new DaemonSysTray();
        }
        return interfaze;
    }
}

