.******************************************************************************
.*  Maul Publisher Spell Checker Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Spell check Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Spell check Handler
:i1 id=all.About Spell check Handler
:p.:font facename='Tms Rmn' size=24x24.
:hp2.Overview of the Spell checker:ehp2.
:font facename=default.
:p.This handler is based on two open source projects, MySpell and Libhnj.
The handler is responsible for text spell checking and hyphenation functions.
:p.:hp2.This handler provides&colon.-:ehp2.
:ul.
:li.Spell and grammar checking.
:li.A series of spell check options enable the product to deal with unusual requirements,
such as comma separated lists, or OCR scanned text.
:li.An exclusion wordlist to ignore particular words during the spell check.
:li.Automatic hyphenation.
:eul.
.br
.br
:p.:hp2.Changes and additions:ehp2.
:p.Copyright 2003 Peter Koller, Maison Anglais, Plonevez du Faou, France. All additions are
subject to MYSPELL COPYRIGHT below.
:p.The source code for the spell checking portion of this handler (the clever bit) is included
with the complete package. You will find it as a zipped archive in the .\etc\myspell path where
maul was installed. You will also find the required dictionaries there.
:p.:hp2.MySpell Copyright Notice:ehp2.
:xmp.
/*
 * Copyright 2002 Kevin B. Hendricks, Stratford, Ontario, Canada
 * And Contributors.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All modifications to the source code must be clearly marked as
 *    such.  Binary redistributions based on modified source code
 *    must be clearly marked as modified versions in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KEVIN B. HENDRICKS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * KEVIN B. HENDRICKS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * NOTE: A special thanks and credit goes to Geoff Kuenning
 * the creator of ispell.  MySpell's affix algorithms were
 * based on those of ispell which should be noted is
 * copyright Geoff Kuenning et.al. and now available
 * under a BSD style license. For more information on ispell
 * and affix compression in general, please see:
 * http&colon.//www.cs.ucla.edu/ficus-members/geoff/ispell.html
 * (the home page for ispell)
 *
 * An almost complete rewrite  of MySpell for use by
 * the Mozilla project has been developed by David Einstein
 * (Deinst@world.std.com).  David and I are now
 * working on parallel development tracks to help
 * our respective projects (Mozilla and OpenOffice.org
 * and we will maintain full affix file and dictionary
 * file compatibility and work on merging our versions
 * of MySpell back into a single tree. David has been
 * a significant help in improving MySpell.
 *
 * Special thanks also go to La'szlo' Ne'meth
 * <nemethl@gyorsposta.hu> who is the author of the
 * Hungarian dictionary and who developed and contributed
 * the code to support compound words in MySpell
 * and fixed numerous problems with the encoding
 * case conversion tables.
 *
 */
:exmp.
:p.:hp2.LibHnj Copyright Notice:ehp2.
:p.:note.This module only uses a part of the libhnj library by Raph Levien. In fact, I have only used
the hyphenation part from it.
:xmp.
LibHnj is a library for high quality hyphenation and justification. It
is dual licensed under both LGPL and MPL to encourage widespread use.
The parseAFM.[ch] files are written by Adobe and distributed under a
slightly different license, but one that appears to be compatible with
both LGPL and MPL.

The code is currently fairly rough. In particular, psset has many
fixed-size buffers and is simply not suitable for production. Further
speedups are also possible, although the code isn't exactly slow now.
:exmp.
:p.:hp2.Copyright Notice for Spell Handler:ehp2.
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:xmp.
Maul Spell Check Handler
Copyright  2001 Peter Koller, Maison Anglais.
All Rights Reserved.
:exmp.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.******************************************************************************
:h1 res=2 id=2 global.Managing dictionaries and codepages
:i1 id=techno.Managing dictionaries and codepages
:p.:hp2.The Dictionary control file 'MYSPELL.DLS':ehp2.
:p.This file is found, like many other control files, in maul's .\etc folder (directory).
Dictionaries are stored in a subfolder. This subfolder is specified in the dictionary
control file. The file also provides information about hyphenation dictionaries,
languages, and information for the 'about' message available in the spellcheck dialog.
:p.The file is parsed by a relatively sophisticated parser, so some idea about how this works
will be helpful.
:p.:hp1.Comments:ehp1.
:p.Comments follow the C++ convention. This provides /* block quotes */ to add large blocks
of comments, or //line quotes valid to the end of the line.
:p.Line quotes can be placed inside block quotes, but block quotes cannot be nested.
:p.:hp1.Commands:ehp1.
:p.Commands always start with a <command> and end with a ;
:p.:hp1.Strings:ehp1.
:p.If a string contains characters that form part of the syntax, you can place it in
"double quote marks" to avoid the parser trying to split up the string.
:p.:hp2.Dictionary control file definition:ehp2.
:p.Each language has it's own dictionaries. These dictionaries are specified in a control block.
:xmp.
<dict>"name","subfolder", "langid", "info";
<spl>"langid", "spell dictionary", "affix file";
<hyp>"langid", "hyphenation dictionary", minleft, minlen, minright;
:exmp.
:p.:hp1.<dict>:ehp1.
:ul.
:li."name"&colon.- This should be a user friendly name, in the correct language, for this dictionary.
:li."subfolder"&colon.- This is the subfolder to .\etc where the dictionaries are found. i.e. If you
have the string "myspell" here, the files are found in ".\etc\myspell". If you
have the string "!off" here, no dictionary is installed for this language.
:li."langid"&colon.- This is used to distinguish the language of the dictionary control block,
rather than the individual dictionaries. In order for Maul to use the dictionary, the same langid
value must appear in the file DATECONV.LCI, described in the text handler help manual.
:li."info"&colon.- This optional string can be used to provide information about the dictionaries,
such as versions, or copyrights, or general comments. This string can be left empty if
you don't need it.
:eul.
:p.:hp1.<spl>:ehp1.
:ul.
:li."langid"&colon.- This specifies the language of the actual dictionaries, as opposed to the
language these dictionaries are used for. i.e. "en_us"
:li."spell dictionary"&colon.- The full filename of the dictionary, i.e. "en_us.dic"
:li."affix file"&colon.- The full filename of the affix file, i.e. "en_us.aff"
:eul.
:p.:hp1.<hyp>:ehp1.
:ul.
:li."langid"&colon.- This specifies the language of the actual dictionary, as opposed to the
language this dictionary is used for. i.e. "en_en"
:li."hyphenation dictionary"&colon.- The full filename of the dictionary, i.e. "hyph_en.dic"
:li."minleft"&colon.- A number that specifies the minimum length of the left half of a
hyphenated word.
:li."minlen"&colon.- A number that specifies the minimum length of the hyphenated word.
Note&colon.- minlen >= minleft + minright
:li."minright"&colon.- A number that specifies the minimum length of the right half of a
hyphenated word.
:eul.
:p.You can specify more than one hyphenation dictionary, and choose the one you want in the
hyphenation dialog.
:p.:hp1.Example:ehp1.
:p.Below is an actual example&colon.-
:xmp.
//British English dictionary definitions
<dict>English, myspell, en_gb, "Release R 1.14, 15/12/02 or later";
<spl>en_gb, en_gb.dic, en_gb.aff;
<hyp>en_gb, hyph_en.dic, 3, 5, 2;
:exmp.
:p.You can add as many dictionaries to the dictionary control file as you wish.
:p.:hp2.Finding dictionaries:ehp2.
:p.The best place I have found so far for obtaining MySpell and Libhnj dictionaries is the
Open Office linguistic component web pages
:link reftype='launch' object='netscape.exe' data='http://lingucomponent.openoffice.org/'.
http&colon.//lingucomponent.openoffice.org/:elink.
:p.:hp2.Translation codepages:ehp2.
:p.In order that spell checking can work correctly, Maul needs to translate
from the codepage you are using in the text article, to the codepage used by
the dictionary.
:p.Myspell dictionaries tend to use the ISO codepages as Myspell was created
for UNIX compatible systems. The dictionaries used may have any one of these
codepages, as specified by the code in the myspell source file
'csutil.cpp'&colon.-
:ul.
:li.codepage 819, 'ISO8859-1'
:li.codepage 912, 'ISO8859-2'
:li.codepage 913, 'ISO8859-3'
:li.codepage 914, 'ISO8859-4'
:li.codepage 915, 'ISO8859-5'
:li.codepage 1089, 'ISO8859-6'
:li.codepage 813, 'ISO8859-7'
:li.codepage 916, 'ISO8859-8'
:li.codepage 920, 'ISO8859-9'
:li.codepage 919, 'ISO8859-10'
:li.codepage 878, 'KOI8-R'
:li.codepage 1251, 'CP-1251' (a Windows codepage)
:li.codepage 1252, 'CP-1252' (a Windows codepage)
:eul.
:p.This handler uses Unicode translation to translate from OS/2 codepages to
ISO codepages, and vice versa.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Dialog Item Help
.*
.*
.*
.******************************************************************************
:h1 res=95 id=95 global.Check Spelling
:i1 id=spellchk.Check Spelling
:p.This dialog allows you to check spelling. If you do not wish to check the spelling of the
whole article, hilight the text you wish to spell check. If nothing is hilighted, the text
is checked from the cursor position onwards. Enable 'Start at top of text' to check the whole
article.
:p. You can press ':link reftype=hd res=98.More spellcheck options >>:elink.' before you start
spell checking, in order to setup specific options relative to this spell check. These options
include methods to find or ignore special characters or words, as well as selecting particular
grammar test options.
:p.:hp2.Overview Of the Spell checking process:ehp2.
:p.When you are ready, press 'Go', and the spell check will commence. When a word is found that
is not in the dictionary, the spell check dialog will offer a series of possible alternatives.
The most likely alternative is automatically selected in the listbox, and shown in the current
word entryfield.
:p.If you click the 'Restore from File' button, the original misspelt word is re-loaded into the
current word entryfield. You can then manually edit it before clicking 'Correct and continue'.
The 'Correct and continue' button is used to replace the word in the article with the word in
the current word entryfield.
:p.If you click 'Stop' during a spell check, the spell check is abandoned. The button marked
'Skip word and continue' changes to 'Go', and if you click it, the spell check restarts from the top.
:p.If you click 'Skip word and continue', the spell check continues without taking any other action.
:p.If you click 'Ignore All and continue', the word in the article is saved in a temporary exclusion
dictionary. The spell checking process will ignore all words found in this temporary exclusion
dictionary. The spell check then continues without taking any further action.
.br
.br
.*******************************************************************************
:h1 res=96 id=96 global.Spell Check Options Dialog
:i1 id=spellopt.Spell Check Options Dialog
:p.:artwork name='splopt.bmp' align=left.
:p.You must have a text article selected in order that the correct dictionaries are loaded.
The spellcheck options menu item will be disabled if no text article is selected.
:p.:hp2.Language:ehp2.
:p.The language used by the currently selected text article is shown. If you
click on the 'About' button, you will see the copyright holders for that particular language.
:p.The selected language will also affect the hyphenation dictionaries used for
:link reftype=hd res=97.hyphenation:elink..
:p.:hp2.More options:ehp2.
:p.Click on the 'More >>' button to set the default spell checking process options.
Accessing the ':link reftype=hd res=98.More Spell Check Options:elink.' dialog from here
ensures that these options are saved for all future spell checking.
.br
.br
.*******************************************************************************
:h1 res=98 id=98 global.More Spell Check Options Dialog
:i1 id=spellmore.More Spell Check Options Dialog
:p.:artwork name='splmore.bmp' align=left.
:p.:hp1.Default more spellcheck options:ehp1.
:p.:hp2.Find:ehp2.
:ul.
:li.Uncapitalized Start of Sentence
.br
Find sentences starting with a small letter i.e. "I said hello. he said goodbye."
:li.Words with special Characters
.br
Find all words which contain the specified characters. Enter the specified character(s) in
the entryfield provided. This option can help find consistent errors in OCR scanned text.
:li.Words between special characters
.br
Allows words to be found that are separated by special characters i.e. "My-separated-list".
Enter the character(s) that separate the words in the entryfield provided.
:eul.
:p.:hp2.Ignore:ehp2.
:ul.
:li.Single Character Words
.br
Ignores words like "A"
:li.Numbers
.br
Ignores numbers such as "1234"
:li.Words with Numbers
.br
Ignores words with numbers, like "Catch22"
:li.Words with all CAPS
.br
Ignores words like "USA", or "BBC"
:li.Roman Numerals
.br
Ignores words like "LVXCII", note that this option can cause misspellings to be missed.
:li.Words with special characters
.br
Ignore words containing special characters i.e. with "$" specified, "tri$met" is not checked. Enter the character(s) to cause the word to be ignored in the entryfield.
:li.SPecial characters in words
.br
Strips special characters from words before checking them. i.e. with "()" specified, "(hello)" is checked as
"hello". Enter the character(s) to strip in the entryfield.
:eul.
.br
.br
.*******************************************************************************
:h1 res=97 id=97 global.Hyphenation Options Dialog
:i1 id=hyphopt.Hyphenation Options Dialog
:p.:hp2.Hierachical hyphenation mode settings:ehp2.
:p.Hyphenation is controlled by three factors.
:ul.
:li.The global setting stored in the initialisation profile is the default for all
new publications. By checking the 'Save as default' checkbox in the main hyphenation
dialog, you alter this global setting.
:li.The per file settings are stored in the file itself, and all new frames will inherit
these setting.
:li.The hyphenation can be enabled or disabled independantly for each text article. This
setting overrides the above settings, so that once a text article has hyphenation disabled,
the more global setting will not enable hyphenation to work. The text article hyphenation is
set by the 'Enable hyphenation' menu item shown by the text or tables handler.
:eul.
:p.:hp2.Global hyphenation mode settings:ehp2.
:p.You must have a text article selected in order that the correct dictionaries are loaded.
The hyphenation options menu item will be disabled if no text article is selected.
:p.:artwork name='hyph1.bmp' align=left.
:p.:hp2.Select hyphenation mode:ehp2.
:p.The spell check handler supports just two different hyphenation modes at present.
:ul.
:li.No hyphenation.
.br
Words are not automatically hyphenated.
:li.Use hyphenation.
.br
Words are hyphenated according to rules found in the current hyphenation dictionary.
:eul.
:p.If the currently selected language supports different hyphenation dictionaries, you can
select the appropriate dictionary in the listbox.
:p.If you check the 'Save as default' button the information is written to Maul Publisher's initialisation
profile, and all new publications will be created with this style.
:euserdoc.
