.******************************************************************************
.*  Maul Publisher Bitmap Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Bitmap Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Bitmap Handler
:i1 id=all.About Maul Bitmap Handler
:p.:artwork name='bmphand.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Default Bitmap Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Bitmap Handler:ehp2.
:p.Use this handler to put pictures into frames.
:p.The Maul bitmap handler uses the OS/2 V2.0 bitmap format to display pictures.
:p.You can import any uncompressed bitmaps to a number of bitmap formats.
Once imported, you can scale, rotate, and mirror bitmaps. In addition, a large range of colour
and brightness adjustments can be made directly within the application. You can also edit
bitmap colour tables for bitmaps up to 8 bits per pixel (up to 256 colours).
:p.:hp2.Raster operations:ehp2.
This handler uses GpiWCBitBlt for painting. This means that for normal usage, your display and
printer drivers must support the following raster operations&colon.-
:ul.
:li.For masked bitmaps, the handler uses ROP_SRCAND, and ROP_SRCPAINT.
:li.For painting normal bitmaps, the handler uses ROP_MERGECOPY with a blank pattern bitmap. This is
done to force the svga display driver into not interpolating pixels. The problem is of course
that whereas this display driver smooths pixels for nice upright bitmaps, the printer driver
does not. Also, rotated or masked bitmaps cannot be smoothed by the display driver. In order to
head off potential problems before they occur, this handler can be made to change it's raster
operations by creating an empty file in maul's etc path. The files are searched for on startup.
:ul.
:li.Create the file 'srccpy.rop' to perform a simple bitmap copy.
:li.Create the file 'srcpnt.rop' to perform a bitwise 'or' bitmap copy.
:li.The default is reset by deleting these two files again.
:eul.
:li.When printing does not support raster operations, such as when using the postscript printer
driver, the handler performs a workaround. This involves preparing a bitmap that contains the
images of any underlying objects as well as the bitmap itself, and then painting that as a normal
overlay image. This can sometimes cause the print process to become very slow. Further, inlined
images with maskmaps will always be painted as ordinary bitmaps with a white background.
:eul.
:p.Normally, no problems occur by leaving things as they are.
:p.:hp2.About offlining:ehp2.
:p.This handler can use a technique called offlining to save memory while editing. The way
this is done is by storing large bitmaps in a separate folder. This folder will be have the
same name as the current publication (without the .mpb extension), and will be saved in the
same place. As you load images into the publication, the system decides whether the bitmap
should be stored separately from the publication, and if necessary generates a small
placeholder bitmap so that you can still see the picture. As you make changes, so the
offlining mechanism makes backups, and modifies the full sized bitmaps on disk. You will
notice some disk activity while offlining is used.
:p.To enable offlining, you need to check the 'Store big bitmaps offline' item in 'Global
style settings...' in the 'Options' menu. The offlining mechanism is automatic, but you can
refresh the offline images manually by clicking on ':link reftype=hd res=55.
Reload offlined bitmaps:elink.' in the 'Options' menu.
:p.:hp2.About mask maps:ehp2.
:p.Mask maps are used to produce transparent backgrounds in a bitmap. The effect is often seen
with icons, or mouse pointers, for example. Masked bitmaps can be used as overlays on top of
other images or text.
:p.Mask maps can be used by the text formatter to flow text around the image mask shape. You
must enable the maskmap boundary mode in the frame handler. Switch to frame edit mode, and
enable the 'Enable maskmap boundary' option in the 'Object modes' item in the edit menu. For
this to work, the masked bitmap must be in the top layer (layer 0) of the frame to exclude
from the text frame.
:p.:hp2.Image formats:ehp2.
:p.This handler is compatible with the generic import/export system built into Maul. If the
required import or export modules are installed, you can read any supported bitmap based image.
:p.This handler directly imports OS/2 and Windows *.ico icon resources, OS/2 multiple bitmaps,
old OS/2 short bitmaps, uncompressed Windows bitmaps *.bmp and *.dib, and native format *.mbm
files. Exports are limited to *.mbm format files, and *.bmp bitmaps.
:p.:hp2.The native *.mbm image format:ehp2.
:p.This handler uses it's own *.mbm image format to store bitmaps in order to be able to
retain all the various image options available when offlining. The format is shown below,
with optional items in [square brackets].
:xmp.
"mbm"           //4 bytes
checksum        //4 byte checksum of all ULONGs from file+8 to eof
BMPDATA3        //a 44 byte header
BITMAPINFO      //image bitmap
[BITMAPINFO]    //image maskmap
["filename"]    //a zero terminated filename
:exmp.
The BMPDATA3 format is available from the developers section of http&colon.//www.manglais.com
.br
.br
:p.To obtain more help from here, select 'Options' then 'Contents' on the menu in this
help window. You will then get a list of help contents to guide you further. Alternatively, you can
press the 'Index' button below for an index.
:p.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998, 2001 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=10 id=10 global.The Bitmap handler edit menu
:i1 id=edit.The Bitmap handler edit menu
:p.The bitmap handler edit menu contains the basic edit menu items one would expect to find in any editor,
plus a few specific ones for bitmaps.
:p.These include&colon.-
:ul.
:li.How to :link reftype=hd res=12.cut:elink. bitmaps.
:li.How to :link reftype=hd res=13.copy:elink. bitmaps.
:li.How to :link reftype=hd res=14.paste:elink. bitmaps.
:li.How to :link reftype=hd res=15.clear:elink. bitmaps.
:li.How to use the :link reftype=hd res=19.original bitmap size:elink..
:li.How to maintain the :link reftype=hd res=20.bitmap shape:elink..
:li.How to set the :link reftype=hd res=21.bitmap tile mode:elink..
:li.How to :link reftype=hd res=22.lock the bitmap :elink. position.
:li.How to :link reftype=hd res=18.scale:elink. bitmaps.
:li.How to :link reftype=hd res=17.rotate:elink. bitmaps.
:li.How to :link reftype=hd res=23.crop:elink. a frame to match the bitmap size.
:li.How to set a :link reftype=hd res=54.bitmap style:elink..
:li.How to save a :link reftype=hd res=54.bitmap style:elink..
:li.How to :link reftype=hd res=11.remove:elink. the bitmap handler from a frame.
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=12 id=12 global.Cut bitmap to clipboard
:i2 refid=edit.Cut bitmap to clipboard
:p.Select this menu item to copy the bitmap to the clipboard. The bitmap is then destroyed.
:p.The cut command can be executed by using the Shift + Delete keys.
.*******************************************************************************
:h2 res=13 id=13 global.Copy bitmap to clipboard
:i2 refid=edit.Copy bitmap to clipboard
:p.Select this menu item to copy the bitmap to the clipboard. The bitmap is not destroyed.
:p.The copy command can be executed by using the Control + Insert keys.
.*******************************************************************************
:h2 res=14 id=14 global.Paste bitmap from clipboard
:i2 refid=edit.Paste bitmap from clipboard
:p.Select this menu item to paste a bitmap from the clipboard into the frame.
Any existing bitmap is deleted.
:p.The paste command can be executed by using the Shift + Insert keys.
.*******************************************************************************
:h2 res=15 id=15 global.Clear bitmap
:i2 refid=edit.Clear bitmap
:p.Select this menu item to delete the bitmap.
:p.The bitmap is not copied to the clipboard.
:p.The clear command can be executed by using the Delete key.
.*******************************************************************************
:h2 res=19 id=19 global.Use original bitmap size
:i2 refid=edit.Use original bitmap size
:p.The bitmap handler uses two scaling methods. The first is that the bitmap is
scaled to the smallest rectangle that can contain the frame. Any scaling that is then performed
using the :link reftype=hd res=18.Scale Picture:elink. dialog is in addition
to this initial scaling.
:p.You can choose not to perform this initial scaling by clicking on the 'Use original
bitmap size' menu item. Other scaling and rotation is unaffected.
.*******************************************************************************
:h2 res=20 id=20 global.Maintain bitmap shape
:i2 refid=edit.Maintain bitmap shape
:p.The bitmap handler uses two scaling methods. The first is that the bitmap is
scaled to the smallest rectangle that can contain the frame.
:p.By selecting the 'Maintain bitmap shape' menu item, the original aspect ratio is preserved
during this initial scaling.
:p.Any scaling that is then performed using the :link reftype=hd res=18.Scale Picture:elink.
dialog can still alter the aspect ratio.
.*******************************************************************************
:h2 res=21 id=21 global.Set tile image mode
:i2 refid=edit.Set tile image mode
:p.Use tile mode for images that provide a background. This mode closely resembles the tile mode for window
image backgrounds in OS/2 Warp, so you should find the system supplied bitmaps useful for this mode.
:p.It is important to note that the bitmap is always scaled to the printer dpi, so whereas a tiled bitmap
may look good on your screensaver, the same bitmap in Maul may be so tiny that you only get a mess. It is
only when you zoom in close to the same dpi scale as your printer that you start to see the detailed
result.
:p.See also ':link reftype=hd res=18.Scale Picture:elink.'.
.*******************************************************************************
:h2 res=22 id=22 global.Lock bitmap position
:i2 refid=edit.Lock bitmap position
:p.If you lock the bitmap position, you can alter the frame to crop your image. Make sure your image is in the right
place, because if you subsequently unlock the image, it will jump to the object centre.
:p.A locked bitmap cannot be moved, but can still be scaled and tiled. If you wish to be able to move the image within
a polygon, do not use this mode, but use manual scaling to adjust the image size as required. You will then be able to
move the image by altering the object centre. You can alter the object centre by using the frame handler.
:p.The locked mode enables the 'Use original bitmap size' menu item as well as the 'Maintain bitmap aspect ratio' menu
item, and rescales the bitmap so that the actual size of the bitmap does not appear to change. When you come to adjust
the scale of a locked bitmap, you may find that the scale factors have changed completely. If you unlock the bitmap,
the function attempts to restore the original scale factors.
.*******************************************************************************
:h2 res=18 id=18 global.Scale Picture
:i2 refid=edit.Scale Picture
:p.:hp2.Force scale to printer dpi:ehp2.
:p.This menu item is used to quickly impose a rational scaling factor. In this case, rational
means that the bitmap is scaled to produce a fixed number of dots per inch (dpi), depending
upon the resolution of the printer&colon.-
:ul.
:li.75dpi for printers with less than 300dpi.
:li.100dpi for printers with less than 600dpi.
:li.150dpi for printers with 600dpi or better.
:eul.
:p.In each case, the printer has at least 3 dots available to get the colour right in the
fine detail.
:p.To actually get precisely that scale, you will also need to check (enable) the
':link reftype=hd res=19.Use original bitmap size:elink.'  menu item.
:p.:hp2.Reset all scaling:ehp2.
:p.Use this menu item to reset all scaling set up by the scaling dialog or by the 'Force scale to
printer dpi' menu item. Scaling caused by having the bitmap fitted to the frame is not affected.
:p.:hp2.Scaling dialog:ehp2.
:p.Use the 'Scale Picture...' dialog to alter the scaling of a bitmap. Scaling is a graphics transform
that is performed independently from other scaling factors. The scaling dialog allows you to scale
and mirror pictures.
:p.Use the entryfields to type in the height and width of the required scale factors in percent. For
convenience, use the buttons provided to add and subtract a factor of 50%. Negative scaling factors invert or
mirror the image.
:p.The dialog also provides two sliders to alter the scaling factors over a total range of 100%.
:p.Any changes are shown in the sample image. This sample can only give a guide to aspect ratios when scaling
is greater than 100%. The image is always shrunk to remain within the sample window.
:p.Press 'Apply' to apply the changes to the bitmap, and 'Exit' to exit the dialog when you are finished.
.*******************************************************************************
:h2 res=17 id=17 global.Rotate Picture
:i2 refid=edit.Rotate Picture
:p.Picture orientation is made up of the sum of frame orientation and bitmap orientation.
By default the bitmap orientation is 0.
:p.Normally, if the frame is orientated to zero, the bitmap is orientated to 0, which
results in a normally orientated bitmap.
:p.If you rotate the frame, the bitmap will also rotate. The actual bitmap angle is shown
as a status string within the rotate dialog. You can use the spin button or enter the
required angle to change the :hp1.relative:ehp1. orientation between the bitmap and the frame.
:p.Click on 'Apply' to apply the new bitmap angle, and 'Exit' to exit the dialog when you are finished.
.*******************************************************************************
:h2 res=23 id=23 global.Crop Frame
:i2 refid=edit.Crop Frame
:p.You can crop any frame to the current image. Once the frame has been cropped, the image may re-scale yet again in
order to fit the new minimum rectangle that can contain the new frame size. This very much depends on the complexity
of the frame being cropped. The frame will not alter it's basic shape, but it's overall height and width are
recalculated to fit the bitmap image.
:p.By selecting the menu item, the bitmap handler will recalculate the size of the frame required to hold the
image, and will then resize the frame to match the size of the image.
.*******************************************************************************
:h2 res=54 id=54 global.Save bitmap style
:i2 refid=edit.Save bitmap style
:p.:hp2.Set a bitmap style:ehp2.
:p.Use the 'Edit'->'Set bitmap style' menu to apply a bitmap style. If you select the small
button to the right of the menu item, the available bitmap styles are listed. If you select
one of the listed styles, that style becomes the default for the 'Set bitmap style' menu item.
:p.:hp2.Save bitmap style:ehp2.
:p.If you have a bitmap with a particular style, you can save that style.
:p.Bitmap styles include everything except the bitmap locking offset and the bitmap itself.
If you need a style that also sets the bitmap, use the frame styles in the frame handler.
:p.The styles are saved as style sheets in the user path. To see what the current user path
is set to, look at the 'Global style settings' in the Options menu.
:p.Styles are saved as common stylesheets. To find out more about these, please read the
Common Stylesheets section of Maul Publishers main manual.
.*******************************************************************************
:h2 res=11 id=11 global.Remove bitmap handler from frame
:i2 refid=edit.Remove bitmap handler from frame
:p.Select this menu item to destroy the bitmap in the frame, and remove the bitmap handler
from the frame. Once you have done this you can add a different handler to the frame in place
of the default bitmap handler.
.******************************************************************************
.*  Bitmap Menu
.******************************************************************************
:h1 res=2 id=2 global.The Bitmap handler bitmap menu
:i1 id=bitmap.The Bitmap handler bitmap menu
:p.The bitmap handler bitmap menu contains the specific edit menu items related to bitmaps.
:p.These include&colon.-
:ul.
:li.How to get :link reftype=hd res=28.information:elink. about the selected
bitmap.
:li.How to move a bitmap:link reftype=hd res=32.online or offline:elink..
:li.How to :link reftype=hd res=29.crop:elink. a bitmap.
:li.How to edit bitmap :link reftype=hd res=16.colour tables:elink..
:li.How to :link reftype=hd res=30.transform:elink. bitmap data.
:li.How to :link reftype=hd res=31.scale:elink. bitmap data to the frame.
:li.How to insert or delete :link reftype=hd res=26.mask maps:elink..
:li.How to preview and edit a :link reftype=hd res=27.mask map:elink..
:li.How to :link reftype=hd res=24.convert to 16 colour bitmaps:elink..
:eul.
.br
.br
.*******************************************************************************
:h2 res=28 id=28 global.Bitmap information
:i2 refid=bitmap.Bitmap information
:p.Use this menu item to get information about a selected bitmap image.
:p.The bitmap handler structure allows for two images to be stored. One is a normal image, and
the other is a mask map. The mask map is used to cut parts out of an image, you often see the
effect used with icons. Note that not all images have a mask map.
:p.The bitmap image can also be stored outside of the publication file. In this case, a
placeholder bitmap is used to display an image on the screen. When the publication is printed,
the full sized 'offlined' bitmap is reloaded in order to print the page with the maximum
detail. The infomation box will show the size of the placeholder bitmap, as well as the size
of it's offlined cousin. Note that an image name is also shown, this is the filename that is
assigned in order for the bitmap to be stored on disk.
.br
.br
.*******************************************************************************
:h2 res=32 id=32 global.Bitmap offlining
:i2 refid=bitmap.Bitmap offlining
:p.:hp2.About offlining:ehp2.
:p.This handler can use a technique called offlining to save memory while editing. The way
this is done is by storing large bitmaps in a separate folder. This folder will be have the
same name as the current publication (without the .mpb extension), and will be saved in the
same place. As you load images into the publication, the system decides whether the bitmap
should be stored separately from the publication, and if necessary generates a small
placeholder bitmap so that you can still see the picture. As you make changes, so the
offlining mechanism makes backups, and modifies the full sized bitmaps on disk. You will
notice some disk activity while offlining is used.
:p.To enable offlining, you need to check the 'Store big bitmaps offline' item in 'Global
style settings...' in the 'Options' menu.
.*******************************************************************************
:h2 res=29 id=29 global.Crop bitmap
:i2 refid=bitmap.Crop bitmap
:p.Use this dialog to crop a bitmap. You can use the mouse to drag a cropping
rectangle to the size that you require. For a more accurate selection, you can
use the controls in the crop box to make small adjustments.
:p.You may notice that this dialog can be sized and maximized. This is to
enable you to more accurately select the cropping rectangle. Simply maximize
the dialog when required.
:p.When you click 'Apply' the bitmap is cropped to the selection, and the crop
dialog is updated.
:p.Click 'Exit' when you are finished.
.*******************************************************************************
:h2 res=16 id=16 global.Edit bitmap colour table
:i2 refid=bitmap.Edit bitmap colour table
:p.Use this dialog to edit the colour tables of bitmaps containing 256 colours or less.
:p.By clicking on a colour, you select it, and start a colour editing dialog to change the
colour of that particular entry.
:p.Once a colour has been selected, you can shuffle it up or down the colour table to a new
position. Note that by doing so, the colours of the entire bitmap will change. This is rarely
of much use, but you can get very some pretty colour effects this way.
.*******************************************************************************
:h2 res=30 id=30 global.Bitmap data transforms
:i2 refid=bitmap.Bitmap data transforms
:p.Although you can set immediate rotations and transforms (for use during the paint process), 
it is sometimes important to be able to apply transforms to the bipmap data itself, especially 
if you subsequently wish to copy the bitmap from Maul into another application.
:p.The four transforms available are&colon.-
:ul.
:li.Rotate left, the bitmap data is rotated to the left.
:li.Rotate right, the bitmap data is rotated to the right.
:li.Flip bitmap data vertical, the bitmap data is inverted top to bottom.
:li.Flip bitmap data horizontal, the bitmap data is mirrored left to right.
:eul.
.br
.br
.*******************************************************************************
:h2 res=31 id=31 global.Scale bitmap data to frame
:i2 refid=bitmap.Scale bitmap data to frame
:p.Although you can achieve :link reftype=hd res=18.immediate scaling:elink. or rotation
within the application, it is sometimes useful to be able to apply transforms to the bipmap data itself,
especially if you subsequently wish to copy the bitmap from Maul into another application.
:p.The second advantage of scaling the bitmap data is that you can apply some interpolation
in order to make a clearer image than would otherwise be achieved.
:p.:hp2.Scaling method:ehp2.
:p.Three levels of smoothing are available in the bitmap data scaling dialog&colon.
:ul.
:li.:hp2.Harsh:ehp2. - No interpolation takes place, this is the equivalent of the on-demand
scaling provided by the :link reftype=hd res=18.'Scale Picture...':elink. dialog.
:li.:hp2.Crisp:ehp2. - Non linear interpolation takes place, transitions are smoothed out over
half their range only. The equivalent is found in advanced background shading modes, where
50% runin and runout give the same kind of colour transition. See the background handler manual
for futher details.
:li.:hp2.Smooth:ehp2. - Linear interpolation takes place, transitions are fully smoothed out
between one pixel and the next.
:eul.
:p.:hp2.Resolution:ehp2.
:p.The size of the scaled bitmap is given by a simple calculation. It is the number of dots
per inch (dpi), by the number of inches wide or high.
:p.In other words, if the frame is 4 inches wide and 3 inches tall, and the dpi value is set
to 75, you get a bitmap that is 300 dots wide x 225 dots tall.
:p.The default dpi value is calculated to give optimum results on your printer, but you are
free to change it as required.
:p.:hp2.Resulting bitmap:ehp2.
:p.The resulting bitmap will be of the size and shape shown. No sample image is shown because
this would be misleading&colon.- Samples must be scaled to fit into a sample window, images on
the screen are always scaled from the printer page, and zooming in and out involves scaling too.
:p.Smooth or 'Crisp' scaling will give good results when used for printing screen captures or other
images with fine detail, particularly when the new image is smaller than the original. Mask maps
are always scaled 'Harsh'. Harsh scaling is the fastest algorithm, and is the one used for creating
sample images or placeholder bitmaps. All forms of scaling except 'Harsh' must convert the image into
a 24bit colour bitmap.
:p.If you want to maintain the
original shape of the bitmap, you must make sure that the containing frame has the required
shape. In order that you can achieve this, make sure that
the 'Edit->:link reftype=hd res=20.Maintain bitmap shape:elink.' menu
item is checked, then click on the 
'Edit->:link reftype=hd res=23.Crop frame to bitmap:elink.' menu item.
.br
.br
.*******************************************************************************
:h2 res=26 id=26 global.Insert or delete mask maps
:i2 refid=bitmap.Insert or delete mask maps
:p.:hp2.About mask maps:ehp2.
<p>If a bitmap image has a mask map, parts of the image will be masked out to show whatever is
underneath. The effect is similar to that seen with icons, or with mouse cursors.
:p.:hp2.Inserting a mask map:ehp2.
:p.Click on the 'Insert mask map...' menu item to open the Insert mask map dialog.
:p.Mask maps can be provided from a number of sources.
:p.You can either&colon.-
:ul.
:li.Make a mask map from the existing bitmap. This works best with bitmaps that have large
areas of a similar colour.
:li.Load a mask map from the clipboard. This can be used for copying bitmaps across from
another application.
:li.Load a mask map from a file. Any bitmap file can be used.
:eul.
:p.Ideal mask maps are best created from two colour bitmap overlays. A number of applications
are available to produce some very sophisticated mask maps. Click on the 'Mask maker'
pushbutton to use the inbuilt :link reftype=hd res=27.mask maker dialog:elink.. This dialog
allow you to preview and adjust the candidate mask map.
:p.These dialogs have certain restrictions with black and white (1bit per pixel) images. You
can view the mask map in the mask maker dialog, but cannot change it. The mask map cannot
be inverted. If you need to modify the mask map, you can place it in an empty frame, and convert
it to a colour bitmap before using it. See ':link reftype=hd res=24.Convert
to 16 colour bitmaps:elink.'.
:p.:hp2.Deleting a mask map:ehp2.
:p.Click on the 'Remove mask map' menu item. The mask map will be deleted, and the image will
be repainted without a mask.
:p.:hp2.Cut mask map:ehp2.
:p.Click on the 'Cut mask map' menu item. The mask map will be copied to the clipboard before
being deleted, and the image will then be repainted without a mask.
:p.:hp2.Copy mask map:ehp2.
:p.Click on the 'Copy mask map' menu item. The mask map will be copied to the clipboard.
.br
.br
.*******************************************************************************
:h2 res=27 id=27 global.Colour mask maker
:i2 refid=bitmap.Colour mask maker
:p.This dialog is accessed from the :link reftype=hd res=26.Insert mask map
:elink. dialog.
:p.The colour mask maker allows you to preview and adjust a mask map before inserting it into
the publication.
:p.The first step is to pick a colour on the sample bitmap. You can see the current colour
under the cursor shown in the information area. When you click on the image, the current
colour is selected.
:p.To preview the areas that will become transparent, enable the 'Show mask' checkbox. The
image will show the resultant mask in red.
:p.Use the 'Copy mask' button to copy the maskmap to the clipboard. The mask map is generated
using the current settings, and is then copied to the clipboard. This could be slow with
very large bitmaps.
:p.It is often necessary to create a mask from a small range of similar colours, so you can
allow the mask maker some tolerance in the colours that will be considered as part of the mask.
:p.In the following image, the mask is actually set to the wanted part. You can invert the
mask map in the :link reftype=hd res=26.Insert mask map:elink. dialog if
required.
:p.:artwork name='mkmask.bmp' align=left.
.br
:p.If you have a bitmap editor, you can create a mask map outside of this application, and
import it 'as is' to create a mask. You can use this dialog to preview and fine tune the
resultant mask.
:p.:hp2.Offlined images:ehp2.
:p.For offlined images the mask maker dialog uses the placeholder bitmap to create its colour
selection window. Thus the coordinates shown will not correspond to the actual bitmap size.
:p.When the maskmap is created, the full size offlined image is used. For large bitmaps, the
mask creation process can take some time. Hard disk activity can be seen before and after the
creation process. Please be patient.
.br
.br
.*******************************************************************************
:h2 res=24 id=24 global.Convert to 16 colour bitmap
:i2 refid=bitmap.Convert to 16 colour bitmap
:p.Because of the way that the OS/2 version of this handler is obliged to use monochrome
bitmaps, it is necessary to convert such maps to at least 16 colours. If you don't, the
image just stays stuck as black and white (or white and black). Also, display and printer
drivers tend to treat these images differently, with nice displays turning into horrible
printouts.
:p.Once a bitmap has been updated, you can edit the colours as you please.
.******************************************************************************
.*
.*
.*  statusbar information
.*
.*
.******************************************************************************
.******************************************************************************
.*  status bar
.******************************************************************************
:h1 res=60 id=60 global.Status Bar information
:i1 id=stats.Status Bar information
:p.The status bar provides information about the current object.
.******************************************************************************
:h2 res=61 id=61 global.Bitmap status information
:i2 refid=stats.Bitmap status information
:p.The Bitmap status information provides the size of the bitmap in the form <horizontal> x <vertical>,
and indicates the number of bits per pel.
:p.When no bitmap is loaded, the display shows '0 x 0, 0bpp'
.br
.br
.******************************************************************************
.*
.*
.*  Other information
.*
.*
.******************************************************************************
:h1 res=55 id=55 global.Reload offlined bitmaps
:i1 id=refresh.Reload offlined bitmaps
:p.:hp2.About offlining:ehp2.
:p.If you have enabled the offlining of large bitmaps in the 'Global style settings',
any large bitmap will be saved in it's own file, rather than making the publication file
become unmanageable.
:p.So that you can see what these offlined images look like, a small sample placeholder bitmap
is stored in the publication and is used for display purposes.When the publication is printed,
the full sized 'offlined' bitmap is momentarily reloaded in order to print the page with the
maximum detail.
:p.:hp2.Reloading offlined images:ehp2.
:p.In order to give you some confidence in the offlined images, you can reload them and
re-create all the placeholder bitmaps in the entire publication.
:p.As long as all is well, you should see no difference in you publication after performing
this operation. If an offlined file is missing or contains the wrong image, you will either
get an error message, or you will see that the placeholder image is wrong.
:p.This command is of most use for confirming that all the files associated with a publication
are present and correct. This is of particular importance if the files have been loaded or
transferred from another computer.
.br
.br
.******************************************************************************
.*  Import Bitmaps
.******************************************************************************
:h1 res=100 id=100 global.Importing Pictures
:i1 id=import.Importing Pictures
:p.Use the import dialog to import pictures into the default bitmap handler.
:p.The import dialog will display the selected bitmap if the image can be imported.
:p.The bitmap handler is fully integrated into the Maul Publishers import mechanism, making it
capable of acquiring any image data format via an external bitmap image import handler. The
mechanism is capable of converting clipboard as well as file data.
:p.This handler directly imports OS/2 and Windows *.ico icon resources, OS/2 multiple bitmaps,
old OS/2 short bitmaps, uncompressed Windows bitmaps *.bmp and *.dib, and native format *.mbm
files. Exports are limited to *.mbm format files, and *.bmp bitmaps.
:p.When you create a new bitmap frame, you will be offered a chance to import a bitmap. If
you press 'Cancel' during the import dialog, the bitmap frame will be empty.
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=40 id=40 global.Help with keyboard keys
:i1 id=keys.Help with keyboard keys
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Bitmap handler key usage:ehp2.
:ol.
:li.:hp2.Edit menu:ehp2.
:dl compact tsize=16.
:dt.Shift+Delete:dd.Cut bitmap
:dt.Ctrl+Insert:dd.Copy bitmap
:dt.Shift+Insert:dd.Paste bitmap
:dt.Delete:dd.Clear bitmap
:dt.Alt+Delete:dd.Remove bitmap handler
:edl.
:li.:hp2.Bitmap menu:ehp2.
:dl compact tsize=16.
:dt.U:dd.Use original bitmap size
:dt.M:dd.Maintain bitmap aspect ratio
:dt.T:dd.Tile bitmap
:dt.P:dd.Lock bitmap position
:dt.S:dd.Scale bitmap...
:dt.O:dd.Rotate bitmap...
:dt.Ctrl+Shift+C:dd.Black and white bitmap colours
:edl.
:eol.
:euserdoc.
