/******************************************************************************
    RTF Import Export Filter resources
    (c)Peter Koller 2000
******************************************************************************/
#ifndef MPB_FILTER_RESOURCES
#define MPB_FILTER_RESOURCES

/*******************************************************************************
    main string defs
*******************************************************************************/
#define IDS_HELPWINTITLE        16  //"Page Import Export Filter help"
#define IDS_HELPLIBRARY         17  //"pagehand.hlp"
#define IDS_FILE_EXISTS         18  //"Warning - File Exists, save anyway ?"
#define IDS_IMPORTBUTTON        19  //"Import"
#define IDS_EXPORTBUTTON        20  //"Export"
#define IDS_HANDLERTYPE     	40  //"Maul document V2.00 native"
#define IDS_HANDLERTYPE2     	41	//"Maul document V2.00 native"
#define IDS_HANDLERTYPE3     	42	//"Maul page V2.00 native"
#define IDS_HANDLERTYPE4     	43	//"Maul page V2.00 native"
#define IDS_HANDLERNAME     	44  //"Import Maul document"
#define IDS_HANDLERNAME2     	45	//"Export Maul document"
#define IDS_HANDLERNAME3     	46	//"Import Maul page"
#define IDS_HANDLERNAME4     	47	//"Export Maul page"
#define IDS_IODESCDOCUMENT      48	//"Maul document (*.mpb)"
#define IDS_IODESCMASTER		49	//"Maul master page (*.mmp)"


/*******************************************************************************
    A base offset to each set of strings required for import and export
*******************************************************************************/
#define IDBASE_PAGE_FORMAT      24
#define IDBASE_DOC_FORMAT       28
#define IDBASE_LAST_FORMAT      32

/*******************************************************************************
    A list of offsets for each set of strings describing a particular format.
    Each string is read by the import or export function using (base + offset).
*******************************************************************************/
#define IDOFFS_IMPORTTITLE      1
#define IDOFFS_EXPORTTITLE      2
#define IDOFFS_FORMATEXTN       3

/*******************************************************************************
    The actual set of strings describing the various formats
*******************************************************************************/
#define IDS_IMPORTPAGETITLE     (IDBASE_PAGE_FORMAT + IDOFFS_IMPORTTITLE)    //"Import Maul page (native)"
#define IDS_EXPORTPAGETITLE     (IDBASE_PAGE_FORMAT + IDOFFS_EXPORTTITLE)    //"Export Maul page (native)"
#define IDS_EXTN_PAGE           (IDBASE_PAGE_FORMAT + IDOFFS_FORMATEXTN)     //"*.MPB"
#define IDS_IMPORTDOCTITLE      (IDBASE_DOC_FORMAT + IDOFFS_IMPORTTITLE)     //"Import Maul document (native)"
#define IDS_EXPORTDOCTITLE      (IDBASE_DOC_FORMAT + IDOFFS_EXPORTTITLE)     //"Export Maul document (native)"
#define IDS_EXTN_DOC            (IDBASE_DOC_FORMAT + IDOFFS_FORMATEXTN)      //"*.MPB"
#endif
