/******************************************************************************
    Frame handler resources
    (c)Peter Koller 1998
******************************************************************************/
#ifndef FRAMEHAND_RESOURCES
#define FRAMEHAND_RESOURCES

#define     PROF_STYLESHEET     ",ssh"
#define     PROF_LOADIMG        ",loadstyle"
#define     DEF_STYLESHEET      "*"
#define     EXT_STYLESHEET		".ssh"
#define     PROF_WIZARD	        ",wiz"

#define     DEF_FRAMESHEET      "*.FOB"
#define     EXT_FRAMESHEET      ".FOB"
#define     PROF_CATALOGUE     "clipcat"
#define     DEF_CATALOGUE       "*.CAT"
#define     EXT_CATALOGUE       ".CAT"

/*******************************************************************************
    RCDATA descriptions
*******************************************************************************/
#define IDACC_DEFLTKEYS         40

#define IDPTR_CROSSHAIR     10
#define IDPTR_ROTHAIR       11
#define IDPTR_SCALEHAIR     12
#define IDPTR_SHEARHAIR     13
#define IDPTR_REMHAIR       14
#define IDPTR_SPLITHAIR     15
#define IDPTR_JOINHAIR      16
#define IDPTR_DJNTHAIR      17
#define IDPTR_ADDHLINE      18
#define IDPTR_ADDHARC       19
#define IDPTR_ADDHSPLN      20

/*******************************************************************************
    Bitmaps and icons
*******************************************************************************/
#define IDBMP_TRAKRECT      1000
#define IDBMP_TRAKLINE      1001
#define IDBMP_TRAKPOLY      1002
#define IDBMP_SPLINE        1003
#define IDBMP_3PLINE        1004
#define IDBMP_SPOLY         1005
#define IDBMP_3PPOLY        1006
#define IDBMP_PARTARC       1007
#define IDBMP_PIESEG        1008
#define IDBMP_FULLARC       1009
#define IDBMP_DISJOINT      1010
#define IDBMP_TRAKSCALE     1011
#define IDBMP_TRAKROTATE    1012
#define IDBMP_TRAKSHEAR     1013
#define IDBMP_PTR           1014
#define IDBMP_ADDELEM       1015
#define IDBMP_REMELEM       1016
#define IDBMP_CLOSE         1017
#define IDBMP_OPENFIG       1018
#define IDBMP_TRAKROUNDRECT 1019
#define	IDBMP_MOUSE			1020
#define IDBMP_HITVERT		1021
#define IDBMP_HITHORZ		1022
#define IDBMP_HITALL		1023
#define IDBMP_HITNONE		1024
#define IDICO_METAFILE		1025
#define IDBMP_FLEFT			1026
#define IDBMP_FRIGHT		1027
#define IDBMP_MVERT			1028
#define IDBMP_MHORZ			1029
#define IDBMP_MYSELF		1030
#define IDBMP_HITOFF		1031
#define IDBMP_WIZARD		1032
#define IDBMP_ELEMENU		1033

/*******************************************************************************
	Menus
*******************************************************************************/
#define FRM_CUT             (FIRST_MENU_ID + 1)
#define FRM_COPY            (FIRST_MENU_ID + 2)
#define FRM_PASTE           (FIRST_MENU_ID + 3)
#define FRM_CLEAR           (FIRST_MENU_ID + 4)
#define FRM_FRONT           (FIRST_MENU_ID + 5)
#define FRM_BACK            (FIRST_MENU_ID + 6)
#define FRM_EDITPOLY        (FIRST_MENU_ID + 7)
#define FRM_LOCK            (FIRST_MENU_ID + 8)
#define FRM_TRANS           (FIRST_MENU_ID + 9)
#define FRM_CLIPCNT         (FIRST_MENU_ID + 10)
#define FRM_CLIPBRD         (FIRST_MENU_ID + 11)
#define FRM_GROUP           (FIRST_MENU_ID + 12)
#define FRM_UNGROUP         (FIRST_MENU_ID + 13)
#define FRM_VERTALIGN       (FIRST_MENU_ID + 14)
#define FRM_HORZALIGN       (FIRST_MENU_ID + 15)
#define FRM_BOTHALIGN       (FIRST_MENU_ID + 16)
#define FRM_VERTEQUAL       (FIRST_MENU_ID + 17)
#define FRM_HORZEQUAL       (FIRST_MENU_ID + 18)
#define FRM_BOTHEQUAL       (FIRST_MENU_ID + 19)
#define FRM_VERTCENTRE      (FIRST_MENU_ID + 20)
#define FRM_HORZCENTRE      (FIRST_MENU_ID + 21)
#define FRM_BOTHCENTRE      (FIRST_MENU_ID + 22)
#define FRM_GROUPHCTR       (FIRST_MENU_ID + 23)
#define FRM_GROUPVCTR       (FIRST_MENU_ID + 24)
#define FRM_BOTHGRPCTR      (FIRST_MENU_ID + 25)
#define FRM_OBJCTRST        (FIRST_MENU_ID + 26)
#define FRM_AUTOSCALE       (FIRST_MENU_ID + 27)
#define FRM_MASKENABLE      (FIRST_MENU_ID + 28)
#define FRM_ROTLEFT         (FIRST_MENU_ID + 29)
#define FRM_ROTRIGHT        (FIRST_MENU_ID + 30)
#define FRM_VERTMIRROR      (FIRST_MENU_ID + 31)
#define FRM_HORZMIRROR      (FIRST_MENU_ID + 32)
#define FRM_WIZARD          (FIRST_MENU_ID + 33)
#define FRM_MULTIPASTE      (FIRST_MENU_ID + 34)
#define FRM_SELECTALL       (FIRST_MENU_ID + 35)

#define SECND_MENU_ID       (FIRST_MENU_ID + 40)
#define FRMB_TRAKRECT       (SECND_MENU_ID + 1)
#define FRMB_TRAKROUNDRECT  (SECND_MENU_ID + 2)
#define FRMB_TRAKLINE       (SECND_MENU_ID + 3)
#define FRMB_TRAKPOLY       (SECND_MENU_ID + 4)
#define FRMB_TRAKSPLINE     (SECND_MENU_ID + 5)
#define FRMB_TRAK3PLINE     (SECND_MENU_ID + 6)
#define FRMB_TRAKSPOLY      (SECND_MENU_ID + 7)
#define FRMB_TRAK3PPOLY     (SECND_MENU_ID + 8)
#define FRMB_TRAKPARTARC    (SECND_MENU_ID + 9)
#define FRMB_TRAKPIESEG     (SECND_MENU_ID + 10)
#define FRMB_TRAKFULLARC    (SECND_MENU_ID + 11)

#define FRMB_TRAKSCALE      (SECND_MENU_ID + 12)
#define FRMB_TRAKROTATE     (SECND_MENU_ID + 13)
#define FRMB_TRAKSHEAR      (SECND_MENU_ID + 14)
#define FRMB_TRAKDISJNT     (SECND_MENU_ID + 15)
#define FRMB_TRAKCLOSE      (SECND_MENU_ID + 16)
#define FRMB_TRAKOPENFIG    (SECND_MENU_ID + 17)

#define FRMB_FRAMESTYLESAVE (SECND_MENU_ID + 18)
#define FRMB_CUSTOMFRMSAVE  (SECND_MENU_ID + 19)
#define FRMB_RECTTOPOLY     (SECND_MENU_ID + 20)
#define FRMB_SWAPFGBG       (SECND_MENU_ID + 21)
#define FRMB_TRAKADDELEM    (SECND_MENU_ID + 22)
#define FRMB_TRAKREMELEM    (SECND_MENU_ID + 23)
#define FRMB_ELEMLINE       (SECND_MENU_ID + 24)
#define FRMB_ELEMSPLINE     (SECND_MENU_ID + 25)
#define FRMB_ELEM3PARC      (SECND_MENU_ID + 26)

#define FRSM_GROUP          (SECND_MENU_ID + 27)
#define FRSM_ALIGN          (SECND_MENU_ID + 28)
#define FRSM_SIZE           (SECND_MENU_ID + 29)
#define FRSM_CENTRE         (SECND_MENU_ID + 30)
#define FRSM_LAYER          (SECND_MENU_ID + 31)
#define FRSM_MODE           (SECND_MENU_ID + 32)
#define FRSM_MIRROR         (SECND_MENU_ID + 33)
#define FRM_CUSTOMFRAMESEL  (SECND_MENU_ID + 34)

//this one must always be last - it's a dropdown submenu...
#define FRM_FRAMESTYLESEL   (SECND_MENU_ID + 35)

/*******************************************************************************
	Button bar
*******************************************************************************/
#define     IDB_TRAKRECT    FIRST_BBAR_ID
#define     IDB_TRAKROUNDRECT   (FIRST_BBAR_ID + 1)
#define     IDB_TRAKLINE        (FIRST_BBAR_ID + 2)
#define     IDB_TRAKPOLY        (FIRST_BBAR_ID + 3)
#define     IDB_TRAKSPLINE      (FIRST_BBAR_ID + 4)
#define     IDB_TRAK3PLINE      (FIRST_BBAR_ID + 5)
#define     IDB_TRAKSPOLY       (FIRST_BBAR_ID + 6)
#define     IDB_TRAK3PPOLY      (FIRST_BBAR_ID + 7)
#define     IDB_TRAKPARTARC     (FIRST_BBAR_ID + 8)
#define     IDB_TRAKPIESEG      (FIRST_BBAR_ID + 9)
#define     IDB_TRAKFULLARC     (FIRST_BBAR_ID + 10)
#define     IDB_TRAKADDELEM     (FIRST_BBAR_ID + 11)
#define     IDB_TRAKREMELEM     (FIRST_BBAR_ID + 12)
#define     IDB_ELEMLINE        (FIRST_BBAR_ID + 13)
#define     IDB_ELEMSPLINE      (FIRST_BBAR_ID + 14)
#define     IDB_ELEM3PARC       (FIRST_BBAR_ID + 15)
#define     IDB_ELEMMENU        (FIRST_BBAR_ID + 16)
#define     IDB_WIZARD          (FIRST_BBAR_ID + 17)
#define     IDB_TRAKELEMENU     (FIRST_BBAR_ID + 18)

#define     IDB_TRAKSCALE       (FIRST_BBAR_ID + 20)
#define     IDB_TRAKROTATE      (FIRST_BBAR_ID + 21)
#define     IDB_TRAKSHEAR       (FIRST_BBAR_ID + 22)
#define     IDB_TRAKDISJNT      (FIRST_BBAR_ID + 23)
#define     IDB_TRAKCLOSE       (FIRST_BBAR_ID + 24)
#define     IDB_TRAKOPENFIG     (FIRST_BBAR_ID + 25)

#define 	IDB_ROTLEFT         (FIRST_BBAR_ID + 26)
#define 	IDB_ROTRIGHT        (FIRST_BBAR_ID + 27)
#define 	IDB_VERTMIRROR      (FIRST_BBAR_ID + 28)
#define 	IDB_HORZMIRROR      (FIRST_BBAR_ID + 29)

/*******************************************************************************
    Status bar
*******************************************************************************/
#define     IDS_HANDIDENT   FIRST_STAT_ID
#define     IDS_XYPOSITION  (FIRST_STAT_ID + 1)
#define     IDS_POLYACTION  (FIRST_STAT_ID + 2)

/*******************************************************************************
    Stringdefs
*******************************************************************************/
#define IDS_HELPWINTITLE        16  //"Maul Default Framehandler Help"
#define IDS_HELPLIBRARY         17  //"frmhand.hlp"
#define IDS_LOCKFRAME           18  //"change frame lock"
#define IDS_TRANSFRAME          19  //"change frame transparency"
#define IDS_SETFRAMESTYLE       20  //"add frame style data"
#define IDS_RECTTOPOLY          21  //"change polygon to figure"
#define IDS_CLIPOVRFRAME        22  //"change frame clipping mode"
#define IDS_SWAPBGFG            23  //"swap object layers"
#define IDS_LINEID              24  //"lines"
#define IDS_CORNERID            25  //"corners"
#define IDS_SPLINEID            26  //"splines"
#define IDS_3PARCID             27  //"arcs"
#define IDS_SELECTBET           28  //"Select between %d and %d"
#define IDS_LINEFIGID           29  //"Polygon figure"
#define IDS_SPLINEFIGID         30  //"4 point spline figure"
#define IDS_3PARCFIGID          31  //"3 point arc figure"
#define IDS_OPLINEID            32  //"Lines"
#define IDS_OPSPLINEID          33  //"4 point splines"
#define IDS_OP3PARCID           34  //"3 point arcs"
#define IDS_CENTREFRAME         35  //"change frame centre"
#define IDS_UNGROUP             36  //"ungroup figures"
#define IDS_GROUP               37  //"group figures"
#define IDS_FRAMEFLAGS          38  //"change frame mode or lock"
#define IDS_FRAMESAVEDLGTXT     39  //"Save object or group"
#define IDS_DISPLAYPREVIEW      40  //"~Display preview mode"
#define IDS_PAINTENABLES        41  //"~Paint enables..."
#define IDS_HANDMENU            42  //"O~bject"
#define IDS_AUTOSCALEFRAME      43  //"change autoscale mode"
#define IDS_CLIPFRAME_NODATA    44  //"no data in clipframe (size = 0)"
#define IDS_CHANGEBORDER        45  //"change frame border width"
#define IDS_MASKENABLE          46  //"change mask bitmap boundary mode"
#define IDS_NOSTYLESHEET		47  //"No stylesheet is selected"

#define IDS_INVALIDFRAMEDATA    50  //"Error - Invalid frame data format (version id's do not match)"
#define IDS_CLIPBOARDERROR      51  //"Error - failed to save clipboard data"
#define IDS_CONVERTTOFIG        52  //"Convert this frame to a figure?"
#define IDS_STYLE_EXISTS        53  //"Style sheet exists, overwrite"
#define IDS_STYLE_DELETE        54  //"Delete this style sheet"
#define IDS_FILE_EXISTS         55  //"Warning - File Exists, save anyway ?"
#define IDS_HANDLERRECOG        56  //"Warning - handler type not recognised"
#define IDS_CREATEDIR	        57  //"Directory does not exist, create new?"

#define IDOU_BORDER             60  //"Border top layers"
#define IDOU_BORDSUB1           61  //"Border backgrounds"
#define IDOU_BORDSUB2           62  //"Border base layers"
#define IDOU_BORDSUB3           63  //"Border shadows"
#define IDOU_CONTENTS           64  //"Content top layers"
#define IDOU_CONTSUB1           65  //"Content backgrounds"
#define IDOU_CONTSUB2           66  //"Content base layers"
#define IDOU_CONTSUB3           67  //"Content shadows"

#define IDFH_HANDIDENT          70  //"Frame handler is active"
#define IDFH_EDITMENU           71  //"Select object editing tasks"
#define IDFH_OBJMENU            72  //"Select object tasks"
#define IDFH_XYPOSITION         73  //"Cursor position"
#define IDFH_POLYACTION         74  //"Current frame handler mode"
#define IDFH_LINE               75  //"Create new line"
#define IDFH_MULTISPLINE        76  //"Create new spline(s)"
#define IDFH_DISJOINT           77  //"Disjoint open figure"
#define IDFH_CLOSE              78  //"Close open figure"
#define IDFH_RECTANGLE          79  //"Create new rectangle"
#define IDFH_FIGURE_OPEN        80  //"Create new open figure"
#define IDFH_FIGURE_CLS         81  //"Create new closed figure"
#define IDFH_FIGURE_SPLN        82  //"Create new splines"
#define IDFH_FIGURE_3PLN        83  //"Create new 3 point arcs"
#define IDFH_FIGURE_POLY        84  //"Create new poly figure"
#define IDFH_FIGURE_SPOLY       85  //"Create new spline figure"
#define IDFH_FIGURE_3PPOLY      86  //"Create new arc figure"
#define IDFH_PARTARC            87  //"Create new arc segment"
#define IDFH_PIESEG             88  //"Create new pie segment"
#define IDFH_FULARC             89  //"Create new circle"
#define IDFH_ADDSEG             90  //"Add element to figure"
#define IDFH_REMSEG             91  //"Remove element from figure"
#define IDFH_SCALE              92  //"Scale figure"
#define IDFH_SHEAR              93  //"Shear figure"
#define IDFH_ROTATE             94  //"Rotate figure"
#define IDFH_OPENFIG            95  //"Break (open) selected figure"
#define IDFH_ROUNDRECT          96  //"Create new rounded rectangle"
#define IDFH_VMIRROR            97  //"Vertical flip frame/group"
#define IDFH_HMIRROR            98  //"Horizontal flip frame/group"
#define IDFH_FLEFT              99  //"Rotate frame/group to left"
#define IDFH_FRIGHT             100 //"Rotate frame/group to right"
#define IDFH_WIZARD             101 //"Object creation Wizard"

#define IDSTATOP_CENTRE         102 //"Centre"
#define IDSTATOP_MOVE           103 //"Move"
#define IDSTATOP_ROTATE         104 //"Rotate"
#define IDSTATOP_SHEAR          105 //"Shear"
#define IDSTATOP_SCALE          106 //"Scale"
#define IDSTATOP_ALTER          107 //"Alter"
#define IDSTATOP_RESHAPE        108 //"Reshape"
#define IDSTATOP_UPDATE         109 //"Update"
#define IDSTATOP_CREATE         110 //"Create"
#define IDTYPE_LINE             111 //" line"
#define IDTYPE_RECT             112 //" rect"
#define IDTYPE_POLY             113 //" poly"
#define IDTYPE_SPLINE           114 //" spline"
#define IDTYPE_CIRCLE           115 //" circle"
#define IDTYPE_SEGMNT           116 //" segmnt"
#define IDTYPE_FIGURE           117 //" figure"
#define IDTYPE_GROUP            118 //" group"
#define IDS_SNAPMSG             119 //" snap"
#define IDS_RADIUSMSG           120 //"radius:"
#define IDS_INFOCHARS           121 //"    @  >   % x "
#define INCH_CTR                6
#define INCH_AT                 8
#define INCH_DEG                10
#define INCH_TO                 12
#define INCH_TALL               14
#define INCH_WIDE               16
#define INCH_PC                 18
#define INCH_MUL                20

#define	IDS_MSGISPNT			126 //"mouse:"
#define	IDS_MSGISANGLE			127 //"angle:"
#define	IDS_MSGISROTATE			128 //"rotate:"
#define	IDS_MSGISSWEEP			129 //"sweep:"

#define IDS_NEWRECT             130 //"New rect"
#define IDS_NEWRRECT            131 //"New rndrect"
#define IDS_NEWLINE             132 //"New line"
#define IDS_NEWSPLINE           133 //"New splines"
#define IDS_NEWARCS             134 //"New arcs"
#define IDS_NEWFIGURE           135 //"New figure"
#define IDS_NEWCIRCLE           136 //"New circle"
#define IDS_NEWPARC             137 //"New partarc"
#define IDS_NEWPIESEG           138 //"New pieseg"
#define IDS_IMPORTTITLE         139 //"Import frame(s) object";
#define IDS_IMPORTBUTTON        140 //"~Import"
#define IDS_EXPORTTITLE         141 //"Export frame(s) object"
#define IDS_EXPORTBUTTON        142 //"~Export"
#define	IDS_WIZARDTITLE         143 //"Object creation wizard"
#define	IDS_NOMORELAYERS        144 //"Warning: You have been a busy bee, all layers are used up!"
#define	IDS_NEXTBUTTON          145 //"~Next  >>"
#define	IDS_FINISHBUTTON        146 //"~Finish"

#define IDSAT_EXPORT            150 //"@Export object/group"
#define IDSAT_IMPORT            151 //"@Import object/group"
#define IDSAT_LOAD              152 //"@Load object/group"
#define IDSAT_SAVE              153 //"@Save object/group"
#define IDSAT_OPENSTYLE         154 //"@Open object style"
#define IDSAT_SAVESTYLE         155 //"@Save object style"
#define IDSAT_PREVIEW           156 //"@Preview object/group"
#define IDSAT_PASTE             157 //"@Paste object/group"
#define IDS_HANDLERTYPE         158 //"Frames"
#define IDS_HANDLERNAME         159 //"Frame handler"
#define IDS_IMPORTNTYPE     	160 //"Frame objects (*.fob)"
#define IDS_IMPORTNNAME     	161 //"Import/export frames"

#endif

