.******************************************************************************
.*  Maul Publisher Text Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Text Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Text Handler
:i1 id=all.About Maul Text Handler
:p.:artwork name='texthand.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Text Handler:ehp2.
:p.:artwork name='wingstmp.bmp' align=left runin.
:hp2.Wingstamp express:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Text Handler and Wingstamp express:ehp2.
:p.Use these handlers to add text to frames.
:p.Both handlers use a format called FFTXT. This format supports the full
gamut of text manipulation features of Warp's inbuilt graphics functions.
:p.:hp2.Text Handler:ehp2.
:p.Using Mauls own graphics engine, the text can be flowed and justified at any angle
in any shape of frame, and excludes overlapping frames unless these are marked as
transparent. In addition, this handler supports a huge number of other sophisticated features.
:p.Import and export are supported, as are style sheets, title extraction, automated
page numbering, date and time stamping, and national language support.
:p.This version provides support for DBCS character sets.
:p.:hp2.Wingstamp express:ehp2.
:p.This handler is used to place FFTXT text on borders. As it is based on the FFTXT format,
almost all the features of the normal text handler are supported. The handler allows the text to be
repeated the length of the border, thus giving the 'stamp' part of it's name.
:p.As data types are compatible, you can cut and paste beween this handler and the text handler. The
import, export, style sheets, page numbering, date stamping, etc. functions are also supported.
:p.:hp2.More help:ehp2.
:p.To obtain more help from here, select 'Options' then 'Contents' on the menu in this
help window. You will then get a list of help contents to guide you further. Alternatively, you can
press the 'Index' button below for an index.
:p.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998 to 2004 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.******************************************************************************
:h1 res=2 id=2 global.Text editing overview
:i1 id=using.Text editing overview
:p.The text handler works by using plain text interspersed with blocks of data called LOL's. A LOL
is a data structure starting and ending with 0 and a size indicator so that the LOL can be Leapt Over
going backwards through the file as well as forwards.
:p.Whenever you position the cursor next to a LOL, the cursor will be positioned before it, rather
than after it.
:p.Take the example string BLACK:hp8.RED:ehp8.. Between the words BLACK and :hp8.RED:ehp8., there
is a LOL containing a red colour setting.
:p.If you position the cursor before the word :hp8.RED:ehp8.
and start typing, the colour will be black, because you are positioned before the LOL.
:p.If you highlight the word :hp8.RED:ehp8. by dragging the cursor from left to right, and overtype it
with something, the new text will be red. If you drag the cursor from right to left instead, the cursor
will end up at the black/red junction. Now when you overtype the word :hp8.RED:ehp8., the new text will
be black!
:p.:hp2.Text confusion:ehp2.
:p.LOL's can lead newcomers to some confusion. Every font style, size, colour, inline image, paragraph,
etc., etc. is represented by a LOL. Some of these LOL's, such as inline images and paragraphs, behave
like visible characters.
:p.Invisible LOL's are not allowed at the end of the file, but having one or more new paragraph LOL's
at the end of the file can allow such LOL's to be present before the paragraph. This can cause the font
settings to switch strangely whenever you move the cursor, and can become very annoying. Go to where you
think the end of the file should be (not on an empty new line), and hit the delete key until your
computer beeps. The hidden LOL's are now deleted.
:p.Let's go back to the example string BLACK:hp8.RED:ehp8.. Position the cursor before the word
:hp8.RED:ehp8.. If you were to type now, the output would be black. Instead, hold down the 'Alt' key,
and press on the right arrow key. You should see the status string change from a '&colon.' to a '*'.
You have just leapt over the LOL. Now when you type, the output will be red.
:p.:hp2.LOL list:ehp2.
:p.The text handler can display a LOL list looking backwards from the cursor position and showing
each type of LOL in the order that it appears. Open the
:link reftype=hd res=56.LOL list dialog:elink., and try the experiment above.
You will see the colour LOL appearing at the top of the list when you go past it.
.br
.br

.******************************************************************************
.*
.*
.*
.*  Configuration files
.*
.*
.*
.******************************************************************************
:h1 res=110 id=110 global.Configuration files
:i1 id=config.Configuration files
:p.The text handler uses a number of configuration files to control languages and codepages, as well as
providing the means of controlling codepage translation during import.
:p.The configuration files listed below work together with the spellchecker as well as the tables handler,
and they are interdependant. Thus you can use a language for which there is no spellcheck dictionary,
as long as you don't attempt a spell check. You can use the configuration files to set up the system to
your own requirements.
:p.These include&colon.-
:ul.
:li.:link reftype=hd res=111.DATECONV.LCI data format, used to specify languages:elink.
:li.:link reftype=hd res=112.CODEPAGE.LCI data format, used to specify codepages:elink.
:eul.
:lm margin=1.
.br
.br
.*******************************************************************************
:h2 res=111 id=111 global.DATECONV.LCI data format
:i2 refid=config.DATECONV.LCI data format
:p.The file DATECONV.LCI is used to convert numeric dates read from the system clock into a text date string.
It uses your current country code to determine your language. In addition, the file is used to help determine
the language used for spellchecking and hyphenation.
:p.The DATECONV.LCI file is found in the ..\etc directory. (Most stylesheets and master pages are found here too!)
:p.The format of the date string determines, in conjunction with the system settings, exactly how a date is displayed.
:p.The entries in the DATECONV.LCI file are ordered, that is to say that the first entry is a language country id,
and subsequent entries determine the text for that language. Thus the first functional entry in the file will be a
:hp2.lang=:ehp2. statement. Comments start with :hp2.rem:ehp2. and may occur before this entry.
:p.:hp2.lang=:ehp2. is followed by the number(s) corresponding to one or several country ids. Each country id also
has an associated country string in square brackets. For example the country id and string
for Germany is 049[de_de]. The file supplied with Maul V3.09 or later should :hp2.already contain:ehp2. all the
languages that the system can recognise.
:p.Further, the character string in [square brackets] :hp2.has to be
recognised by the unicode API:ehp2., and 
the base country id (the number) :hp2.has to be recognised by the original 'Dos' control program API:ehp2.,
or something will break!
:p.You can list several country ids, just separate them with a semicolon;
ie :hp2.lang=001[en_us];044[en_gb].:ehp2. Notice that there are no spaces anywhere. Sometimes a country has two
or more languages, or the same language code applies to two or more countries. In this case you can specify a
sublanguage type.
:p.Here we have one language, and two countries.
:xmp.
:hp2.lang=001[en_us];001.1[en_ca]:ehp2.
:exmp.
:p.When we have two languages and one country (de_ch and it_ch), the entries are grouped by language.
Note that 041.0[de_ch] has exactly the same value as 041[de_ch].
:xmp.
:hp2.
rem Franais
lang=033[fr_fr];041.1[fr_ch]

rem Deutsch
lang=049[de_de];041.0[de_ch]

rem Italy
lang=039[it_it];041.2[it_ch]
:ehp2.
:exmp.
:p.The country string is used to find the correct spellcheck and hyphenation dictionary for the selected language.
Have a look in the file MYSPELL.DLS, you will find an entry like :hp2.<dict>"US English", myspell, en_us;:ehp2.,
the country string used by both files is 'en_us', and it must match for the correct dictionaries to be loaded.
:p.This allows countrycode 001 to be asssociated with en_us, and this in turn loads the US English dictionaries.
Furthermore, hypenation and spellcheck options are saved on a per-language basis using the country string, giving
huge flexibility for creating multilingual documents. The system will automatically switch language and codepages
on a per text article basis.
:xmp.
lang=001[en_us];044[en_en];
:exmp.
:p.Once the language has been determined, you can add the following information. If it is missing, the
date will be based on a unicode locale setting&colon.-
:p.:hp2.numtrail=:ehp2. Used to convert 1 into 1st, 2 into 2nd etc. List a series of numbers followed by their text
ending, followed by a semicolon if required, and then another series of numbers and their ending. The last ending has
no number associated with it and is the default. Note that you only need to specify this for numbers up to 31 (the
maximum number of days in a month). If you don't want to uses this feature, delete the line. Also, if dateorder
(below) is not set, this line is never used.
:xmp.
numtrail=1,21,31,st;2,22,nd;3,33,rd;th
:exmp.
:p.:hp2.dateorder=:ehp2. The order in which the date is assembled. the keywords available are wkday for the name of
the day, day for the day of the month, month for the month, and year for the year. If you want to use the unicode
locale, delete the line.
:xmp.
dateorder=wkday;day;month;year
:exmp.
:note.In all the above statements, no spaces are allowed. Each item is separated by a semicolon i.e. ; and each element
of an item is separated from the next with a comma i.e. , so if you look at the statement :hp2.numtrail=:ehp2., you will
see :hp2.numtrail=:ehp2.<item>:hp2.;:ehp2.<item>:hp2.;:ehp2.<item> where <item> is made up of
<element:hp2.,:ehp2.element:hp2.,:ehp2.element>.
.br
.br
.******************************************************************************
:h2 res=112 id=112 global.CODEPAGE.LCI data format
:i2 refid=config.CODEPAGE.LCI data format
:p.You can list here pretty well any of the codepages found in the OS/2 'Keyboards and Code Pages' book
supplied with OS/2.
:p.This file lists and names all the codepages you are able to select. You can disable the use of a codepage
by deleting it from this file. The file is found in the ..\etc directory. (Most stylesheets and master pages
are found here too!)
:xmp.
#
#   Codepages available with Maul Publisher
#
#   Note that some codepages cause the
#   application to appear seized.
#
#
850  Multilingual
1252 Latin 1 Windows
1004 Windows Extended
#
852  Latin 2 (Eastern Europe)
1250 Latin 2 Windows
:exmp.
:p.All lines starting with # are ignored.
:p.All other lines must start with a number, and no leading spaces. There is no particular order required
for listing these codepages.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=10 id=10 global.The Text handler edit menu
:i1 id=edit.The Text handler edit menu
:p.The text handler edit menu contains the basic edit menu items one would expect to find in any text editor,
plus a few specific ones for Maul.
:p.These include&colon.-
:ul.
:li.How to :link reftype=hd res=18.select:elink. text.
:li.How to :link reftype=hd res=12.cut:elink. text.
:li.How to :link reftype=hd res=13.copy:elink. text.
:li.How to :link reftype=hd res=14.paste:elink. text.
:li.How to :link reftype=hd res=15.clear:elink. text.
:li.How to set :link reftype=hd res=16.text styles:elink..
:li.How to insert special :link reftype=hd res=63.characters:elink..
:li.How to insert :link reftype=hd res=23.line flush breaks:elink..
:li.How to insert :link reftype=hd res=24.inline images:elink..
:li.How to use :link reftype=hd res=27.frame anchors:elink..
:li.How to insert :link reftype=hd res=26.footnotes:elink..
:li.How to insert :link reftype=hd res=47.control text:elink..
:li.How to set a :link reftype=hd res=25.control text merge row:elink..
:li.How to :link reftype=hd res=19.Find:elink. text.
:li.How to :link reftype=hd res=20.Count words:elink..
:li.How to :link reftype=hd res=22.Spell check:elink. your text.
:li.How to set :link reftype=hd res=28.information about:elink. the text article.
:li.How to :link reftype=hd res=17.link:elink. text objects.
:li.How to :link reftype=hd res=11.remove:elink. the text handler from a frame.
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=18 id=18 global.Selecting text
:i2 refid=edit.Selecting text
:p.To select a block of text....
:ol compact.
:li.Position the text cursor at the start or end of the block you wish to select by using the cursor
movement keys or by pressing the left mouse button.
:li.Hold down the left mouse button and move the mouse over the area required.
:eol.
:p.:hp2.OR:ehp2.
:ol compact.
:li.Position the text cursor at the start or end of the block you wish to select by using the cursor
movement keys or by clicking on the left mouse button.
:li.Move the mouse to position the mouse cursor at the other end of the text you wish to select,
hold down the Shift key and then click on the left mouse button. (Tip&colon.- do not drag the mouse,
or the start of the highlighted text will change)
:eol.
:p.:hp2.OR:ehp2.
:ol compact.
:li.Position the cursor at the start or end of the block you wish to select.
:li.Hold down the Shift key and use any of the cursor movement
(arrow, home, end, etc.) Keys.
:eol.
:note. The Selected block will be highlighted (coloured black?).
:p.:hp2.Selecting the whole frame:ehp2.
:p.Press Ctrl+/ to select all.
:p.pressing Ctrl+\ deselects all.
:note.Selecting the whole frame enables you to alter the text style for the whole frame,
as well as allowing you to copy the text of the entire frame.
.br
.br
.*******************************************************************************
:h2 res=12 id=12 global.Cut text to clipboard
:i2 refid=edit.Cut text to clipboard
:p.Select this menu item to copy the :link reftype=hd res=18.selected:elink. text to
the clipboard. The text is then destroyed.
:p.The cut command can be executed by using the Shift + Delete keys.
.br
.br
.*******************************************************************************
:h2 res=13 id=13 global.Copy text to clipboard
:i2 refid=edit.Copy text to clipboard
:p.Select this menu item to copy the :link reftype=hd res=18.selected:elink. text to
the clipboard. The text is not destroyed.
:p.The copy command can be executed by using the Control + Insert keys.
.br
.br
.*******************************************************************************
:h2 res=14 id=14 global.Paste text from clipboard
:i2 refid=edit.Paste text from clipboard
:p.Select this menu item to paste text from the clipboard into the frame at the current cursor
position. Any highlighted text is deleted.
:p.If the clipboard data contains the correct format most of the original text style is preserved.
Specifically, line parameters such as line tilt wedges and justification are not preserved.
:p.The paste command can be executed by using the Shift + Insert keys.
.br
.br
.*******************************************************************************
:h2 res=15 id=15 global.Clear text
:i2 refid=edit.Clear text
:p.Select this menu item to delete the :link reftype=hd res=18.selected:elink. text.
:p.The text is not copied to the clipboard.
:p.The clear command can be executed by using the Delete key.
.br
.br
.*******************************************************************************
:h2 res=16 id=16 global.Set a text style
:i2 refid=edit.Set a text style
:p.Use this menu to apply a text style. If you select the small button to the right of the menu
item, the available text styles are listed. If you select one of the listed styles, that style
becomes the default for the 'Set text style' menu item. If the text style is from an earlier version
of this program, some text styles will not be available.
:p.If you have highlighted text, the highlighted text will be altered, otherwise only the current text
settings are altered. These text setting do not come into effect unless you insert new text.
:p.See the :link reftype=hd res=53.Save text character styles:elink.. help panel
for more information on text styles.
.br
.br
.*******************************************************************************
:h2 res=63 id=63 global.Insert character
:i2 refid=edit.Insert character
:p.Use this dialog to select characters from a listbox. This can be extremely useful for
characters that you cannot access easily from the keyboard, or to select symbols from a symbol
font that are not readily discernible from the keyboard.
:p.If the characters are too small to see, you can do one of two things&colon.-
:ul.
:li.Choose a larger font from the fontsize combobox.
:li.Zoom in using the zoom buttons on the main window toolbar.
:eul.
:p.Either way, this dialog enables you to choose a font, style and size, as well as your
special character. Once you have selected the character, click on the 'Insert' button to insert
the character at the current cursor position. You must click on the 'Exit' button to end
this dialog.
.br
.br
.*******************************************************************************
:h2 res=23 id=23 global.Insert line flush break
:i2 refid=edit.Insert line flush break
:p.A line flush break is a bit like a tab, but it pushes all remaining text in a line to the
right hand side.
:p.Line flush breaks have a number of restrictions&colon.-
:ul.
:li.They must appear after any normal tabs in the line.
:li.Only one can occur on each line.
:li.The line must be left, or fully, justified.
:eul.
:p.If any of the above conditions are not met, the flush character is ignored.
:p.:hp2.Uses:ehp2.
:p.Line flush breaks can be used to place a terminating bullet on the end of an article or
paragraph, or to force inline images to the right.
.br
.br
.*******************************************************************************
:h2 res=24 id=24 global.Insert, or edit, inline images
:i2 refid=edit.Insert, or edit, inline images
:p.Inline images are extremely useful for those circumstances where the image must stay in
relationship with the text. If the text is altered, the inline image will be repositioned as
part of the normal reformat process.
:p.Inline images are sized as though they are special font characters. The vertical size is
specified in points, and the horizontal size is calculated from it.
:p.The same dialog is used both to insert and alter inline images.
:p.:hp2.Loading Images:ehp2.
:p.You cannot load a different image on top of an existing one. You must first delete the
existing image, and then insert a new one. This is because they behave like characters.
:p.Select the required image type, and click 'Load >>' (or 'Paste', if copying from the
clipboard). Set the required offset, size, and margins, then click 'Ok' to insert the
image into the text.
:p.:hp2.Editing Images:ehp2.
:p.To edit the inline image, position the cursor at the start of the image and select the
'Edit inline image' dialog, make any changes required, and then click 'Apply'.
You can continue applying changes until the image is perfectly placed. Click 'Exit' when done.
:p.You can offset the baseline of inline images so that they align properly with the text.
You can also specify margins around the images to provide finer control over the positioning
of surrounding text. The margin directions are based on the current text orientation, and not
the image orientation. Where possible, images are rotated according to the character direction.
:p.:hp2.Additional modes for images in a block of text:ehp2.
:p.You can disable the default text fitting mode, and allow the image to overpaint text that
is in the way. You can then still position text by using the paragraph and line setting
dialogs.
:p.A 'Format around object' mode is also available. This uses boundary determination to correctly
format text around lines following after the line where the image was inserted. It is impossible
to format text around an image unless you know where it is placed, so lines before the image insertion
point are ignored, and may get overpainted by the image in some circumstances. If this occurs, simply
offset the image downwards a little.
:p.Otherwise, inline images behave just like characters, they scale and rotate with the text,
and generally stay... inline.
.br
.br
.*******************************************************************************
:h2 res=27 id=27 global.Insert, or edit, frame anchors
:i2 refid=edit.Insert, or edit, frame anchors
:p.:hp2.Please turn off the 'Faster boundary maths' option in 'Global style settings' before using anchors!:ehp2.
:p.:hp2.What is an Anchor:ehp2.
:p.In theory, anchors are just symbolic links between unrelated bits of your publication. Anchors are used to
embed a frame into a block of text. Anchors are referenced within a paragraph header, which means that anchors
don't work with text along a border. It also means that you can only have one anchor per paragraph. The anchor
does not have its own data, but instead paints the data (a frame) to which the anchor is linked.
:p.:hp2.Signatures:ehp2.
:p.Anchors use signatures. A signature is a numeric identifier that is unique to every structure in the file.
:p.Pages, frames, objects, all contain a signature that uniquely identifies them. A particular place in the file
can be found quickly by searching for its signature. Signatures are lost when copying data to the clipboard, and
are replaced by a new signature when pasted back into a file.
:p.:hp2.Embedors and Embedees:ehp2.
:p.The embedor is the text frame in which there is the signature of an anchor. The embedee is the frame to which that
anchor points. Each anchor has just one embedor and one embedee. However, many anchors can contain the same
embedor and embedee. If the embedee is part of a group of frames, then the whole group will be painted as though
is is a single entity.
:p.The anchor is stored as a separate entity at the start of the file. The text paragraph header contains
a signature to enable the anchor to be found quickly. The anchor contains signatures for the embedor and embedee,
as well as some housekeeping information such as the insertion point and some flags. The signature of the embedee
is shown in the anchor dialog.
:p.The embedor (text object) can find the anchor at the start of the file by using its signature. The anchor
provides the text object with a way of getting information about the embedee (a frame). The embedee (a frame)
can access the anchor by looking for its own signature amongst the anchors at the start of the file. If you edit
the size and shape of the embedee frame, the embedee frame can mark all the text objects that it is anchored to as
invalid.
:p.An anchor thus represents a way for text and frames to communicate. If you change the shape of the anchored
frame (the embedee), the anchor will also reformat the embedor. If the text frame (the embedor) has altered,
then the embedee image is repainted in a new position, but the embedee itself is not affected.
:p.:hp2.Anchors are imperfect:ehp2.
:p.Anchors don't always work as you might expect.
:ul.
:li.If the text is rotated, the anchored frame is not rotated.
:li.Anchors cannot be detached from the containing file, so you can't copy and/or paste them like text. The anchor
dialog allows you to copy and paste the signature of an embedee. When the dialog is closed, the copy of the signature
is lost.
:li.Anchors can be pushed beyond the bottom of a text frame, or otherwise go beyond the shape of the text into which
they are embedded.
:li.The embedee frames are visible as well as the anchors. On the other hand, you can put the embedee frame off the
page somewhere.
:li.If you ungroup a group of frames containing an embedee frame, the anchor falls apart and and only the embedee
frame gets painted. Make a group from an embedee frame, and suddenly the anchor paints the whole group.
:li.The positioning of an anchor is somewhat restricted. You can choose to align the anchor with the left, right
or centre of the embedor text frame.
:li.When you select 'clear all' from the anchor dialog,
you will also need to add an additional new line to the text. This is to ensure that the anchor has a paragraph
all to itself.
:li.If the anchored image sticks up into the text above, the text gets overpainted. The boundaries of an anchored
object cannot be determined until its position is known, and that depends on the text above the anchor. This is
incidentally also true for embedded images.
:eul.
:p.:hp2.Anchors are useful:ehp2.
:p.Anchors are sometimes the only way to overcome a particular problem.
:ul.
:li.Use anchors when you have to embed the same frames into a text block many times. Use the 'Get anchor embedee'
button to copy the first anchor and then use the same button to paste the anchor back again and again, but only
one anchor per paragraph please!
:li.Alter just one frame or frame group to change every associated anchor (...but this can cause a major reformat).
:li.The anchor is painted at exactly the same size as the embedee frame. This provides accurate repeatable scaling.
:li.Save memory. Anchors use very little memory as they are not much more than a pair of signatures.
:li.Anchors are the only way to embed offlined bitmaps into a text block. This can be very important if the image
is in the 100's of Mb, and you want to print it half a dozen times throughout a text article!
:eul.
:p.:hp2.Anchor dialog:ehp2.
:p.The anchor dialog will prevent you from editing the text. Position the text cursor on a paragraph that contains
an existing anchor to edit or copy that anchor. Position  the text cursor on a paragraph that does not contain
an existing anchor to select a new embedee frame, or to reuse an anchor copied earlier.
:p.Text can either flow around the anchor, or be positioned below it.
:p.Anchors can be placed to the left, right, or centered in relation to the embedor (text) frame.
.br
.br
.*******************************************************************************
:h2 res=26 id=26 global.Insert, or edit, footnotes
:i2 refid=edit.Insert, or edit, footnotes
:p.:hp2.Overview:ehp2.
:p.You can annotate your text using footnotes. The footnote will be shown as a superscript string in the body of
the text. This superscript string is called a footnote indicator.
:p.A footnote consists of three parts. The footnote indicator, the footnote title, and the footnote text itself.
:p.The style of a footnote indicator must be the same for the entire article.
:p.Footnotes are semi-manual, this makes them slightly more complex to use, but it gives a very powerful series of
options.
:p.Once all the required footnotes have been added, they can be extracted into a new (or existing) frame. One
restriction is that you cannot extract footnotes from the currently selected frame into the currently selected frame.
See :link reftype=hd res=69.get footnotes:elink..
:p.:hp2.The footnote indicator:ehp2.
:p.You can only alter the footnote indicator for the first footnote in the text article. For subsequent footnotes,
the footnote indicator controls are disabled.
:p.The most basic kind of footnote indicator is a counter. You can set the start value of a counter by enabling the
'lock' checkbox, and entering a number into the adjacent entryfield. This method enables you to use footnotes that
are numbered consecutively across several articles. The manual start value setting has been provided because it
allows you to decide in which order the articles are supposed to be listed.
:p.For footnotes global to all text articles, it is probably best to use the footnote title text as a footnote indicator.
:p.:hp2.The footnote title:ehp2.
:p.The footnote title is used as a header to the footnote. Also, when the cursor is positioned on a footnote
you can see the footnote title in the help field of the status bar.
:p.:hp2.The footnote text:ehp2.
:p.The footnote text can be any text up to around 32k in size. This should be adequate for most footnotes.
.br
.br
.*******************************************************************************
:h2 res=47 id=47 global.Insert control text
:i2 refid=edit.Insert control text
:p.Use the 'Insert control text' dialog to add control text to the text frame. Control text is text that
is automatically generated from internal information. Such internal information includes the current
date and time, the current publication filename and path, the current page number and the number
of pages in the publication, as well as user defined text merge data.
:p.:hp2.Page numbers:ehp2.
:p.The page number is determined by the position of the control text on the printer page. If the control text
is not actually within a page, or exactly centred across two pages, the correct page number may not be found.
In this case you will get a '?'
:p.The total number of pages is useful for creating text of the form 'Page x of y', where 'y' is the total number of
pages in the entire publication.
:p.:hp2.Counters:ehp2.
:p.Counters provide a way of producing numbered lists. A number of ways of counting are provided, such as counting
alphabetically, or using roman numerals.
:p.Because counters can be nested, you can create numbered lists something like shown below.
:fig.
1 cars.
2 boats,
    a rowing.
    b sailing.
    c pedal.
3 bikes.
4 airplanes.
:efig.
:p.:hp2.Merge data:ehp2.
:p.You can load and use a merge database as a way of merging information into the text. The most common usage
for this is to create personalised letters from a list of names and addresses. Before you insert merge data,
you should load a merge database into the publication, and select the starting row of the data to be used for
the merge. Merging is performed automatically, dynamically, and changes as you alter the information in the
:link reftype=hd res=67.merge database:elink.. You can select which row in the merge database
you want to use by selecting the correct row from the dropdown list.
:p.Later, you can select a different row by selecting the appropriate text and selecting a new merge row in the
:link reftype=hd res=25.Select merge row:elink. dialog.
:p.:hp2.Date and time:ehp2.
:p.The date and time information is converted from a numeric format to a text format using a file called
:link reftype=hd res=111. DATECONV.LCI.:elink.
:p.You can set the date and time as normal text, in which case the control text is converted to normal text before
insertion in the document. As normal text, the date and time values will not be updated each time you repaint or print
the text. Because inserting a fixed date and time is the most common requirement, the mode is enabled by default.
:p.:hp2.File information:ehp2.
:p.You can select from the name of the publication, or you can choose to have the full file path inserted. If
the file has no name, you will get a blank string. When the file is saved, the string will appear with the
correct file information.
.br
.br
.*******************************************************************************
:h3 res=25 id=25 global.Select merge row dialog
:i2 refid=edit.Select merge row dialog
:p.This dialog is available if you have highlighted a piece of :link reftype=hd res=47.control text:elink.
containing data from a :link reftype=hd res=67.merge database:elink..
:p.You can change the relative merge database row used for obtaining the text. If the rows are set to auto-increment during
multiple print runs, the row will auto-increment in a corresponding manner.
:p.The base row is selected in the :link reftype=hd res=67.merge database:elink. dialog. The first row
shown in this dialogs listbox will correspond to the selected first row in the merge database dialog. The minimum offset
from this base row found in the selected control text will be selected in the listbox. This ensures that the row that you
can select is always greater than the base row.
:p.When you produce multiple print runs with an auto-incrementing base row, all the other rows will be offset accordingly.
Rows greater than the rows available in the merge database will cause the text to become a placeholder (such as '$$(123)'
for example).
.br
.br
.*******************************************************************************
:h2 res=19 id=19 global.Find text
:i2 refid=edit.Find text
:p.Select Find from the Edit menu. Find searches for text in the find entryfield.
:p.Enter the text you wish to find into the find entryfield. The entryfields allow strings of up to 254 characters.
:p.If you wish to alter the found text, enter the new text in the change entryfield.
:p.Select whether you want the test to be case sensitive, or you wish to search backwards.
:p.Until Find has found something, all other options are disabled. Once text is found, it is highlighted.
:p.:hp2.You may then:ehp2.
:ol.
:li.Change the text for that in the change entryfield.
:li.Change the text as above, and then find the next occurrence.
:li.Use any normal editing function, such as cut, copy, paste, typing, etc. Just move the find
dialog out of the way (or minimize) and click on the text to get a cursor. The dialog
will remain there until wanted.
:li.Change all occurrences of the text.
:eol.
:note.Find is a separate thread. Try not to edit the file whilst find is actually
searching.
.*******************************************************************************
:h2 res=20 id=20 global.Wordcount
:i2 refid=edit.Wordcount
:p.Select the 'Count words' menu item to give you a count of words in the current article. An article is made
up either of a single frame, or a set of linked frames. A complete publication can contain any number of articles.
.*******************************************************************************
:h2 res=22 id=22 global.Spell checking
:i2 refid=edit.Spell checking
:p.In order to check spelling, you need to have a spellcheck and hyphenation handler
installed. If you have this handler installed, you can use it to check the spelling of your
documents.
:p.To get more information about the spell check handler, you can either&colon.-
:ul.
:li.Use the 'List handlers...' menuitem in the help dialog, and use the 'Help for selected
handler' button after finding and selecting the spellcheck handler to obtain help.
:li.Open the text handler's 'Edit' menu and click on the 'Check text spelling...' menuitem.
The spellcheck handler should present you with a dialog containing a 'Help' button.
:eul.
:p.If the 'Check text spelling...' menuitem is disabled, the spellcheck handler is not
available. In this case, you may have to re-install it.
.*******************************************************************************
:h2 res=28 id=28 global.Article information
:i2 refid=edit.Article information
:p.Article information is used to distinguish text articles from one another. Any given publication can contain text
articles from several authors, articles that might be destined for that publication, or articles that have been
obtained from an entirely different publication. Once set, article information remains embedded within the article, and
can be viewed from the article information dialog.
:p.The various article information fields are provided to reflect the status of a given article. Later, this information
can be used to search for a particular article, or to select an article from a list.
:p.If no article information is provided, the application will, where necessary, use the first few words of the text
article to describe the article in a list.
:p.The following information fields are available&colon.-
:p.:hp2.Article name:ehp2.
:p.This field describes the name of the document. Some dialogs, such as the as the
:link reftype=hd res=69.get footnotes:elink. dialog, list the articles by name. If the article has no
name, the first few words of the text are used instead, but if you decide to set the text article information, you must
enter a name.
:p.You can search for the name of the article using the search tool in the 'Tools' menu.
:p.:hp2.Author:ehp2.
:p.This optional field describes the author of the document. You can put any text in here, or leave it empty.
:p.You can search for the author of the article using the search tool in the 'Tools' menu.
:p.:hp2.Date:ehp2.
:p.This optional field describes the date when the article was created. If no date exists, todays date is filled
in for you. You are not restricted to dates, you can put any kind of text in here, or leave it empty.
:p.:hp2.Destination:ehp2.
:p.This optional field describes where the article was intended to be published. If no destination exists, the
current filename is filled in for you. You can leave the field unchanged, put any text in here, or leave it empty.
:p.:hp2.Comments:ehp2.
:p.This optional field provides you with space to add comments. If the article has a copyright, this might be a good
place to make a note of it. Other useful things you can put in here is notes about corrections, translations, additions,
and so on.
.br
.br
.*******************************************************************************
:h2 res=17 id=17 global.Set object linkage
:i2 refid=edit.Set object linkage
:note.Not used by the Wingstamp border handler.
:p.Object linkage allow you to flow text over more than one object. This is the best way
of dealing with large articles spread over several columns or even pages.
:p.:hp2.Linking:ehp2.
:p.Ensure that all the objects you wish to link to have an empty contents layer
button. You can chain between different layers by selecting between handler buttons
during the chaining procedure. You can even chain between different layers on the
same frame.
:p.Select an unchained text object if you are creating a new chain, or select any text object
of an existing chain. All new objects will be added to this object. If you wish to add a new
object to the end of the chain, please select the last object in the chain.
:p.Click on the chain button. You will now see a dialog that allows you add objects to the chain.
:p.Select a different layer button if required. Ensure that the object you will select
has no handler attached. Exceptionally, you can link to an empty text object that was once unlinked
from a chain. This is known as an orphaned chain object.
Select a frame and/or page and click 'Add'. If the object was empty, the
dialog will say 'ok'. You can keep selecting and adding objects until you have created the desired
chain.
:p.To add a new object to the start of the chain, select the first object in the chain, the add the
new object. The new object will be added after the first object. By unlinking the first object and
then immediately relinking it to the new object, you have suceeded in swapping the first and second
objects in the chain. Other objects can be swapped in a similar fashion.
:artwork name='link.bmp' align=left.
:p.:hp2.Unlinking:ehp2.
:p.To unlink an object, select the object in the frame and press the unlink button. The
object will be shorted out so that the previous object is now chained to the next object, and the text
handler will be removed from that object. Note that removing (deleting) the text handler from a chained
object has the same effect.
:artwork name='unlink.bmp' align=left.
:p.:hp2.See also:ehp2.
:p.:link reftype=hd res=21.Chain breaking and linking:elink.
.br
.br
.*******************************************************************************
:h3 res=21 id=21 global.Chain breaking and linking
:i2 refid=edit.Chain breaking and linking
:p.From V1.22 this program adds the means to break and re-join chains of objects. If you break a linked chain
into two parts, you have created two chains. The first chain, containing the original text, is called a base chain.
The second chain, which is made up of text frames you cannot edit, is called a linkable chain.
:p.:hp2.Breaking chains apart:ehp2.
:p.Select the frame after the required break. So, for example, if your chain has two frames, and you wish to break the
frames into two, select the second frame. Select 'Break linked chain' from the 'Edit menu, and you will be presented
with the re-link dialog, as explained below.
:p.:hp2.Joining chains together:ehp2.
:p.You can only add a linkable chain to a base chain. There is no method for linking two chains in any other way. This
is done to prevent the possibility of a chain that links back to itself in an endless loop.
:p.If you click on the first frame of a linkable chain, you will be offered two choices. Either, you can make the chain
editable, in which case you will not be able to link it to a base chain. Or, you can link this frame to another chain, as
long as that chain is a base chain. If you choose to do neither, by pressing 'Cancel', you have a chain that can be
linked or made editable at some later time; all you need to do is reselect the first frame of the linkable chain.
:p.If you choose to link the linkable chain to a base chain, you will get a linkage dialog, and the cursor will
change to a linkage cursor. Navigate to the required base chain, by moving to another page or by switching to background
edit mode if necessary. You can click on any frame of the base chain, the linkable chain will always be added on to the
end.
.br
.br
.*******************************************************************************
:h2 res=11 id=11 global.Remove text handler
:i2 refid=edit.Remove handler
:p.Select this menu item to destroy all the text in the frame, and remove the handler
from the frame. Once you have done this you can add a different handler to the frame in place
of the current handler.
.br
.br
.******************************************************************************
.*  Character Menu
.******************************************************************************
:h1 res=40 id=40 global.The Text handler character menu
:i1 id=char.The Text handler character menu
:p.The Text handler character menu contains items specific to the fftxt text handler. Many of these
options are unique to this handler and are very powerful.
:p.Some of the items listed below will not be available when using the Wingstamp handler to add text to borders.
Similarly, some options are specific to the Wingstamp handler.
:ul.
:li.How to set :link reftype=hd res=42.the text orientation:elink..
:li.How to set :link reftype=hd res=68.the text language and codepage:elink..
:li.How to set :link reftype=hd res=72.intelligent quotes:elink..
:li.How to :link reftype=hd res=66.suppress paragraph widows and orphans:elink..
:li.How to :link reftype=hd res=71.enable text hyphenation:elink..
:li.How to set :link reftype=hd res=65.the character direction:elink..
:li.How to set :link reftype=hd res=59.the Wingstamp text start segment:elink..
:li.How to set :link reftype=hd res=58.the boundary whitespace:elink..
:li.How to set :link reftype=hd res=44.paragraph:elink. settings.
:li.How to set :link reftype=hd res=73.bullets and lists:elink..
:li.How to set :link reftype=hd res=45.line:elink. settings.
:li.How to setup a :link reftype=hd res=48.tab table:elink..
:li.How to select a :link reftype=hd res=43.font type and style:elink..
:li.How to set :link reftype=hd res=41.the colour of text characters:elink..
:li.How to set :link reftype=hd res=61.text dropshadows:elink..
:li.How to :link reftype=hd res=56.get information about text settings:elink..
:li.How to :link reftype=hd res=57.repeat text strings in Wingstamp borders:elink..
:li.How to :link reftype=hd res=60.reverse text strings in Wingstamp borders:elink..
:li.How to :link reftype=hd res=49.mark a title for extraction:elink..
:li.How to :link reftype=hd res=69.extract footnotes:elink. from your publication.
:li.How to :link reftype=hd res=52.extract a contents list:elink. from your publication.
:li.How to save text :link reftype=hd res=53.styles:elink..
:eul.
.******************************************************************************
:h2 res=42 id=42 global.Set the text orientation
:i2 refid=char.Set the text orientation
:note.Not used by the Wingstamp border handler.
:p.Text orientation is made up of the sum of frame orientation and text orientation.
By default the text orientation is +90.
:p.Normally, if the frame is orientated to zero, the text is orientated to +90, which
results in horizontal text.
:p.If you rotate the frame, the text will also rotate. The actual text angle is shown
as a status string within the rotate dialog. You can use the spin button or enter the
required angle to change the :hp1.relative:ehp1. orientation between text and frame.
:p.If you check the 'Save as default' button the information is written to Maul Publisher's initialisation
profile, and all new text frames will be created with this style.
:p.Click on 'Apply' to apply the new text angle. Click on 'Exit' when you are satisfied with the results.
:p.If you wish to change the angle of only one line, you may be able to do it using
:link reftype=hd res=45.tilt wedges:elink..
:p.See also :link reftype=hd res=65.Set the character direction:elink..
.******************************************************************************
:h2 res=68 id=68 global.Set the text language and codepage
:i2 refid=char.Set the text language and codepage
:p.The language selection is used to determine a number of important settings, these include&colon.-
:ul.
:li.The language used for calculating hyphenation wordbreaks.
:li.The language used for spell checking.
:li.The language used for displaying the date and time.
:eul.
:p.Each item in the language selection list displays 3 different parameters. The first is the language id,
and the second is the language string. The third parameter is only shown if the correct dictionaries for
your language are installed.
:p.To install a new language, you need to edit two files, both are found in Maul's .\etc path. The first file
is :link reftype=hd res=111.DATECONV.LCI:elink., and the second is called MYSPELL.DLS. To edit
MYSPELL.DLS, see the section "Managing dictionaries and codepages" in the spellcheck handler help manual.
:p.If you choose a language that has no dictionaries, hyphenation and spellchecking will not work correctly!
:p.Codepages are extensively used by OS/2 to display text for a given language or operating system.
Text is stored in memory as a series of numbers. The codepage determines to which character a number
belongs. If you import plain text with a different codepage, the characters will be wrong. Change
to the right codepage and the text will display correctly.
:p.Although the selected codepage is used to display text, it is not used to change the keyboard,
nor is it  used to actually convert text from one codepage to another. The application will translate
some codepages for you, see :link reftype=hd res=1000.Internationalisation Information:elink..
:p.Common codepages include&colon.-
:ul.
:li.1208 The default MBCS unicode codepage used by Maul Publisher unless you change it.
:li.819  This codepage is used by ISO8859-1 Linux systems, the MySpell spellchecker uses this codepage.
:li.850  This codepage is used by latin 1 OS/2 systems, and incorporates accents such as those used in French.
:li.852  This codepage is used by latin 2 OS/2 systems, and incorporates accents such as those used in Czech.
:li.1004 This codepage enables OS/2 systems to generally correctly display text created by Windows.
:li.1252 This codepage is used by latin 1 Windows systems.
:li.1250 This codepage is used by latin 2 Windows systems.
:eul.
:p.You can select the language and codepage you want to use for this article. Click on 'Set' to set both
the language and the codepage, and then click 'Exit' to leave the dialog. If you select a different text
frame, the dialog will automatically update. You can use different languages and codepages for different text
articles.
:p.There is a problem to be aware of though.
:p.The selected codepage is translated back to the installed codepage(s) on your system. The more complex this
translation, the slower text processing becomes. When selecting a frame with a different codepage, the handler
may need to reload it's table of fonts, and this gives the effect of momentary seizures from time to time.
:p.The codepages you can select are defined by the intersecting of codepages available on the operating system
and the file called :link reftype=hd res=112.CODEPAGE.LCI:elink.. This file lists and names all
the codepages you are able to select. You can disable the use of a codepage by deleting it from this file.
You may also find codepages in the file that you cannot select, these are simply not found on your system. The file
is found in the ..\etc directory. (Most stylesheets and master pages are found here too!)
.br
.br
.******************************************************************************
:h2 res=66 id=66 global.Suppress widows and orphans
:i2 refid=char.Suppress widows and orphans
:note.Not used by the Wingstamp border handler.
:p.:hp2.About widows and orphans:ehp2.
:p.Widows and orphans occur when a text paragraph is split between two frames. The first part
of the paragraph is called a widow, and the second part is called an orphan. This becomes a
problem when the paragraph is split so that maybe only the first one or two lines appear in
one frame, and the rest appear in another frame.
:p.:hp2.Using widows and orphans suppression:ehp2.
:p.This handler provided widows and orphans suppression on a per article basis. When the mode
is enabled, the 'Suppress widows and orphans' menu item is checked. You can enable or disable
the menu item by clicking on it.
:p.When the menu item is checked, the text article is reformatted using the following
algorithm (the rules are applied in the order shown)&colon.-
:ol compact.
:li.Split paragraphs of less than 8 lines in length are moved to the next frame.
:li.Widows of less than 4 lines also cause the paragraph to be moved to the next frame.
:li.Orphans cannot be less than 4 lines in length, the paragraph is split to ensure this
rule is maintained.
:li.All remaining paragraphs, split or not, are ignored.
:eol.
.br
.br
.******************************************************************************
:h2 res=71 id=71 global.Enable text hyphenation
:i2 refid=char.Enable text hyphenation
:p.Hyphenation is language and codepage dependant. Before you enable text hyphenation,
please select the correct language and codepage for your text article.
:p.To set the correct language for your text article, please use the
:link reftype=hd res=68.the text language and codepage:elink. dialog.
.br
.br
.******************************************************************************
:h2 res=72 id=72 global.Intelligent text quotes
:i2 refid=char.Intelligent text quotes
:p.Maul provides a means of managing quotes according to language. If the
'Intelligent text quotes' menu item is enabled, the simple "quote marks"
will be replaced by a :link reftype=hd res=2.LOL:elink. structure that automatically chooses the
appropriate quotemarks according to the selected language of the text article.
:p.The 'Intelligent text quotes' menu item determines if the inserted text is an
intelligent quote, or the default character.
:p.You can also insert intelligent 'single quotes', but to do this you must press
Alt+<'>. This is to avoid confusion with the apostrophe seen in the word l'eau (French),
or the word it's (English). There is otherwise no way of distinguishing between the two
usages.
:p.Other quote types, such as guillemets, are not part of the intelligent quotes feature.
:Note.This feature is disabled if the codepage does not support the required characters.
It is the reason why 1208 unicode is used as the default codepage for new text objects.
.br
.br
.******************************************************************************
:h2 res=65 id=65 global.Set the character direction
:i2 refid=char.Set the character direction
:p.Character direction determines the orientation of the individual characters that make up a line.
:p.This dialog will automatically adjust the text orientation and stroke direction to match
the character direction you choose.
:p.The characters are always output along the line of a stroke. The stroke
is set by the :link reftype=hd res=42.text orientation:elink..
:p.This dialog will rotate the stroke in order that the text orientation remains
consistent for each character direction.
:p.If you imagine that the text orientation is from left to right, then the
strokes can be stacked from the top down, or the bottom up. You can achieve
the latter effect by using a reverse stroke direction.
:p.The character direction settings also work for the Wingstamp border handler. In this case,
neither text orientation nor stroke ordering apply. It may be necessary to reverse the border painting
direction in some cases though.
:p.If you check the 'Save as default' button the information is written to Maul Publisher's initialisation
profile, and all new text frames will be created with this style.
:p.See also :link reftype=hd res=42.Set the text orientation:elink..
.br
.br
.******************************************************************************
.*  Wingstamp start segment
.******************************************************************************
:h2 res=59 id=59 global.Wingstamp text start segment Dialog
:i2 refid=char.Wingstamp text start segment Dialog
:note.Only available for the Wingstamp border handler.
:p.All the shapes available within Maul are made up of one or more segments. If a frame is a closed shape, and is made
up of several segments, you can choose the starting segment to paint the text from.
:p.Once the text is positioned on the correct segment, use tabs and spaces to precisely position the text.
.******************************************************************************
:h2 res=58 id=58 global.Set the boundary whitespace
:i2 refid=char.Set the boundary whitespace
:note.Not used by the Wingstamp border handler.
:p.When a object sits on top of the text frame, the text flows around the object. Normally,
a small amount of whitespace is left around such objects. This whitespace setting is independent of other
margin settings you may have set. Similarly, the margins do not affect this whitespace, which is calculated
to be an equal spacing in all directions, and which is placed only around objects intruding into the text frame.
:p.Enter in each field you wish to change a number followed by the measurement type. i.e. 0.5in.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without a
measurement type, the value is considered to be
in printer pels. The actual value is stored and displayed as printer pels.
:p.If you check the 'Save as default' button the information is written to Maul Publisher's initialisation
profile, and all new text frames will be created with this style.
.******************************************************************************
:h2 res=44 id=44 global.Set paragraph settings
:i2 refid=char.Set paragraph settings
:note.Not used by the Wingstamp border handler.
:p.Paragraph settings affect the positioning of an entire paragraph.
:p.If you have highlighted several paragraphs, the highlighted paragraphs will be altered, otherwise
only the current paragraph settings are altered.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are satisfied with the
results.
:p.If you check the 'Save as default button' the indenting information is written to Maul
Publisher's initialisation profile, and all new text frames will be created with the same
indent setting.
:p.:hp2.Paragraph indents:ehp2.
:p.Paragraph settings allow you to set the indenting and leading of a paragraph as well as
setting drop capitals. A paragraph in this instance is a formatted block of text covering one
or more lines. You can independently alter the indentation of the first line of the paragraph
to allow you to create a neat text layout. Both left and right indentation are supported.
:p.Enter in each field you wish to change a number followed by the measurement type. i.e.
0.5in.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without a
measurement type, the value is considered to be
in printer pels. The actual values are stored as points, and are accurate to 1/65536 of a point.
:p.:hp2.Drop capitals:ehp2.
:p.The font size field for drop capitals functions like the font size list on the tool bar.
If the required font size is not listed, you can type the required size into the combobox.
Font sizes are always specified in points.
:p.In order to precisely align drop capitals, the dialog also provides the means to adjust
the vertical offset of the drop capital character, and the empty distance to the right of it.
The 'Extra offset' entryfield accepts positive or negative measurements to offset the drop
capital character. The 'Extra width' entryfield will only accept positive values, and is used
to shift the remaining text to the right by the required amount.
:p.The settings for drop capitals are never saved with the system profile, but can be saved as
a style sheet.
.br
.br
.******************************************************************************
:h2 res=73 id=73 global.Set paragraph bullets
:i2 refid=char.Set paragraph bullets
:note.Not used by the Wingstamp border handler.
:p.Use bullets to create simple numbered or bulleted lists. Bullets require the use of unicode or DBCS codepages
that contain the necessary characters.
:p.Clicking on one of the bullet list buttons will create a default bulleted or numbered list. By using the
menu, or by right clicking on one of the bullet list buttons, you will get the 'Bullets and lists' dialog.
:p.The default bullet points are the same as those commonly used by web browsers, but you can
deselect this option and choose your own character.
:p.Numeric bullet points can be displayed as letters or roman numerals, as well as numbers. They can also be
decorated using a variety of brackets or punctuation. By selecting a counter level, you can create
multi-level numeric lists as shown below.
:fig.
1 cars.
2 boats,
    a rowing.
    b sailing.
    c pedal.
3 bikes.
4 airplanes.
:efig.
:p.The bullet settings are stored with the paragraph, and will overwrite any dropcaps settings.
:p.This is not the only way to create lists.
You can also use :link reftype=hd res=47.control text:elink., or you can manually create bulleted
lists by setting the appropriate :link reftype=hd res=44.paragraph:elink. indenting, and by inserting
your own character or inline image as a bullet.
.******************************************************************************
:h2 res=45 id=45 global.Set line parameters
:i2 refid=char.Set line parameters
:note.Only text justification is available in the Wingstamp border handler.
:p.Line parameters affect the positioning of an individual line. Line parameters are somewhat volatile.
If you change the width of a frame, a paragraph may contain fewer lines. In such a case, the excess line
parameters are deleted, along with your carefully chosen settings. If you then make the frame narrower, extra
lines will be added, and these new lines will copy their settings from the last of the previous
lines.
:p.If you have highlighted text, all highlighted lines will be altered, otherwise only the current line settings
are altered.
:p.You can set text justification using the radio buttons provided.
:p.Line leading is measured in a percentage of the current maximum character height.
:p.Line tilt wedges allow you to skew a line. From the viewpoint of an ancient printing press, the effect is
the same as taking two matching wedges of lead (hence leading) and placing them above and below a line of
metal character blocks. The tilt wedge parameter is the thickest part of the wedge.
:p.If the tilt wedge parameter is negative, the line will tilt down on the right, overwise it will tilt
down on the left. Enter a number followed by the measurement type. i.e. 0.5in. to introduce the wedges.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without a
measurement type, the value is considered to be
in printer pels. The actual value is stored as points, and is accurate to 1/65536 of a point.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are satisfied with the results.
:p.If you check the 'Save as default button' the information is written to Maul Publisher's initialisation
profile, and all new text frames will be created with this style.
.******************************************************************************
:h2 res=48 id=48 global.Set up a text tab table
:i2 refid=char.Set up a text tab table
:p.When you create a tab table, that table is inserted into the text file and is valid until you add a different
tab table. Tab tables allow you to setup odd tab settings for a given block of text.
:p.:hp2.Setting the tabs in the dialog:ehp2.
:p.When the tabs dialog is created, a ruler is drawn using the current rule settings for the main window. You can
set or clear a tab on any one of the ruler tickmarks by clicking on it with the mouse.
:p.Zoom in using the zoom buttons on the main window toolbar if you want to set the tabs more precisely than the ruler
will allow.
:p.:hp2.Applying the tabs to highlighted text:ehp2.
:p.Clicking the 'Apply' button sets the tab table into a temporary buffer. If text is highlighted, the table is applied
to the highlighted portion of the text.
:p.:hp2.Adding the tabs along with some new text:ehp2.
:p.In order to insert a new tab table without highlighting the text first, you must immediately start typing without
selecting a cursor position. Clicking the mouse on the text area causes the current settings to be reloaded from the
text file, destroying the tab table you have just created.
:p.:hp2.How many tabs?:ehp2.
:p.The number of tabs you can have is limited to about 60.
:p.The tab values are stored as points, and are accurate to 1/65536 of a point. (There are 72.2818 points to the inch.)
.******************************************************************************
:h2 res=43 id=43 global.Select a font type and style
:i2 refid=char.Select a font type and style
:p.Use the font dialog to choose a font. This dialog also allows you to alter a number of settings that affect what
the font looks like.
:p.Zoom in using the zoom buttons on the main window toolbar if the font example is too small. If you have highlighted
some text, this will be used as a sample string.
:p.:hp2.Font:ehp2.
:p.First choose a font, the select one of the available styles.
:p.Use the font size combobox either to select a given font size, or to type in your own.
:p.:hp2.Attributes:ehp2.
:p.The font attributes can also be used to make normal fonts bold or italic. The fonts thus
created may not be actual fonts, but synthesised fonts. You should be aware that synthesised
font attributes may cause unexpected results if your publication is to be printed by a print
shop. If you are printing from your own PC, you can perform a short test print to see what you
get.
:p.:hp2.Stretch:ehp2.
:p.Use the character spacing controls to alter the gap between characters, and the character stretch controls
to alter the average width of a character. You can use the sliders or you can enter a number into the appropriate
entryfield.
:p.Both spacing and stretch are specified as a percentage of the average text width.
:p.:hp2.Shear:ehp2.
:p.Character shear affects the tilt of the characters. It is one way to create italic text for example.
:p.Use the rotary control or the entryfield to enter an angle in degrees. The status display shows the vertice
angle, that is the angle of the vertical portion of the text, and takes into account the current rotation factors.
:p.:hp2.Reset:ehp2.
:p.Press the reset button to reset all the the controls back to the current settings.
:p.:hp2.Save as default:ehp2.
:p.If you check the 'Save as default button' the information is written to Maul Publisher's
initialisation profile, and all new text frames will be created with this style.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are satisfied with the
results.
:p.If you have highlighted text, the highlighted text will be altered, otherwise only the current text
settings are altered. These text setting do not come into effect unless you insert new text.
.******************************************************************************
:h2 res=41 id=41 global.Set the character colour
:i2 refid=char.Set the character colour
:p.Use this dialog to select a character colour for a selected block of text. The foreground colour is used for the
text, and the background colour is used to place a colour behind the selected text. You can also set the background
colour to transparent.
:p.If you are using the Wingstamp border handler, you can set an overall background colour using a seperate
menu item.
:p.Either way, this is a dialog within the current colour handler. See the help information
provided with the colour handler to obtain information on how to use this dialog.
.******************************************************************************
:h2 res=54 id=54 global.Alter the character kerning
:i2 refid=char.Alter the character kerning
:p.:hp2.About kerning:ehp2.
:p.Kerning is used to adjust the gap between certain character pairs in order to make words
look more balanced. Classic examples of kerning include moving the letters Y and o closer
together. Otherwise, it looks as if there is a space between them.
:p.Kerning relies on kerning tables built into the current font. The kerning table for one
font may well be different to the kerning table for another. If no kerning table is found, no
kerning takes place.
:p.:hp2.Kerning dialog:ehp2.
:p.Use the character kerning dialog to determine when kerning takes place. If you have highlighted
text, the highlighted text will be altered, otherwise only the current text settings are altered.
These text setting do not come into effect unless you insert new text.
:p.You can use the dropdown list or the entryfield of the combobox to enter a minimum point
size for kerning.
:p.Click the checkbox to enable or disable kerning for the selected text.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are satisfied with the
results.
:p.If you check the 'Save as default button' the information is written to Maul Publisher's
initialisation profile, and all new text frames will be created with this style.
.******************************************************************************
:h2 res=61 id=61 global.Dropshadow text
:i2 refid=char.Dropshadow text
:p.You can use text dropshadows to highlight a text string, or title. Dropshadows use a dropshadow
colour to draw a dropshadow string beneath the text string. The default dropshadow uses a mid gray colour, and is
offset by 7% to the bottom right of the text.
:p.If you are happy with the default settings, just clicking on the dropshadow button is sufficient to enable drop
shadows. There are, however, a couple of gotcha's.
:p.First, if the dropshadow colour is disabled, the drop shadow will be invisible. Similarly, if the dropshadow
offset is set to zero, the dropshadow will be hidden from view.
:p.By using the 'Character Dropshadow...' dialog, you get considerably greater control over the dropshadow. Use this
dialog to set the colour, the offset percentage, and the offset direction of the dropshadow. The offset percentage
is based on the height of the maximum ascender, usually the height of a capital 'H'.
:p.If you have highlighted text, the highlighted text will be altered, otherwise only the current text settings are altered.
These text setting do not come into effect unless you insert new text.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are satisfied with the results.
:p.If you check the 'Save as default button' the information is written to Maul Publisher's initialisation
profile, and all new text frames will be created with this style.
.******************************************************************************
:h2 res=56 id=56 global.Getting information by using the LOL List
:i2 refid=char.Getting information by using the LOL List
:p.The LOL List is a dialog that shows the current settings at the cursor position. Settings such as fonts and colours
are stored inline with normal text. This dialog reads back these normally invisible embedded settings.
:p.The LOL List shows the following settings&colon.-
:dl compact tsize=30.
:dt.Font:dd.The font, and any additional emphasis as Bold, Italic, Underline, Outline, Strikethrough.
:dt.Paragraph:dd.Paragraph leading, left and right 1st line indents, and remaining left and right indents.
:dt.Shear:dd.Shear angle in degrees offset from the default.
:dt.Direction:dd.Character direction is always left to right.
:dt.Charbox:dd.Text size in points.
:dt.Colour:dd.An RGB colour value, where 00000000 is black, and 00ffffff is white.
:dt.Emphasis:dd.Superscript, subscript, or none.
:dt.Title:dd.The current title extraction level, where 0 = none.
:dt.Spacing:dd.The gap between this character and the next, in points.
:dt.Stretch:dd.The amount the text characters are stretched by, in points.
:edl.
.br
.br
.******************************************************************************
:h2 res=57 id=57 global.Repeating text strings in Wingstamp borders
:i2 refid=char.Repeating text strings in Wingstamp borders
:note.Only available for the Wingstamp border handler.
:p.If you are using the Wingstamp border handler, you can set a flag that makes the handler repeat the text string until
the border is filled with text. Click on the 'Repeat Text' menu item to toggle this mode.
.******************************************************************************
:h2 res=60 id=60 global.Reversing text strings in Wingstamp borders
:i2 refid=char.Reversing text strings in Wingstamp borders
:note.Only available for the Wingstamp border handler.
:p.If you are using the Wingstamp border handler, you can set a flag that makes the handler reverse the text string
so that the text is painted around a figure by going in the opposite direction. Click on the 'Reverse paint' menu item
to toggle this mode.
.******************************************************************************
:h2 res=49 id=49 global.Mark a string for title extraction
:i2 refid=char.Mark a string for title extraction
:p.Use the 'Title extraction' dialog to mark a string as a title for creating a contents list
of your publication later on.
:p.Select a titling level. 0 turns off the title marking. 1 is the top or highest title
level, and 8 is the lowest. Click on 'Ok' to set the current titling level.
:p.If you have highlighted text, the highlighted text will be altered, otherwise only the current text settings
are altered. These text setting do not come into effect unless you insert new text.
:p.A marked title looks no different to an unmarked title, so you won't see any difference in the text.
You will however see the current level shown in the cursor status and position field of the status bar.
:p.Be careful not to inadvertently mark the whole article as a title. If the title is set to a certain level, any text
that you add will be set to the current level. When you subsequently extract the contents, you get rather more than you
bargained for!
.br
.br
.******************************************************************************
:h2 res=69 id=69 global.Extract footnotes from the text
:i2 refid=char.Extract footnotes from the text
:p.You can extract (list) footnotes that you have created in various text articles. The way to use footnotes is as
follows&colon.-
:ol.
:li.Annotate your text articles with footnotes.
:li.Create an empty text frame at the bottom of the page, or at the end of the document, as required.
:li.Extract footnotes from selected text articles into the empty text frame. Although you can extract footnotes into
a text frame that already contains text, you cannot extract footnotes from within that text back into the same frame.
But because the extracted footnotes are just ordinary text, you can copy, paste, and edit them as required.
:eol.
:p.:hp2.Get footnotes dialog:ehp2.
:p.By using stylesheets, you can give the footnote titles a different look to the footnote itself. Depending on some
options (shown as <option>), the footnote is extracted in the following format&colon.-
:fig.
<indicator><indent>Footnote title[newline]
<indent>Footnote text[newline]
:efig.
:p.If you want empty lines between the footnotes, make sure that you add the appropriate number of blank lines at the
end of the footnote text. The footnote text will be extracted complete with all new lines and tabs intact.
:p.Click the 'Add indicator to title' checkbox if you want the footnote indicator added to the footnote title. If the
footnote indicator uses the footnote title, the checkbox is ignored.
:p.:hp2.Selecting text articles:ehp2.
:p.Use the two listboxes provided to set the text articles you want to extract from, and in which order you want to
process them.
:p.The left hand listbox allows you to make a multiple selection. All selected articles will appear in the right hand
listbox.
:p.The right hand listbox allows you to select a single text article, and to move it up or down the list by clicking the
appropriate buttons. The extraction process will extract footnotes from the text articles in the order that they are
listed in the right hand listbox.
:p. See also&colon.-
.br
How to insert :link reftype=hd res=26.footnotes:elink..
.br
.br
.******************************************************************************
:h2 res=52 id=52 global.Extract titles from the text
:i2 refid=char.Extract titles from the text
:note.You cannot extract titles to a Wingstamp border, but you can mark titles on a border in order to extract them
into a normal text frame.
:p.Use the extract titles dialog to extract a contents list from your publication. You need to
:link reftype=hd res=49.flag the titles:elink. that you wish to extract before
commencing. You also need to have a text frame prepared and selected to extract into.
:p.The titles are extracted page by page, frame by frame, and object by object. If you wish to have a title in one frame
appear before the title in a subsequent frame, you must make sure the frames are in the correct order. Frames are searched
from the lower-most frame to the upper-most frame (frames appearing later in the file paint over frames appearing earlier).
:p.Once the titles are extracted they are ordinary text and can be edited as usual. It is
unlikely that the title extraction will create the exact layout you require so be prepared
to do some additional tidying up later.
:p.The handler supports subtitles up to eight layers deep so you shouldn't have a problem
creating a quite complex contents list. Each depth of subtitling can have a different text style, and
you can also add a page number and/or subtitling depth to each title.
:p.You will probably wish to set up a number of text styles specifically reserved for creating
a contents list. See :link reftype=hd res=53.Save text character styles:elink..
:p.:hp2.Title page information:ehp2.
:p.You can add page information to your extracted titles. Select the appropriate button to add
page information at the front or back of the title. The text string that you type into the entryfield
will be added to each title.
:p.The page information entryfield recognizes some commands. These are as follows&colon.-
:p.Note that every command starts with a $, and the command names is always in brackets. Only the commands
shown above are recognized. Everything else is considered to be plain text.
:dl compact tsize=20.
:dt.:hp2.$(tab):ehp2.:dd.A tab.
:dt.:hp2.$(page):ehp2.:dd.The page the title was found on. See note.
:dt.:hp2.$(level):ehp2.:dd.The subtitle level.
:edl.
:lm margin=1.
:p.(...where level 1 is the top, and level 8 is at the bottom)
:note.If the title is not actually within a page, or exactly centred across two pages, the correct page number may
not be found. In this case you will get a '?'
:p.:hp2.Saving the extraction settings:ehp2.
:p.You can save the settings used to extract titles. The settings are saved in the program profile, so once
saved, the settings become the default.
.******************************************************************************
:h2 res=53 id=53 global.Save text character styles
:i2 refid=char.Save text character styles
:p.Use the 'Add to style list' dialog to save or delete a text style. The actual text style saved is the
currently set style. When you move the cursor to a given position in the frame, the text style is copied to
a set of structures. These structures are manipulated whenever you use a dialog or menu item to alter any of
the current text settings.
:p.If you move the text cursor after altering the text shear, for example, the text shear will be reset to the
value under the cursor. If, on the other hand, you change any text style settings before saving them, and you have
not moved the text cursor, the changed setting are saved. Similarly, if you cange a setting and then type something, the
changed settings are used for the new text.
:p.The 'Add to style list' dialog reads the current text settings and saves them in a file.
:p.The settings that are saved are the following&colon.-
:ul.
:li.The current font.
:li.The current font emphasis, (bold, italic, etc.).
:li.The current paragraph settings.
:sl.
:li.paragraph leading.
:li.line 1 left and right indents.
:li.default left and right indents.
:esl.
:li.The current text colours.
:li.The current text size.
:li.The current line settings.
:sl.
:li.line leading in %
:li.line tiltwedge.
:li.line justification.
:esl.
:li.The current text shear.
:li.The current text spacing.
:li.The current text kerning settings.
:sl.
:li.The kerning enable flag
:li.The minimum kerning size
:esl.
:li.The current text stretch.
:li.The current text dropshadow settings.
:sl.
:li.dropshadow offset in %
:li.dropshadow angle.
:li.dropshadow colour.
:li.dropshadow enable.
:esl.
:eul.
:p.If you check the 'Save as default' button the information is written to Maul Publisher's initialisation
profile, and all new text frames will be created with this style.
.******************************************************************************
.*
.*
.*
.*  Toolbar Help
.*
.*
.*
.******************************************************************************
:h1 res=90 id=90 global.Toolbar Help
:i1 id=tools.Toolbar Help
:p.The toolbar provides most of the functionality of the text handler in a condensed, and convenient manner.
:p.This section provides help on the following toolbar items.
:ul.
:li.:link reftype=hd res=91.Font Selector:elink..
:li.:link reftype=hd res=92.Font Style Selector:elink..
:li.:link reftype=hd res=93.Font size Selector:elink..
:li.:link reftype=hd res=94.Text style buttons:elink..
:li.:link reftype=hd res=95.Text reflow button:elink..
:li.:link reftype=hd res=96.Text justification buttons:elink..
:eul.
.******************************************************************************
:h2 res=91 id=91 global.Toolbar Font Selector
:i2 refid=tools.Toolbar Font Selector
:p.Use the font selector :artwork name='font.bmp' runin. to select a font. This is a dropdown list of all available
font families on your system. Note that only scalable outline fonts can be used. The actual font used will in part
depend on the text style (bold, italic, etc.) that you have selected. The actual font is shown in the
:link reftype=hd res=81.font status:elink. field.
:p.If any text is highlighted, the text is changed immediately. Otherwise, the new font will not be used unless you
type something. As you move the cursor, so the selected entry is updated. Thus, if you move the cursor before
typing or inserting any text, any new selection is abandoned.
:p.:hp2.The complete font selector:ehp2.
:p.:artwork name='fontsel.bmp' align=left>.
.br
.br
.******************************************************************************
:h2 res=92 id=92 global.Toolbar Font Style Selector
:i2 refid=tools.Toolbar Font Style Selector
:p.Use the font style selector :artwork name='fontsty.bmp' runin. to select a font style. This is a dropdown list
of all available styles within a particular font family. The name of the actual font is shown in the
:link reftype=hd res=81.font status:elink. field.
:p.If any text is highlighted, the text is changed immediately. Otherwise, the new font will not be used unless you
type something. As you move the cursor, so the selected entry is updated. Thus, if you move the cursor before
typing or inserting any text, any new selection is abandoned.
:p.:hp2.The complete font selector:ehp2.
:p.:artwork name='fontsel.bmp' align=left>.
.br
.br
.******************************************************************************
:h2 res=93 id=93 global.Toolbar Font size Selector
:i2 refid=tools.Toolbar Font size Selector
:p.Use the font size selector :artwork name='size.bmp' runin. to select a font size. If the precise size is not listed,
you can type the required size into the box, and press enter.
:p.If any text is highlighted, the text is changed immediately. Otherwise, the new size will not be used unless you
type something. As you move the cursor, so the selected size is updated. Thus, if you move the cursor before
typing or inserting any text, any new size selection is abandoned.
:p.:hp2.The complete font selector:ehp2.
:p.:artwork name='fontsel.bmp' align=left>.
.br
.br
.******************************************************************************
:h2 res=94 id=94 global.Toolbar Text style buttons
:i2 refid=tools.Toolbar Text style buttons
:p.Use the text style :artwork name='charmode.bmp' runin. buttons to quickly alter the style of the text. You thus have
instant access to outline, underlined, strikeout, superscript, subscript, and dropshadow, text styles.
:p.Note that the dropshadow style has additional parameters that can be set from the 'Character' menu.
:p.If any text is highlighted, the text is changed immediately. Otherwise, the new style will not be used unless you
type something. As you move the cursor, so the selected style is updated. Thus, if you move the cursor before
typing or inserting any text, any new selection is abandoned.
.******************************************************************************
:h2 res=95 id=95 global.Text reflow button
:i2 refid=tools.Text reflow button
:p.Use the text reflow :artwork name='reflow.bmp' runin. button to reformat the whole text article. If the text is spread
over many frames, all frames will be reformatted.
:p.This function is not a simple repaint, all text positions are recalculated. If the text article is very large, or if
the text frame is very complex, this can take a moment. You will see a percentage bar if the reformat is slow. You
cannot interrupt this reformat process once started.
.******************************************************************************
:h2 res=96 id=96 global.Toolbar Text justification buttons
:i2 refid=tools.Toolbar Text justification buttons
:p.Use the text justification :artwork name='charjust.bmp' runin. buttons to alter the justification of the current line.
:p.If several lines are highlighted, all the lines are altered. Justification is dynamically calculated, and does not require
the text to reformat. Justification can be altered on a line by line basis. Justification is only one of several
parameters that you can alter using the 'Line settings...' dialog in the 'Character' menu.
.******************************************************************************
.*
.*
.*
.*  Status Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  status bar
.******************************************************************************
:h1 res=80 id=80 global.Status Bar information
:i1 id=stats.Status Bar information
:p.The status bar contains information to help you understand where you are in the text frame.
:p.In essence, a lot of text status information is available on the button bar, where the state
of the buttons and list boxes indicate the current text emphasis, justification, and so on.
.******************************************************************************
:h2 res=81 id=81 global.Font status information
:i2 refid=stats.Font status information
:p.This status bar indicates the exact name of the current font, whereas the font name given in
the buttonbar listbox is the family name of a family of fonts.
:p.Thus the buttonbar listbox may say 'Swiss' to indicate the Swiss font family, and the status
bar may say 'Helv Bold' to indicate the actual current font from within the Swiss font family.
.******************************************************************************
:h2 res=83 id=83 global.Cursor status and position information
:i2 refid=stats.Cursor status and position information
:p.The cursor status information contains a number of useful indicators not normally shown elsewhere.
:p.The format is as follows&colon.-
:p.:hp2.L<line number><lolflag><textposition>,<titlemark><tablist>:ehp2.
:p.The line number is fairly self explanatory, as is the text position. These two numbers indicate the
row and column of the current cursor position.
:p.:hp2.The lolflag:ehp2.
:p.Not so obvious is the lolflag. A lol is an invisible data block that causes a change in the text style
between the previous character, and the next. When you position the cursor at the junction between two
text styles, you can either add text in the previous style (the default), or the next style. If you
wish to edit in the previous style you must be positioned before the lol, if you wish to edit in
the next style you must be positioned after the lol.
:p.To leap over a lol (lol means 'leap over lol') hold down the alt key and press the right cursor
button on the keyboard. To go to the start of the lol, press the left cursor button on the keyboard.
:p.If you are at the start of a lol (the default), the lolflag will be a colon "&colon."; if you are at the end of
a lol, the lolflag will change to a "*".
:p.:hp2.The titlemark:ehp2.
:p.If the cursor is positioned within a marked title, the titlemark will be a number from 0 to 8. Otherwise it will
be a "." to indicate no title mark. A titlemark of level 0 is not extracted. All titles should be separated by a
level 0 portion of text.
:p.:hp2.The tablist:ehp2.
:p.If there is a valid tablist lol before the current cursor position, the fact will be indicated with a "t".
Otherwise a "." will be shown to indicate that there is no valid tablist at this point in the frame.
.******************************************************************************
:h2 res=82 id=82 global.Linkage information
:i2 refid=stats.Linkage information
:p.This status field indicates linkage between frames. A "" indicates the first frame in a series of linked
frames. The "" indicates the last frame in a series of linked frames. If you see "" the frame is linked both
the previous frame and the next, and is thus in the middle of a series of linked frames.
:p.If the status field is blank, no linkage is associated with this frame.
:p.This status field is also used by the Wingstamp handler to indicate when the cursor is found. The flag is a small
'*' and makes it much easier to hilight a piece of curved text.
.******************************************************************************
.*
.*
.*
.*  Options Help
.*
.*
.*
.******************************************************************************
:h1 res=100 id=100 global.Tool and Option menu items set by this handler
:i1 id=options.Tool and Option menu items set by this handler
:p.The fftxt and wingstamp handlers share a number of option menu items. Items in
'Tools' or 'Options' are dynamically created on program startup.
:p.This section provides help on the following option menu items.
:ul.
:li.Tool&colon.- How to use a :link reftype=hd res=67.text merge:elink. database.
:li.Tool&colon.- How to :link reftype=hd res=97.mark an entire document as invalid:elink..
:eul.
:p.:hp2.Text options&colon.-:ehp2.
:ul.
:li.Option&colon.- How to use set the :link reftype=hd res=55.default tab:elink. size.
:eul.
:p.The following determine the default modes used for all new text objects. This also includes text
created on a line(wingstamp) or in a table. Changing these settings will not affect any existing text objects.
:ul.
:li.Option&colon.- Enable :link reftype=hd res=72.intelligent text quotes:elink.
when creating new text objects.
:li.Option&colon.- Enable :link reftype=hd res=66.widow and orphan suppression:elink.
when creating new text objects.
:eul.
.br
.br
.*******************************************************************************
:h2 res=67 id=67 global.Merge database
:i2 refid=options.Merge database
:p.Menu item&colon. 'Options->Select merge data...'
:p.You can load and use a merge database as a way of merging information into the text. The most common usage
for this is to create personalised letters from a list of names and addresses. Merge data can be provided by
table based applications such as spreadsheets and databases. Once you have loaded merge data into the publication,
you can use :link reftype=hd res=47.control text:elink. to place this data anywhere within your
publication.
:p.The merge database is loaded into the publication as a comma separated list. Most spreadsheets and databases can
save data as a comma separated list. The first line of your data should contain the names of the columns. This enables
you to easily select the correct field.
:p.Once the comma separated list file has been loaded, you should select the row of data you require. Any merge data
entries already in the file will change the instant that you click on ok.
:p.If you select 'Increment when printing', you can print a series of personalised publications. Select the row you
require the series to start from. In the print dialog, select the number of print copies you require. Each print copy
will use a new row. When all the available rows are used up, and yet more print runs are to be made, the series will
restart on the selected row.
:p.:hp2.Comma separated lists:ehp2.
:p.A comma separated list is a plain text list of items separated by commas. Individual items may contain commas as long
as the item is in "quotes". Such quotes are automatically removed. Here is an example with just two rows and four
entries per row&colon.-
:xmp.
Name, Address, Postcode, City
John Smith, "27, the High Street", BC1 4AD, Bigcity
:exmp.
.br
.br
.*******************************************************************************
:h2 res=97 id=97 global.Mark entire document as invalid
:i2 refid=options.Mark entire document as invalid
:p.Use the Tools menu item 'Mark entire document as invalid' to reformat the entire publication.
All frames will be reformatted.
:p.This function is not a simple repaint, because all text positions are recalculated. In order to save time, only the
current page is reformatted. Other pages will be reformatted as they are required, either when repainting,
or during a print run.
.br
.br
.*******************************************************************************
:h2 res=55 id=55 global.Set the default text tab size
:i2 refid=options.Set the default text tab size
:p.Menu item&colon. 'Options->FFText tabs...'
:p.Use this dialog to set the default tab size when you haven't setup a tab table.
:p.As supplied the text handler sets a default tab to 36pt. This is about half an inch.
:p.Enter a number followed by the measurement type. i.e. 0.5in.
:p.The information is saved as the default tab setting for the text frame.
:p.If you check the 'Save as default' button the information is written to Maul Publisher's initialisation
profile, and all new text frames will be created with this default tab setting.
:p.This arrangement provides for a hierarchy of tab settings, starting with a system wide default tab, then a
frame default tab, and then any tab tables you may have set up.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without a
measurement type, the value is considered to be
in printer pels. The actual value is stored as points, and is accurate to 1/65536 of a point.
.br
.br

.******************************************************************************
.*
.*
.*
.*  Import Export Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  import and export
.******************************************************************************
:h1 res=84 id=84 global.Importing and Exporting text
:i1 id=import.Importing and Exporting text
:p.Importing and exporting text is used to allow files produced by other applications to be loaded into
the default text handler. Two formats are supported by this handler. Plain ASCII text can be used where the
text contains no formatting information other that that created by a text editor such as the OS/2 system editor.
:p.The other format that can be imported and exported by this handler is the native FFTXT format.
At present this format is incompatible with any other editor, but the format does contain all the formatting
information that is lacking in plain text.
:p.Other text formats are supported by separate import handlers.
:p.:hp2.How to import or export text:ehp2.
:p.Before you can import or export text, you must have selected a text frame, and positioned the cursor at the
required position. If you wish to export only a portion of the text, you can
:link reftype=hd res=18.select:elink. the text to export and only that portion will be exported.
Otherwise, all the text within the selected frame is exported. When importing text, ensure that no text is highlighted
unless you wish to have that portion of text overwritten.
:p.Click on 'File' and then 'Import' or 'Export'. You will be presented with a list of text types available. Choose
the type you require. Maul will provide more text types if other suitable import and export handlers are installed.
.******************************************************************************
:h1 res=62 id=62 global.Font substitution
:i1 id=fontsubs.Font substitution
:p.The font substitution dialog is raised whenever you select a text frame for the first time, and one
of the required fonts is missing. The ensuing dialog gives a unique opportunity to directly alter
the font in a text frame. If you choose not to update a missing font, you will not get another chance
to change the missing font unless&colon.-
:ul.
:li.You close and then re-load the file.
:li.You switch pages while in text editing mode.
:eul.
:p.Mostly, you won't get another chance.
:p.:hp2.This font is missing:ehp2.
:p.This is a short description of the font that cannot be found. Whenever a font is not found, the
system tries to substitute a default font such as Helv. You may decide, however, that a different
font would be more suitable.
:p.:hp2.Replace with the font shown:ehp2.
:p.The font selector uses two dropdown lists. The first shows a list of available font families, while
the second shows the styles available for that font.
:p.:hp2.Sample:ehp2.
:p.The dialog has a status display that shows an example string. This can help greatly in choosing
a suitable replacement font.
:p.Click on 'Replace' to apply the new font.
:p.Click on 'Ignore' if you don't want to alter the name of the font. In this case, a default font
is substituted. This default is usually a font from the 'Swiss' font family.
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=120 id=120 global.Help with keyboard keys
:i1 id=keys.Help with keyboard keys
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.Please note that keyboard shortcuts are editable, and thus may not correspond to the settings listed here.
The keys shown here are the default settings.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Text handler key usage:ehp2.
:p.The same keys apply to the wingstamp handler, where applicable.
:p.:hp2.Keys used to move the cursor&colon.-:ehp2.
:dl compact tsize=16.
:dt.Alt+Left:dd.Start of prior adjacent LOL.
:dt.Ctrl+Left:dd.Prior word
:dt.Alt+Right:dd.End of next adjacent LOL.
:dt.Ctrl+Right:dd.Next word
:dt.Shift+Cursor movement:dd.Highlight, when used with any cursor movement keys, or the mouse.
:edl.
:p.:hp2.Hyphenation&colon.-:ehp2.
:dl compact tsize=16.
:dt."-":dd.The minus character (not on the numeric keypad!) is the default hyphen character.
:dt.Alt+"-":dd.The minus character (not on the numeric keypad!) with the Alt key forms a
speculative hyphen character. The character only appears if the word happens to be hyphenated
at that point. Speculative hyphens override automatically generated ones.
.br
To remove a speculative hyphen, position the cursor to the left of the hyphen, press Alt+Right, then press backspace.
:edl.
:p.:hp2.Intelligent text quotes&colon.-:ehp2.
:dl compact tsize=16.
:dt."'":dd.Inserts a single apostrophe. Intelligent text quotes are not used.
:dt.Alt+"'":dd.Inserts a single intelligent text quote. The shape of the quote is determined by the selected
language and its position within the text.
:edl.
:p.:hp2.Non breaking punctuation&colon.-:ehp2.
:p.Any character recognized as punctuation, or the space character, can be marked as non-breaking.
The formatter will not use the character to indicate a possible linebreak, and will treat all such
characters as normal text instead. For example&colon.-
:dl compact tsize=16. 
:dt." ":dd.Inserts a space character.
:dt.Ctrl+Alt+" ":dd.Inserts non breaking space character.
:edl.
:p.:hp2.Tabs&colon.-:ehp2.
:dl compact tsize=16.
:dt.Tab:dd.Inserts a tab, the tab will move the next word to the start of the tab.
:dt.Shift+Tab:dd.Inserts a right justified or numeric tab.
If the next word contains a decimal point or comma (and is a number), the text will align to it.
Otherwise, the text will align to the end of the next word.
:edl.
:p.:hp2.Menu keys&colon.-:ehp2.
:ol.
:li.:hp2.Edit menu:ehp2.
:dl compact tsize=16.
:dt.Shift+Delete:dd.Cut
:dt.Ctrl+Insert:dd.Copy
:dt.Shift+Insert:dd.Paste
:dt.Delete:dd.Clear
:dt.Ctrl+Alt+F:dd.Find text...
:dt.Ctrl+Alt+O:dd.Count words...
:dt.Ctrl+Shift+L:dd.Link to text frame (not Wingstamp)...
:dt.Ctrl+Shift+K:dd.Unlink text frame (not Wingstamp).
:dt.Ctrl+Alt+S:dd.Set text style...
:dt.Alt+Delete:dd.Remove handler
:edl.
:li.:hp2.Character menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+O:dd.Text orientation (not Wingstamp)...
:dt.F2:dd.Check text spelling...
:dt.Ctrl+Shift+G:dd.Paragraph settings (not Wingstamp)...
:dt.Ctrl+Alt+L:dd.Line settings (not Wingstamp)...
:dt.Ctrl+Alt+T:dd.Line tabs...
:dt.Ctrl+Shift+F:dd.Character font...
:dt.Ctrl+Shift+C:dd.Character colour...
:dt.Ctrl+Alt+P:dd.Wingstamp repeat text mode...
:dt.Ctrl+Alt+U:dd.Wingstamp background fill colour...
:dt.Ctrl+ALT+I:dd.Lol List dialog...
:dt.Ctrl+Shift+U:dd.Select superscript
:dt.Ctrl+Shift+B:dd.Select subscript
:dt.Ctrl+Shift+Q:dd.Insert control text...
:dt.Ctrl+Shift+X:dd.Add text to title index...
:dt.Ctrl+Alt+X:dd.Extract title index (not Wingstamp)...
:dt.Ctrl+Alt+A:dd.Add to text style list...
:edl.
:eol.
:h1 res=1000 id=1000 global.Internationalisation Information
:i1 id=tech.Internationalisation Information
:p.This text handler uses a number of techniques to cope with different languages. The
translation of dates and times is covered in the page on
:link reftype=hd res=47.control text:elink..
:p.:hp2.Codepages:ehp2.
:p.Maul performs on the fly codepage translations using the inbuild OS/2 unicode API standard.
:euserdoc.
