.******************************************************************************
.*  Maul Publisher Colour separation Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Colour separation Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Colour separation Handler
:i1 id=all.About Maul Colour separation Handler
:font facename='Tms Rmn' size=24x24.
:hp2.Maul Colour separation Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Colour separation Handler:ehp2.
:p.Use this handler to create CMYK colour separations during printing.
:p.The handler also provides the means to tune colour densities in the CMY colour domain. The handler does not deal with
colour gamut limiting, as this is usually ink and printer specific.
:p.To obtain more help from here, select 'Options' then 'Contents' on the menu in this
help window. You will then get a list of help contents to guide you further. Alternatively, you can
press the 'Index' button below for an index.
:p.:hp2.Using ICM:ehp2.
:p.This handler also provides :link reftype=hd res=40.ICC/ICM colour management:elink.. The colour management is
used when printing and scanning to provide improved colour matching. It is ignored when printing spot colour separations
as these are output as a default colour. The four normal separations, CMYK, are also subject to colour management, and so
should provide the same benefits as full colour printing.
:p.:hp2.Understanding CMYK:ehp2.
:p.CMYK stands for Cyan, Magenta, Yellow, and blacK. These are the four colours of ink used in traditional four colour
printing. Most inkjet printers today use these four basic inks, although a second set of lighter inks are sometimes used
to produce the lighter shades.
:p.Unlike colours on the screen, where the background is black, the basic background of a page is white. All the printer
colours are the inverse of the screen colours. The translation between them is simple. Given that each colour has a range
of 0 to 255&colon.-
:ul.
:li.Cyan = 255 - Red
:li.Magenta =  255 - Green
:li.Yellow = 255 - Blue
:lp....or seen the other way round
:li.Red = 255 - Cyan
:li.Green = 255 - Magenta
:li.Blue = 255 - Yellow
:eul.
:p.Notice as well that if cyan, magenta, and yellow are set to zero, the page remains :hp1.white:ehp1..
:p.When mixing ink on the pages, as blue = -yellow, so blue can be made of cyan + magenta. The mixing effect works
perfectly&colon.-
:ul.
:li.Red (-cyan) = yellow + magenta
:li.Green (-magenta) = cyan + yellow
:li.Blue (-yellow) = cyan + magenta
:eul.
:p.The colour black is used to replace the three colours cyan + magenta + yellow wherever possible. Again, the process
is quite simple in principle. Black must equal the minimum of the three other colours. Once we know what the black level
is, we subtract it from the other colours to prevent our printer page from turning into a soggy mess.
:fig.
cyan = 30, magenta = 50, yellow = 20
therefore black = 20
 ...and after subtraction...
cyan = 10, magenta = 30, yellow = 0, black = 20
:efig.
:p.Notice that in this scheme, at least one of the colours will always be reset to zero.
:p.:hp2.Spot Colours:ehp2.
:p.Occasionally, some professional printing jobs require the use of spot colours. A spot colour is a particular ink,
often used on it's own, to produce special effects. One of the oldest uses of spot colour is the addition of gold
leaf, or gold ink, over a normal image.
:p.This handler provides some support for the extraction of spot colours, these are only used during separations, and
are always output as a CMYK colour in their own layer. Maul does not support shading with spot colours at this time.
When colour separation is disabled, the spot colour is output as a normal CMYK colour.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 2000, 2001 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.******************************************************************************
.*  Options dialog
.******************************************************************************
:h1 res=10 id=10 global.Colour print options dialog
:i1 id=options.Colour separation options dialog
:p.When this handler is installed, a new option called 'Colour print options...' is provided in the main 'Options'
menu.
:p.:hp2.Colour channel gain:ehp2.
:p.Use the settings to reduce the intensities of the basic printer colours. These settings take effect before the
black (K) colour is calculated. The settings have an effect only when printing, and work even when colour separation is
turned off.
:p.As you reduce the gain of each colour channel, so the page gets lighter and lighter. This is because the controls
resemble printer ink levels, rather than light levels on a screen. Reducing the colour gain also results in a reduction
of the range of colours available. Where possible, try to alter the printer driver properties instead.
:p.You cannot increase the colour channel gain beyond 100%, and you cannot decrease the gain below 50%. With colour
separation turned on, and no icc profile, once all the gains have been calculated, the black (k) output is compensated
back to 100% in order to ensure that the final printout does not get 'washed out'. As OS/2 uses RGB internally, the
data representation resulting from a colour separation will still be in RGB.
:p.:hp2.ICM Profiles in colour separations:ehp2.
:p.By selecting an icc/icm cmyk colour profile, you can perform colour separations based on paper types. This is a
sophisticated method of separating colours which disables the simple 'ideal world' method of k thresholds. Suitable
CMYK colour profiles for various paper types can be found on the internet.
:p.:hp2.K thresholds:ehp2.
:p.If you choose to use a mix of Cyan, Magenta, and Yellow to create shades of gray, you can alter the threshold at
which the black ink is used. Using three colours to create lighter shades of gray may produce more pleasing results.
:p.The primary controlling factor is 'min k'. Every gray shade lighter than 'min k' will be made up of a CMY mix.
:p.If the gray shade is darker than 'pure k', no further mixing of CMY will be used to create that shade.
:p.Gray shades between 'min k' and 'pure k' will be a mix of all four colours. This is a way of blending black ink with
the other inks to produce a more balanced tonal range.
:p.:hp2.Mathematically:ehp2., the colour processing looks like this&colon.-
:sl.
:li.Apply colour channel gain values to the three colours c, m, and y. If any of the gain values are less than 100%, you
can never reach 100% colour saturation.
:li.Set k (black ink) to equal the minimum of the other three colours.
:li.If k is less than 'min k', reduce k to zero.
:li.If k is greater than, or equal to, 'min k', and less than 'pure k', subtract 'min k' from k.
:li.If k is greater than, or equal to, 'pure k', k is unaffected.
:li.After the k value has been determined, subtract k from all the other colours.
:li.Compensate k for alterations in colour channel gain to bring it's maximum level back to 100%. Notice that you will
nevertheless loose some shades of grey in the process.
:esl.
:lm margin=1.
:p.If you set both 'pure k' and 'min k' values to 255, no black separation is produced, i.e. you only get a three
colour separation. Note that 'pure k' must always be greater than, or equal to, 'min k'.
:p.:hp2.Other options:ehp2.
:p.Select 'Save as default settings' to save the current gain and k threshold settings.
:p.Select 'Enable CMYK separation' on a file by file basis to decide to seperate publications into their component
colours. This option cannot be saved as a default setting.
.br
.br
.br
.******************************************************************************
.*  Select dialog
.******************************************************************************
:h1 res=20 id=20 global.Colour separation dialog
:i1 id=select.Colour separation dialog
:p.If colour separation is enabled in the :link reftype=hd res=10.Colour print options dialog:elink.,
you will get this dialog every time you print your publication.
:p.Use the radiobuttons provided to select the separation you require. As each colour separation is printed, the default
option will advance to the next radiobutton. The process will pause for each separation, giving you the chance to
determine which separation to print.
:p.If you press 'Cancel' at any phase of the separation, the print process will end. You will not erase any separations
created before this point, however.
:p.After the first print run, the dialog will be updated to show all the spot colours found during the first separation.
You must print at least one normal separation before you can print a spot colour separation.
:p.The dialog gives you another chance to set the colour print options. Note that if you turn off Colour separation
in the options dialog and press 'Ok', a full colour printout will proceed immediately.
.br
.br
.******************************************************************************
.*  System colour dialog
.******************************************************************************
:h1 res=11 id=11 global.System screen colours dialog
:i1 id=sysclr.System screen colours dialog
:p.Use the System screen colours dialog to change the colour of the page to the colour of the
paper you are printing on. Of course, this can make it difficult to see where the grid
markings and so on are placed, so you can change these too.
:p.The changes you make here are saved in the file, and subsequently this
publication will always open with these colours.
:p.If you check the 'Save as default' checkbox, the colours are also saved in the system
profile, and subsequently all publications will open with these colours.
:p.As you can quickly get fed up with strange colour shemes, the 'Reset all colours' checkbox
is provided to restore a little sanity.
:p.Click 'Ok' to make changes and exit the dialog, and 'Cancel' to abandon the dialog.
.br
.br
.******************************************************************************
.*  International Color Consortium (ICC/ICM) Profiles
.******************************************************************************
:h1 res=40 id=40 global.International Color Consortium (ICC/ICM) Profiles
:i1 id=icmclr.International Color Consortium (ICC/ICM) Profiles
:p.Maul Publisher can use ICM or ICC profiles thanks to some very clever software
called 'icclib', by Graeme W. Gill.
:p.The ICC profile I/O library archive is kept at <http&colon.//www.argyllcms.com/>
.********** Do not translate **********
:xmp.
Copyright (c) 1997-2002 Graeme W. Gill

Permission is hereby granted, to use, copy, modify, distribute,
and sell this software and its associated documentation files
(the "Software") for any purpose without fee, provided
that:

    1) The above copyright notices and this permission notice
       accompany all source code copies of the Software and
       related documentation.
and

    2) If executable code based on the Software only is distributed,
       then the accompanying documentation must acknowledge that
       "this software is based in part on the work of Graeme W. Gill".
and

    3) It is accepted that Graeme W. Gill (the "Author") accepts
       NO LIABILITY for damages of any kind.  The Software is
       provided without fee by the Author "AS-IS" and without
       warranty of any kind, express, implied or otherwise,
       including without limitation, any warranty of merchantability
       or fitness for a particular purpose.
and

    4) These conditions apply to any software derived from or based
       on the Software, not just to the unmodified library.
:exmp.
.********** End - Do not translate **********
:p.:hp2.How ICC/ICM is implemented here:ehp2.
:p.In an ideal world, this is what colour management should look like...
:p.:artwork name='IdealICM.bmp' align=left.
:p.The PCS, or 'profile connection space' is a universal, well defined colour space, and colours
are transformed via this colour space as required.
:p.To really get this right, colour management has to be built into the operating system API.
Using the method shown below will provide accurate colour management for everything except
the colour monitor. Luckily, modern monitors are very good and often contain the necessary tools
to get quite close to the required colour match.
:p.Here is what colour management looks like for Maul Publisher on OS/2 or eCS...
:p.:artwork name='Maulos2ICM.bmp' align=left.
:p.Colours are converted and stored as sRGB, that is, 24bit colours. These 24bit colours are not
converted for display on the monitor. When scanning or printing, the colours are converted from
sRGB to the currently selected profile. You can change the file colour profile to be anything you like,
but if it is not sRGB, expect poor results. There are a number of SRGB profiles available for different
rendering intents, so provision is made to select a different profile for the file data.
:p.When converting from sRGB to sRGB, the transformation effect will depend on the selected rendering
intents. If these are the same, the transformation occurs anyway, but will have no effect.
:p.Maul will select the correct profile using information stored in its initialisation file, and
the profiles used can be edited using the
:link reftype=hd res=41.colour profile selection dialog:elink.
.br
.br
:h2 res=41 id=41 global.(ICC/ICM) Colour Profile Dialog
:i2 refid=icmclr.(ICC/ICM) Colour Profile Dialog
:p.Use this dialog to select colour profiles for the devices recognized by Maul Publisher. You can change
all the colour profiles except for the filedata profile. This profile should be set to sRGB, which corresponds
nicely to the OS2RGB format used throughout the OS/2 graphics API.
:p.:hp2.First, select the device:ehp2.
:p.When you select a device from the dropdown list, the current colour profile and intent are shown for
this device.
:p.:hp2.Then, select the colour profile:ehp2.
:p.Colour profiles are kept as *.icm or *.icc files in Maul Publishers .\etc path, or as set in config.sys, e.g.
"SET ICC_PROFILES=C&colon.\ICC". These colour profiles can be found on the installation CD for your device, or
on the support website of the manufacturer. If you have the same device installed on a Windows computer, you
can search for the colour profile there.
:p.:hp2.Last, select the rendering intent:ehp2.
:p.Not all profiles contain every kind of rendering intent. Although you can select any intent, you might just
end up with a default anyway.
:p.:hp2.See Also:ehp2.
:link reftype=hd res=40.International Color Consortium (ICC/ICM) Profiles:elink.
.br
.br
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=30 id=30 global.Help with keyboard keys
:i1 id=keys.Help with keyboard keys
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Colour separation handler key usage:ehp2.
:p.There are no keyboard shortcuts available for this handler.
.br
.br
:euserdoc.
