.******************************************************************************
.*  Maul Publisher Index Import Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Index Import Help
:docprof toc=1234.
:h1 res=1 id=1.About the Index Import Handler
:i1 id=all.About the Index Import Handler
:p.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Index Import Handler V1.00:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Index Import Handler:ehp2.
:p.This handler is used to create an index for your publication. Creating an index is a complex and time consuming
process. This indexing tool can help you save a lot of time and effort. However, bear in mind that creating a really
good index requires a lot of manual work that no machine can replace.
:p.This indexing tool is used to find text in the publication that matches the data in the index you have provided,
and to add the page number to that index.
Unlike a contents list, an index is created by using an :link reftype=hd res=10.index creation file:elink.,
and :link reftype=hd res=20.importing:elink. this file into an empty text frame.
:p.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p.1999 to 2002 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
:h1 res=20 id=20 global.Import Index creation files
:i1 id=index.Import Index creation files
:p.The :link reftype=hd res=10.index creation file:elink. is a plain ascii text file that contains indexing
information. You can have as many of these files as you like, and you can create them using any plain text editor, such
as 'E' the System Editor, for example.
:p.To import an index, create a an empty text frame and import the index creation file. This will create an index. You
will probably have to edit this index once the import is finished.
:p.If the indexing process is taking too long, or you wish to abort it for any reason, press the <Esc> key on your
keyboard. The process will terminate immediately.
.br
.br
:h1 res=10 id=10 global.Index creation file syntax
:i1 id=import.Index creation file syntax
:p.:hp2.Overview:ehp2.
:p.The index creation file is a plain ascii text file that contains indexing information. You can have as many of these
files as you like, and you can create them using any plain text editor, such as 'E' the System Editor, for example.
:p.To import an index, create an empty text frame and import the index creation file. This will create an index of the
entire publication. Once the import is finished, you will probably want to edit the index in order to tidy it up a little.
:p.If the indexing process is taking too long, or you wish to abort it for any reason, press the <Esc> key on your
keyboard. The process will terminate immediately.
:p.:hp2.Comments:ehp2.
:p.The index creation file can, and should, contain a comment, or any number of comments, explaining what the file 
does. Comments are created using the common 'C' and 'C++' commenting methods. An example of both methods is shown below.
:xmp.
/*
This is a C like comment. Notice that the comment 
starts with a slash-star, and ends with a star-slash.
Such comments must NEVER be nested.
*/

/************** Valid comment *******************/

/* Bad comment... not valid /*

//This is a C++ style comment, the comment continues
//to the end of the line.

/*  //You can put C++ style comments inside C style
    //comments  */
:exmp.
:p.:hp2.Index entries:ehp2.
:p.An index entry consists of the text as it would appear in the index, followed by a string expression that describes
the text to search for in the file. At it's simplest, the index entry looks like this&colon.-
:xmp.
Entry;
:exmp.
:p.This is known as an implicit entry because the index text and the word searched for are the same.
It is the equivalent of typing&colon.-
:xmp.
Entry = entry;
:exmp.
:p.This slightly modified entry has the advantage that the index entry text and the word searched for need no longer be
the same. For example, an entry like this is quite acceptable&colon.-
:xmp.
Entry = entrances;
:exmp.
:p.The actual syntax is this&colon.-
.br
:hp2.<index>[=<expression>];:ehp2.
.br
Note that items in square brackets are optional, and items in arrow brackets are replaced by something else.
:p.Notice that whitespace is ignored. Notice as well that all entries must be terminated with a semicolon. The index entry
can be spread over as many lines as you like, as long as you end the entry with a ;. 
:p.This basic syntax can be considerably expanded....
:p.:hp2.Quoted Strings:ehp2.
:p.Where an <index>, or an <expression>, contains whitespace, you can enclose the text in double quotes.
:xmp.
"This index entry" = "look for this string";
:exmp.
:p.If the quoted string contains a double quote, you can enter it by preceeding it with a backslash.
:xmp.
"This index entry" = "look for \"pair of quotes\"";
:exmp.
:p.If the quoted string is longer than will fit on a line, you can use a backslash as a line continuation.
:xmp.
"This index entry" = "has a line \
continuation";
:exmp.
:p.The backslash character can also be used to add a newline '\n', or itself, '\\', or any number of ascii codes&colon.-
:table cols='25 20 30' rules=both frame=box.
:row.
:c.\b = (backspace):c.\" = ("quotes"):c.\<number> = (decimal number)
:row.
:c.\f = (newpage):c.\' = ('quotes'):c.\0<number> = (octal number)
:row.
:c.\n = (newline):c.\0 = (null):c.\0x<number> = (hex number)
:row.
:c.\r = (CarrRet):c.\\ = (\):c.\<white> = line break
:row.
:c.\t = (tab):c.\v = (vert tab)
:etable.
:p.:hp2.Expressions:ehp2.
:p.The <expression> part of an index entry allows boolean searching of your publication.
Two kinds of comparisons are made. The first is a comma. A list of strings separated by comma act as an OR function.
Any one of the strings will do to add an index page number.
:xmp.
/* Look for 'index' OR 'entry'*/
"This index entry" = index, entry;
:exmp.
:p.The second comparison type is a plus sign.
:xmp.
/* Look for 'index' AND 'entry'*/
"This index entry" = index + entry;
:exmp.
:p.You can invert the operation of an expression.
:xmp.
/* Look for 'index' AND NOT 'entry'*/
"This index entry" = index + !(entry);

//notice the use of brackets
:exmp.
:p.:hp2.Evaluation order of expressions:ehp2.
:p.Expressions are evaluated from left to right. You can change the evaluation order by using brackets&colon.-
:xmp.
"Life and times of Albert Einstein" =
(life, times) + "Albert Einstein";
:exmp.
:p.Here we are looking for frames mentioning 'Albert Einstein' that also talk of 'life' or 'times'
:p.:hp2.A complex index entry:ehp2.
:p.The following example show how a complex index entry might be constructed. Notice the use of brackets to determine
the correct interpretation&colon.-
:xmp.
"Life and times of Albert Einstein (but not James Bond)" =
!"James Bond" + ((life, times) + "Albert Einstein");
:exmp.
:p.:hp2.Input, and Results:ehp2.
:p.Given the following index creation file...
:xmp.

Aston = cars;

"Life and times of Albert Einstein" = (life, times) + "Albert Einstein";

"Sentences beginning with 'the, at, or, and'" = the, at, or, and;

"The theatre" = theatre;

:exmp.
:p....the result would look something like this&colon.
:fig.
Aston
Life and times of Albert Einstein
Sentences containing 'the, at, or, and', 1, 2
The theatre
:efig.
:p.Notice that no page numbers were found for 'Aston', 'Life and times of Albert Einstein', or 'The theatre'. These
entries have been added to the index, but they do not have an appropriate page as they do not exist in the indexed file.
Page numbers were added for 'Sentences containing... ' as one or more of the requested words were found.
:p.Notice also that the entries are not alphabetically sorted, but read as they come out of the index creation file.
.br
.br
.br
:euserdoc.
