.******************************************************************************
.*  Maul Publisher Background Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Background Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Background Handler
:i1 id=all.About Maul Background Handler
:p.:artwork name='bgndhand.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Default Background Handler V1.20:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Background Handler:ehp2.
:p.The background handler is used to create coloured backgrounds. Coloured backgrounds can be
made up of a pattern of two colours, of which the background colour can be transparent.
:p.This version provides multi colour shading modes in addition to the basic fill style. Where
it makes sense, the shading angle can be changed.
:p.The circle fill mode is centred around the object centre, giving the means to alter the
shading origin by moving the object centre. This can create nice 3d effects.
:p.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998, 2001 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=8 id=8 global.The Background handler edit menu
:i1 id=edit.The Background handler edit menu
:p.The background handler edit menu contains the basic edit menu items one would expect to find in any editor,
plus a few specific ones for Maul.
:p.These include&colon.-
:ul.
:li.How to :link reftype=hd res=10.cut:elink. the background.
:li.How to :link reftype=hd res=11.copy:elink. the background.
:li.How to :link reftype=hd res=12.paste:elink. in a background.
:li.How to :link reftype=hd res=13.clear:elink. the background and remove the handler.
:li.How to set a background :link reftype=hd res=54.style:elink..
:li.How to set the background :link reftype=hd res=30.colour:elink..
:li.How to set the :link reftype=hd res=34.advanced:elink. colour options.
:li.How to set the background :link reftype=hd res=31.pattern:elink. mix.
:li.How to set the background :link reftype=hd res=33.orientation:elink..
:li.How to :link reftype=hd res=35.offset:elink. the background in relation to the frame.
:li.How to make :link reftype=hd res=26.holes:elink. in the background.
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=10 id=10 global.Cut background to clipboard
:i2 refid=edit.Cut background to clipboard
:p.Select this menu item to copy the background to the clipboard. The background is then destroyed.
:p.The cut command can be executed by using the Shift + Delete keys.
.*******************************************************************************
:h2 res=11 id=11 global.Copy background to clipboard
:i2 refid=edit.Copy background to clipboard
:p.Select this menu item to copy the background to the clipboard. The background is not destroyed.
:p.The copy command can be executed by using the Control + Insert keys.
.*******************************************************************************
:h2 res=12 id=12 global.Paste background from clipboard
:i2 refid=edit.Paste background from clipboard
:p.Select this menu item to paste a background from the clipboard into the frame.
Any existing background is deleted.
:p.The paste command can be executed by using the Shift + Insert keys.
.*******************************************************************************
:h2 res=13 id=13 global.Clear background
:i2 refid=edit.Clear background
:p.Select this menu item to delete the background and remove the background handler
from the frame. Once you have done this you can add a different handler to the frame in place
of the background handler.
:p.The clear command can be executed by using the Delete key.
.*******************************************************************************
:h2 res=54 id=54 global.Set a background style
:i2 refid=edit.Set a background style
:p.Once you have saved a background style, you can use it again and again to recreate a
particular colour or shade throughout your publication.
:p.Use the 'Edit background style...' menu item to access the common stylesheet dialog. This
dialog provides the tools necessary to set and delete styles, and to set a default background style
that is used for every new background that you create.
:p.If you select the small button to the right of the 'Set background style' menu item, the available background
styles are listed. If you select one of the listed styles, that style
becomes the default for the 'Set background style' menu item.
.br
.br
.*******************************************************************************
:h2 res=30 id=30 global.Set background colour
:i2 refid=edit.Set background colour
:p.You will get the colour setting dialog if you create a plain fill style. If you create a shaded fill style, you will
get the :link reftype=hd res=32.Shading colours dialog:elink. instead.
:p.Use this dialog to select a background colour. Both the foreground and background colours are used.
The actual colour will be a mixture determined by the pattern settings. If the current colour
handler supports it, you can set the background colour to transparent. See the
:link reftype=hd res=31.pattern:elink. settings for more information on mixing colours.
:p.This is a dialog within the current colour handler. See the help information
provided with the colour handler to obtain information on how to use this dialog.
.*******************************************************************************
:h2 res=34 id=34 global.Advanced colour options
:i2 refid=edit.Advanced colour options
:artwork name='advanced.bmp' align=left.
.br
:p.:hp2.Shading fill modes:ehp2.
:p.Shading fill modes have a number of parameters that can be modified from the default.
Use this dialog to edit and apply changes to the manner in which shading is performed.
:p.This handler currently only supports shading by crossfading. Crossfading involves fading
one colour out to white, and the next colour in from white.
:p.The crossfade and its parameters are most readily explained with a diagram&colon.-
:artwork name='addiag.bmp' align=left.
.br
:p.:hp2.Run in and run out:ehp2.
:p.The 'run-in' and 'run-out' sliders adjust the size of the run in and run out parts shown
on the diagram. If the sliders aren't accurate enough, you can directly enter the required
percentage values into the edit fields.
:p.As you increase the run in, so the crossfade tends towards blackness. As you increase the
run out, the crossfade tends towards whiteness. If you increase both run in and run out, the
crossface itself occurs over a shorter area. At 100% run in and 100% run out, there remains
no room for the crossfade, and the colours switch directly from one to the next.
:p.:hp2.Normalised brightness:ehp2.
:p.When two colours are mixed, the resultant brightness, or luminance, can change
dramatically. By selecting the 'Normalised brightness' checkbox, the crossfade will correct
and average out this change in brightness. For some colours, the effect is not apparent, for
some, it totally changes the look of the crossfade. The effect is particularly noticable when
mixing between primary colours, such as red and green.
.*******************************************************************************
:h2 res=31 id=31 global.Set background pattern
:i2 refid=edit.Set background pattern
:p.Use this dialog to select a background mix pattern. If the mix pattern is set to solid, the default,
only the foreground colours are used. If you select one of the other mix patterns, the background
colour is painted first, followed by a pattern in the foreground colours.
:p.If the background colour is set to transparent, only the foreground pattern is painted. This is one way
in which you can tint an underlying picture or text frame.
.******************************************************************************
:h2 res=33 id=33 global.Background fill orientation
:i2 refid=edit.Background fill orientation
:p.Background fill orientation is made up of the sum of frame orientation and fill orientation.
By default the fill orientation is +0.
:p.Normally, if the frame is orientated to zero, the fill is orientated to 0, which
results in a vertical fill.
:p.If you rotate the frame, the fill will also rotate. The actual fill angle is shown
as a status string within the rotate dialog. You can use the spin button or enter the
required angle to change the :hp1.relative:ehp1. orientation between fill and frame.
:p.Click on 'Apply' to apply the new fill angle, and 'Exit' to exit the dialog when you are finished.
.*******************************************************************************
:h2 res=35 id=35 global.Offset the background
:i2 refid=edit.Offset the background
:p.Offsetting the background is a very useful way to generate a shadow for a frame. The
technique is very commonly used to make particular objects on the page stand out.
:p.:hp2.Offset distance:ehp2.
:p.Enter the distance the background should be offset by.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the
size without a measurement type, the value is considered to be in printer
pels.
:p.:hp2.Offset angle:ehp2.
:p.The actual background offset angle is made up of the sum of frame orientation and the
offset angle specified in this dialog. As you rotate the frame, so the offset rotates with it.
This ensures that the overall look of the object is maintained.
:p.You may either use the rotary control, or directly enter the required angle in the offset
angle entry field.
:p.To help you visualise the result, the actual combined angle is also shown.
:p.:hp2.Tip:ehp2.
:p.To make a text frame with a background drop shadow, you need to place a plain white
background beneath the text, and then place another background beneath that.
:artwork name='offset.bmp' align=left.
.*******************************************************************************
:h2 res=26 id=26 global.Background with cutouts
:i2 refid=edit.Background with cutouts
:p.By enabling this menu item, you can cause frames lying on top of the current frame to cut holes
into the background. To see a nice effect, try placing a 'hole' on top of another 'hole'.
:p.You will not need to use this mode often, but it is a quick way to achieve a cutout in a background.
.br
.br
.******************************************************************************
.*  Mode Menu
.******************************************************************************
:h1 res=20 id=20 global.Background handler fill modes
:i1 id=fill.Background handler fill modes
:p.The background handler supports a number of fill modes to provide shading effects as well as a simple
colour fill.
:p.The fill modes include&colon.-
:ul.
:li.:link reftype=hd res=21.Plain:elink. fill mode.
:li.:link reftype=hd res=22.Flat:elink. fill mode.
:li.:link reftype=hd res=23.Arc:elink. fill mode.
:li.:link reftype=hd res=24.Circle:elink. fill mode.
:li.:link reftype=hd res=25.Rectangle:elink. fill mode.
:li.:link reftype=hd res=27.Figure:elink. fill mode.
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=21 id=21 global.Plain fill mode.
:i2 refid=fill.Plain fill mode.
:p.:artwork name='backplain.bmp' runin.This mode fills the frame with a single colour.
:p.All fill modes support :link reftype=hd res=31.patterns:elink. with a pattern background colour.
.*******************************************************************************
:h2 res=22 id=22 global.Flat fill mode.
:i2 refid=fill.Flat fill mode.
:p.:artwork name='backcol2.bmp' runin.This mode fills the frame with a shade between two or more colours. The colours are drawn as flat stripes
across the frame.
The :link reftype=hd res=33.orientation:elink. can be changed as required.
:p.As with most shading fills, if you have a angled shading fill clipped to text, the repaint will be :hp2.very slow:ehp2. indeed.
:p.All fill modes support :link reftype=hd res=31.patterns:elink. with a pattern background colour.
.*******************************************************************************
:h2 res=23 id=23 global.Arc fill mode.
:i2 refid=fill.Arc fill mode.
:p.
:p.:artwork name='backcol.bmp' runin.This mode fills the frame with a shade between two or more colours. The colours are drawn as arcs of increasing
diameter across the frame.
The :link reftype=hd res=33.orientation:elink. can be changed as required.
:p.As with most shading fills, if you have a angled shading fill clipped to text, the repaint will be :hp2.very slow:ehp2. indeed.
:p.All fill modes support :link reftype=hd res=31.patterns:elink. with a pattern background colour.
.*******************************************************************************
:h2 res=24 id=24 global.Circle fill mode.
:i2 refid=fill.Circle fill mode.
:p.:artwork name='backcol1.bmp' runin.This mode fills the frame with a shade between two or more colours. The colours are drawn as increasing circles
starting from the centre of the frame.
:p.As with most shading fills, if you have a shading fill clipped to text, the repaint will be :hp2.very slow:ehp2. indeed.
:p.All fill modes support :link reftype=hd res=31.patterns:elink. with a pattern background colour.
.*******************************************************************************
:h2 res=25 id=25 global.Rectangle fill mode.
:i2 refid=fill.Rectangle fill mode.
:p.:artwork name='backcol3.bmp' runin.This mode fills the frame with a shade between two or more colours. The colours are drawn as increasing rectangles
starting from the centre of the frame.
:p.As with most shading fills, if you have a shading fill clipped to text, the repaint will be :hp2.very slow:ehp2. indeed.
:p.All fill modes support :link reftype=hd res=31.patterns:elink. with a pattern background colour.
.*******************************************************************************
:h2 res=27 id=27 global.Figure fill mode.
:i2 refid=fill.Figure fill mode.
:p.:artwork name='backcol4.bmp' runin.This mode fills the frame with a shade between two or more colours. The colours are drawn as increasing polygons
starting from the centre of the frame. The shape of the frame determines the shape of the fill.
:p.As with most shading fills, if you have a shading fill clipped to text, the repaint will be :hp2.very slow:ehp2. indeed.
:p.All fill modes support :link reftype=hd res=31.patterns:elink. with a pattern background colour.
.******************************************************************************
.*  Shading colours
.******************************************************************************
:h1 res=32 id=32 global.Shading Colours Dialog
:i1 id=shadingdlg.Shading Colours Dialog
:p.Create a list of shading colours for shaded fills.
:artwork name='shadedlg.bmp' align=left.
:p.When you first open the dialog, you will find two colours defined. Unless you have already altered the colour of the
fill, both colours will normally be white.
:p.Select one of the colours in the listbox, and you can edit the colour, move the colour up or down the list, or delete
the colour if you have more than two. Shading colour styles need at least two colours defined, although both colours can
be the same. Pressing the add button will add another colour item. The colour of the new colour item is taken from the
currently selected colour.
:p.Use a left mouse click on the colour wheel or colour list to alter the foreground colour. All the methods used by the
default colour dialog can be used here, this includes clicking on the lower right hand swatch control to get a more precise
colour control. You can also select a colour from the colour table, if loaded.
:p.You can change the background colour of your fill at any time by editing the background colour. Use a right mouse
click on the colour wheel or colour list to alter the colour. The background colour is independant of the colour items.
:p.See the :link reftype=hd res=34.advanced:elink. settings for more information on normalised colour mixing.
:p.Press 'Apply' to apply the new list of colours, and 'Exit' to exit the dialog when you are finished.
.br
.br

.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=40 id=40 global.Help with keyboard keys
:i1 id=keys.Help with keyboard keys
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Background handler key usage:ehp2.
:ol.
:li.:hp2.Edit menu:ehp2.
:dl compact tsize=16.
:dt.Shift+Delete:dd.Cut background
:dt.Ctrl+Insert:dd.Copy background
:dt.Shift+Insert:dd.Paste background
:dt.Delete:dd.Clear background / Remove handler
:dt.Ctrl+Shift+C:dd.Background colour
:dt.Ctrl+Shift+T:dd.Background pattern
:dt.Ctrl+Shift+O:dd.Background orientation
:edl.
:eol.
:euserdoc.
