.******************************************************************************
.*  Maul Publisher Text Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul-Hilfe zum Text-Handler
:docprof toc=1234.
:h1 res=1 id=intro.ber den Maul Text-Handler
:i1 id=all.ber den Maul Text-Handler
:p.:artwork name='texthand.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Text-Handler:ehp2.
:p.:artwork name='wingstmp.bmp' align=left runin.
:hp2.Simstext:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.bersicht zum Maul Text-Handler und Simstext:ehp2.
:p.Benutzen Sie diese Handler, um Text in Rahmen einzufgen.
:p.Beide Handler verwenden ein Format namens FFTXT. Dieses Format untersttzt die volle
Bandbreite der Textmanipulationsfunktionen der Warp-eigenen Grafikroutinen.
:p.:hp2.Text-Handler:ehp2.
:p.Bei Verwendung von Mauls eigener Grafik-Engine kann Text um beliebige Winkel gedreht werden und
beliebige Rahmenformen umflieen, wobei berlappende Rahmen ausgelassen werden, es sei denn, sie
wren als transparent markiert. Dazu untersttzt dieser Handler eine groe Anzahl weiterer
ausgefeilter Features.
:p.Untersttzt werden Import und Export sowie Stilvorlagen, Titelextraktion, automatische Seitennumerierung,
das Versehen mit Datum und Zeit und Sprachen.
:p.Diese Version untersttzt DBCS-Zeichenstze.
:p.:hp2.Simstext:ehp2.
:p.Dieser Handler dient dem Plazieren von FFTXT-Text auf Umrandungen. Da er auf dem FFTXT-Format aufbaut,
werden beinahe smtliche Funktionen des normalen Texthandlers untersttzt. Mit Hilfe des Handlers
kann Text entlang der Umrandung wiederholt werden, daher der Teil 'Sims' seines Namens.
:p.Da die Datentypen kompatibel sind, sind Ausschneide- und Einfgen-Operationen zwischen diesem und dem
Text-Handler mglich. Auch die Funktionen zum Importieren und Exportieren, fr Stilvorlagen, Seitennumerierung,
Datumsstempel usw. werden untersttzt.
:p.:hp2.Weitere Hilfe:ehp2.
:p.Weitere Hilfe erhalten Sie durch Auswahl von 'Optionen' und 'Inhalt' aus dem Men dieses Hilfefensters. 
Es wird dann eine Auswahl weiterfhrender Hilfethemen angezeigt. Alternativ knnen Sie die Schaltflche 
'Index' bettigen, um das Register anzeigen zu lassen. 
:p.
.br
.br
:p.Erstellt von Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998 bis 2004 Peter Koller, Maison Anglais. Alle Rechte vorbehalten. 
:p.Details der Lizenzbestimmungen entnehmen Sie bitte dem Urheberrechtshinweis im Haupthandbuch  
des Maul Publishers. 
.br
.******************************************************************************
:h1 res=2 id=2 global.bersicht Bearbeiten von Text
:i1 id=using.bersicht Bearbeiten von Text
:p.Der Text-Handler arbeitet so, da einfacher Text verwendet wird, innerhalb dessen sich LOLs genannte
Datenblcke befinden. Ein LOL ist eine Datenstruktur, die mit 0 und einem Grenanzeiger beginnt und
endet, so da das LOL beim Bewegen in der Datei vorwrts wie rckwrts bersprungen (Leapt Over) werden kann.
:p.Jedesmal, wenn man den Cursor neben einem LOL plaziert, wird der Cursor davor positioniert, nicht dahinter.
:p.Nehmen Sie die Beispielzeichenkette SCHWARZ:hp8.ROT:ehp8.. Zwischen den Wrtern SCHWARZ und
:hp8.ROT:ehp8. befindet sich ein LOL mit einer roten Farbeinstellung.
:p.Plaziert man nun den Cursor vor dem Wort :hp8.ROT:ehp8. und beginnt mit der Eingabe, so
ist die Farbe schwarz, weil man sich vor dem LOL befindet.
:p.Hebt man das Wort :hp8.ROT:ehp8. durch Ziehen mit dem Cursor von links nach rechts hervor und
berschreibt es mit etwas anderem, wird der neue Text rot. Zieht man den Cursor stattdessen von
rechts nach links, befindet sich der Cursor an der Grenze schwarz/rot. Wenn man nun das Wort
:hp8.ROT:ehp8. berschreibt, wird der neue Text schwarz!
:p.:hp2.Text-Verwirrung:ehp2.
:p.LOLs knnen fr Neulinge etwas verwirrend sein. Jeder Schriftschnitt, Farbe, Bilder im Text, Abstze
usw. usw. werden durch ein LOL reprsentiert. Manche dieser LOLs, wie etwa Bilder im Text und Abstze,
verhalten sich wie sichtbare Zeichen.
:p.Unsichtbare LOLs sind am Dateiende nicht erlaubt, hat man aber einen oder mehrere LOLs fr
neue Abstze am Dateiende, knnen solche LOLs vor dem Absatz anwesend sein. Dies kann dazu fhren,
da sich die Schriftarteinstellungen beim Bewegen des Cursors auf seltsame Weise ndern, was
recht unangenehm werden kann. Suchen Sie dann den Ort auf, wo sich Ihrer Meinung nach das Dateiende
befinden sollte (nicht in einer leeren Zeile) und drcken Sie solange die Taste Entf, bis der Rechner
einen Signalton von sich gibt. Die unsichtbaren LOLs wurden entfernt.
:p.Kehren wir zur Beispielzeichenkette SCHWARZ:hp8.ROT:ehp8. zurck. Plazieren Sie den Cursor
vor dem Wort :hp8.ROT:ehp8.. Gben Sie nun etwas ein, wre die Ausgabe schwarz. Halten Sie stattdessen
die Taste 'Alt' gedrckt und drcken die rechte Pfeiltaste. Der Statusanzeiger sollte sich von
einem '&colon.' auf ein '*' ndern. Das LOL wurde gerade bersprungen. Wenn Sie nun etwas eingeben,
ist das Ergebnis rot.
:p.:hp2.LOL-Liste:ehp2.
:p.Der Text-Handler kann eine Liste der LOLs rckblickend von der aktuellen Cursor-Position anzeigen, in der
jeder LOL-Typ in der Reihenfolge des Auftretens angezeigt wird. ffnen Sie einmal den
:link reftype=hd res=56.Dialog LOL-Liste:elink., und fhren Sie obiges Experiment durch.
Das Farb-LOL wird am Anfang der Liste erscheinen, wenn Sie es passieren.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Configuration files
.*
.*
.*
.******************************************************************************
:h1 res=110 id=110 global.Konfigurationsdateien
:i1 id=config.Konfigurationsdateien
:p.Der Text-Handler besitzt eine Reihe von Konfigurationsdateien fr die Kontrolle von Sprache und
Zeichenstzen sowie zur Kontrolle der Zeichensatzkonvertierung beim Importieren.
:p.Die folgend aufgefhrten Konfigurationsdateien wirken sich sowohl auf die Rechtschreibprfung
als auch auf den Tabellen-Handler aus und sind voneinander abhngig. Daher lassen sich Sprachen verwenden,
fr die keine Rechtschreibwrterbcher vorhanden sind, sofern man nicht versucht, eine Rechtschreibprfung
durchzufhren. Das System lt sich mit Hilfe der Konfigurationsdateien den eigenen Bedrfnissen anpassen.
:p.Dazu gehren&colon.-
:ul.
:li.:link reftype=hd res=111.DATECONV.LCI-Datenformat, wird zur Festlegung von Sprachen verwendet:elink.
:li.:link reftype=hd res=112.CODEPAGE.LCI-Datenformat, wird zur Angabe von Zeichenstzen verwendet:elink.
:eul.
:lm margin=1.
.br
.br
.*******************************************************************************
:h2 res=111 id=111 global.DATECONV.LCI-Datenformat
:i2 refid=config.DATECONV.LCI-Datenformat
:p.Die Datei DATECONV.LCI wird zur Konvertierung von aus der Systemuhr gelesenen numerischen Daten in
einen Textdatumstring verwendet. Sie benutzt den aktuellen Lndercode, um Ihre Sprache festzustellen.
Darber hinaus dient diese Datei zur Festlegung der Sprache, die bei der Rechtschreibprfung und
Silbentrennung verwendet wird.
:p.Die Datei DATECONV.LCI befindet sich im Verzeichnis ..\etc. (Wie auch die meisten Stil- und Seitenvorlagen!)
:p.Zusammen mit den Systemeinstellungen bestimmt das Format des Datumsstrings, wie genau ein Datum angezeigt wird.
:p.Die Eintrge in der Datei DATECONV.LCI mssen eine bestimmte Reihenfolge einhalten, d.h. der erste
Eintrag ist die Sprachkennung und die folgenden Eintrge bestimmen den Text fr diese Sprache.
Daher ist der erste wirksame Eintrag in der Datei eine Anweisung vom Typ :hp2.lang=:ehp2.. Kommentare
werden mit :hp2.rem:ehp2. eingeleitet und knnen vor diesem Eintrag auftauchen.
:p.:hp2.lang=:ehp2. wird von den einer oder mehreren Sprachkennungen entsprechenden Zahlen gefolgt. Jeder
Lnder-ID ist auerdem ein Lnderstring in eckigen Klammern zugeordnet. Die Lnder-ID und Lnderstring
fr Deutschland lauten beispielsweise 049[de_de]. Die mit Maul V3.09 oder neuer gelieferte Datei sollte
:hp2.bereits alle Sprachen enthalten:ehp2., die vom System erkannt werden knnen.
:p.Darber hinaus mu die Zeichenkette zwischen den eckigen Klammern :hp2.vom Unicode-API erkannt werden knnen:ehp2.,
und die Lnder-ID (die Zahl) :hp2.vom ursprnglichen Steuerprogramm-API "Dos":ehp2.. Anderfalls kommt
es zu Fehlfunktionen!
:p.Es knnen mehrere Sprachkennungen angegeben werden,
solange sie durch ein Semikolon getrennt werden, z.B. wie bei :hp2.lang=001[en_us];044[en_gb]:ehp2.. 
Achten Sie darauf, da hier keine Leerzeichen auftreten. Mitunter werden in einem Land mehrere Sprachen gesprochen
oder mehrere Lnder haben den gleiche Sprachcode. In diesem Fall lt sich ein Untersprachtyp festlegen.
:p.Ein Beispiel fr eine Sprache und zwei Lnder&colon.
:xmp.
:hp2.lang=001[en_us];001.1[en_ca]:ehp2.
:exmp.
:p.Im Falle von zwei Sprachen im gleichen Land (de_ch und it_ch), werden die Eintrge nach
Sprache gruppiert. Beachten Sie, da 041.0[de_ch] denselben Wert wie 041[de_ch] hat.
:xmp.
:hp2.
rem Franais
lang=033[fr_fr];041.1[fr_ch]

rem Deutsch
lang=049[de_de];041.0[de_ch]

rem Italy
lang=039[it_it];041.2[it_ch]
:ehp2.
:exmp.
:p.Der Lnderstring dient dazu, die fr die ausgewhlte Sprache passenden
Rechtschreib- und Silbentrennungswrterbcher zu finden. Wenn man einen Blick in die Datei MYSPELL.DLS wirft, findet
man dort Eintrge wie :hp2.<dict>"US English", myspell, en_us;:ehp2.. In beiden Dateien wird der Lnderstring en_us
benutzt. Er mu bereinstimmen, damit die korrekten Wrterbcher geladen werden knnen.
:p.Auf diese Weise kann die Lnder-ID 001 mit en_us verknpft werden, was seinerseits das Laden der US-englischen
Wrterbcher ermglicht. Desweiteren werden Einstellungen fr Silbentrennung und Rechtschreibprfung ber den
Lnderstring auf Sprachbasis gespeichert, wodurch eine sehr hohe Flexibilitt bei der Erstellung von mehrsprachigen
Dokumenten erreicht wird. Das System schaltet pro Textartikel zwischen Sprachen und Zeichenstzen um.
:xmp.
lang=001[en_us];044[en_en];
:exmp.
:p.Wurde die Sprache festgelegt, knnen folgende Informationen angegeben werden. Geschieht dies nicht, so
wird das Datum von einer Unicode-Lndereinstellung abgeleitet&colon.
:p.:hp2.numtrail=:ehp2. Wird verwendet, um 1 in 1ste zu konvertieren, 2 in 2te usw. Zhlen Sie hier eine Reihe
von Zahlen gefolgt von ihrem Textanhngsel auf, ggf. mit einem Semikolon, und anschlieend eine Reihe von
Zahlen und deren Endungen. Die letzte Endung wird keiner Zahl zugeordnet und als Voreinstellung verwendet.
Beachten Sie, da hier nur Zahlen bis 31 aufgezhlt werden mssen (die Hchstanzahl Tage in einem Monat).
Wenn Sie diese Funktion nicht benutzen mchten, mu die Zeile gelscht werden. Zudem wird die Einstellung
nicht verwendet, wenn dateorder (siehe unten) nicht gesetzt ist.
:xmp.
numtrail=1,21,31,st;2,22,nd;3,33,rd;th
:exmp.
:p.Beim Deutsch bevorzugt man einen Punkt.
:xmp.
numtrail=.
:exmp.
:p.:hp2.dateorder=:ehp2. Die Reihenfolge, in der das Datum zusammengestellt wird. Die zur Verfgung stehenden
Schlsselwrter sind wkday fr den Namens des Tags, day fr den Tag des Monats, month fr den Monat und year
fr das Jahr. Lschen Sie diese Zeile, wenn die Unicode-Lndereinstellungen verwendet werden sollen.
:xmp.
dateorder=wkday;day;month;year
:exmp.
:note text='Hinweis:'.Bei allen obigen Anweisungen sind Leerzeichen nicht erlaubt. Jeder Eintrag wird durch ein
Semikolon beendet und jedes Element eines Eintrags wird vom nchsten durch ein Komma abgetrennt. Die Anweisung
:hp2.numtrail=:ehp2. sieht also folgendermaen aus:
:hp2.numtrail=:ehp2.<eintrag>:hp2.;:ehp2.<eintrag>:hp2.;:ehp2.<eintrag> wobei sich <eintrag> aus
<element:hp2.,:ehp2.element:hp2.,:ehp2.element> zusammensetzt.
.br
.br
.******************************************************************************
:h2 res=112 id=112 global.CODEPAGE.LCI-Datenformat
:i2 refid=config.CODEPAGE.LCI-Datenformat
:p.Hier knnen praktisch smtliche Zeichenstze aus dem OS/2 beiliegenden Buch 'Tastaturen und Zeichenstze'
aufgefhrt werden.
:p.Diese Datei fhrt alle whlbaren Zeichenstze auf. Zeichenstze knnen von der Benutzung ausgeschlossen
werden, indem man sie aus dieser Datei entfernt. In der Datei knnen auch Zeichenstze vorkommen, die Sie
nicht auswhlen knnen, weil sie auf Ihrem System nicht vorhanden sind. Die Datei
befindet sich im Verzeichnis .\etc. (Wie auch die meisten Stilvorlagen und Seitenvorlagen!)
:xmp.
#
#  Im Maul Publisher verfgbare Zeichenstze
#
#  Beachten Sie, da manche Zeichenstze dazu fhren knnen,
#  da die Anwendung fr einen Moment abgestrzt zu sein scheint.
#
#
850  Mehrsprachig
1252 Latin-1 Windows
1004 Windows erweitert
#
852  Latin-2 (Osteuropa)
1250 Latin-2 Windows
:exmp.
:p.Alle mit # beginnenden Zeilen werden ignoriert.
:p.Alle anderen Zeilen mssen mit einer Zahl beginnen und es drfen keine fhrenden Leerzeichen
vorhanden sein. Beim Auffhren der Zeichenstze ist keine bestimmte Reihenfolge erforderlich.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=10 id=10 global.Das Men Bearbeiten des Text-Handlers
:i1 id=edit.Das Men Bearbeiten des Text-Handlers
:p.Das Men Bearbeiten des Text-Handlers enthlt grundliegende Meneintrge, wie man sie
bei jedem Editor zu finden erwarten wrde, sowie ein paar fr Maul spezifische.
:p.Diese umfassen&colon.
:ul.
:li.Wie man Text :link reftype=hd res=18.auswhlt:elink..
:li.Wie man Text :link reftype=hd res=12.ausschneidet:elink..
:li.Wie man Text :link reftype=hd res=13.kopiert:elink..
:li.Wie man Text :link reftype=hd res=14.einfgt:elink..
:li.Wie man Text :link reftype=hd res=15.lscht:elink..
:li.Wie man :link reftype=hd res=16.Textstile:elink. festlegt.
:li.Wie man :link reftype=hd res=63.Sonderzeichen:elink. einfgt.
:li.Wie man :link reftype=hd res=23.Restrechtsbndigkeit:elink. einfgt.
:li.Wie man :link reftype=hd res=24.Bilder im Text:elink. einfgt.
:li.Wie man :link reftype=hd res=27.Rahmenanker:elink. benutzt.
:li.Wie man :link reftype=hd res=26.Funoten:elink. einfgt.
:li.Wie man :link reftype=hd res=47.Steuerzeichen:elink. einfgt.
:li.Wie man eine :link reftype=hd res=25.Steuerzeichenmischzeile:elink. einfgt.
:li.Wie man Text :link reftype=hd res=19.sucht:elink..
:li.Wie man :link reftype=hd res=20.Wrter zhlt:elink..
:li.Wie man eine :link reftype=hd res=22.Rechtschreibprfung:elink. durchfhrt.
:li.Wie man :link reftype=hd res=28.Informationen ber:elink. Textartikel festlegt.
:li.Wie man Textobjekte :link reftype=hd res=17.verbindet:elink..
:li.Wie man den Text-Handler aus einem Rahmen :link reftype=hd res=11.entfernt:elink..
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=18 id=18 global.Auswhlen von Text
:i2 refid=edit.Auswhlen von Text
:p.Zur Auswahl eines Textbereichs:
:ol compact.
:li.Plazieren Sie den Text-Cursor am Beginn oder Ende des auszuwhlenden Bereichs mit Hilfe der
Cursor-Tasten oder durch Drcken der linken Maustaste.
:li.Halten Sie die linke Maustaste gedrckt und bewegen Sie die Maus ber den gewnschten Bereich.
:eol.
:p.:hp2.ODER:ehp2.
:ol compact.
:li.Plazieren Sie den Text-Cursor am Beginn oder Ende des auszuwhlenden Bereichs mit Hilfe der
Cursor-Tasten oder durch Drcken der linken Maustaste.
:li.Bewegen Sie die Maus und plazieren Sie den Maus-Cursor am anderen Ende des auszuwhlenden Texts,
halten Sie die Umschalttaste gedrckt und drcken Sie dann die linke Maustaste. (Tip&colon. ziehen
Sie nicht mit der Maus oder der Startpunkt des hervorgehobenen Texts ndert sich.)
:eol.
:p.:hp2.ODER:ehp2.
:ol compact.
:li.Plazieren Sie den Cursor am Beginn oder Ende des auszuwhlenden Bereichs.
:li.Halten Sie die Umschalttaste gedrckt und benutzen Sie die Cursor-Tasten
(Pfeile, Pos1, Ende usw.).
:eol.
:note text='Hinweis:'.Der ausgewhlte Bereich wird hervorgehoben (in schwarzer Farbe?).
:p.:hp2.Auswahl des gesamten Rahmens:ehp2.
:p.Drcken von Strg+/ whlt alles aus.
:p.Drcken von Strg+\ nimmt die gesamte Auswahl zurck.
:note text='Hinweis:'.Durch Auswahl des gesamten Rahmens erhlt man die Mglichkeit, den Textstil
fr den gesamten Rahmen zu ndern sowie den gesamten im Rahmen befindlichen Text zu kopieren.
.br
.br
.*******************************************************************************
:h2 res=12 id=12 global.Text ausschneiden und in Zwischenablage ablegen
:i2 refid=edit.Text ausschneiden und in Zwischenablage ablegen
:p.Whlen Sie diesen Meneintrag, um den :link reftype=hd res=18.ausgewhlten:elink.
Text in die Zwischenablage zu kopieren. Anschlieend wird der Text entfernt.
:p.Der Befehl Ausschneiden kann ber die Tastenkombination Umschalt + Entfernen ausgefhrt werden.
.br
.br
.*******************************************************************************
:h2 res=13 id=13 global.Text in Zwischenablage kopieren
:i2 refid=edit.Text in Zwischenablage kopieren
:p.Whlen Sie diesen Meneintrag, um den :link reftype=hd res=18.ausgewhlten:elink.
Text in die Zwischenablage zu kopieren. Der Text wird nicht gelscht.
:p.Der Befehl Kopieren kann ber die Tastenkombination Strg + Einfgen ausgefhrt werden.
.br
.br
.*******************************************************************************
:h2 res=14 id=14 global.Text aus der Zwischenablage einfgen
:i2 refid=edit.Text aus der Zwischenablage einfgen
:p.Whlen Sie diesen Meneintrag, um Text aus der Zwischenablage an der derzeitigen Cursor-Position
in den Rahmen einzufgen. Jeglicher hervorgehobene Text wird dabei gelscht.
:p.Liegen die Daten der Zwischenablage im korrekten Format vor, so wird der Groteil des originalen
Textstils beibehalten. Genau gesagt werden Zeilenparameter wie Anschrgungen und Justierung nicht
beibehalten.
:p.Der Befehl Einfgen kann ber die Tastenkombination Umschalt + Einfgen ausgefhrt werden.
.br
.br
.*******************************************************************************
:h2 res=15 id=15 global.Text lschen
:i2 refid=edit.Text lschen
:p.Whlen Sie diesen Meneintrag, um den :link reftype=hd res=18.ausgewhlten:elink. Text
zu lschen.
:p.Der Text wird nicht in die Zwischenablage kopiert.
:p.Der Befehl Lschen kann ber die Taste Entfernen ausgefhrt werden.
.br
.br
.*******************************************************************************
:h2 res=16 id=16 global.Festlegen eines Textstils
:i2 refid=edit.Festlegen eines Textstils
:p.Benutzen Sie dieses Men, um einen Textstil zuzuweisen. Bei Auswahl der kleinen Schaltflche
zur rechten des Mens werden die verfgbaren Textstile aufgefhrt. Whlt man einen der aufgefhrten
Textstile aus, so wird dieser Textstil zum neuen Standard des Meneintrags 'Textstil festlegen'.
Stammt der Textstil aus einer lteren Version dieses Programms, stehen einige Textstile nicht
zur Verfgung.
:p.Wurde Text hervorgehoben, so wird der hervorgehobene Text gendert; andernfalls betrifft die
nderung nur die allgemeinen Texteinstellungen. Diese haben keine Auswirkung, bis neuer Text
eingefgt wird.
:p.Weitere Informationen zu Textstilen siehe Hilfeseite
:link reftype=hd res=53.Textzeichenstile sichern:elink..
.br
.br
.*******************************************************************************
:h2 res=63 id=63 global.Zeichen einfgen
:i2 refid=edit.Zeichen einfgen
:p.Mit Hilfe dieses Dialogs knnen Zeichen aus einem Listenfeld ausgewhlt werden. Dies ist sehr praktisch
in Fllen, wo Zeichen nicht einfach ber die Tastatur zur Verfgung stehen oder zur Auswahl von
Symbolen aus einer Symbolschriftart, bei der die Tastenbelegung nicht klar ist.
:p.Bei zu kleinen Zeichen gibt es zwei Mglichkeiten&colon.
:ul.
:li.Whlen Sie im Listenfenster 'Schriftgre' eine hhere Schriftgre.
:li.Zoomen Sie mit Hilfe der Zoom-Schaltflchen im Hauptfenster in das Dokument hinein.
:eul.
:p.In jedem Fall knnen in diesem Dialog Schriftart, -schnitt und -gre sowie 
das gewisse Zeichen ausgewhlt werden. Hat man das Zeichen ausgewhlt, kann 
dieses durch Drcken der Schaltflche 'Einfgen' an der derzeitigen 
Cursor-Position eingefgt werden. Zum Verlassen des Dialogs ist die 
Schaltflche 'Beenden' zu bettigen. 
.br
.br
.*******************************************************************************
:h2 res=23 id=23 global.Restrechtsbndigkeit einfgen
:i2 refid=edit.Restrechtsbndigkeit einfgen
:p.Die Restrechtsbndigkeit hnelt etwas einem Tabulator, sorgt jedoch dafr, da der restliche
Text in einer Zeile an der rechten Seite ausgerichtet wird.
:p.Die Restrechtsbndigkeit unterliegt einer Reihe von Einschrnkungen&colon.
:ul.
:li.Sie mu hinter allen normalen Tabulatoren einer Zeile auftauchen.
:li.Sie kann nur einmal pro Zeile verwendet werden.
:li.Die Zeile mu linksbndig oder im Blocksatz ausgerichtet sein.
:eul.
:p.Sind nicht smtliche obigen Bedingungen erfllt, wird die Restrechtsbndigkeit ignoriert.
:p.:hp2.Anwendungszwecke:ehp2.
:p.Mit Hilfe der Restrechtsbndigkeit knnen am Ende eines Artikels oder Absatzes End-Bullets plaziert
oder Bilder im Text an den rechten Rand gezwungen werden.
.br
.br
.*******************************************************************************
:h2 res=24 id=24 global.Bilder im Text einfgen oder bearbeiten
:i2 refid=edit.Bilder im Text einfgen oder bearbeiten
:p.Bilder im Text sind besonders in Situationen ntzlich, wenn ein Bild ein bestimmtes Verhltnis
zum Text behalten mu. Wird der Text gendert, wird das Bild im Text im Zuge des normalen
Neuformatierungsvorgangs neu positioniert.
:p.Bezglich der Gre werden Bilder im Text wie besondere Schriftzeichen behandelt. Die vertikale
Ausdehnung wird in Punkten angegeben und die horizontale daraus ermittelt.
:p.Zum Einfgen und Bearbeiten von Bildern im Text wird derselbe Dialog verwendet.
:p.:hp2.Laden von Bildern:ehp2.
:p.Es ist nicht mglich, ber ein vorhandenes Bild ein anderes zu laden. Das vorhandene Bild
mu zuerst gelscht und dann das neue eingefgt werden. Dies rhrt daher, da sich die Bilder
wie Zeichen verhalten.
:p.Whlen Sie den erforderlichen Bildtyp aus und klicken Sie auf 'Laden >>' (oder 'Einfgen',
wenn Sie aus der Zwischenablage kopieren). Legen Sie den bentigten Versatz, die Gre und
die Rnder fest und klicken Sie dann auf 'OK', um das Bild in den Text einzufgen.
:p.:hp2.Bearbeiten von Bildern:ehp2.
:p.Um ein Bild im Text zu bearbeiten, plazieren Sie den Cursor am Beginn des Bildes und
rufen den Dialog 'Bild im Text bearbeiten' auf, nehmen Sie gewnschten nderungen vor und klicken Sie 'Anwenden'.
Auf diese Art und Weise knnen Sie vorgehen, bis das Bild perfekt plaziert ist. Wenn Sie
die Arbeiten abgeschlossen haben, drcken Sie 'Beenden'.
:p.Die Grundlinie von Bildern im Text kann so versetzt werden, da sie ordnungsgem
mit dem Text ausgerichtet sind. Auerdem ist es mglich, Rnder um das Bild zu bestimmen
und damit eine Feinabstimmung der Positionierung des umgebenden Textes vorzunehmen.
Der Verlauf der Rnder richtet sich nach der derzeitigen Ausrichtung des Texts, nicht des Bildes.
Bilder werden, soweit mglich, entsprechend der Zeichenausrichtung gedreht.
:p.:hp2.Zustzliche Modi fr Bilder innerhalb von Textblcken:ehp2.
:p.Der Standardtexteinpassungmodus kann deaktiviert werden, wodurch ein Bild im Weg befindlichen
Text berlappen kann. Es ist dann immer noch mglich, den Text mit Hilfe des Dialogs Absatz- und
Zeileneinstellungen zu plazieren.
:p.Desweiteren steht der Modus 'Objekt umflieen' zur Verfgung. Hierbei wird die Grenzerkennung
angewendet, um den Text in den folgenden Zeilen korrekt formatieren zu knnen. Es ist unmglich,
Text ein Bild umflieen zu lassen, wenn unbekannt ist, wo sich das Bild befindet, weshalb
Zeilen oberhalb des Punktes, an dem das Bild eingefgt wurde, ignoriert werden. Dadurch werden diese
Zeilen unter bestimmten Umstnden berlappt. Verschieben Sie das Bild etwas nach unten, falls es
dazu kommen sollte.
:p.Ansonsten verhalten sich Bilder im Text genau wie Zeichen, sie werden mit dem Text skaliert
und gedreht und tanzen nicht aus der Reihe.
.br
.br
.*******************************************************************************
:h2 res=27 id=27 global.Rahmenanker einfgen oder bearbeiten
:i2 refid=edit.Rahmenanker einfgen oder bearbeiten
:p.:hp2.Was ist ein Anker?:ehp2.
:p.Theoretisch sind Anker nur symbolische Verbindungen zwischen Teilen des Dokuments, die nicht
miteinander in Beziehung stehen. Anker werden zum Einbetten von Rahmen in Textblcke eingesetzt. Auf sie
wird innerhalb eines Absatz-Headers verwiesen, was bedeutet, da sie nicht in Text verwendet werden
knnen, der eine Umrandung entlang luft. Auerdem bedeutet es, da nur ein Anker pro Absatz benutzt werden
kann. Anker besitzen keine eigenen Daten, sondern lassen die Daten (einen Rahmen) zeichnen, auf den sie
verweisen.
:p.:hp2.Signaturen:ehp2.
:p.Anker verwenden Signaturen. Dabei handelt es sich um numerische Kennungen, die eindeutig fr jede Struktur
innerhalb einer Datei sind.
:p.Seiten, Rahmen und Objekte enthalten alle eine Signatur, durch die sie eindeutig identifizierbar sind.
Ein bestimmter Ort in einer Datei kann schnell durch eine Suche nach seiner Signatur gefunden werden.
Die Signatur geht beim Kopieren von Daten in die Zwischenablage verloren und wird beim Einfgen in ein Dokument
durch eine neue Signatur ersetzt.
:p.:hp2.Einfger und Inhaltsanbieter:ehp2.
:p.Der Einfger ist der Textrahmen, in dem sich die Signatur eines Ankers befindet. Bei einem Inhaltsanbieter
handelt es sich um den Rahmen, auf den ein Anker verweist. Jeder Anker besitzt nur einen Einfger und einen
Inhaltsanbieter. Es knnen jedoch mehrere Anker denselben Einfger und Inhaltsanbieter besitzen. Ist der Inhaltsanbieter
Teil einer Rahmengruppe, so wird die komplette Gruppe gezeichnet, als ob es sich um eine Einheit handelte.
:p.Anker werden als einzelne Einheiten am Anfang des Dokuments gespeichert. Textabsatz-Header(siehe
:link reftype=hd res=2.LOL:elink.) enthalten eine
Signatur, ber die Anker schnell aufgefunden werden knnen. Die Anker enthalten wiederum die Signaturen
des Einfgers und des Inhaltsanbieters sowie einige Verwaltungsinformationen wie den Einfgepunkt und verschiedene
Merker. Die Signatur des Inhaltsanbieters wird im Ankerdialog angezeigt.
:p.Der Einfger (Textobjekt) findet den Anker am Dateianfang mit Hilfe seiner Signatur. Der Anker stellt
dem Textobjekt ein Verfahren zur Beschaffung von Informationen ber den Inhaltsanbieter (ein Rahmen) zur Verfgung.
Der Inhaltsanbieter (ein Rahmen) kann wiederum auf den Anker zugreifen, indem er am Dateianfang innerhalb der
Anker nach seiner eigenen Signatur sucht. Bearbeitet man die Gre und Form des Rahmens des Inhaltsanbieters, kann
der Inhaltsanbieter smtliche Textobjekte, in denen er verankert ist, als ungltig markieren.
:p.Somit stellt ein Anker eine Mglichkeit fr Text und Rahmen dar, miteinander zu kommunizieren. Wird die Form
des verankerten Rahmens (des Inhaltsanbieters) verndert, wird durch den Anker auch der Einfger neu formatiert.
Verndert sich der Textrahmen (der Einfger), so wird der Inhaltsanbieter an neuer Position dargestellt, aber es
hat keine Auswirkung auf den Inhaltsanbieter selbst.
:p.:hp2.Anker sind nicht perfekt:ehp2.
:p.Anker funktionieren nicht immer so, wie man es vielleicht erwartet.
:ul.
:li.Wird der Text gedreht, wird der verankerte Rahmen nicht gedreht.
:li.Anker knnen nicht von der Datei, in der sie enthalten sind, losgelst werden, weshalb sie nicht wie Text
kopiert und/oder eingefgt werden knnen. Im Ankerdialog ist es mglich, die Signatur eines Inhaltsanbietern zu
kopieren und einzufgen. Wenn der Dialog geschlossen wird, geht die Kopie der Signatur verloren.
:li.Anker knnen ber das untere Ende eines Textrahmens hinaus verschoben werden oder anderweitig ber die Form
des Textes hinausgehen, in den sie eingebettet sind.
:li.Der Inhaltsanbieter ist genauso sichtbar wie der Anker. Andererseits kann der Rahmen des Inhaltsanbieters auerhalb
der Seite plaziert werden.
:li.Hebt man die Gruppierung einer Rahmengruppe auf, die einen Inhaltsanbieter enthlt, zerfllt der Anker und
es wird nur der Rahmen des Inhaltsanbieters dargestellt. Erstellt man eine Gruppe mit einem Inhaltsanbieter darin,
lt der Anker die gesamte Gruppe darstellen.
:li.Die Plazierung von Ankern unterliegt gewissen Einschrnkungen. Anker knnen im Einfger-Rahmen linksbndig,
rechtbndig oder zentriert ausgerichtet werden.
:li.Bei Auswahl von 'Alle aufheben' im Ankerdialog mu dem Text eine weitere Zeile hinzugefgt werden. Damit
wird sichergestellt, da ein Absatz fr den Anker allein vorhanden ist.
:li.Reicht die verankerte Darstellung in den Text darber hinein, wird dieser berlagert. Die Grenzen eines
verankerten Objektes lassen sich erst feststellen, wenn seine Position bekannt ist, und diese hngt vom Text
oberhalb des Ankers ab. Dies gilt gleichermaen fr eingebettete Bilder.
:eul.
:p.:hp2.Anker sind ntzlich:ehp2.
:p.Manchmal sind Anker die einzige Mglichkeit, bestimmte Probleme zu lsen.
:ul.
:li.Anker sollten eingesetzt werden, wenn dieselben Rahmen mehrmals in einen Textblock eingebettet werden sollen.
Drcken Sie die Schaltflche 'Inhaltsanbieter des Ankers holen', um den ersten Anker zu kopieren und benutzen Sie
dann dieselbe Schaltflche, um den Anker wieder und wieder einzufgen - aber nur einmal pro Absatz!
:li.ndern Sie nur einen Rahmen oder eine Rahmengruppe, um alle zugeordneten Anker zu ndern (dies kann jedoch
zu einer umfangreichen Neuformatierung fhren).
:li.Der Anker wird mit derselben Gre dargestellt wie der Rahmen des Inhaltsanbieters. Auf diese Weise ist es
mglich, eine Skalierung genau zu wiederholen.
:li.Sparen Sie Speicher. Anker verbrauchen nur sehr wenig Speicher, da sie aus nur wenig mehr als einem Signaturenpaar
bestehen.
:li.Anker sind die einzige Mglichkeit, ausgelagerte Bitmaps in einen Textblock einzubetten. Dies kann von groer
Bedeutung sein, wenn ein Bild eine Grenordnung von 100 MB hat und ein halbes Dutzend Mal in einem Textartikel
abgebildet werden soll!
:eul.
:p.:hp2.Dialog 'Anker':ehp2.
:p.Der Dialog 'Anker' verhindet das Bearbeiten des Textes. Um einen bereits vorhandenen Anker zu bearbeiten
oder zu kopieren, plazieren Sie den Text-Cursor ber einem Absatz, der einen solchen Anker enthlt. Zum Auswhlen
eines neuen Einfger-Rahmens oder Wiederverwenden eines zuvor kopierten Ankers plazieren Sie den Text-Cursor
ber einem Rahmen, der noch keinen Anker enthlt.
:p.Text kann einen Anker entweder umflieen oder darunter angeordnet werden.
:p.Anker lassen sich im Verhltnis zum Einfger- (Text-) Rahmen linksbndig, rechtsbndig oder zentriert
ausrichten.
.br
.br
.*******************************************************************************
:h2 res=26 id=26 global.Funoten einfgen und bearbeiten
:i2 refid=edit.Funoten einfgen und bearbeiten
:p.:hp2.bersicht:ehp2.
:p.Mit Hilfe von Funoten lt sich Text mit Anmerkungen versehen. Funoten werden im Textkrper als
hochgestellte Zeichenkette dargestellt. Diese hochgestellte Zeichenkette wird als Funotenzeichen bezeichnet.
:p.Funoten bestehen aus drei Teilen, dem Funotenzeichen, dem Funotentitel und dem Funotentext selbst.
:p.Der Stil fr das Funotenzeichen mu im gesamten Artikel gleich sein.
:p.Funoten sind halbautomatisch und dadurch etwas komplizierter in der Bedienung, besitzen damit aber auch
eine Reihe leistungsfhiger Merkmale.
:p.Wurden alle bentigten Funoten hinzugefgt, knnen sie in einen neuen (oder bereits vorhandenen) Rahmen
extrahiert werden. Eine Einschrnkung besteht darin, da Funoten nicht aus dem ausgewhlten in denselben
Rahmen extrahiert werden knnen. Siehe
:link reftype=hd res=69.Funoten extrahieren:elink..
:p.:hp2.Das Funotenzeichen:ehp2.
:p.Das Funotenzeichen lt sich nur bei der ersten Funote eines Artikels anpassen. Bei den folgenden
Funoten sind die Steuerelemente fr Funotenzeichen deaktiviert.
:p.Das einfachste Funotenzeichen ist ein Zhler. Durch Auswahl des Markierungsfeldes 'Sperren' und Eintragen
einer Zahl in das nebenstehende Eingabefeld kann ein Startwert fr den Zhler festgelegt werden. Dieses Verfahren
erlaubt es, Funoten ber mehrere Artikel hinweg fortlaufend zu numerieren. Mit Hilfe des manuell festgelegten
Startwerts knnen Sie entscheiden, in welcher Reihenfolge Artikel aufgefhrt werden.
:p.Bei Funoten, die allen Textartikeln gemeinsam sind, ist es wahrscheinlich am besten, den Funotentitel als
Funotenzeichen zu verwenden.
:p.:hp2.Der Funotentitel:ehp2.
:p.Der Funotentitel wird als berschrift fr die Funote verwendet. Darber hinaus ist der Funotentitel im
Hilfefeld der Statuszeile sichtbar, wenn sich der Cursor auf einer Funote befindet.
:p.:hp2.Der Funotentext:ehp2.
:p.Der Funotentext kann aus beliebigem Text bis zu einer Gre von etwa 32 K bestehen. Das sollte fr die
meisten Funoten ausreichen.
.br
.br
.*******************************************************************************
:h2 res=47 id=47 global.Steuerzeichen einfgen
:i2 refid=edit.Steuerzeichen einfgen
:p.Mit Hilfe des Dialogs 'Steuerzeichen einfgen' lassen sich Steuerzeichen in den Textrahmen einfgen.
Steuerzeichen sind Text, der automatisch aus internen Informationen generiert wird. Zu solchen
internen Informationen gehren das aktuelle Datum und die Zeit, der Dateiname und Pfad des aktuellen
Dokuments, die derzeitige Seitennummer und die Anzahl der Seiten im Dokument sowie benutzerdefinierte
Textmischdaten.
:p.:hp2.Seitennummern:ehp2.
:p.Die Seitennummer wird durch die Position der Steuerzeichen auf der Druckseite bestimmt. Befinden
sich die Steuerzeichen nicht wirklich innerhalb einer Seite oder genau zwischen zwei Seiten, kann der
korrekte Wert evtl. nicht ermittelt werden. In diesem Fall wird ein '?' ausgegeben.
:p.Die Gesamtanzahl der Seiten ist beim Erstellen von Text wie 'Seite x von y' hilfreich, wobei 'y' fr die
Anzahl Seiten im gesamten Dokument steht.
:p.:hp2.Zhler:ehp2.
:p.Zhler sind eine Mglichkeit, numerierte Listen zu erstellen. Es stehen mehrere Numerierungsarten zur Verfgung,
wie etwa alphabetisch oder mit rmischen Zahlen.
:p.Da Zhler auerdem verschachtelt werden knnen, knnen Numerierungen wie folgende erstellt werden&colon.
:fig.
1 Autos.
2 Boote,
    a mit Paddeln.
    b mit Segeln.
    c mit Pedalen.
3 Fahrrder.
4 Flugzeuge.
:efig.
:p.:hp2.Mischdaten:ehp2.
:p.Das Laden und Verwenden einer Mischdatenbank stellt einen Weg dar, Informationen in einen Text einzufgen.
Die gebruchlichste Nutzung dieser Funktion ist die Erstellung von Serienbriefen. Bevor Sie Mischdaten einfgen,
sollten Sie eine Mischdatenbank in das Dokument laden und die erste Zeile der Daten auswhlen, die beim
Einfgen verwendet werden soll. Das Einfgen geschieht automatisch, dynamisch und wird aktualisiert, wenn
an der :link reftype=hd res=67.Mischdatenbank:elink. nderungen vorgenommen werden.
Die zu verwendende Zeile der Mischdatenbank kann durch Auswahl der korrekten Zeile aus dem Listenfeld
festgelegt werden.
:p.Zu einem spteren Zeitpunkt lt sich eine andere Zeile festlegen, indem der entsprechende Text markiert
und im Dialog :link reftype=hd res=25.Mischzeile auswhlen:elink. die korrekte Zeile ausgewhlt wird.
:p.:hp2.Datum und Zeit:ehp2.
:p.Die Informationen zu Datum und Zeit werden mittels einer Datei namens
:link reftype=hd res=111.DATECONV.LCI.:elink.
aus einem numerischen in ein Textformat konvertiert.
:p.Datum und Zeit knnen als normaler Text eingefgt werden. In diesem Fall werden die Steuerzeichen
vor dem Einfgen in normalen Text konvertiert. Wie bei normalem Text blich werden die Werte fr Datum
und Zeit nicht jedesmal aktualisiert, wenn der Text neu gezeichnet oder ausgedruckt wird. Da das Einfgen
fixer Werte fr Datum und Zeit am gebruchlichsten ist, ist dieser Modus voreingestellt.
:p.:hp2.Dateiinformation:ehp2.
:p.Zur Auswahl stehen der Name des Dokuments und der vollstndige Dateipfad. Ist die Datei noch unbenannt,
wird ein leerer String zurckgegeben. Nach Sichern der Datei erscheint der String mit der korrekten
Dateiinformation.
.br
.br
.*******************************************************************************
:h3 res=25 id=25 global.Dialog Einzuarbeitende Zeile auswhlen
:i2 refid=edit.Dialog Einzuarbeitende Zeile auswhlen
:p.Dieser Dialog ist verfgbar, wenn :link reftype=hd res=47.Steuerzeichen:elink.
markiert wurden, die Daten aus einer :link reftype=hd res=67.Mischdatenbank:elink.
enthalten.
:p.Hier kann die zum Einlesen des Texts verwendete Zeile der Mischdatenbank relativ gendert werden.
Wird fr die Zeilen eine automatische Erhhung zwischen mehreren Drucklufen festgelegt, so wird
die Zeile entsprechend hochgezhlt.
:p.Die Basiszeile wird im Dialog :link reftype=hd res=67.Datenbank einarbeiten:elink. festgelegt.
Die erste im Listenfeld dieses Dialogs angezeigte Zeile entspricht der im Dialog 'Einzuarbeitende Zeile auswhlen'
ausgewhlten ersten Zeile. Im Listenfeld wird die dem kleinsten Versatz der Steuerzeichen entsprechende Zeile
ausgewhlt. Dadurch wird sichergestellt, da die auswhlbare Zeile immer
grer als die Basiszeile ist.
:p.Werden mehrere Drucklufe mit einer automatisch hochgezhlten Basiszeile durchgefhrt, werden alle anderen
Zeilen entsprechend versetzt. Werden mehr Zeilen angesprochen als in der einzuarbeitenden Datenbank
vorhanden sind, wird als Text ein Platzhalter verwendet (wie z.B. '$$(123)').
.br
.br
.*******************************************************************************
:h2 res=19 id=19 global.Text suchen
:i2 refid=edit.Text suchen
:p.Whlen Sie 'Suchen' aus dem Men 'Bearbeiten'. Diese Funktion sucht nach dem im Eingabefeld 'Suchbegriff'
angegebenen Text.
:p.Geben Sie den Suchbegriff in das entsprechende Eingabefeld ein. Es erlaubt die Eingabe von Zeichenketten
mit einer Lnge von bis zu 254 Zeichen.
:p.Soll der gefundene Text gendert werden, geben Sie im Eingabefeld 'Ersetzen durch' den neuen Text ein.
:p.Whlen Sie, ob die Suche Gro-/Kleinschreibung bercksichtigen und ob rckwrts im Text gesucht werden soll.
:p.Alle weiteren Optionen bleiben deaktiviert, bis die Suche erfolgreich war. Dann wird der Treffer markiert.
:p.:hp2.Dann kann:ehp2.
:ol.
:li.der Text durch den im Eingabefeld 'Ersetzen durch' ersetzt werden,
:li.der Text wie oben gendert und nach dem nchsten Auftreten gesucht werden,
:li.jede normale Editierfunktion wie Ausschneiden, Kopieren, Einfgen, Eingeben usw. benutzt werden.
Schieben Sie den Suchdialog einfach aus dem Weg (oder minimieren Sie ihn) und klicken Sie auf den Text,
um einen Cursor anzeigen zu lassen. Der Dialog wird solange wie gewnscht angezeigt.
:li.jedes Auftreten des Texts ersetzt werden.
:eol.
:note text='Hinweis:'.Das Suchen findet in einem eigenen Thread statt. Nehmen Sie mglichst keine nderungen
an der Datei vor, whrend der eigentliche Suchvorgang luft.
.*******************************************************************************
:h2 res=20 id=20 global.Wrter zhlen
:i2 refid=edit.Wrter zhlen
:p.Whlen Sie den Meneintrag 'Wrter zhlen', um die Anzahl der Wrter im derzeitigen Artikel anzeigen zu lassen.
Ein Artikel besteht dabei entweder aus einem einzelnen Rahmen oder einer Kette verbundener Rahmen.
Das vollstndige Dokument kann eine beliebige Anzahl von Artikeln enthalten.
.*******************************************************************************
:h2 res=22 id=22 global.Rechtschreibprfung
:i2 refid=edit.Rechtschreibprfung
:p.Damit eine Rechtschreibprfung vorgenommen werden kann, mu ein Rechtschreib- und
Silbentrennungs-Handler installiert sein.
:p.Weitere Informationen zum Rechtschreibprfungs-Handler&colon.
:ul.
:li.Benutzen Sie den Meneintrag 'Handler-Liste...' des Hilfedialogs und dann nach Auswahl
des Rechtschreibprfungs-Handlers die Schaltflche 'Hilfe zum ausgewhlten Handler',
um die Hilfe aufzurufen.
:li.ffnen Sie das Men 'Bearbeiten' des Text-Handlers und whlen Sie den Meneintrag
'Rechtschreibprfung...'. Der Rechtschreibprfungs-Handler sollte dann einen Dialog
mit einer 'Hilfe'-Schaltflche anzeigen.
:eul.
:p.Sollte der Meneintrag 'Rechtschreibprfung...' deaktiviert sein, steht der
Rechtschreibprfungs-Handler nicht zur Verfgung. In diesem Fall mu er evtl.
erneut installiert werden.
.*******************************************************************************
:h2 res=28 id=28 global.Artikelinformationen
:i2 refid=edit.Artikelinformationen
:p.Mit Artikelinformationen lassen sich Textartikel voneinander unterscheiden. Jedes Dokument kann Textartikel von
verschiedenen Autoren enthalten sowie Artikel, die fr dieses bestimmte Dokument verfat wurden, oder solche, die
aus anderen Dokumenten bernommen wurden. Einmal festgelegt, bleiben die Artikelinformationen im Artikel eingebettet
und knnen mit Hilfe des Dialogs 'Artikelinformationen' angezeigt werden.
:p.Die verschiedenen Artikelinformationen spiegeln den Zustand eines gegebenen Artikels wieder. Zu einem sptereren
Zeitpunkt lt sich ein bestimmter Artikel mit Hilfe dieser Informationen suchen oder aus einer Liste auswhlen.
:p.Falls keine Artikelinformationen eingegeben werden, benutzt die Anwendung, wo ntig, die ersten Worte des Textartikels,
um diesen in einer Liste zu kennzeichnen.
:p.Folgende Informationsfelder stehen zur Verfgung&colon.-
:p.:hp2.Artikelname:ehp2.
:p.Dieses Feld gibt den Namen des Textes an. Einige Dialoge, wie etwa der Dialog
:link reftype=hd res=69.Funoten extrahieren:elink., fhren die Artikel nach Namen auf. Hat der Artikel
keinen Namen, werden statt dessen die ersten Wrter im Text verwendert. Entscheidet man sich aber, Artikelinformationen
einzugeben, ist die Angabe eines Namens obligatorisch.
:p.Mit Hilfe der Suche im Men 'Werkzeuge' kann nach dem Namen eines Artikels gesucht werden.
:p.:hp2.Autor:ehp2.
:p.Diese wahlfreie Feld gibt den Autor des Textes an. Hier kann beliebiger Text eingegeben oder das Feld leer
gelassen werden.
:p.Mit Hilfe der Suche im Men 'Werkzeuge' kann nach dem Autor eines Artikels gesucht werden.
:p.:hp2.Datum:ehp2.
:p.Dieses wahlfreie Feld gibt das Datum an, an dem der Artikel erstellt wurde. Ist kein Datum vorhanden, wird
das heutige Datum eingetragen. Das Feld ist nicht auf ein Datum beschrnkt; es knnen beliebige Informationen
eingegeben oder das Feld leer gelassen werden .
:p.:hp2.Ziel:ehp2.
:p.Dieses wahlfreie Feld gibt an, wo der Artikel verffentlicht werden sollte. Ist kein Ziel vorhanden, wird
der aktuelle Dateiname eingetragen. Das Feld kann im gegenwrtigen Zustand belassen, mit beliebigem Text gefllt
oder leer gelassen werden.
:p.:hp2.Anmerkungen:ehp2.
:p.Dieses wahlfreie Feld bietet Raum fr Anmerkungen. Wenn fr den Artikel urheberrechtliche Beschrnkungen
bestehen, wre hier ein guter Platz, darauf hinzuweisen. Andere ntzliche Dinge wren Hinweise auf Korrekturen
bersetzungen, Ergnzungen usw.
.br
.br
.*******************************************************************************
:h2 res=17 id=17 global.Objektverbindungen festlegen
:i2 refid=edit.Objektverbindungen festlegen
:note text='Hinweis:'.Wird nicht vom Simstext-Handler verwendet.
:p.Mit Hilfe der Verbindung von Objekten ist es mglich, Text ber mehr als ein Objekt
flieen zu lassen. Dies stellt den besten Weg des Umgangs mit langen Artikeln dar,
die sich ber mehrere Spalten oder sogar Seiten erstrecken.
:p.:hp2.Herstellen von Verbindungen:ehp2.
:p.Achten Sie darauf, da die Schaltflche der Inhaltsebene aller zu verbindenden Objekte
leer ist. Es knnen auch Verbindungen zwischen Ebenen hergestellt werden, indem whrend
des Verbindungsvorgangs entsprechende Handler-Schaltflchen ausgewhlt werden. Es ist sogar
mglich, Verbindungen zwischen verschiedenen Ebenen desselben Rahmens herzustellen.
:p.Whlen Sie ein nicht verbundenes Textobjekt, um eine neue Verbindungskette zu erstellen, oder
ein beliebiges Objekt einer vorhandenen Verbindungskette. Alle neuen Objekte werden zu diesem
Objekt hinzugefgt. Soll ein neues Objekt an das Ende der Kette angefgt werden, whlen Sie
das letzte Objekt der Kette aus.
:p.Bettigen Sie die Ketten-Schaltflche. Es wird ein Dialog angezeigt, mit dessen Hilfe der Kette
Objekte hinzugefgt werden knnen.
:p.Whlen Sie ggf. die Schaltflche einer anderen Ebene aus. Achten Sie darauf, da dem auszuwhlenden
Objekt kein Handler zugewiesen ist. Eine Ausnahme stellen leere Textobjekte dar, die zu einem
frheren Zeitpunkt aus einer Verbindungskette herausgelst wurden. Diese werden verwaiste Kettenobjekte
genannt.
Whlen Sie einen Rahmen und/oder eine Seite und klicken Sie auf 'Hinzufgen'. War das Objekt leer,
wird der Dialog eine Erfolgsmeldung anzeigen. Sie knnen mit dem Auswhlen und Hinzufgen von
Objekten fortfahren, bis die gewnschte Kette fertiggestellt ist.
:p.Zum Hinzufgen eines neuen Objekts an den Anfang einer Kette whlt man das erste Objekte der Kette aus
und fgt dann das neue Objekt hinzu. Das neue Objekt wird nach dem ersten Objekt eingefgt. Durch
Entfernen des ersten Objektes aus der Kette und sofortiges Wiedereinfgen nach dem neuen Objekt
kann die Position der Objekte in der Kette vertauscht werden. Andere Objekte knnen auf dieselbe
Weise ausgetauscht werden.
:artwork name='link.bmp' align=left.
:p.:hp2.Entfernen einer Verbindung:ehp2.
:p.Zum Entfernen der Verbindung eines Objekts whlen Sie das Objekt im Rahmen aus und bettigen die
Schaltflche Verbindung entfernen. Das Objekt wird herausgenommen und der Text-Handler davon entfernt.
Das Entfernen des Text-Handlers von einem verbundenen Objekt hat dieselbe Wirkung.
:artwork name='unlink.bmp' align=left.
:p.:hp2.Siehe auch:ehp2.
:p.:link reftype=hd res=21.Aufbrechen und Zusammenfgen von Ketten:elink.
.br
.br
.*******************************************************************************
:h3 res=21 id=21 global.Aufbrechen und Zusammenfgen von Ketten
:i2 refid=edit.Aufbrechen und Zusammenfgen von Ketten
:p.Seit Version 1.22 besitzt dieses Programm die Fhigkeit, Objektketten aufzubrechen und wieder zusammenzufgen.
Wird eine Verbindungskette in zwei Teile aufgebrochen, so erhlt man zwei Ketten. Die erste Kette, die den
originalen Text enthlt, wird Basiskette genannt. Die zweite Kette, die aus nicht-editierbaren Textrahmen
besteht, wird verbindbare Kette genannt.
:p.:hp2.Aufbrechen von Ketten:ehp2.
:p.Whlen Sie den Rahmen nach der beabsichtigten Bruchstelle aus. Wenn die Kette beispielsweise aus zwei Rahmen
besteht und diese aufgebrochen werden soll, whlt man den zweiten Rahmen aus. Whlen Sie 'Verbindungskette
aufbrechen' aus dem Men 'Bearbeiten'. Es wird der Dialog 'Verbindung wiederherstellen' angezeigt, der unten
nher erlutert wird.
:p.:hp2.Wiederverbinden von Ketten:ehp2.
:p.Es knnen nur verbindbare Ketten mit Basisketten wiederverbunden werden. Es gibt keine Mglichkeit, zwei Ketten
auf andere Weise zu verbinden. Damit wird der Fall ausgeschlossen, da eine Kette mit sich selbst in einer
Endlosschleife verbunden wird.
:p.Klickt man auf den ersten Rahmen einer verbindbaren Kette, hat man zwei Mglichkeiten zur Auswahl. Entweder
macht man die Kette editierbar, wodurch sie nicht mehr mit einer Basiskette verbunden werden kann, oder man
verbindet diesen Rahmen mit einer anderen Kette, bei der es sich um eine Basiskette handeln mu. Whlt man
keine von beiden durch Drcken von 'Abbruch', so erhlt man eine Kette, die zu einem spteren Zeitpunkt verbunden
oder editierbar gemacht werden kann. Es mu nur der erste Rahmen der verbindbaren Kette ausgewhlt werden.
:p.Whlt man, die verbindbare Kette mit einer Basiskette zu verbinden, wird ein Verbindungsdialog angezeigt und
der Cursor in den Verbindungs-Cursor gendert. Begeben Sie sich zur gewnschten Basiskette durch Aufrufen einer
anderen Seite oder ggf. Umschalten in den Hintergrundbearbeitungsmodus. Es kann jeder beliebige Rahmen der
Basiskette ausgewhlt werden, die verbindbare Kette wird immer am Ende angefgt.
.br
.br
.*******************************************************************************
:h2 res=11 id=11 global.Text-Handler entfernen
:i2 refid=edit.Handler entfernen
:p.Whlen Sie diesen Meneintrag, um den gesamten Text im Rahmen zu lschen und den Handler vom
Rahmen zu entfernen. Danach kann dem Rahmen anstelle des derzeitigen Handlers ein anderer Handler
hinzugefgt werden.
.br
.br
.******************************************************************************
.*  Character Menu
.******************************************************************************
:h1 res=40 id=40 global.Das Men Zeichen des Text-Handlers
:i1 id=char.Das Men Zeichen des Text-Handlers
:p.Das Men 'Zeichen' des Text-Handlers enthlt fr den FFTXT-Text-Handler spezifische Eintrge.
Viele dieser Optionen sind einmalig fr diesen Handler und sehr leistungsfhig.
:p.Manche der unten aufgefhrten Eintrge stehen nicht zur Verfgung, wenn der Simstext-Handler
verwendet wird, um Umrandungen mit Text auszustatten. Gleichermaen betreffen manche Optionen
nur den Simstext-Handler.
:ul.
:li.Wie man die :link reftype=hd res=42.Textausrichtung:elink. festlegt.
:li.Wie man die :link reftype=hd res=68.Textsprache und den Text-Zeichensatz:elink. festlegt.
:li.Wie man die :link reftype=hd res=72.Intelligente Anfhrungsstriche:elink.. aktiviert.
:li.Wie man :link reftype=hd res=66.Schusterjungen und Hurenkinder unterdrckt:elink..
:li.Wie man die :link reftype=hd res=71.Silbentrennung aktiviert:elink..
:li.Wie man die :link reftype=hd res=65.Zeichenrichtung:elink. anpat.
:li.Wie man das :link reftype=hd res=59.Startsegment des Simstext:elink. bestimmt.
:li.Wie man die :link reftype=hd res=58.Grenzauffllung:elink. festlegt.
:li.Wie man :link reftype=hd res=44.Absatzeinstellungen:elink. anpat.
:li.Wie man :link reftype=hd res=73.Aufzhlungszeichen und Listen:elink. definiert.
:li.Wie man :link reftype=hd res=45.Zeileneinstellungen:elink. anpat.
:li.Wie man eine :link reftype=hd res=48.Tabulatortabelle:elink. erstellt.
:li.Wie man einen :link reftype=hd res=43.Schriftschnitt und -stil:elink. auswhlt.
:li.Wie man die :link reftype=hd res=41.Zeichenfarbe:elink. festlegt.
:li.Wie man den :link reftype=hd res=61.Wurfschatten von Text:elink. festlegt.
:li.Wie man :link reftype=hd res=56.Informationen ber Texteinstellungen erhlt:elink..
:li.Wie man :link reftype=hd res=57.Zeichenketten in Umrandungen mit Simstext wiederholen lt:elink..
:li.Wie man :link reftype=hd res=60.Zeichenketten in Umrandungen mit Simstext umkehrt:elink..
:li.Wie man :link reftype=hd res=49.einen Titel fr die Extraktion markiert:elink..
:li.Wie man aus dem Dokument :link reftype=hd res=69.Funoten extrahiert:elink..
:li.Wie man aus dem Dokument ein :link reftype=hd res=52.Inhaltsverzeichnis extrahiert:elink..
:li.Wie man :link reftype=hd res=53.Textstile:elink. sichert.
:eul.
.******************************************************************************
:h2 res=42 id=42 global.Festlegen der Textausrichtung
:i2 refid=char.Festlegen der Textausrichtung
:note text='Hinweis:'.Wird nicht vom Simstext-Handler verwendet.
:p.Die wirkliche Textausrichtung setzt sich aus der Rahmenausrichtung und der Textausrichtung
zusammen. Voreingestellt ist eine Textausrichtung von +90.
:p.Normalerweise ist ein Rahmen auf 0 und der Text auf +90 ausgerichtet, was horizontalen
Text ergibt.
:p.Wird der Rahmen gedreht, dreht sich auch der Text mit. Der tatschliche Textwinkel wird
im Dialog Drehen als Statusstring angezeigt. Mit Hilfe des Drehknopfs oder durch Eingeben
des gewnschten Winkels kann die :hp1.relative:ehp1. Ausrichtung zwischen Text und Rahmen
angepat werden.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
:p.Drcken Sie 'Anwenden', um den neuen Textwinkel zu bernehmen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Soll der Winkel einer einzelnen Zeile angepat werden, kann dies evtl. mit Hilfe der
:link reftype=hd res=45.Anschrgung:elink. erreicht werden.
:p.Siehe auch :link reftype=hd res=65.Festlegen der Zeichenrichtung:elink..
.******************************************************************************
:h2 res=68 id=68 global.Festlegen der Textsprache und des Text-Zeichensatzes
:i2 refid=char.Festlegen der Textsprache und des Text-Zeichensatzes
:p.Mit der Sprachauswahl wird eine Reihe wichtiger Einstellungen festgelegt. Dazu gehren&colon.-
:ul.
:li.Die bei der Silbentrennung zur Bestimmungen der Trennpositionen verwendete Sprache.
:li.Die bei der Rechtschreibprfung verwendete Sprache.
:li.Die bei der Anzeige von Datum und Zeit verwendete Sprache.
:eul.
:p.Fr jeden Eintrag der Sprachauswahl werden drei verschiedene Parameter angezeigt. Der erste ist
die Sprachkennung, der zweite der Sprachstring. Der dritte Parameter wird nur angezeigt, wenn fr die
Sprache die passenden Wrterbcher installiert wurden.
:p.Zum Hinzufgen einer neuen Sprache sind zwei Dateien zu bearbeiten, die sich beide im Maul-Verzeichnis .\etc
befinden. Die erste Datei ist
:link reftype=hd res=111.DATECONV.LCI:elink., die zweite MYSPELL.DLS. Hinweise zum Bearbeiten
von MYSPELL.DLS finden Sie im Abschnitt 'Verwaltung von Wrterbchern und Zeichenstzen' des Handbuchs des
Rechtschreib-Handlers.
:p.Bei Auswahl einer Sprache, fr die keine Wrterbcher zu Verfgung stehen, knnen Silbentrennung und
Rechtschreibprfung nicht ordnungsgem funktionieren!
:p.Zeichenstze werden von OS/2 intensiv bei der Anzeige von Text in bestimmten Sprachen oder
bestimmter Betriebssysteme verwendet. Text wird als eine Folge von Zahlen gespeichert. Der
Zeichensatz bestimmt, welches Zeichen einer bestimmten Zahl entspricht. Importiert man einfachen
Text mit einem abweichenden Zeichensatz, werden Zeichen falsch angezeigt. Durch Wechseln zum
korrekten Zeichensatz wird der Text ordnungsgem angezeigt.
:p.Der ausgewhlte Zeichensatz wird zwar zur Anzeige von Text verwendet, aber weder beeinflut er
die Tastenbelegung noch wird er zur tatschlichen Konvertierung von einem Zeichensatz in einen anderen benutzt.
Diese Anwendung bersetzt einige Zeichenstze, siehe :link reftype=hd res=1000.Informationen zur Internationalisierung:elink..
:p.Gebruchlich sind beispielsweise folgende Zeichenstze&colon.
:ul.
:li.1208 Dieser MBCS Unicode Zeichensatz wird bei Maul Publisher verwendet ausser dem da Sie es verndern.
:li.819  Dieser Zeichensatz wird von ISO8859-1 Linux-Systemen verwendet; die Rechtschreibprfung
MySpell benutzt diesen Zeichensatz ebenfalls.
:li.850  Dieser Zeichensatz wird von Latin-1 OS/2-Systemen verwendet und enthlt Akzentzeichen, wie sie im Franzsischen verwendet werden.
:li.852  Dieser Zeichensatz wird von Latin-1 OS/2-Systemen verwendet und enthlt Akzentzeichen, wie sie im Tschechischen verwendet werden.
:li.1004 Mit diesem Zeichensatz knnen OS/2-Systeme im allgemeinen unter Windows erstellten Text ordnungsgem anzeigen.
:li.1252 Dieser Zeichensatz wird von Latin-1 Windows-Systemen verwendet.
:li.1250 Dieser Zeichensatz wird von Latin-2 Windows-Systemen verwendet.
:eul.
:p.Der fr diesen Artikel gewnschte Zeichensatz kann hier ausgewhlt werden. Drcken Sie 'Anwenden' zum Festlegen
des Zeichensatzes und 'Beenden' zum Verlassen des Dialogs. Bei Auswahl eines anderen Textrahmens wird der Dialog
automatisch aktualisiert. Fr die verschiedenen Textartikel knnen unterschiedliche Sprachen und Zeichenstze
verwendet werden.
:p.Es besteht jedoch ein Problem, dessen Sie sich bewut sein sollten.
:p.Der ausgewhlte Zeichensatz wird zurck auf den/die auf dem System installierten Zeichensatz/Zeichenstze bersetzt.
Je komplexer dieser bersetzungsvorgang wird, desto langsamer wird die Verarbeitung des Texts. Bei Auswahl eines
Rahmens mit einem anderen Zeichensatz kann es ntig werden, da der Handler die Schriftentabelle neu laden mu,
was mitunter zu einer kurzen Unterbrechung fhrt.
:p.Die auswhlbaren Zeichenstze definieren sich aus der Schnittmenge der im Betriebssystem zur Verfgung stehenden
Zeichenstze und einer Datei namens :link reftype=hd res=112.CODEPAGE.LCI:elink.. Diese Datei fhrt
alle whlbaren Zeichenstze auf. Zeichenstze
knnen von der Benutzung ausgeschlossen werden, indem man sie aus dieser Datei entfernt. In der Datei knnen auch
Zeichenstze vorkommen, die Sie nicht auswhlen knnen, weil sie auf Ihrem System nicht vorhanden sind. Die Datei
befindet sich im Verzeichnis .\etc. (Wie auch die meisten Stilvorlagen und Seitenvorlagen!)
.br
.br
.******************************************************************************
:h2 res=66 id=66 global.Unterdrcken von Schusterjungen und Hurenkindern
:i2 refid=char.Unterdrcken von Schusterjungen und Hurenkindern
:note text='Hinweis:'.Wird nicht vom Simstext-Handler verwendet.
:p.:hp2.ber Schusterjungen und Hurenkinder:ehp2.
:p.Schusterjungen und Hurenkinder knnen beim Umbrechen eines Absatzes zwischen zwei Rahmen auftreten,
wenn der Absatz so aufgeteilt wird, da entweder nur eine oder zwei Zeilen
im ersten Rahmen angezeigt werden und der Rest im zweiten oder der Hauptteil im ersten Rahmen
angezeigt wird und nur ein oder zwei Zeilen im zweiten. Im ersten Fall spricht man von Schusterjungen,
im zweiten von Hurenkindern.
:p.:hp2.Anwendung der Unterdrckung von Schusterjungen und Hurenkindern:ehp2.
:p.Dieser Handler bietet Unterdrckung von Schusterjungen und Hurenkindern auf Artikelbasis. Der Modus
ist aktiv, wenn der Meneintrag 'Schusterjungen und Hurenkinder unterdrcken' ausgewhlt ist. Durch
Klicken auf den Meneintrag kann zwischen Aktivierung und Deaktivierung umgeschaltet werden.
:p.Ist der Meneintrag ausgewhlt, wird der Artikel unter Verwendung des folgenden Algorithmus
neu formatiert (die Regeln werden in der Reihenfolge wie aufgefhrt angewendet)&colon.
:ol compact.
:li.Aufgeteilte Absatzteile mit weniger als 8 Zeilen Lnge werden in den nchsten Rahmen verschoben.
:li.Schusterjungen mit weniger als 4 Zeilen Lnge werden ebenfalls in den nchsten Rahmen verschoben.
:li.Hurenkinder drfen nicht weniger als 4 Zeilen lang sein, der Absatz wird so aufgeteilt, da diese
Regel eingehalten wird.
:li.Alle weiteren Abstze werden ignoriert, egal ob geteilt oder nicht.
:eol.
.br
.br
.******************************************************************************
:h2 res=71 id=71 global.Silbentrennung aktivieren
:i2 refid=char.Silbentrennung aktivieren
:p.Die Silbentrennung ist von Sprache und Zeichensatz abhngig. Whlen Sie bitte die korrekte
Sprache und den Zeichensatz fr Textartikel aus, bevor Sie die Silbentrennung aktivieren.
:p.Die korrekte Sprache fr einen Textartikel lt sich mit Hilfe des Dialogs
:link reftype=hd res=68.Textsprache und Zeichensatz:elink. festlegen.
.br
.br
.******************************************************************************
:h2 res=72 id=72 
global.Intelligente Anfhrungsstriche
:i2 refid=char.Intelligente Anfhrungsstriche
:p.Maul ist in der Lage, Anfhrungszeichen entsprechend der jeweiligen Sprache zu 
behandeln. Ist der 
Meneintrag "Intelligente Anfhrungszeichen" aktiviert, so werden normale 
Anfhrungsstriche durch eine 
:link reftype=hd res=2.LOL:elink. struktur ersetzt, durch das automatisch
die zur im Artikel verwendeten Sprache gehrenden Anfhrungszeichen verwendet werden.
:p.Der Meneintrag "Intelligente Anfhrungszeichen" bestimmt damit, ob es sich beim 
eingefgten Text um ein 
intelligentes Anfhrungszeichen oder das Standardzeichen handelt.
:p.Darber hinaus lassen sich auch intelligente einfache Anfhrungszeichen 
verwenden. Um 
Verwechselungen mit dem echten Apostroph zu vermeiden, das beispielsweise im 
franzsischen 
:hp2.l'eau:ehp2. oder im englischen :hp2.it's:ehp2. verwendet wird, mu bei der Eingabe 
jedoch Alt+<'> 
gedrckt werden. Andernfalls gbe es keine Mglichkeit, zwischen beiden 
Anwendungen zu unterscheiden.
:p.Weitere Arten von Anfhrungszeichen, wie z.B. Guillemets ( und ), werden nicht von 
der Funktion 
Intelligente Anfhrungszeichen untersttzt.
:note text='Hinweis:'.Die Funktion steht nicht zur Verfgung, wenn der verwendete 
Zeichensatz nicht die 
erforderlichen Zeichen enthlt. Aus diesem Grunde wird bei neuen Textobjekten auch 
1208 Unicode als 
Standardzeichensatz verwendet.
.br
.br
.******************************************************************************
:h2 res=65 id=65 global.Festlegen der Zeichenrichtung
:i2 refid=char.Festlegen der Zeichenrichtung
:p.Die Zeichenrichtung legt die Ausrichtung der einzelnen Zeichen fest, die zusammen eine Zeile ergeben.
:p.Dieser Dialog pat die Textausrichtung und die Reihenfolge der Textzeilen automatisch der
ausgewhlten Zeichenrichtung an.
:p.Die Zeichen werden immer entlang der Textzeilenreihenfolge ausgegeben. Diese wird ber
die :link reftype=hd res=42.Textausrichtung:elink. festgelegt.
:p.Der Dialog dreht die Textzeilenreihenfolge so, da die Textausrichtung fr jede Zeichenrichtung
konsistent bleibt.
:p.Angenommen, die Textausrichtung verluft von links nach rechts, dann kann die Reihenfolge der
Textzeilen von oben nach unten oder von unten nach oben verlaufen. Letzteres ist mit einer
umgekehrten Textzeilenreihenfolge zu erreichen.
:p.Die Einstellung der Zeichenrichtung funktioniert auch beim Simstext-Handler. In diesem Fall
sind weder Textausrichtung noch Textzeilenreihenfolge anwendbar. In manchen Fllen kann es
erforderlich sein, die Zeichenrichtung der Umrand umzukehren.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
:p.Siehe auch :link reftype=hd res=42.Festlegen der Textausrichtung:elink..
.br
.br
.******************************************************************************
.*  Wingstamp start segment
.******************************************************************************
:h2 res=59 id=59 global.Dialog Simstext-Startsegment
:i2 refid=char.Dialog Simstext-Startsegment.
:p.Smtliche in Maul verfgbaren Figuren bestehen aus einem oder mehreren Segmenten. Handelt es sich bei einem
Rahmen um eine geschlossene Figur, die aus mehreren Segmenten besteht, kann das Startsegment gewhlt werden,
von dem aus der Text ausgegeben wird.
:p.Sobald der Text auf dem richtigen Segment plaziert ist, kann er mit Hilfe von Tabulatoren und Leerzeichen
genau positioniert werden.
.******************************************************************************
:h2 res=58 id=58 global.Grenzauffllung festlegen
:i2 refid=char.Grenzauffllung festlegen
:note text='Hinweis:'.Wird nicht vom Simstext-Handler verwendet.
:p.Wenn sich ein Objekt im Vordergrund des Textrahmens befindet, fliet der Text um das Objekt herum.
Normalerweise wird ein kleiner Abstand um solche Objekte belassen. Die Einstellung dieser Grenzauffllung
hngt nicht von anderen eventuell festgelegten Randeinstellungen ab. Gleichermaen werden die Rnder
nicht von dieser Auffllung beeinflut, die in alle Richtungen gleich und nur bei Objekten angewendet
wird, die in den Textrahmen hineinragen.
:p.Geben Sie fr jeden zu ndernden Wert eine Zahl gefolgt von einer Maeinheit ein, z.B. 0.5in.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt). 
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel 
interpretiert. Der eigentliche Wert wird in Druckerpunkten gespeichert und angezeigt.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
.******************************************************************************
:h2 res=44 id=44 global.Absatzeinstellungen festlegen
:i2 refid=char.Absatzeinstellungen festlegen
:note text='Hinweis:'.Wird nicht vom Simstext-Handler verwendet.
:p.Absatzeinstellungen betreffen die Positionierung eines vollstndigen Absatzes.
:p.Wenn mehrere Abstze markiert wurden, werden die markierten Abstze angepat, andernfalls nur
die Einstellungen des aktuellen Absatzes.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Einzugsinformationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesen Einzgen erstellt werden.
:p.:hp2.Absatzabstnde:ehp2.
:p.Mit Hilfe der Absatzeinstellungen knnen Abstnde und Einzge fr Abstze und Initialen
festgelegt werden. Ein Absatz ist in diesem Fall ein formatierter Textblock, der sich ber
eine oder mehrere Zeilen erstreckt. Der Einzug der ersten Zeile des Absatzes kann unabhngig
vom Rest festgelegt werden, womit sich ein ansprechendes Textlayout realisieren lt.
Es werden sowohl linke wie rechte Einzge untersttzt.
:p.Geben Sie fr jeden zu ndernden Wert eine Zahl gefolgt von einer Maeinheit ein, z.B. 0.5in.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt). 
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel 
interpretiert. Der eigentliche Wert wird in Punkten gespeichert und zwar auf ein 65536-stel eines
Punktes genau.
:p.:hp2.Initialen:ehp2.
:p.Das Feld Schriftgre fr Initialen funktioniert wie das in der Werkzeugleiste.
Sollte die gewnschte Schriftgre nicht aufgefhrt sein, kann sie in der Combobox eingegeben werden.
Schriftgren werden stets in Punkten angegeben.
:p.Zur przisen Ausrichtung von Initialen bietet dieser Dialog die Mglichkeit, den vertikalen
Versatz des Initialbuchstabens und den freien Bereich zu seiner Rechten anzupassen.
Das Eingabefeld 'Extra-Versatz' akzeptiert positive und negative Werte fr den Versatz des
Initialbuchstabens. Das Eingabefeld 'Extra-Breite' akzeptiert dagegen nur positive Werte und wird
dazu verwendet, den brigen Text um den gewnschten Wert nach rechts zu verschieben.
:p.Die Einstellungen fr Initialen werden nie im Systemprofil abgespeichert, knnen jedoch als
Stilvorlage gesichert werden.
.br
.br
.******************************************************************************
:h2 res=73 id=73 global.Aufzhlungszeichen fr Absatz festlegen
:i2 refid=char.Aufzhlungszeichen fr Absatz festlegen
:note text='Hinweis:'.Nicht im Simstext-Handler verfgbar.
:p.Mit Aufzhlungszeichen lassen sich einfache Numerierungen und Aufzhlungen erstellen. Fr den Einsatz
von Aufzhlungszeichen ist die Nutzung von Unicode- oder DBCS-Zeichenstzen erforderlich, welche die
notwendigen Zeichen enthalten.
:p.Durch Bettigen einer der Schaltflchen fr Listen wird die voreingestellte Aufzhlung oder Numerierung 
erzeugt. Der Dialog 'Aufzhlungszeichen und Listen' kann ber das Men oder durch Klick mit der rechten 
Maustaste auf eine der Schaltflchen fr Listen aufgerufen werden.
:p.Die voreingestellten Aufzhlungspunkte entsprechen den bei Web-Browsern gebruchlichen. Diese Option
lt sich jedoch deaktivierieren, so da eigene Zeichen ausgewhlt werden knnen.
:p.Numierierungszeichen knnen als Buchstaben, rmische sowie normale Zahlen angezeigt werden. Darber hinaus
knnen sie mit einer Vielzahl Klammern oder Satzzeichen versehen werden. Durch  Auswahl von Zhlerebenen
lassen sich, wie unten dargestellt, verschachtelte Aufzhlungen erstellen.
:fig.
1 Autos.
2 Boote.
    a mit Paddeln.
    b mit Segeln.
    c mit Pedalen.
3 Fahrrder.
4 Flugzeuge.
:efig.
:p.Die Einstellungen fr Listen werden im Absatz gespeichert und bersteuern alle Einstellungen fr Initiale.
:p.Es gibt noch weitere Mglichkeiten zur Erstellung von Listen: mit Hilfe von
:link reftype=hd res=47.Steuerzeichen:elink. oder durch manuelles Erstellen, indem der entsprechende
Einzug fr den :link reftype=hd res=44.Absatz:elink. eingestellt und das gewnschte Zeichen oder
Bild im Text als Aufzhlungszeichen eingefgt wird.
.******************************************************************************
:h2 res=45 id=45 global.Zeileneinstellungen festlegen
:i2 refid=char.Zeileneinstellungen festlegen
:note text='Hinweis:'.Nur Textjustierung ist verfgbar im Simstext-Handler.
:p.Zeileneinstellungen wirken sich auf die Positionierung einer einzelnen Zeile aus. Sie sind ein wenig
'flchtig'. Wenn die Breite eines Rahmens gendert wird, kann es sein, da der Absatz danach weniger Zeilen
enthlt. In diesem Fall werden die berflssigen Zeilenparameter zusammen mit Ihren sorgfltig vorgenommenen
Einstellungen gelscht. Wenn der Rahmen dann schmaler gemacht wird, werden zustzliche Zeilen hinzugefgt.
Diese neuen Zeilen bernehmen die Einstellungen der vormals letzten Zeile.
:p.Wurde Text markiert, so werden alle markierten Zeilen angepat, andernfalls wird nur die aktuelle
Zeile gendert.
:p.Die Justierung lt sich mit Hilfe der Radioknpfe festlegen.
:p.Der Durchschu wird in Prozenten der derzeit maximalen Zeichenhhe angegeben.
:p.Mit der Anschrgung lassen sich Zeilen schrg stellen. In Bezug auf eine uralte Druckerpresse
gesehen, geschieht bei diesem Effekt das gleiche, als wenn man zwei gleichgroe Bleikeile nhme und
sie ber und unter einer Zeile metallener Zeichenblcke plazierte. Der Parameter Anschrgung gibt dabei
den breitesten Teil des Keils an.
:p.Bei negativer Anschrgung wird die Zeile nach rechts unten gedrckt, andernfalls nach links unten.
Geben Sie einen Wert gefolgt von einer Maeinheit ein, um den Keil einzufhren, z.B. 0.5in.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt). 
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel 
interpretiert. Der eigentliche Wert wird in Punkten gespeichert und zwar auf ein 65536-stel eines
Punktes genau.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
.******************************************************************************
:h2 res=48 id=48 global.Texttabulatortabelle einrichten
:i2 refid=char.Texttabulatortabelle einrichten
:p.Bei der Erstellung einer Tabulatortabelle wird diese in die Textdatei eingefgt und bleibt
gltig, bis eine andere Tabulatortabelle eingerichtet wird. Mit Hilfe von Tabulatortabellen
knnen fr einen gegebenen Textblock abweichende Tabulatoreinstellungen eingerichtet werden.
:p.:hp2.Einrichten der Tabulatoren im Dialog:ehp2.
:p.Im Tabulatordialog wird ein Lineal mit den derzeit fr das Hauptfenster gltigen Tabulatoreinstellungen
angezeigt. Durch Anklicken der Linealmarkierungen mit der Maus knnen Tabulatoren gesetzt und
entfernt werden.
:p.Zoomen Sie mit Hilfe der Zoom-Schaltflchen in der Menleiste des Hauptfensters hinein, wenn Sie die Tabulatoren
genauer festlegen wollen, als es das Lineal erlaubt.
:p.:hp2.Anwenden von Tabulatoren auf markierten Text:ehp2.
:p.Durch Bettigen der Schaltflche 'Anwenden' wird die Tabulatortabelle in einen temporren Puffer bertragen.
Ist markierter Text vorhanden, so wird die Tabelle auf den markierten Textblock angewendet.
:p.:hp2.Hinzufgen der Tabulatoren mit neuem Text:ehp2.
:p.Um eine neue Tabulatortabelle hinzuzufgen, ohne vorher Text markiert zu haben, geben Sie etwas ein, ohne vorher
eine Cursorposition auszuwhlen. Durch Klicken mit der Maus auf einen Textbereich werden die aktuellen Einstellungen
aus der Textdatei neu geladen, wodurch die gerade angelegte Tabelle zerstrt wird.
:p.:hp2.Anzahl der Tabulatoren:ehp2.
:p.Die Anzahl der Tabulatoren ist auf 60 begrenzt.
:p.Die Tabulatorwerte werden als Punkte gespeichert und sind auf 1/65536 Punkt genau. (Ein Inch hat 72.2818 Punkte.)
.******************************************************************************
:h2 res=43 id=43 global.Schriftauswahl
:i2 refid=char.Schriftauswahl
:p.Benutzen Sie den Schriftartendialog zur Auswahl einer Schriftart. Mit Hilfe dieses Dialogs lt sich zudem
eine Reihe von Einstellungen anpassen, die das Erscheinungsbild einer Schrift beeinflussen.
:p.Zoomen Sie mit Hilfe der Zoom-Schaltflchen in der Menleiste des Hauptfensters hinein, falls das Schriftbeispiel
zu klein sein sollte. Wurde Text markiert, wird er als Beispielzeichenkette verwendet.
:p.:hp2.Schriftart:ehp2.
:p.Zur Auswahl einer Schriftart werden zwei Listenfenster verwendet. Das erste zeigt
die verfgbaren Schriftfamilien an, das zweite die fr die jeweilige Schriftart verfgbaren
Stile.
:p.Whlen Sie im Listenfenster 'Schriftgre' eine vorgegebene Schriftgre aus oder geben Sie selbst
eine ein.
:p.:hp2.Schriftschnitt:ehp2.
:p.Mit Hilfe des Schriftschnitts knnen normale Schriftarten auch fett oder kursiv dargestellt werden.
Bei den damit erzeugten Schriften handelt es sich evtl. nicht um echte Schriftarten, sondern um
synthetisierte Schriften. Seien Sie sich im klaren darber, da synthetisierte Schriftschnitte
zu unerwarteten Ergebnissen beim Ausdruck eines Dokumentes in einer Druckerei fhren knnen.
Beim Ausdruck ber den eigenen PC ist ein kurzer Testausdruck ratsam, um das Ergebnis berprfen
zu knnen.
:p.:hp2.Zeichendehnung:ehp2.
:p.Nutzen Sie die Zeichenabstands-Steuerelemente, um den Abstand zwischen Zeichen anzupassen, und die
Zeichendehnungs-Steuerelemente, um die durchschnittliche Breite eines Zeichens zu beeinflussen.
Dazu knnen die Schieberegler benutzt oder Werte in die entsprechenden Felder eingegeben werden.
:p.Sowohl Abstand als auch Dehnung werden in Prozent der durchschnittlichen Textweite angegeben.
:p.:hp2.Zeichenscherung:ehp2.
:p.Die Zeichenscherung legt fest, wie Zeichen gekippt werden. Dies ist eine Mglichkeit, kursiven Text zu erzeugen.
:p.Benutzen Sie den Drehregler oder das Eingabefeld zur Eingabe eines Winkels in Grad. Die Statusanzeige gibt den
Vertikalwinkel - also den Winkel der vertikal verlaufenden Teile der Zeichen - an und bercksichtigt die
aktuellen Drehungsfaktoren.
:p.:hp2.Rcksetzen:ehp2.
:p.Drcken Sie 'Rcksetzen', um die Steuerelemente auf die derzeitigen Einstellungen zurckzusetzen.
:p.:hp2.Als Standard sichern:ehp2.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
.******************************************************************************
:h2 res=41 id=41 global.Zeichenfarbe festlegen
:i2 refid=char.Zeichenfarbe festlegen
:p.Benutzen Sie diesen Dialog zur Auswahl einer Zeichenfarbe fr einen ausgewhlten Textbereich. Die
Vordergrundfarbe wird fr den Text verwendet, mit der Hintergrundfarbe wird der Bereich hinter dem
Text eingefrbt. Es ist auch mglich, eine transparente Hintergrundfarbe zu whlen.
:p.Bei Verwendung des Simstext-Handlers kann ber einen eigenen Meneintrag eine Gesamthintergrundfarbe
festgelegt werden.
:p.In beiden Fllen handelt es sich hier um den Dialog des aktuellen Farb-Handlers. Weitere Informationen
zur Bedienung dieses Dialogs finden sich in der Hilfe des Farb-Handlers.
.******************************************************************************
:h2 res=54 id=54 global.Unterschneiden
:i2 refid=char.Unterschneiden
:p.:hp2.ber Unterschneiden:ehp2.
:p.Das Unterschneiden ist ein Verfahren zur Anpassung des Abstandes zwischen bestimmten Zeichenpaaren,
um ein ausgewogeneres Erscheinungsbild der Wrter zu erreichen. Zu den klassischen Anwendungsbeispielen
des Unterschneidens gehrt das Zusammenziehen der Buchstaben Y und o. Andernfalls schiene es, als ob
sich zwischen den Buchstaben ein Leerzeichen befnde.
:p.Das Unterschneiden erfordert in die aktuelle Schriftart eingebaute Unterschneidungstabellen. Die Unterschneidungstabellen
knnen sich dabei sehr wohl von Schriftart zu Schriftart voneinander unterscheiden. Wird keine
Unterschneidungstabelle gefunden, findet kein Unterschneiden statt.
:p.:hp2.Dialog Unterschneiden:ehp2.
:p.Benutzen Sie den Dialog 'Unterschneiden' um festzulegen, unter welchen Umstnden unterschnitten wird.
Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
:p.Verwenden Sie das ausklappbare Listenfeld oder das Eingabefeld des Kombinationsfeldes zur Eingabe einer
Mindestschriftgre fr das Unterschneiden.
:p.Mit Hilfe des Markierungsfeldes lt sich das Unterschneiden fr den markierten Text aktivieren und deaktivieren.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
.******************************************************************************
:h2 res=61 id=61 global.Schattenwurf einstellen
:i2 refid=char.Schattenwurf einstellen
:p.Mit Hilfe des Schattenwurfs kann ein Textstck oder ein Titel hervorgehoben werden. Zum Zeichnen
des Wurfschattens unterhalb des Textstcks wird eine Schattenwurffarbe verwendet. Der Standardwurfschatten
benutzt eine mittelgraue Farbe und ist um 7% nach rechts unten versetzt.
:p.Wenn Ihnen die Standardwerte zusagen, reicht ein Klick auf die Schaltflche 'Schattenwurf' zur Aktivierung
des Schattenwurfs aus. Es gibt jedoch ein paar Stolpersteine.
:p.Zum einen ist der Wurfschatten unsichtbar, wenn die Schattenwurffarbe deaktiviert ist. Gleichermaen wird
der Wurfschatten verdeckt, wenn der Versatz Null betrgt.
:p.Der Dialog 'Schattenwurf einstellen...' gibt Ihnen wesentlich weitergehende Kontrollmglichkeiten ber den Schattenwurf.
Mit seiner Hilfe knnen die Farbe, der Versatz in Prozent und die Versatzrichtung des Wurfschattens festgelegt werden.
Der prozentuale Versatz basiert auf der Hhe der maximalen Oberlnge - gewhnlich die Hhe des groen 'H'.
:p.Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
.******************************************************************************
:h2 res=56 id=56 global.Informationen ber die LOL-Liste erhalten
:i2 refid=char.Informationen ber die LOL-Liste erhalten
:p.Die LOL-Liste ist ein Dialog, der die aktuellen Einstellungen an der Cursor-Position anzeigt. Einstellungen wie
Schriftart und Farbe werden innerhalb des normalen Texts angezeigt. Dieser Dialog liest diese normalerweise
unsichtbaren, eingebetteten Einstellungen aus.
:p.Die LOL-Liste zeigt folgende Einstellungen an&colon.
:dl compact tsize=30.
:dt.Schriftart:dd.Die Schriftart und jedwede zustzliche Hervorhebung wie Fettdruck, Kursivdruck, Unterstreichen, Umri oder Durchstreichen. 
:dt.Absatz:dd.Absatzabstand, linker und rechter Einzug der ersten Zeile sowie linke und rechte Einzge der restlichen Zeilen.
:dt.Scherung:dd.Scherungswinkel in Grad als Versatz zum Standard.
:dt.Richtung:dd.Zeichenrichtung, immer links nach rechts.
:dt.Zeichenrechteck:dd.Textgre in Punkten.
:dt.Farbe:dd.Ein RGB-Farbwert, wobei 00000000 schwarz und 00ffffff wei entspricht.
:dt.Hervorhebung:dd.Hochstellung, Tiefstellung oder keine.
:dt.Titel:dd.Die aktuelle Titelextraktionsebene, wobei 0 = keine.
:dt.Abstand:dd.Der Abstand zwischen diesem Zeichen und dem nchsten in Punkten.
:dt.Dehnung:dd.Betrag der Zeichendehnung in Punkten.
:edl.
.br
.br
.******************************************************************************
:h2 res=57 id=57 global.Text in Simstext-Umrandungen wiederholen
:i2 refid=char.Text in Simstext-Umrandungen wiederholen
:note text='Hinweis:'.Nur fr den Simstext-Handler verfgbar.
:p.Bei Benutzung des Simstext-Umrandungs-Handlers kann eine Kennung gesetzt werden, mit welcher der
Text wiederholt wird, bis die Umrandung mit Text aufgefllt ist. Dieser Modus lt sich ber den
Meneintrag 'Textwiederholungsmodus ndern' umschalten.
.******************************************************************************
:h2 res=60 id=60 global.Textstrings in Simstext-Umrandungen umkehren
:i2 refid=char.Textstrings in Simstext-Umrandungen umkehren
:note text='Hinweis:'.Nur fr den Simstext-Handler verfgbar.
:p.Bei Benutzung des Simstext-Umrandungs-Handlers kann eine Kennung gesetzt werden, mit welcher der
Textstring umkehrt wird, so da der Text um die Figur herum in anderer Richtung dargestellt wird.
Dieser Modus lt sich ber den Meneintrag 'Textumkehrmodus ndern' umschalten.
.******************************************************************************
:h2 res=49 id=49 global.Zeichenkette fr Titelextraktion markieren
:i2 refid=char.Zeichenkette fr Titelextraktion markieren
:p.Benutzen Sie den Dialog 'Titelextraktion' zur Markierung einer Zeichenkette als Titel, um daraus
spter ein Inhaltsverzeichnis des Dokuments zu erzeugen.
:p.Whlen Sie eine Titelebene. 0 schaltet die Titelmarkierung ab. 1 ist die hchste Ebene, 8 die niedrigste.
Die aktuelle Titelebene wird durch Klick auf 'OK' festgelegt.
:p.Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
:p.Ein markierter Titel unterscheidet sich in seinem Aussehen nicht von einem nicht markierten; er ist also nicht
auf Anhieb im Text zu erkennen. ber die aktuelle Ebene gibt jedoch das Feld fr den Cursor-Status und dessen
Position in der Statuszeile Auskunft.
:p.Achten Sie darauf, nicht versehentlich den gesamten Artikel als Titel zu markieren. Wrde dann eine bestimmte
Titelebene festgelegt, so wrde diese auch jedem weiter hinzugefgten Text zugewiesen. Eine folgende Extraktion
des Inhaltes lieferte dann einiges mehr als beabsichtigt!
.br
.br
.******************************************************************************
:h2 res=69 id=69 global.Funoten aus Text extrahieren
:i2 refid=char.Funoten aus Text extrahieren
:p.Es ist mglich, in verschiedenen Artikeln erstellte Funoten zu extrahieren (aufzulisten). Dies geschieht
folgendermaen&colon.
:ol.
:li.Versehen Sie die Artikel mit Funoten.
:li.Erstellen Sie, je nach Bedarf, am Seiten- oder Dokumentenende einen leeren Textrahmen.
:li.Extrahieren Sie Funoten aus ausgewhlten Artikeln in den leeren Rahmen. Es ist zwar mglich, Funoten in
einen Textrahmen zu extrahieren, der bereits Text enthlt, aber nicht, sie in denselben Rahmen zu extrahieren.
Da es sich bei den extrahierten Funoten jedoch nur um einfachen Text handelt, kann dieser beliebig kopiert,
eingefgt und bearbeitet werden.
:eol.
:p.:hp2.Dialog 'Funoten extrahieren':ehp2.
:p.Mit Hilfe von Stilvorlagen kann den Funotentiteln ein etwas anderes Aussehen als der Funote selbst verliehen
werden. Abhngig von verschiedenen Einstellungen (angezeigt als <option>), werden die Funoten in folgendem Format
extrahiert&colon.
:fig.
<indicator><indent>Funotentitel[newline]
<indent>Funotentext[newline]
:efig.
:p.Sollen sich zwischen den Funoten Leerzeilen befinden, achten Sie darauf, am Ende des Funotentextes eine
entsprechende Anzahl von Leerzeilen einzugeben. Der Funotentext wird unter Beibehaltung smtlicher Zeilenumbrche
und Tabulatoren vollstndig extrahiert.
:p.Whlen Sie das Markierungsfeld 'Zeichen zu Titel hinzufgen', wenn das Funotenzeichen dem Funotentitel
hinzugefgt werden soll. Falls das Funotenzeichen den Funotentitel benutzt, wird das Markierungsfeld ignoriert.
:p.:hp2.Artikelauswahl:ehp2.
:p.Benutzen Sie die beiden Listenfelder, um die zu bercksichtigenden Artikel und die gewnschte Reihenfolge
bei der Verarbeitung festzulegen.
:p.Im linken Listenfeld kann eine Mehrfachauswahl getroffen werden. Alle ausgewhlten Artikel erscheinen im
rechten Listenfeld.
:p.Im rechten Listenfeld lt sich ein Artikel auswhlen und durch Bettigen der entsprechenden Schaltflchen
in der Liste auf und ab bewegen. Der Extraktionsvorgang extrahiert die Funoten aus den Artikeln in der Reihenfolge,
in der sie im rechten Listenfeld angezeigt werden.
:p.Siehe auch&colon.-
.br
Wie man :link reftype=hd res=26.Funoten einfgt:elink..
.br
.br
.******************************************************************************
:h2 res=52 id=52 global.Titel aus dem Text extrahieren
:i2 refid=char.Titel aus dem Text extrahieren
:note text='Hinweis:'.Titel knnen nicht in eine Simstext-Umrandung extrahiert werden, aber es ist mglich,
Titel in einer Umrandung zu markieren, um sie in einen normalen Textrahmen zu extrahieren.
:p.Benutzen Sie den Dialog 'Titelextraktion' zur Extraktion eines Inhaltsverzeichnisses aus dem Dokument.
Bevor Sie fortfahren knnen, mssen die gewnschten
:link reftype=hd res=49.Titel markiert werden:elink..
Desweiteren mu der Textrahmen vorbereitet und ausgewhlt sein, in den extrahiert werden soll.
:p.Titel werden Seite fr Seite, Rahmen fr Rahmen und Objekt fr Objekt extrahiert. Wenn ein Titel in einem Rahmen
vor dem Titel in einem folgenden Rahmen erscheinen soll, mu sichergestellt sein, da die Rahmen in der richtigen
Reihenfolge vorhanden sind. Rahmen werden in der Reihenfolge vom zuunterst liegenden Rahmen zum zuoberst liegenden
durchsucht (spter in der Datei erscheinende Rahmen werden ber die frher erscheinenden gezeichnet).
:p.Die Titel liegen nach der Extraktion als normaler Text vor und knnen wie gewhnlich bearbeitet werden.
Die Titelextraktion wird wahrscheinlich nicht das gewnschte Layout erzeugen, seien Sie also fr eine
sptere berarbeitung bereit.
:p.Der Handler untersttzt Untertitel bis zu einer Tiefe von acht Ebenen, weswegen auch komplexe
Inhaltsverzeichnisse keine Schwierigkeiten bereiten sollten. Jede Untertitelebene kann einen anderen
Textstil besitzen, und jedem Titel kann eine Seitennummer und/oder eine Untertitelebene hinzugefgt werden.
:p.Es empfiehlt sich, eine Reihe von Textstilen speziell fr die Erstellung von Inhaltverzeichnissen zu erstellen.
Siehe :link reftype=hd res=53.Textstil sichern:elink..
:p.:hp2.Seiteninformationen fr Titel:ehp2.
:p.Extrahierten Titeln lassen sich Seiteninformationen hinzufgen. Bettigen Sie die entsprechende Schaltflche,
um die Seiteninformation vor oder hinter dem Titel hinzuzufgen. Der in das Eingabefeld eingegebene
Text wird jedem Titel hinzugefgt.
:p.Das Eingabefeld 'Titelseiteninformation' bietet folgende Befehle&colon.
:p.Beachten Sie, da jeder Befehl mit einem '$' beginnt und der Befehlsname immer in Klammern eingeschlossen wird.
Es werden nur die unteren Befehle erkannt; alles andere wird als normaler Text betrachtet.
:dl compact tsize=20.
:dt.:hp2.$(tab):ehp2.:dd.Ein Tabulator.
:dt.:hp2.$(page):ehp2.:dd.Die Seite, auf welcher der Titel gefunden wurde. Siehe Hinweis.
:dt.:hp2.$(level):ehp2.:dd.Die Untertitelebene.
:edl.
:lm margin=1.
:p.(...wobei Ebene 1 der obersten und Ebene 8 der untersten entspricht)
:note text='Hinweis:'.Wenn sich der Titel nicht innerhalb einer Seite befindet, oder genau zwischen zwei Seiten, kann es
vorkommen, da die korrekte Seitennummer nicht gefunden werden kann. In diesem Fall wird ein '?'
ausgegeben.
:p.:hp2.Sichern der Extraktionseinstellungen:ehp2.
:p.Die Einstellungen fr die Titelextraktion knnen gespeichert werden. Sie werden im Initialisierungsprofil des Programms
gespeichert, werden also nach dem Abspeichern zum neuen Standard.
.******************************************************************************
:h2 res=53 id=53 global.Textstil sichern
:i2 refid=char.Textstil sichern
:p.Benutzen Sie den Dialog 'Textstil sichern' zum Sichern oder Lschen von Textstilen. Als eigentlicher
Textstil werden die derzeit gltigen Stile gesichert. Beim Plazieren des Cursors an einer bestimmten
Stelle in einem Rahmen wird der Textstil in eine Datenstruktur kopiert. Diese Struktur wird immer dann
verndert, wenn eine beliebige Texteinstellung ber einen Dialog oder Meneintrag angepat wird.
:p.Bewegt man beispielsweise den Text-Cursor nach nderung der Zeichenscherung, wird die Zeichenscherung auf den Wert
der Stelle unter dem Cursor zurckgesetzt. Wenn andererseits beliebige Stileinstellungen vor dem Sichern gendert werden
und der Text-Cursor nicht bewegt wurde, werden die genderten Einstellungen gesichert. Gleichermaen werden nach
nderung der Einstellungen und anschlieender Eingabe von neuem Text die genderten Einstellungen fr diesen
neuen Text verwendet.
:p.Der Dialog 'Textstil sichern' liest die derzeitigen Texteinstellungen und speichert sie in einer Datei.
:p.Es werden folgende Einstellungen gesichert&colon.
:ul.
:li.Die derzeitige Schriftart.
:li.Der derzeitige Schriftschnitt (fett, kursiv usw.).
:li.Die derzeitigen Absatzeinstellungen.
:sl.
:li.Absatzabstnde.
:li.Linker und rechter Einzug der ersten Zeile.
:li.Linker und rechter Standardeinzug.
:esl.
:li.Die derzeitige Textfarbe.
:li.Die derzeitige Textgre.
:li.Die derzeitigen Zeileneinstellungen.
:sl.
:li.Durchschu in %.
:li.Zeilenanschrgung.
:li.Zeilenjustierung.
:esl.
:li.Die derzeitige Zeichenscherung.
:li.Die derzeitigen Zeichenabstnde.
:li.Die derzeitigen Einstellungen fr das Unterschneiden.
:sl.
:li.Aktivierung Unterschneiden (ein/aus).
:li.Der Mindestschriftgre beim Unterschneiden.
:esl.
:li.Die derzeitige Zeichendehnung.
:li.Die derzeitigen Einstellungen des Schattenwurfs.
:sl.
:li.Schattenwurfversatz in %.
:li.Schattenwurfwinkel.
:li.Schattenwurffarbe.
:li.Aktivierung Schattenwurf (ein/aus).
:esl.
:eul.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
.******************************************************************************
.*
.*
.*
.*  Toolbar Help
.*
.*
.*
.******************************************************************************
:h1 res=90 id=90 global.Hilfe zur Werkzeugleiste
:i1 id=tools.Hilfe zur Werkzeugleiste
:p.Die Werkzeugleiste stellt einen Groteil der Funktionalitt des Text-Handlers in komprimierter,
einfach zu bedienender Form zur Verfgung.
:p.Dieser Abschnitt bietet Hilfestellung zu folgenden Eintrgen der Werkzeugleiste.
:ul.
:li.:link reftype=hd res=91.Schriftartauswahl:elink..
:li.:link reftype=hd res=92.Schriftschnittauswahl:elink..
:li.:link reftype=hd res=93.Schriftgrenauswahl:elink..
:li.:link reftype=hd res=94.Textstilschaltflchen:elink..
:li.:link reftype=hd res=95.Textreformatierungsschaltflche:elink..
:li.:link reftype=hd res=96.Textjustierungsschaltflchen:elink..
:eul.
.******************************************************************************
:h2 res=91 id=91 global.Schriftauswahl ber die Werkzeugleiste
:i2 refid=tools.Schriftauswahl ber die Werkzeugleiste
:p.Mit Hilfe der Schriftauswahl :artwork name='font.bmp' runin. lt sich die Schriftart festlegen.
Hierbei handelt es sich um eine ausklappbare Liste aller im System vorhandenen Schriftfamilien.
Beachten Sie, da nur skalierbare Vektorschriften verwendet werden knnen. Welche Schriftart
tatschlich benutzt wird, hngt vom ausgewhlten Schriftschnitt (fett, kursiv usw.) ab. Die
tatschliche Schriftart wird im Feld
:link reftype=hd res=81.Schriftstatus:elink. angezeigt.
:p.Ist Text markiert, so wird dieser sofort angepat. Andernfalls wird die neue Schriftart nicht angewendet, bis
etwas eingegeben wird. Mit der Bewegung des Cursors wird das Feld aktualisiert. Daher geht jede neue Einstellung
verloren, wenn der Cursor bewegt wird, bevor Text eingegeben oder eingefgt wurde.
:p.:hp2.Die vollstndige Schriftauswahl:ehp2.
:p.:artwork name='fontsel.bmp' align=left.
.br
.br
.******************************************************************************
:h2 res=92 id=92 global.Schriftschnittauswahl ber die Werkzeugleiste
:i2 refid=tools.Schriftschnittauswahl ber die Werkzeugleiste
:p.Mit Hilfe der Schriftschnittauswahl der Werkzeugleiste :artwork name='fontsty.bmp' runin. lt sich der Schriftschnitt festlegen.
Hierbei handelt es sich um eine ausklappbare Liste aller innerhalb einer bestimmten Schriftfamilie zur Verfgung
stehenden Schnitte. Der Name der tatschlich verwendeten Schriftart wird im Feld
:link reftype=hd res=81.Schriftstatus:elink. angezeigt.
:p.Ist Text markiert, so wird dieser sofort angepat. Andernfalls wird die neue Schriftart nicht angewendet, bis
etwas eingegeben wird. Mit der Bewegung des Cursors wird das Feld aktualisiert. Daher geht jede neue Einstellung
verloren, wenn der Cursor bewegt wird, bevor Text eingegeben oder eingefgt wurde.
:p.:hp2.Die vollstndige Schriftauswahl:ehp2.
:p.:artwork name='fontsel.bmp' align=left>.
.br
.br
.******************************************************************************
:h2 res=93 id=93 global.Schriftgrenauswahl ber die Werkzeugleiste
:i2 refid=tools.Schriftgrenauswahl ber die Werkzeugleiste
:p.Mit Hilfe der Schriftgrenauswahl :artwork name='size.bmp' runin. lt sich die Schriftgre festlegen.
Sollte die genaue Gre nicht aufgefhrt sein, knnen Sie die gewnschte Gre in das Feld eingeben und
die Eingabetaste drcken.
:p.Ist Text markiert, so wird dieser sofort angepat. Andernfalls wird die neue Schriftgre nicht angewendet, bis
etwas eingegeben wird. Mit der Bewegung des Cursors wird das Feld aktualisiert. Daher geht jede neue Einstellung
verloren, wenn der Cursor bewegt wird, bevor Text eingegeben oder eingefgt wurde.
:p.:hp2.Die vollstndige Schriftauswahl:ehp2.
:p.:artwork name='fontsel.bmp' align=left>.
.br
.br
.******************************************************************************
:h2 res=94 id=94 global.Textstilschaltflchen der Werkzeugleiste
:i2 refid=tools.Textstilschaltflchen der Werkzeugleiste
:p.Mit Hilfe der Textstilschaltflchen :artwork name='charmode.bmp' runin. lt sich der Textstil schnell ndern.
Auf diese Weise haben Sie sofortigen Zugriff auf die Textstile Umri, unterstrichen, durchgestrichen,
hochgestellt, tiefgestellt und Schattenwurf.
:p.Beachten Sie, da fr den Stil 'Schattenwurf' weitere Parameter ber das Men 'Zeichen' festgelegt werden knnen.
:p.Ist Text markiert, so wird dieser sofort angepat. Andernfalls wird der neue Textstil nicht angewendet, bis
etwas eingegeben wird. Mit der Bewegung des Cursors wird der Stil aktualisiert. Daher geht jede neue Einstellung
verloren, wenn der Cursor bewegt wird, bevor Text eingegeben oder eingefgt wurde.
.******************************************************************************
:h2 res=95 id=95 global.Textneuformatierungsschaltflche
:i2 refid=tools.Textneuformatierungsschaltflche
:p.Mit Hilfe der Schaltflche Textneuformatierung :artwork name='reflow.bmp' runin. kann der gesamte Artikeltext
neu formatiert werden. Erstreckt sich der Text ber mehrere Rahmen, werden smtliche Rahmen neu formatiert.
:p.Bei dieser Funktion handelt es sich nicht um ein einfaches Neuzeichnen; es werden smtliche Textpositionen neu
berechnet. Dies kann eine Weile in Anspruch nehmen, wenn der Textartikel sehr gro oder der Textrahmen sehr
komplex ist. Bei langsamen Neuformatierungen wird eine Fortschrittsanzeige angezeigt. Der Vorgang kann nicht
unterbrochen werden.
.******************************************************************************
:h2 res=96 id=96 global.Textjustierungsschaltflchen der Werkzeugleiste
:i2 refid=tools.Textjustierungsschaltflchen der Werkzeugleiste
:p.Mit Hilfe der Textjustierungsschaltflchen :artwork name='charjust.bmp' runin. lt sich die Justierung der aktuellen
Zeile anpassen.
:p.Sind mehrere Zeilen markiert, wirkt sich die nderungen auf sie aus. Die Justierung wird dynamisch berechnet und
erfordert keine Neuformatierung des Textes. Sie kann auf Zeilenbasis angepat werden. Die Justierung ist nur einer
von mehreren Parametern, die ber den Dialog 'Zeileneinstellungen...' im Men 'Zeichen' angepat werden knnen.
.******************************************************************************
.*
.*
.*
.*  Status Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  status bar
.******************************************************************************
:h1 res=80 id=80 global.Statuszeileninformation
:i1 id=stats.Statuszeileninformation
:p.Die Statuszeile enthlt Informationen, welche die aktuelle Position im Textrahmen vermitteln sollen.
:p.Grundstzlich bietet die Werkzeugleiste eine ganze Reihe von Informationen, da der Status der
Schaltflchen und Listenfelder Auskunft ber die derzeitge Texthervorhebung, Justierung usw. gibt.
.******************************************************************************
:h2 res=81 id=81 global.Informationen zum Schriftstatus
:i2 refid=stats.Informationen zum Schriftstatus
:p.Die Statuszeile zeigt den genauen Namen der aktuellen Schriftart an, wogegen der Schriftname im
Listenfeld der Werkzeugleiste den Namen der Schriftfamilie angibt.
:p.Daher knnte das Listenfeld in der Werkzeugleiste 'Swiss' fr die Schriftfamilie Swiss anzeigen
und die Statuszeile 'Helv Bold' fr die tatschliche Schriftart innerhalb der Schriftfamilie Swiss.
.******************************************************************************
:h2 res=83 id=83 global.Informationen zu Cursor-Status und -Position
:i2 refid=stats.Informationen zu Cursor-Status und -Position
:p.Die Informationen zum Cursor-Status umfassen eine Reihe ntzlicher Indikatoren, die anderswo normalerweise
nicht angezeigt werden.
:p.Das verwendete Format ist wie folgt&colon.
:p.:hp2.L<zeilennummer><lolkennung><textposition>,<titelmarkierung><tabulatorliste>:ehp2.
:p.Zeilennummer und Textposition drften selbsterklrend sein. Diese beiden Zahlen zeigen Zeile und Spalte
der derzeitigen Cursor-Position an.
:p.:hp2.Die LOL-Kennung:ehp2.
:p.Die LOL-Kennung ist weniger offensichtlich. Ein LOL ist ein unsichtbarer Datenblock, der eine nderung
des Textstils zwischen dem vorangehenden und dem folgenden Zeichen bewirkt. Wird der Cursor auf der Grenze
zwischen zwei Textstilen plaziert, kann Text entweder im vorigen (Standard) oder im folgenden Stil
eingegeben werden. Soll der vorige Stil verwendet werden, mu sich die Position vor dem LOL befinden,
ist dagegen der folgende Stil gewnscht, mu sich die Position nach dem LOL befinden.
:p.Um ein LOL zu berspringen (LOL bedeutet 'leap over lol' oder 'ein LOL berspringen'), halten Sie die Alt-Taste
gedrckt und drcken Sie die rechte Cursor-Taste auf der Tastatur. Der Beginn eines LOLs wird mit der linken
Cursor-Taste der Tastatur angesteuert.
:p.Befindet man sich am Beginn eines LOLs (der Standard), entspricht die LOL-Kennung einem Doppelpunkt "&colon.";
am Ende eines LOLs ndert sich die LOL-Kennung auf ein '*'.
:p.:hp2.Die Titelmarkierung:ehp2.
:p.Befindet sich der Cursor innerhalb eines markierten Titels, entspricht die Titelmarkierung einer Zahl von 0 bis 8.
Andernfalls zeigt ein '.' keine Titelmarkierung an. Eine Titelmarkierung der Ebene 0 wird nicht extrahiert. Alle Titel
sollten durch ein Textstck der Ebene 0 getrennt sein.
:p.:hp2.Die Tabulatorliste:ehp2.
:p.Befindet sich vor der derzeitigen Cursor-Position ein gltiges Tabulator-LOL, wird dies durch ein 't' angezeigt.
Andernfalls zeigt ein '.' an, da sich an diesem Punkt des Rahmens keine gltige Tabulatorliste befindet.
.******************************************************************************
:h2 res=82 id=82 global.Informationen ber Verbindungen
:i2 refid=stats.Informationen ber Verbindungen
:p.Dieses Statusfeld zeigt Verbindungen zwischen Rahmen an. Ein "" zeigt den ersten Rahmen einer Kette verbundener
Rahmen an, "" den letzten Rahmen. Bei Anzeige von "" ist der Rahmen sowohl mit dem vorigen als auch dem
folgenden Rahmen verbunden und befindet sich damit innerhalb einer Kette verbundener Rahmen.
:p.Ist das Statusfeld leer, bestehen fr diesen Rahmen keine Verbindungen.
:p.Dieses Statusfeld wird auerdem vom Simstext-Handler benutzt um anzuzeigen, da der Cursor gefunden wurde. Als
Kennung wird ein kleines '*' verwendet, was die Markierung eines Stcks gebogenen Texts wesentlich erleichtert.
.******************************************************************************
.*
.*
.*
.*  Options Help
.*
.*
.*
.******************************************************************************
:h1 res=100 id=100 global.Eintrge dieses Handlers in den Mens 'Werkzeuge' und 'Optionen'
:i1 id=options.Eintrge dieses Handlers in den Mens 'Werkzeuge' und 'Optionen'
:p.Der Text- und Simstext-Handler haben eine Reihe von Eintrgen in den Mens 'Werkzeuge' und 'Optionen' gemeinsam. Eintrge
in diesen Mens werden beim Programmstart dynamisch erzeugt.
:p.Dieser Abschnitt bietet Hilfestellung zu den folgenden Eintrgen der Mens&colon.
:ul.
:li.Werkzeug&colon. Wie man eine :link reftype=hd res=67.Mischdatenbank:elink. benutzt.
:li.Werkzeug&colon. Wie man das ganze Dokument als :link reftype=hd res=97.ungltig markiert:elink..
:eul.
:p.:hp2.Textoptionen&colon.-:ehp2.
:ul.
:li.Option&colon. Wie man die :link reftype=hd res=55.Standardtabulatorweite:elink. festlegt.
:eul.
:p.Die folgenden bestimmen die Standardmodi fr alle neuen Textobjekte,
einschlielich Text entlang von Linien (Simstext) und in Tabellen.
nderungen dieser Einstellungen wirken sich nicht auf vorhandene
Textobjekte aus.
:ul.
:li.Option&colon. :link reftype=hd
res=72.Intelligente Anfhrungsstriche:elink. beim
Erstellen neuer Textobjekte aktivieren.
:li.Option&colon. :link reftype=hd res=66.Unterdrckung
von Schusterjungen und Hurenkindern:elink. beim Erstellen neuer
Textobjekte aktivieren.
:eul.
.br
.br
.*******************************************************************************
:h2 res=67 id=67 global.Mischdatenbank
:i2 refid=options.Mischdatenbank
:p.Meneintrag&colon. 'Optionen->Mischdatenbank auswhlen...'
:p.Eine Mglichkeit des Einfgens von Informationen in den Text ist das Laden und Einfgen einer
Mischdatenbank. Die gebruchlichste Nutzung dieser Funktion ist die Erstellung von Serienbriefen.
Mischdaten knnen ber tabellenbasierte Anwendungen wie Tabellenkalkulationen oder Datenbanken
bereitgestellt werden. Nach dem Laden der Mischdaten in das Dokument knnen diese Daten mit Hilfe
von :link reftype=hd res=47.Steuerzeichen:elink. an beliebigen Stellen des Dokuments
eingefgt werden.
:p.Die Mischdatenbank wird als durch Kommata getrennte Liste (CSV) in das Dokument geladen. Die meisten Tabellenkalkulationen
und Datenbanken sind in der Lage, Daten in diesem Format zu speichern. Die erste Zeile der Daten sollte die Namen
der Spalten enthalten. Auf diese Weise kann das richtige Feld einfach ausgewhlt werden.
:p.Nach dem Laden der CSV-Datei ist die bentigte Datenzeile auszuwhlen. Jedwede bereits in der Datei vorhandenen
Mischdateneintrge werden bei Klick auf 'OK' sofort angepat.
:p.Durch Auswahl von 'Neue Zeile nach jedem Drucklauf' kann eine Reihe von Serienbriefen gedruckt werden. Whlen Sie dazu
die Zeile aus, mit der die Serie beginnen soll. Dann legen Sie im Druckdialog die Anzahl der zu druckenden Exemplare
fest. Bei jedem Exemplar wird eine neue Zeile verwendet. Falls alle verfgbaren Zeilen aufgebraucht wurden und noch
Drucklufe anstehen, beginnt die Serie wieder bei der ausgewhlten Zeile.
:p.:hp2.Durch Kommata getrennte Listen (comma seperated lists, CSV):ehp2.
:p.Eine durch Kommata getrennte Liste ist eine Liste in einer einfachen Textdatei, deren Eintrge durch Kommata
getrennt sind. Die einzelnen Eintrge knnen ihrerseits Kommata enthalten, wenn der Eintrag in "Anfhrungszeichen"
gesetzt wird. Solche Anfhrungszeichen werden automatisch entfernt. Es folgt ein Beispiel mit nur zwei Zeilen und
vier Eintrgen pro Zeile&colon.
:xmp.
Name, Adresse, Postleitzahl, Stadt
Johann Schmidt, "Hohestrae 27", 76345, Groestadt
:exmp.
.br
.br
.*******************************************************************************
:h2 res=97 id=97 global.Gesamtes Dokument als ungltig markieren
:i2 refid=options.Gesamtes Dokument als ungltig markieren
:p.Verwenden Sie den Meneintrag 'Ganzes Dokument als ungltig markieren', um das Dokument vollstndig neu
formatieren zu lassen. Es werden smtliche Rahmen neu formatiert.
:p.Bei dieser Funktion handelt es sich nicht um ein simples Neuzeichnen, da smtliche Textpositionen neu
berechnet werden. Aus Zeitersparnis wird nur die aktuelle Seite neu formatiert. Weitere Seiten werden
nach Bedarf beim Neuzeichenen oder Ausdrucken neu formatiert.
.br
.br
.*******************************************************************************
:h2 res=55 id=55 global.Festlegen der Standardtabulatorweite
:i2 refid=options.Festlegen der Standardtabulatorweite
:p.Meneintrag&colon. 'Optionen->FFText-Tabulatoren...'
:p.Mit Hilfe dieses Dialogs lt sich die Standardtabulatorweite fr den Fall festlegen, da keine
Tabulatortabelle erstellt wurde.
:p.Im Text-Handler ist eine Tabulatorweite von 36pt voreingestellt. Dies entspricht etwa einem halben Inch.
:p.Geben Sie eine Zahl gefolgt von einer Maeinheit ein, z.B. 0.5in.
:p.Dieser Wert wird als Standardtabulatoreinstellungen des Textrahmens gespeichert.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesen Standardtabulatoreinstellungen erstellt werden.
:p.Auf diese Weise entsteht ein System hierarchischer Tabulatoreinstellungen, angefangen bei einem systemweiten
Standardtabulator ber einen Standardtabulator fr einen Rahmen bis zu ggf. eingerichteten
Tabulatortabellen.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt). 
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel 
interpretiert. Der eigentliche Wert wird in Druckerpunkten gespeichert und ist auf
1/65536 Punkt genau.
.******************************************************************************
.*
.*
.*
.*  Import Export Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  import and export
.******************************************************************************
:h1 res=84 id=84 global.Importieren und Exportieren von Text
:i1 id=import.Importieren und Exportieren von Text
:p.Mit Hilfe des Importierens und Exporierens von Text lassen sich von anderen Anwendungen erstellte Dateien in
den Standard-Text-Handler laden. Dieser Handler untersttzt zwei Formate. Einfacher ASCII-Text kann verwendet
werden, wenn der Text keine Informationen zur Formatierung enthlt als solche, die von einem Texteditor wie
dem OS/2-Systemeditor erzeugt werden.
:p.Als weiteres von diesem Handler untersttztes Format kann Text im nativen FFTXT-Format importiert und exportiert werden.
Zur Zeit ist dieses Format zu keinem anderen Editor kompatibel, aber das Format umfat alle Formatierungsinformationen,
die bei einfachem Text fehlen.
:p.Weitere Textformate werden durch separate Import-Handler untersttzt.
:p.:hp2.Wie man Text importiert und exportiert:ehp2.
:p.Bevor Text importiert oder exportiert werden kann, mu ein Rahmen ausgewhlt und der Cursor an der gewnschten
Position positioniert werden. Soll nur ein Teil des Texts exportiert werden, kann der zu exportierende Textbereich
:link reftype=hd res=18.ausgewhlt:elink. werden.
Andernfalls wird der gesamte im ausgewhlten Rahmen befindliche Text exportiert. Achten Sie beim Importieren von Text
darauf, da kein Text markiert ist, es sei denn, Sie mchten, das dieser Bereich berschrieben wird.
:p.Whlen Sie 'Datei' und dann 'Import' oder 'Export'. Es erscheint eine Aufstellung der verfgbaren Textformate.
Whlen Sie das gewnschte Format. Wenn weitere Import- und Export-Handler installiert sind, stellt Maul die entsprechenden
Formate zur Verfgung.
.******************************************************************************
:h1 res=62 id=62 global.Schriftartersetzung
:i1 id=fontsubs.Schriftartersetzung
:p.Der Dialog 'Schriftartersetzung' erscheint immer dann, wenn ein Textrahmen ausgewhlt wird und
eine der erforderlichen Schriftarten fehlt. Der folgende Dialog bietet die einmalige Gelegenheit,
die Schriftart im Rahmen direkt zu ndern. Wenn Sie sich entscheiden, die fehlende Schriftart nicht
zu aktualisieren, erhalten Sie dazu keine weitere Mglichkeit, es sei denn&colon.
:ul.
:li.Sie schlieen die Datei und ffnen sie erneut.
:li.Sie schalten zwischen den Seiten um, whrend der Textbearbeitungsmodus aktiv ist.
:eul.
:p.Meistens gibt es keine weitere Mglichkeit.
:p.:hp2.Fehlende Schriftart:ehp2.
:p.Hierbei handelt es sich um eine kurze Beschreibung der Schriftart, die nicht gefunden wurde.
Jedesmal, wenn eine Schriftart nicht gefunden wurde, versucht das System, sie durch eine
Standardschriftart wie Helv zu ersetzen. Die Entscheidung, ob eine andere Schriftart passender
ist, liegt jedoch bei Ihnen.
:p.:hp2.Durch angezeigte Schriftart ersetzen:ehp2.
:p.Die Schriftartauswahl benutzt zwei ausklappbare Listen. Die erste zeigt eine Aufstellung verfgbarer
Schriftfamilien an, die zweite die fr die jeweilige Schriftart verfgbaren Schnitte.
:p.:hp2.Beispiel:ehp2.
:p.Der Dialog besitzt eine Statusanzeige mit einem Beispieltext. Dieser kann bei der Auswahl einer
geeigneten Ersatzschriftart sehr ntzlich sein.
:p.Drcken Sie 'Ersetzen' zum bernehmen der neuen Schriftart.
:p.Drcken Sie 'Ignorieren' zum Beibehalten des Schriftartnamens. In diesem Fall wird eine
Standardersatzschriftart verwendet. Hierfr ist meistens eine Schriftart aus der Schriftfamilie
'Swiss' voreingestellt.
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=120 id=120 global.Hilfe zu Tasten
:i1 id=keys.Hilfe zu Tasten
:p.Fr diesen Handler stehen die folgenden Tasten zur Verfgung. Es werden die gebruchlichsten Tasten aufgefhrt, jedoch
keine Tasten, die fr andere Handler spezifisch sind. Whlen Sie einen Rahmen und Handler aus, fr die Sie Informationen
bentigen und rufen Sie die Hilfe nochmals auf.
:p.Ist kein Rahmen ausgewhlt, so wird die Tastenhilfe fr das Hauptprogramm des Maul Publisher angezeigt.
:p.Bitte bemerken Sie da Sie diese Tasten ndern knnen, und da nur die Standarteinstellungen hier gezeigt werden.
:p.:hp2.Allgemeine Tastenbelegung:ehp2.
:ol.
:li.:hp2.Menauswahl:ehp2.
:dl compact tsize=16.
:dt.Alt+B:dd.Men Bearbeiten
:dt.Alt+D:dd.Men Datei
:dt.Alt+H:dd.Men Hilfe
:dt.Alt+O:dd.Men Optionen
:dt.Alt+S:dd.Men Seite
:dt.Alt+W:dd.Men Widerrufen
:dt.Alt+A:dd.Men Anzeige
:dt.Alt+U:dd.Umschalten zu (Umschaltliste)
:edl.
:li.:hp2.Men Datei:ehp2.
:dl compact tsize=16.
:dt.Strg+N:dd.Neue Datei
:dt.Strg+:dd.Datei ffnen...
:dt.Strg+I:dd.Importieren...
:dt.Strg+X:dd.Exportieren...
:dt.Strg+S:dd.Datei sichern
:dt.Strg+A:dd.Datei sichern unter...
:dt.Strg+R:dd.Datei drucken...
:edl.
:li.:hp2.Men Seite:ehp2.
:dl compact tsize=16.
:dt.Strg+P:dd.Seitendruckeinstellungen...
:dt.Strg+M:dd.Rnder und Gitter...
:dt.Strg+Umschalt+M:dd.Seitenvorlage verwenden...
:dt.Strg+T:dd.Seitenvorlage sichern/lschen
:dt.Alt+Umschalt+Entf:dd.Eine Seite kopieren
:dt.Alt+Umschalt+Einfg:dd.Eine Seite aus der Zwischenablage einfgen
:dt.Strg+Umschalt+I:dd.Eine neue Seite einfgen
:dt.Strg+Umschalt+J:dd.Eine neue erste Seite einfgen
:dt.Strg+Umschalt+D:dd.Eine Seite lschen
:dt.Alt+G:dd.Gehe zu Seite
:dt.Strg+Umschalt+N:dd.Nchste Seite
:dt.Strg+Umschalt+P:dd.Vorige Seite
:edl.
:li.:hp2.Men Anzeige:ehp2.
:dl compact tsize=16.
:dt.Strg+1:dd.Seitenanzeige Drucker
:dt.Strg+2:dd.Seitenanzeige
:dt.Strg+3:dd.Auf Breite anpassen
:dt.Strg+4:dd.Wirkliche Gre
:dt.Strg+Plus:dd.Vergrern
:dt.Strg+Minus:dd.Verkleinern
:dt.Strg+F:dd.Rahmenbearbeitungsmodus
:dt.Strg+C:dd.Inhaltsbearbeitungsmodus
:dt.Strg+G:dd.Hintergrundbearbeitungsmodus
:dt.Strg+B:dd.Umrandungsbearbeitungsmodus
:edl.
:li.:hp2.Men Widerrufen:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Letzte nderung widerrufen
:dt.Strg+Backspace:dd.Letzte nderung wiederholen
:dt.Strg+U:dd.Widerrufsliste...
:edl.
:li.:hp2.Men Optionen:ehp2.
:dl compact tsize=16.
:dt.Strg+Umschalt+R:dd.Druckereinstellungen...
:dt.Strg+E:dd.Raster aktivieren
:dt.Strg+Umschalt+S:dd.Rastereinstellungen...
:edl.
:li.:hp2.Men Hilfe:ehp2.
:dl compact tsize=16.
:dt.Strg+H:dd.Inhaltsverzeichnis
:dt.Strg+Umschalt+H:dd.Hilfeindex
:dt.Strg+K:dd.Hilfe fr Tasten
:dt.Strg+L:dd.Alle Handler anzeigen
:dt.Strg+Z:dd.Produktinformation...
:edl.
:eol.
:p.:hp2.Tastenbelegung Text-Handler:ehp2.
:p.Fr den Simstext-Handler gelten - soweit mglich - dieselben Tasten.
:p.:hp2.Tasten zur Bewegung des Cursors&colon.:ehp2.
:dl compact tsize=16.
:dt.Alt+Links:dd.Beginn des vorherigen, angrenzenden LOLs.
:dt.Strg+Links:dd.Voriges Wort
:dt.Alt+Rechts:dd.Ende des angrenzenden LOLs.
:dt.Strg+Rechts:dd.Nchstes Wort
:dt.Umsch+Cursor:dd.Markieren bei Nutzung zusammen mit Cursor-Bewegungstasten oder der Maus.
:edl.
:p.:hp2.Silbentrennung&colon.:ehp2.
:dl compact tsize=16.
:dt."-":dd.Das Minuszeichen (nicht das des Ziffernblocks!) ist das Standardzeichen fr die Silbentrennung.
:dt.Alt+"-":dd.Das Minuszeichen (nicht das des Ziffernblocks!) formt zusammen mit der Alt-Taste
ein potentielles Trennungszeichen. Das Zeichen erscheint nur, wenn das Wort tatschlich an dieser
Stelle getrennt wird. Potentielle Trennungszeichen bersteuern automatisch erzeugte.
.br
Zum Entfernen eines potentiellen Trennungszeichens plaziert man den Cursor links neben dem Trennungszeichen
und drckt dann Alt-Rechts, gefolgt von der Rckschrittaste.
:edl.
:p.:hp2.Intelligente Anfhrungszeichen&colon.-:ehp2.
:dl compact tsize=16.
:dt."'":dd.Fgt ein normales Apostroph ein. Es werden keine intelligenten 
Anfhrungszeichen benutzt.
:dt.Alt+"'":dd.Fgt ein intelligentes einfaches Anfhrungszeichen ein. Das Aussehen des 
Anfhrungszeichens 
wird durch die ausgewhlte Sprache und die Position im Text bestimmt.
:edl.
:p.:hp2.Geschtzte Satzzeichen&colon.-:ehp2.
:p.Jedes Zeichen das als Satzzeichen erkannt wird, oder das Leerzeichen, kann als geschtzt markiert werden.
Geschtzte Zeichen werden nicht als Satzzeichen erkannt, und werden ohne Zeilenumbruch als Normalzeichen formatiert. 
Zum Beispiel&colon.-
:dl compact tsize=16. 
:dt." ":dd.Leerzeichen einfgen.
:dt.Strg+Alt+" ":dd.Geschtztes Leerzeichen einfgen.
:edl.
:p.:hp2.Tabulatoren&colon.:ehp2.
:dl compact tsize=16.
:dt.Tab:dd.Fgt einen Tab ein, Tab bewegt das folgende Wort an den Beginn des Tabs.
:dt.Umschalt+Tab:dd.Fgt einen rechtsjustierten oder numerischen Tab ein. Falls das
folgende einen Dezimal-Punkt oder ein Komma enthlt (und auch eine Zahle ist) wird
sich der Text daran fgen. Ansonsten fgt sich der Text an das Ende des nchsten Wortes.
:edl.
:p.:hp2.Men-Tasten&colon.:ehp2.
:ol.
:li.:hp2.Men Bearbeiten:ehp2.
:dl compact tsize=16.
:dt.Umschalt+Entf:dd.Ausschneiden
:dt.Strg+Einf:dd.Kopieren
:dt.Umschalt+Einf:dd.Einfgen
:dt.Entf:dd.Lschen
:dt.Strg+Alt+F:dd.Text suchen...
:dt.Strg+Alt+O:dd.Wrter zhlen...
:dt.Strg+Umschalt+L:dd.Verbindung zu Textrahmen erstellen (nicht Simstext)...
:dt.Strg+Umschalt+K:dd.Verbindung zu Textrahmen aufheben (nicht Simstext)
:dt.Strg+Alt+S:dd.Textstil setzen...
:dt.Alt+Entf:dd.Handler entfernen
:edl.
:li.:hp2.Men Zeichen:ehp2.
:dl compact tsize=16.
:dt.Strg+Umschalt+O:dd.Textausrichtung (nicht Simstext)...
:dt.F2:dd.Rechtschreibprfung...
:dt.Strg+Umschalt+G:dd.Absatzeinstellungen (nicht Simstext)...
:dt.Strg+Alt+L:dd.Zeileneinstellungen (nicht Simstext)...
:dt.Strg+Alt+T:dd.Zeilentabulatoren...
:dt.Strg+Umschalt+F:dd.Zeichenschriftart...
:dt.Strg+Umschalt+C:dd.Zeichenfarbe...
:dt.Strg+Umschalt+E:dd.Zeichenscherung...
:dt.Strg+Umschalt+A:dd.Zeichenabstand...
:dt.Strg+Alt+R:dd.Zeichendehnung...
:dt.Strg+Alt+P:dd.Text wiederholen...
:dt.Strg+Alt+U:dd.Hintergrundfarbe...
:dt.Strg+Alt+I:dd.Lol-Listen-Dialog...
:dt.Strg+Umschalt+U:dd.Hochstellung auswhlen
:dt.Strg+Umschalt+B:dd.Tiefstellung auswhlen
:dt.Strg+Umschalt+Q:dd.Steuerzeichen einfgen...
:dt.Strg+Umschalt+X:dd.Als Titeltext einstellen...
:dt.Strg+Alt+X:dd.Titel extrahieren (nicht Simstext)...
:dt.Strg+Alt+A:dd.Zur Stilauswahl hinzufgen...
:edl.
:eol.
:h1 res=1000 id=1000 global.Informationen zur Internationalisierung
:i1 id=tech.Informationen zur Internationalisierung
:p.Dieser Text-Handler wendet eine Reihe von Verfahren fr den Umgang mit unterschiedlichen Sprachen an.
Die Konvertierung von Datum und Zeit wird auf der Hilfeseite zu
:link reftype=hd res=47.Steuerzeichen:elink. behandelt. Mit der Verwendung unterschiedlicher
Zeichenstze beschftigen sich diese Seite und die Seite :link reftype=hd res=68.Zeichenstze:elink..
:p.:hp2.Zeichenstze:ehp2.
:p.Maul verfgt ber Laufzeit DBCS-Konvertierung, indem da OS/2 Unicode-Untersttzungs API verwended wird.
:euserdoc.
 
