.******************************************************************************
.*  Maul Publisher Image import Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul-Hilfe zum Bildimport-Handler
:docprof toc=1234.
:h1 res=100 id=intro.Maul-Hilfe zum Bildimport-Handler
:i1 id=all.Maul-Hilfe zum Bildimport-Handler
:font facename='Tms Rmn' size=24x24.
:hp2.Maul-Bildimport-Handler:ehp2.
:font facename=default.
:p.
:p.Diese Software basiert auf Generalised Bitmap Module von Andy Key.
.*<!--<a href="mailto:nyangau@interalpha.co.uk">nyangau@interalpha.co.uk</a>-->
:p.Folgende Dateien wurden freundlicherweise von Heiko Nitzsche zu GBM beigetragen.
:ul.
:li.:hp2.gbmpng.c und gbmmap.c:ehp2. - Ermglichen GBM die Nutzung der Bibliothek Libpng.
:li.:hp2.gbmtif.c und gbmmap.c:ehp2. - Ermglichen GBM die Nutzung der Bibliothek Libtiff.
:li.:hp2.gbmppm.c:ehp2. - Ermglicht GBM das Lesen und Schreiben nicht palettisierter Dateien vom Typ RGB PPM.
:eul.
:p.Martin Lisowski hat freundlicherweise gbmjpg.c zu GBM beigetragen. Dadruch wird GBM ermglicht,
die Bibliothek IJG 6a/IJG 6b zu nutzen.
:p.Diese Software basiert teilweise auf der Arbeit der Independent JPEG Group.
:p.
:p.Implementiert von Peter Koller, Maison Anglais.
:p.Untersttzung unter&colon.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:p.
:p.
:p.:hp2.Untersttzte Formate:ehp2.
 
:p.GBM untersttzt eine Reihe von Formaten, wie etwa GIF, TIFF, PCX etc.
 
:p.Normalerweise leiten Anwendungen, die GBM benutzen, das Dateiformat aus der Dateiendung ab.
Beispiel&colon. :hp1.filename.gif:ehp1. ist eine Compu$erve-GIF-Datei.
 
:p.Wenn Programmen, die unter Verwendung von GBM erstellt wurden, Dateinamen bergeben werden,
ist es mglich, eine durch Komma getrennte Liste formatspezifischer Optionen anzugeben. Diese Optionen
werden in ungefhr dergleichen Art und Weise angehngt, wie es bei Webseiten geschieht, z.B.
:xmp.
dateiname#option=xxx, option, option=xxx
:exmp.
Man kann beispielsweise folgendes verwenden&colon. :hp1.webpiccy.gif#ilace:ehp1..
In diesem Fall handelt es sich bei :hp1.ilace:ehp1. um einen Parameter fr den GBM-Code, der
GIF-Dateien schreibt, und legt fest, da das GIF interlaced geschrieben werden soll.
:note text='Hinweis:'.Bei Bedarf wird die Option 'index=' von den Schaltflchen des Import-Dialogs automatisch
angehngt.
 
:p.
:xmp.:hp2.
Kurzname : Langname : Dateierweiterungen:ehp2.
  Anmerkungen
:exmp.
:xmp.
:hp2.Bitmap : OS/2 1.1, 1.2, 2.0 / Windows 3.0 bitmap : .BMP .VGA .BGA .RLE .DIB .RL4 .RL8:ehp2.
  Liest alle obigen, falls unkomprimiert oder run-length-komprimiert.
  Liest keine komprimierten Dateien vom Typ CCITT G3 MH Fax.
  Liest keine 24-Bit RLE-Dateien.
  Ist Eingabe eine OS/2-Bitmap-Array-Datei, kann gewnschte Bitmap angegeben werden.
    Eingabeoptionen: index=# (Standard: 0)
  Kann zum Schreiben von OS/2 1.1 oder Windows 3.0 / OS/2 2.0 Bitmaps veranlat werden.
    Ausgabeoptionen: 1.1,win,2.0 (Standard: 2.0, beachte: win=2.0)
  Handhabung von 1bpp-Bitmaps ist etwas kompliziert.
  Beim Lesen von 1bpp-Bitmaps wird die Palette ignoriert.
  1-en werden als Vordergrund und schwarz interpretiert.
  0-en werden als Hintergrund und wei interpretiert.
  Dies stimmt mit dem Hintergrundmodus der Workplace Shell WPFolder-Klasse und den meisten
  PM-Programmen berein, unterscheidet sich aber von Windows PBrush.
  Beim Schreiben von 1bpp-Bitmaps werden die tatschlichen zwei Farben in der Palette
  ignoriert, und es wird eine feste Palette geschrieben. Dies stellt sicher, da das Ergebnis
  1-en in schwarz und 0-en in wei bei WPFolder usw. anzeigt.
  Vorder- und Hintergrundfarben knnen beim Einlesen invertiert werden.
    Eingabeoptionen: inv
  Vorder- und Hintergrundfarben knnen bei der Ausgabe invertiert werden.
    Ausgabeoptionen: inv
  Bits der Vorder- und Hintergrundfarben knnen beim Einlesen invertiert werden.
    Eingabeoptionen: invb
  Bits der Vorder- und Hintergrundfarben knnen bei der Ausgabe invertiert werden.
    Ausgabeoptionen: invb
  Am besten schreibt man 1bpp-Bitmaps so, da die dunkelste Farbe als Vordergrund geschrieben
  wird. Bei der resultierenden Bitmap sind die dunkelsten Farben durch 1-er Bits und die
  hellsten als 0-Bits gesichert. Beim erneuten Laden ergibt sich bei WPFolder und GBM
  ein Bild aus schwarzen 1-sen und weien 0-en.
    Ausgabeoption: darkfg
  Desweiteren gibt es eine Option, um 1bpp-Bitmaps mit der hellsten Farbe als Vordergrund
  zu schreiben. Da WPFolder und GBM beim Laden annehmen, da der Vordergrund schwarz und
  der Hintergrund wei ist, fhrt dies typischerweise zur Invertierung des Bildes.
    Ausgabeoption: lightfg
:exmp.
:xmp.
:hp2.GIF : CompuServe Graphics Interchange Format : .GIF:ehp2.
  Liest 1-Bit Datendateien.
  Liest Datendateien mit 2, 3 und 4 Bit und stellt sie als 4-Bit dar.
  Liest Datendateien mit 5, 6, 7 und 8 Bit und stellt sie als 8-Bit dar.
  Schreibt Datendateien mit 1, 4 und 8 Bit.
  Liest Dateien im Stil "GIF87a" und "GIF89a".
  Schreibt Dateien im Stil "GIF87a".
  Schreibt "GIF89a"-Datei bei Verwendung der Option transcol=.
  Sollte verzgerten clear-code in LZW-Datenstrmen korrekt handhaben.
  Generiert keine Ausgabe mit verzgertem clear-code.
  D.h.: Sollte ltere GIF-Lesern keine Probleme bereiten.
  Kann Bildindex innerhalb Datei beim Lesen angeben.
    Eingabeoption: index=# (Standard: 0)
  Rckgabe dekodierter Daten bis Fehler kann bei defekten Dateien angegeben werden.
    Eingabeoption: errok
  In Bildschirmdeskriptor der Ausgabe zu schreibende Bildschirmgre kann angegeben werden.
    Ausgabeoptionen: xscreen=#,yscreen=# (Standard: image size).
  In BMHD-Header der Datei zu schreibender Hintergrundfarbindex kann angegeben werden.
    Ausgabeoption: background=# (Standard: 0)
  Positionsinformation in Bilddeskriptor der Ausgabe kann angegeben werden.
    Ausgabeoptionen: xpos=#,ypos=# (Standard: 0,0).
  Transparenter Farbindex (ntzlich fr Einbettung in HTML) kann angegeben werden.
    Ausgabeoption: transcol=# (Standard: keiner).
  Transparenten Farbindex auf erstes Pixel setzen mglich.
    Ausgabeoption: transcol=edge
  Kann interlaced GIFs (ntzlich fr HTML <IMG SRC="x.gif">) schreiben.
    Ausgabeoption: ilace
  Intensiv mit GIF-Dateien aus vielen Quellen getestet.
  Kompatibilitt mit xloadimage und xv getestet.
:exmp.
:xmp.
:hp2.PCX : ZSoft PC Paintbrush Image format : .PCX .PCC:ehp2.
  Liest und schreibt Dateien mit 1, 4, 8 und 24 Bit Farbtiefe.
  Untermenge von Ebene/Bits-pro-Ebene-Kombinationen untersttzt.
  Dateien werden unter Verwendung eines run-length Kodierungsschemas geschrieben.
  Mit .PCX-Dateien von ZSoft getestet.
  Komprimierte Bereiche von Pixeln sollten nicht ber Bildzeilen hinausgehen.
  GBM tut dies nie, aber manche anderen Anwendungen verletzen diese Regel.
  Erkennt GBM, da ein Pixelbereich lnger als die Bildzeile ist, verwendet es
  die berzhligen Pixel standardmig fr die nchste Bildzeile.
  Manche Bilder werden nicht ordnungsgemt geladen, da sie erfordern, da das
  ladende Programm die berzhligen Pixel wegfallen lt. Dieses Verhalten kann
  auch bei GBM aktiviert werden.
    Eingabeoption: trunc
:exmp.
:xmp.
:hp2.TIFF : Microsoft/Aldus Tagged Image File Format : .TIF .TIFF:ehp2.
Standardformate (abwrtskompatibel):
  Liest  1 bpp Schwarz/wei- sowie Farbpaletten- und Graustufendateien.
  Liest  2 bpp Farbpaletten- und Graustufendateien und stellt sie mit  4 bpp dar.
  Liest  4 bpp Farbpaletten- und Graustufendateien und stellt sie mit  4 bpp dar.
  Liest  8 bpp Farbpaletten- und Graustufendateien und stellt sie mit  8 bpp dar.
  Liest 16 bpp Farbpaletten- und Graustufendateien und stellt sie mit 24 bpp dar.
  Liest 24 bpp Farbpalettendateien und stellt sie mit 24 bpp dar.
  Liest 32 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 24 bpp dar.
  Liest 48 bpp Farbdateien und stellt sie als 24 bpp dar.
  Liest 64 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 24 bpp dar.
  Liest CMYK-Dateien ( 8 Bit pro Kanal) und stellt sie als 24 bpp RGB dar (nur strip encoded).
  Liest CMYK-Dateien (16 Bit pro Kanal) und stellt sie als 24 bpp RGB dar (nur strip encoded).
 
Erweiterte Formate (nicht abwrtskompatibel, Importoption ext_bpp erforderlich):
  Liest 16 bpp Farbpaletten- und Graustufendateien und stellt sie mit 48 bpp dar (nur strip encoded).
  Liest 32 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 32 bpp dar.
  Liest 48 bpp Farbdateien und stellt sie als 48 bpp dar (nur strip encoded).
  Liest 64 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 64 bpp dar (nur strip encoded).
  Liest CMYK-Dateien (16 Bit pro Kanal) und stellt sie als 48 bpp RGB dar (nur strip encoded).
 
Schreibt RGB-Dateien mit 1, 4, 8, 24, 32 (24 bpp + Alpha), 48, 64 (48 bpp + Alpha) bpp.
 
  Die Tiefe des Alpha-Kanals mu stets der Tiefe smtlicher RGB-Kanle entsprechen.
 
  Untersttzt folgende Kompressionsformate:
  - unkomprimiert
  - LZW
  - PackBits
  - ThunderScan
  - NeXT
  - JPEG
  - CCITT
  - Deflate
  - Adobe Deflate
 
  Eingabe:
 
  Behandlung des Alpha-Kanals:
    Enthlt die Bitmap einen assoziierten Alpha-Kanal (pre-multiplied alpha), so werden
    die Werte der Alpha-Kanle nicht getrennt zurckgegeben. In diesem Fall wird eine
    angegebene Hintergrundfarbe ignoriert.
    Enthlt die Bitmap einen nicht-assoziierten Alpha-Kanal (not pre-multiplied alpha),
    so werden die Alpha-Kanle getrennt zurckgegeben, es sei denn, der Client fordert
    eine Berechnung gegen die angegebene Hintergrundfarbe an.
    Falls die Option ext_bpp nicht angegeben wird und die Bitmap einen nicht-assoziierten
    Alpha-Kanal enthlt, wird der Alpha-Kanal nur gegen die Hintergrundfarbe verrechnet, wenn
    die Hintergrundfarbe vom Client angegeben wurde. Andernfalls werden die Daten des Alpha-Kanals
    ignoriert.
 
  Bild innerhalb von TIFF-Dateien mit mehreren Bildern kann angegeben werden
    Eingabeoption: index=# (Standard: 0)
  Hintergrundfarbe als RGB fr Verrechnung mit Alpha-Kanal kann angegeben werden
  (wird nur bei Bitmaps mit nicht-assoziiertem Alpha-Kanal interpretiert)
    Eingabeoption: back_rgb=#_#_# (red_green_blue, 0..65535)
  Export fr GBM nicht standardmige Farbtiefen (auch mit Alpha-Kanal) kann ermglicht werden
    Eingabeoption: ext_bpp (Standard: bpp wird auf 24 bpp heruntergerechnet)
 
 
  Ausgabe:
 
  Behandlung des Alpha-Kanals:
    GBM ermglicht das Schreiben nicht-assoziierter Alpha-Kanal-Informationen bei 32 und 64 bpp.
    Es kann zudem separat bereitgestellte Alpha-Kanal-Informationen assoziieren, indem
    eine angegebene Hintergrundfarbe mit den RGB-Kanlen vormultipliziert wird (Option back_rgb).
    Wurde der Alpha-Kanal bereits assoziiert (vormultipliziert), sollten beim Schreiben von
    RGB-Bitmaps die Farbtiefen 24 und 48 bpp benutzt werden.
 
  Hintergrundfarbe fr assoziierten Alpha-Kanal kann als RGB angegeben werden
  (der Alpha-Kanal wird in der Bitmap-Datei beibehalten)
    Ausgabeoption: back_rgb=#_#_# (red_green_blue, 0..65535)
  1 bpp kann als nicht-Baseline-Datei unter Erhaltung von Vorder- und Hintergrundfarbe geschrieben werden
  (kann eingesetzt werden, um das Schreiben einer S/W-Bitmap mit Palette zu erzwingen,
   normalerweise werden nicht-S/W-Bitmap automatisch erkannt und es wird ein Bild mit Palette geschrieben)
    Ausgabeoption: pal1bpp
  Spezifische Strip-Gre kann angegeben werden.
    Ausgabeoption: strip_size=# (4,8,16,32,64 kByte, Standard=16)
  LZW-Kompression kann angegeben werden.
    Ausgabeoption: lzw
  LZW-Kompression mit horizontaler Voraussage kann angegeben werden.
    Ausgabeoption: lzw_pred_hor
  Kann PackBits-Kompression abfragen
    Ausgabeoption: packbits
  Deflate-Kompression (Adobe-kompatibles Deflate) kann angefordert werden.
    Ausgabeoption: deflate
  Deflate-Kompressionsstufe kann angegeben werden.
    Ausgabeoption: deflate_comp=# (Standard=6, 1..9, keine Kompression bis Maximum)
  JPEG-Kompression (nur 24 bpp) kann angefordert werden.
    Ausgabeoption: jpeg
  JPEG-Qualittsstufe kann angegeben werden.
    Ausgabeoption: jpeg_quality=# (Standard=75, 0..100)
  CCITT modifizierte Huffman-RLE-Kodierung (nur 1 bpp) kann angefordert werden.
    Ausgabeoption: ccittrle
  CCITT Gruppe-3-Fax-Kodierung (nur 1 bpp) kann angefordert werden.
    Ausgabeoption: ccittfax3
  CCITT Gruppe-4-Fax-Koderung (nur 1 bpp) kann angefordert werden.
    Ausgabeoption: ccittfax4
  Informationskennzeichnungen knnen zum Hinzufgen bei der Ausgabe angegeben werden.
    Ausgabeoptionen: artist=,software=,make=,model=,host=,documentname=,pagename=,imagedescription=
:exmp.
:xmp.
:hp2.Targa : Truevision Targa/Vista bitmap : .TGA .VST .AFI:ehp2.
  Liest smtliche unkomprimierten und run-length-komprimierten Dateien.
  Liest Dateien mit Farbtiefe von 8 und 24 Bit.
  Kann Dateien mit 8-Bit-Graustufen und 8-Bit Farbzuordnung lesen.
  Liest sowohl yup- als auch ydown-Dateien.
  Schreibt unkomprimierte Daten mit 8 Bit oder 16, 24, 32 Bit.
    Ausgabeoptionen: 16,24,32 (Standard: 24)
  8-Bit-Daten werden stets als Datei mit Farbpalette geschrieben.
  Kann veranlat werden, yup- und ydown-Dateien zu schreiben.
    Ausgabeoptionen: ydown,yup (Standard: yup)
:exmp.
:xmp.
:hp2.ILBM : Amiga IFF / ILBM Interleaved bitmap format : .IFF .LBM:ehp2.
  Liest palettisierte Dateien mit 1 Bit.
  Liest palettisierte Dateien mit 2, 3 und 4 Bit und gibt sie mit 4 Bit zurck.
  Liest palettisierte Dateien mit 5, 6, 7 und 8 Bit und gibt sie mit 8 Bit zurck.
  Liest Bilder mit 24 Bit und gibt sie mit 24 bit zurck.
  Liest HAM6-, HAM8-, SHAM- und Extra-Halfbrite-Bilder.
  HAM6, HAM8 und SHAM werden als 24-Bit-Daten zurckgegeben.
  Schreibt palettisierte Dateien mit 1, 4 und 8 Bit Farbtiefe.
  Schreibt 24-Bit-Dateien normal oder mit vorheriger Konvertierung nach HAM6.
  Hierdurch entsteht ein Qualittsverlust, aber das Ergebnis ist immer noch besser
  als bei 8 Bit.
  Erkennt das verwendete RLE-Kompressionsschema.
  Verwendet nur Dateiabschnitte BMHD, CMAP, CAMG und BODY.
  Schreibt nur Dateiabschnitte BMHD, CMAP, CAMG und BODY.
  Positionsinformation im BHMD-Header der Datei kann angegeben werden.
    Ausgabeoptionen: xpos=#,ypos=# (Standard: 0,0).
  In BMHD-Header der Datei zu schreibende transparente Farbe kann angegeben werden.
    Ausgabeoption: transcol=# (Standard: 0)
  In BMHD-Header der Datei zu schreibende Grenverhltnisse knnen angegeben werden.
    Ausgabeoptionen: xaspect=#,yaspect=# (Standard: 1,1).
  In BMHD-Header der Datei zu schreibende Bildschirmgre kann angegeben werden.
    Ausgabeoptionen: xscreen=#,yscreen=# (Standard: Bildgre).
  Kann veranlat werden, 24-bpp-Daten im HAM6-Format zu schreiben.
    Ausgabeoption: ham6
  Beachten Sie, da wenn DeluxePaint usw. versucht, eine 8 Bit IFF-Datei zu laden,
  in einen 32-Farbmodus (5-Bit-Modus) umgeschaltet wird und nur die 5 letzten
  signifikanten Ebenen der Datei gelesen werden - dies sieht i.a. eklig aus!
  Mit DeluxePaint Beispiel-Bitmaps getestet.
:exmp.
:xmp.
:hp2.YUV12C : YUV12C M-Motion Frame Buffer : .VID:ehp2.
  Liest Dateien und stellt Daten als 24-Bit-Daten dar.
  Schreibt 24-Bit-Datendateien durch Konvertierung in 12-Bit-YUV.
  VID-Dateien MSSEN ein Vielfaches von 4 Pixeln breit sein.
  Werden nicht Vielfache von 4 geschrieben, gehen die letzten 1, 2 oder 3 Pixels verloren.
  Information zu Bildherkunft im YUV12C-Header kann angegeben werden.
    Ausgabeoptionen: xpos=#,ypos=# (Standard: 0,0).
  Mit M-Control Program 2.0, einer Browser-Beispielanwendung, getestet.
:exmp.
:xmp.
:hp2.Greymap : Portable Greyscale-map (binrer P5-Typ) : .PGM:ehp2.
  Dank fr das Dateiformat geht an Jef Poskancer.
  Dateiformat enthlt keine Palette.
  Liest 8-Bit-Graustufendateien.
  Schreibt rote, grne und blaube Ebene oder Graustufenquivalent eines 8-Bit-Bildes.
    Ausgabeoptionen: r,g,b,k (Standard: k)
:exmp.
:xmp.
:hp2.PNG : Portable Network Graphics Format : .PNG:ehp2.
 
Standardformate (abwrtskompatibel):
  Liest  1 bpp Schwarz/Wei- und Farbpaletten/Graustufen-Dateien.
  Liest  2 bpp Farbpaletten- und Graustufendateien und stellt sie als  4 bpp dar.
  Liest  4 bpp Farbpaletten- und Graustufendateien und stellt sie als  4 bpp dar.
  Liest  8 bpp Farbpaletten- und Graustufendateien und stellt sie als  8 bpp dar.
  Liest 16 bpp Graustufendateien und stellt sie als 24 bpp dar.
  Liest 32 bpp Graustufendateien (16 Bit grau + Alpha-Kanal) und stellt sie als 24 bpp dar.
  Liest 24 bpp Farbdateien und stellt sie als 24 bpp dar.
  Liest 32 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 24 bpp dar.
  Liest 48 bpp Farbdateien und stellt sie als 24 bpp dar.
  Liest 64 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 24 bpp dar.
 
Erweiterte Formate (nicht abwrtskompatibel, Importoption ext_bpp erforderlich):
  Liest 16 bpp Graustufendateien und stellt sie als 48 bpp dar.
  Liest 32 bpp Graustufendateien (16 Bit grau + Alpha-Kanal) und stellt sie als 64 bpp dar.
  Liest 32 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 32 bpp dar.
  Liest 48 bpp Farbdateien und stellt sie als 48 bpp dar.
  Liest 64 bpp Farbdateien (RGB + Alpha-Kanal) und stellt sie als 64 bpp dar.
 
Schreibt 1, 4, 8, 24, 32 (24 bpp + Alpha), 48, 64 (48 bpp + alpha) bpp RGB-Dateien.
 
  Die Farbtiefe des Alpha-Kanal mu stets der aller RGB-Kanle entsprechen.
 
  Eingabe:
 
  Handling of Alpha-Kanal:
    PNG-Alpha-Kanal ist stets nicht-assoziiert (kein pre-multiplied Alpha).
    Der Alpha-Kanal wird getrennt zurckgegeben, es sei denn, der Client fordert
    eine Berechnung gegen die angegebene Hintergrundfarbe an.
    Falls die Option ext_bpp nicht angegeben wird und die Bitmap einen Alpha-Kanal
    enthlt, wird der Alpha-Kanal nur gegen die Hintergrundfarbe verrechnet, wenn
    die Hintergrundfarbe vom Client angegeben wurde oder durch die Bitmap
    bereitgestellt wird. Andernfalls werden die Daten des Alpha-Kanals ignoriert.
 
  Bildschirmgamma kann angegeben werden.
    Eingabeoption: gamma=# (Standard=2.2)
  Standardhintergrundfarbe kann zur Verwendung mit allen Bildtypen als RGB angegeben werden
  (ist mit der Bitmap ein Hintergrund assoziiert, wird er durch die angegebene Farbe ersetzt).
    Eingabeoption: back_rgb=#_#_# (red_green_blue, 0..65535)
  Durch Bitmap bereitgestellter Hintergrund kann ignoriert werden
  (ntzlich, wenn der Alpha-Kanal beibehalten und die Bitmap von der Anwendung gegen einen
   Hintergrund mit Textur gerechnet werden soll)
    Eingabeoption: ignore_back
 
 
  Ausgabe:
 
  Behandlung des Alpha-Kanals:
    GBM ermglicht das Schreiben nicht-assoziierter Alpha-Kanal-Informationen bei 32 und 64 bpp.
    Wurde der Alpha-Kanal bereits assoziiert (vormultipliziert), sollten beim Schreiben von
    RGB-Bitmaps die Farbtiefen 24 und 48 bpp benutzt werden.
    Wird ein vollstndiger Alpha-Kanal bereitgestellt, kann Transparenz nicht zustzlich hinzugefgt werden.
 
  Interlaced PNGs (praktisch fr HTML) knnen geschrieben werden
    Ausgabeoption: ilace
  Benutzerdefinierte Bildgamma kann geschrieben werden.
    Ausgabeoption: gamma=#
  Hintergrundfarbenindex fr Farbpaletten/Graustufenbilder kann zum Schreiben in PNG-Header der Datei
  angegeben werden (Alpha-Kanal wird in der Bitmap-Datei beibehalten)
    Ausgabeoption: back_index=#
  Hintergrundfarbe kann fr RGB-Bilder als RGB zum Schreiben in PNG-Header der Datei angegeben werden.
  (Alpha-Kanal wird in der Bitmap-Datei beibehalten)
    Ausgabeoption: back_rgb=#_#_# (red_green_blue, 24/32 bpp: 0..255, 48/64 bpp: 0..65535)
  Transparenz fr palettisierte Bilder kann zum Schreiben in PNG-Header der Datei angegeben werden
  (nur bei Bitmaps ohne Alpha-Kanal)
    Ausgabeoption: transparency=#  (0..255, undurchsichtig..transparent)
  Transparente Farbe kann bei RGB-Bildern zum Schreiben in PNG-Header der Datei angegeben werden
  (nur bei Bitmaps ohne Alpha-Kanal)
    Ausgabeoption: transcol_rgb=#_#_# (red_green_blue, 24/32 bpp: 0..255, 48/64 bpp: 0..65535)
  Kompressionsstufe kann angegeben werden
    Ausgabeoption: compression=# (Standard=6, 0..9, keine Kompression bis Maximum)
:exmp.
:xmp.
:hp2.Pixmap : Portable Pixel-map (binrer P6-Typ) : .PPM:ehp2.
Standardformate (abwrtskompatibel):
  Liest unpalettisierte RGB-Dateien mit 24 bpp.
  Liest unpalettisierte RGB-Dateien mit 48 bpp und stellt sie als 24 bpp dar.
 
Erweiterte Formate (nicht abwrtskompatibel, Importoption ext_bpp erforderlich):
  Liest 48 bpp unpalettisierte RGB-Dateien und stellt sie als 48 bpp dar.
 
Schreibt unpalettisierte RGB-Dateien mit 24 und 48 bpp.
 
  Bild innerhalb PPM-Datei mit mehreren Bildern kann angegeben werden.
    Eingabeoption: index=# (Standard: 0)
  Exportieren einer fr GBM nicht standardmigen Farbtiefe kann angegben werden (48 bpp)
    Eingabeoption: ext_bpp (Standard: bpp wird auf 24 bpp heruntergerechnet)
:exmp.
:xmp.
:hp2.KIPS : IBM KIPS : .KPS:ehp2.
  Liest palettisierte 8-Bit-Dateien.
  Sucht in .PAL-Datei nach Palette, wenn keine .KPL-Datei angegeben wurde.
    Eingabeoptionen: pal,kpl (Standard: pal)
  Schreibt palettisierte 8-Bit-Dateien.
  Schreibt Palette in .PAL-Datei, wenn keine .KPL-Datei angegeben wurde.
    Ausgabeoptionen: pal,kpl (Standard: pal)
:exmp.
:xmp.
:hp2.IAX : IBM Image Access eXecutive : .IAX:ehp2.
  Liest Array als 8-Bit-Graustufen.
  Dateiformat enthlt keine Bilddimensionen.
  Daher wird davon ausgegangen, da die Breite 512 Pixels betrgt, wenn nicht anders angegeben.
    Eingabeoptionen: width=# (Standard: 512)
  Dateiformat enthlt keine Palette.
  Schreibt rote, grne und blaue Ebene oder Graustufenquivalent eines 8-Bit-Bildes.
    Ausgabeoptionen: r,g,b,k (Standard: k)
:exmp.
:xmp.
:hp2.XBitmap : X Windows bitmap : .XBM:ehp2.
  Liest 1bpp X-Bitmaps, stellt 1-en als schwarz und 0-en als wei dar.
  Schreibt 1bpp X-Bitmaps, dunkelste Farbe als 1-en, hellste Farbe als 0-en.
  Mit einigen Beispiel-.XBM-Dateien getestet.
:exmp.
:xmp.
:hp2.Sprite : Archimedes Sprite-Format von RiscOS : .SPR .SPRITE:ehp2.
  Genaugenommen besitzen Sprite-Dateien keine Erweiterung.
  GBM erkennt der Bequemlichkeit halber aber .SPR und .SPRITE.
  Liest 1-, 4- und 8-Bit-Sprites.
  Wert fr 'First bit' im Header mu ein Vielfaches von 8 betragen (sehr wahrscheinlich).
  Liest nur Bildebene, smtliche Maskenebenen werden ignoriert.
  Kommt mit Fehlen von Palette in Datei zurecht.
  Verwendet in diesem Fall Wimp-Standardpalette.
  Sprite kann ausgewhlt werden, falls Eingabe mehrere enthlt.
    Eingabeoptionen: index=# (Standard: 0)
  Gibt Dateien mit 1, 4 und 8 Bit aus.
  Schreibt eine Palette in die Datei.
  Schreibt nur Bildebene, also keine Maskenebene.
  Schreibt eine Palette mit 16 Eintrgen fr 8-Bit-Daten (keine 64 Eintrge).
  Fhrt beim Schreiben von 8-Bit-Daten Zuordnung auf seltsame Archimedes-Palette durch.
  Lesen von 4bpp-Sprites ohne Palette getestet.
  Lesen von 8bpp-Sprites ohne Palette und mit Palette mit 64 Eintrgen getestet.
  Von GBM erzeugte Sprites wurden unter RiscOS geladen.
  Achtung: SetType zum ndern des Typs von PC-Datei nach Sprite verwenden,
  indem Option SetType des Filer-Mens oder "*SetType <filename> Sprite" benutzt wird.
:exmp.
:xmp.
:hp2.PSEG : IBM Druckseitensegment : .PSE .PSEG .PSEG38PP .PSEG3820:ehp2.
  Dieses Dateiformat wird von IBM Dokument/Drucksystemen verwendet.
  Wird zur Darstellung in Dokumenten benutzter bi-level-Bilder verwendet.
  Liest Daten und stellt eine 1bpp-Bitmap dar.
  Bild stellt 1-en als schwarz auf weiem Hingergrund aus 0-en dar.
  PSEG-Dateien sollten von einem VM-Host im Binrmodus bertragen werden.
  Manche PSEG-Dateien besitzen eine defekte Datensatzstruktur.
  Dies stellt unter VM kein Problem dar, kann aber nicht-VM-Leser verwirren.
  GBM kann dazu berredet werden, sich an diesen Dateien zu versuchen.
    Eingabeoption: fixrec
  Gibt 1bpp-Datei aus.
  Gibt Datei mit Skalierungsfaktor 1000 aus.
  Fr x und y kann neue Skala angegeben werden.
    Ausgabeoptionen: scalex=#, scaley=#
  Skalierungsfaktor kann verdoppelt werden (Option fr Abwrtskompatibilitt).
    Ausgabeoption: double
  Schreibt Datei mit pel-Werten von 2400 (Punkte pro 10 Inch, d.h.: 240 dpi).
  Fr x und y knnen neue pel-Werte angegeben werden.
    Ausgabeoptionen: pelx=#, pely=#
  Paletten in 1bpp-Daten gehen beim Schreiben der Datei verloren.
  Resultierende nicht-VM-Datei besitzt keine Datensatzstruktur.
  Beim Hochladen mu sie also mit FIXL3820 EXEC oder hnlichem korrigiert werden.
  Bildbreite wird beim Schreiben auf das nchste Vielfache von 8 gerundet.
:exmp.
:xmp.
:hp2.GemRas : GEM Raster : .IMG:ehp2.
  Grundlegende Untersttzung und verschiedene XIMG-Erweiterungen vorhanden.
  Eine Erweiterung ist Inhalt von Paletteninformation.
  Weitere erlaubt Plazierung von 24-bpp-Daten in .IMG-Datei.
  Liest 1-bpp-Dateien (schwarz/wei) und gibt 1-bpp-Daten zurck.
  Liest 2- ,3- und 4-bpp-Dateien (farbig, grau, XIMG mit Palette) und gibt 4 bpp zurck.
  Liest 5,6,7 and 8 bpp files (grau, XIMG mit Palette) und gibt 8 bpp zurck.
  Liest 24-bpp-Dateien (laut Definition XIMG) und gibt 24 bpp zurck.
  Schreibt 1-bpp-Daten als schwarz/weie 1-bpp-Datei.
  Schreibt 4-bpp-Daten mit Zuordnung zu "standardisierter" 16-Farbpalette
  oder als 4-bpp-Graustufendatei.
    Ausgabeoption: grey
  Oder schreibt 4-bpp-Daten als XIMG-Datei mit Palette.
    Ausgabeoption: pal
  Fr Dateien mit 256 Farben exisitiert keine Standardpalette.
  Schreibt 8-bpp-Daten als 8-bpp-Graustufendatei.
  Oder schreibt 8 bpp in XIMG-Datei mit Palette.
    Ausgabeoption: pal
  Schreibt 24-bpp-Daten als XIMG-Datei (normale Dateien knnen keine 24 bpp).
  Die Punktausmae in Micron knnen angegeben werden..
    Ausgabeoptionen: pixw=#,pixh=# (Standards: 85,85)
:exmp.
:xmp.
:hp2.Portrait : Portrait : .CVP:ehp2.
  In Deutschland bergeben Photographen manchmal Disketten mit einer .CVP-Datei.
  Die Datei enthlt ein einzelnes 24bpp-RGB-Bild mit einer Gre von 512x512.
  Die Datei ist unkomprimiert und daher stets 3/4MB gro.
  Mit diesem Format knnen nur Bilder der Gre 512x512 geschrieben werden.
  Die Pixel in der Datei sind nicht quadratisch, die Breite betrgt etwa 3/4 der Hhe.
  Beim Lesen und Schreiben wird auf dieses Grenverhltnisproblem keine Rcksicht genommen.
:exmp.
:xmp.
:hp2.JPEG : JPEG-Dateiaustauschformat : .JPG .JPEG .JPE:ehp2.
  Kann Dateien mit 8 bpp (Graustufen) und 24 bpp schreiben.
  Kann 24-bpp-Daten in Datei schreiben.
  Kann mit unterschiedlichen Qualittsgraden schreiben.
    Ausgabeoption: quality=# (Bereich 0 bis 100, Standard 75)
  Kann progressive JPEGs schreiben.
    Ausgabeoption: prog
:exmp.
:p.:hp2.Weitere Hinweise:ehp2.
:p.Fr die Nutzung mit Maul Publisher wurde GBM um Untersttzung fr folgende
Funktionen erweitert&colon.-
:ul.
:li.Untersttzung fr Mehrsprachigkeit unter Verwendung von msgc. Ermglicht die Verwendung verschiedener Sprachen
in den beschreibenden Teilen der GBM-Dateiformate. ndert die Struktur GBMFT.
:li.Dateierweiterungen knnen durch Semikolon getrennt werden, z.B. '*.bmp;*.dib;*.rle'.
Hierdurch knnen Dateitypen in einem grafischen Datei-ffnen-Dialog im Windows-Stil ausgewhlt werden.
:li.GBM wurde eine Funktion zur Ermittlung der Bildanzahl hinzugefgt, damit in einem Dialog das
erforderliche Bild ausgewhlt werden kann. ndert die Struktur GBMFT. Fgt der Listenstruktur der
Funktion FT in gbm.c eine neue Funktion hinzu.
:li.Der GBM-Struktur wurde ein Wert 'cs' als Indikator fr Farbkodierung hinzugefgt.
Gibt den Wert ulCompression fr Bitmaps und 'color_space' fr JPEGs zurck. Infolgedessen
:hp1.sollten:ehp1. CMYK-kodierte JPEG-Bilder untersttzt werden. Weitere Kodierungen knnten
untersttzt werden, wenn jemand Code-Beispiele oder Erklrungen dazu einreicht, wie man
dies erzielen kann. Zu den fehlenden Kodierungen gehren JPEG
Y/Cb/Cr (auch als YUV bekannt), JPEG Y/Cb/Cr/K sowie RLE- und HUFFMAN1D-Bitmaps.
:eul.
:p.Der modifizierte GBM-Quellcode ist auf Anfrage erhltlich. Aus Platzgrnden ist er nicht Teil der Distribution
des Maul Publisher.
.br
.br
:euserdoc.
