/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.rmi.RemoteException;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;
import mmguiclient.MMgraphFrame;
import mmguiclient.MMgraphPanel;
import mmguiclient.MMimageResource;
import mmguiclient.MMwindowListener;

public class MMgraph
extends Frame
implements IParameters,
ComponentListener {
    MMgraphPanel m_gPanel;
    MMgraphFrame m_gFrame;
    MMFrame m_frame;
    static final int PANEL_WIDTH = 600;
    static final int PANEL_HEIGHT = 400;
    static final int GRAPH_HEIGHT = 340;
    static final int WIDTH = 680;
    static final int FRAME_HEIGHT = 460;
    static final int INFO_WIDTH = 140;
    static final String ICON = "logo.gif";
    int m_panelWidth;
    int m_panelHeight;
    int m_graphHeight;
    double m_yFactor;
    double m_xFactor;
    int[] m_x;
    int[] m_y;
    double[] m_z;
    double m_xmin;
    double m_xmax;
    double m_ymin;
    double m_ymax;

    public MMgraph(MMFrame mMFrame) {
        this.setLayout(null);
        this.addNotify();
        this.m_frame = mMFrame;
        this.addWindowListener(new MMwindowListener());
        Insets insets = this.getInsets();
        ((Component)this).setSize(680, 460 + insets.top + insets.bottom);
        ((Component)this).setBackground(IParameters.BACKGROUND_COLOR);
        try {
            this.setIconImage(new MMimageResource().getImage(ICON));
        }
        catch (Exception exception) {}
        this.m_gFrame = new MMgraphFrame(this);
        this.m_gFrame.setBounds(0, insets.top, 680, 460);
        this.add(this.m_gFrame);
        this.m_gFrame.setLayout(null);
        this.m_gPanel = new MMgraphPanel();
        this.m_gFrame.add(this.m_gPanel);
        this.m_gPanel.setBounds(40, 30, 600, 400);
        this.m_gPanel.setBackground(IParameters.WHITE);
        ((Component)this).setVisible(false);
        this.m_panelWidth = 600;
        this.m_graphHeight = 340;
        this.addComponentListener(this);
        this.m_x = new int[this.m_panelWidth];
        this.m_y = new int[this.m_panelWidth];
    }

    public Dimension getMinimumSize() {
        return new Dimension(240, 240);
    }

    public void plot(double[] dArray) {
        try {
            if (dArray == null) {
                return;
            }
            this.m_z = dArray;
            this.getMinMax();
            this.m_yFactor = Math.abs(this.m_ymax - this.m_ymin);
            this.m_xFactor = 1.0;
            this.m_yFactor = this.m_yFactor == 0.0 ? 1.0 : (double)this.m_graphHeight / this.m_yFactor;
            if (this.m_x.length != this.m_panelWidth) {
                this.m_x = new int[this.m_panelWidth];
                this.m_y = new int[this.m_panelWidth];
            }
            int n = 0;
            while (n < this.m_panelWidth) {
                this.m_x[n] = n;
                this.m_y[n] = 30 + (int)((this.m_ymax - this.m_z[n + 2]) * this.m_yFactor);
                ++n;
            }
            this.m_gPanel.setXY(this.m_x, this.m_y);
            this.m_gPanel.invalidate();
            this.m_gPanel.repaint();
            this.m_gFrame.setXTicks(this.m_xmin, this.m_xmax);
            this.m_gFrame.setYTicks(this.m_ymin, this.m_ymax);
            this.m_gFrame.setInfo();
            this.m_gFrame.invalidate();
            this.m_gFrame.repaint();
            this.repaint();
            ((Component)this).setVisible(true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void printGraph() {
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Log", null);
        Graphics graphics = printJob.getGraphics();
        this.print(graphics);
        graphics.dispose();
        printJob.end();
    }

    public void print(Graphics graphics) {
        graphics.setFont(this.m_gFrame.getFont());
        this.m_gFrame.layOut(graphics, false);
        Rectangle rectangle = this.m_gPanel.getBounds();
        graphics.setColor(IParameters.BLACK);
        graphics.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 2, rectangle.height + 3);
        graphics.translate(rectangle.x, rectangle.y);
        this.m_gPanel.layOut(graphics);
        graphics.drawString(String.valueOf(this.getTitle()) + "     " + this.m_gFrame.m_info.getText(), 0, rectangle.height + 60);
    }

    public int getNumPoints() {
        return this.m_panelWidth;
    }

    void getMinMax() throws RemoteException {
        this.m_ymax = 0.0;
        this.m_ymin = 0.0;
        if (!Double.isNaN(this.m_z[2])) {
            this.m_ymin = this.m_ymax = this.m_z[2];
        }
        int n = 2;
        while (n < this.m_z.length) {
            if (Double.isNaN(this.m_z[n])) {
                this.m_z[n] = 0.0;
                this.m_frame.showWarning(this.m_frame.m_server.getMessage());
            }
            if (this.m_z[n] < this.m_ymin) {
                this.m_ymin = this.m_z[n];
            }
            if (this.m_z[n] > this.m_ymax) {
                this.m_ymax = this.m_z[n];
            }
            ++n;
        }
        this.m_xmin = this.m_z[0];
        this.m_xmax = this.m_z[1];
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.sizeAll();
        if (this.m_x != null) {
            this.transform();
            this.m_gPanel.setXY(this.m_x, this.m_y);
            this.m_gPanel.invalidate();
            this.m_gFrame.setXTicks(this.m_xmin, this.m_xmax);
            this.m_gFrame.setYTicks(this.m_ymin, this.m_ymax);
            this.m_gFrame.setInfo();
        }
        this.m_gFrame.invalidate();
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    void transform() {
        if (this.m_z == null) {
            return;
        }
        int n = this.m_x.length;
        this.m_xFactor = (double)this.m_panelWidth / (double)n;
        int n2 = 0;
        while (n2 < n) {
            this.m_x[n2] = (int)((double)n2 * this.m_xFactor);
            ++n2;
        }
        this.yTransform();
    }

    void yTransform() {
        if (this.m_z == null) {
            return;
        }
        this.m_yFactor = Math.abs(this.m_ymax - this.m_ymin);
        this.m_yFactor = this.m_yFactor == 0.0 ? 1.0 : (double)this.m_graphHeight / this.m_yFactor;
        int n = this.m_x.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_y[n2] = 30 + (int)((this.m_ymax - this.m_z[n2 + 2]) * this.m_yFactor);
            ++n2;
        }
    }

    void sizeAll() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (dimension.height < dimension2.height) {
            ((Component)this).setSize(dimension.width, dimension2.height);
            return;
        }
        if (dimension.width < dimension2.width) {
            ((Component)this).setSize(dimension2.width, dimension.height);
            return;
        }
        Insets insets = this.getInsets();
        this.m_panelWidth = dimension.width - 80;
        int n = dimension.height - insets.top - insets.bottom;
        int n2 = n - 60;
        this.m_graphHeight = n2 - 60;
        this.m_gFrame.setBounds(0, insets.top, dimension.width, n);
        this.m_gPanel.setBounds(40, 30, this.m_panelWidth, n2);
        this.m_gFrame.m_info.setBounds(0, 7, dimension.width - 4, 15);
    }
}

