/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import eserver.IEngineClient;
import eserver.IEngineServer;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Locale;
import java.util.ResourceBundle;
import mmguiclient.IParameters;
import mmguiclient.MManimation;
import mmguiclient.MMbrowser;
import mmguiclient.MMcommandListener;
import mmguiclient.MMcomputer;
import mmguiclient.MMconstpad;
import mmguiclient.MMfield;
import mmguiclient.MMfileDialog;
import mmguiclient.MMfuncpad;
import mmguiclient.MMgraph;
import mmguiclient.MMhint;
import mmguiclient.MMhistoryList;
import mmguiclient.MMhost;
import mmguiclient.MMimageResource;
import mmguiclient.MMini;
import mmguiclient.MMkeypad;
import mmguiclient.MMlist;
import mmguiclient.MMlog;
import mmguiclient.MMlogo;
import mmguiclient.MMlogoThread;
import mmguiclient.MMmacroDialog;
import mmguiclient.MMmacroManager;
import mmguiclient.MMmenu;
import mmguiclient.MMoperpad;
import mmguiclient.MMpicture;
import mmguiclient.MMplotter;
import mmguiclient.MMprecisionBox;
import mmguiclient.MMquit;
import mmguiclient.MMresult;
import mmguiclient.MMtoolbar;
import mmguiclient.MMwatcher;
import mmguiclient.MMwindowListener;
import structures.MacroList;
import tokens.Macro;

public abstract class MMFrame
extends Frame
implements IEngineClient,
IParameters,
FocusListener,
WindowListener,
ActionListener,
ItemListener {
    int m_left;
    int m_top;
    static final int MAIN_GAP = 8;
    static final int WIDE_GAP = 20;
    static final int FIELD_HEIGHT = 28;
    static final int FIELD_WIDTH = 108;
    static final int FIELD_X = 8;
    static final int UP_Y = 4;
    static final int PIC_X = 20;
    static final int PIC_Y = 36;
    static final int PIC_WIDTH = 50;
    static final int PIC_HEIGHT = 66;
    static final int LO_Y = 106;
    static final int FUNCPAD_X = 8;
    static final int FUNCPAD_Y = 138;
    static final int PBOX_X = 219;
    static final int PBOX_Y = 138;
    static final int RWINDOW_X = 219;
    static final int RWINDOW_Y = 362;
    static final int RWINDOW_WIDTH = 266;
    static final int PRECBOX_X = 505;
    static final int PRECBOX_Y = 114;
    static final int OPERPAD_X = 505;
    static final int OPERPAD_Y = 166;
    static final int KEYPAD_X = 505;
    static final int KEYPAD_Y = 266;
    static final int CONSTPAD_X = 8;
    static final int CONSTPAD_Y = 375;
    static final int HEIGHT = 468;
    static final int WIDTH = 689;
    static final int INPUT_X = 90;
    static final int INPUT_Y = 51;
    static final int INPUT_WIDTH = 591;
    static final int START_WIDTH = 94;
    static final int START_X = 305;
    static final int START_Y = 95;
    static final int RWINDOW_HEIGHT = 78;
    MMmenu m_menu;
    MMpicture m_picture;
    MMfield m_inputLine;
    MMfield m_loLimit;
    MMfield m_upLimit;
    MMfield m_focusHolder;
    MMlist m_list;
    MMwindowListener m_windowListener;
    MMlog m_log;
    MMkeypad m_keypad;
    MMfuncpad m_funcpad;
    MMprecisionBox m_precisionBox;
    MMcommandListener m_commandListener;
    MMtoolbar m_toolbar;
    MMhint m_hint;
    Button m_start;
    TextArea m_resultWindow;
    MMplotter m_plotter;
    MMgraph m_graph;
    MMlogo m_logo;
    Image[] m_animImage;
    MManimation m_animation;
    boolean m_macroFlag;
    boolean m_macroSavedFlag;
    MMmacroManager m_macroManager;
    MMini m_ini;
    MMwatcher m_watcher;
    MMcomputer m_computer;
    MMhistoryList m_hList;
    String m_host;
    String m_browser;
    boolean m_hintFlag;
    IEngineServer m_server;
    boolean m_thinking;
    String m_expression;
    String[] m_expressions;
    ResourceBundle m_resource;
    static String s_start;
    static String s_stop;
    static String s_interrupted;
    static String s_record;
    static String s_open;
    static String s_save;
    static String s_view;
    static String s_export;
    static String s_import;
    static String s_printLog;
    static String s_printGraph;
    static String s_saveAs;
    static String s_about;
    static String s_host;
    static String s_browser;
    static String s_help;
    static String s_cut;
    static String s_copy;
    static String s_paste;
    static String s_history;
    static String s_exit;
    static String s_clearHistory;
    static String s_saveSettings;
    protected int m_connectionType;
    public int m_os;

    static int getOS() {
        String string = System.getProperty("os.name");
        if (string.indexOf("Windows NT") > -1) {
            return 1;
        }
        if (string.indexOf("Windows 95") > -1) {
            return 3;
        }
        if (string.indexOf("AIX") > -1) {
            return 4;
        }
        if (string.indexOf("HP-UX") > -1) {
            return 5;
        }
        if (string.indexOf("Solaris") > -1) {
            return 6;
        }
        return 0;
    }

    void getActionStrings() {
        s_start = this.m_resource.getString("start");
        s_stop = this.m_resource.getString("stop");
        s_interrupted = this.m_resource.getString("interrupted");
        s_record = this.m_resource.getString("record");
        s_open = this.m_resource.getString("open");
        s_save = this.m_resource.getString("save");
        s_view = this.m_resource.getString("view");
        s_export = this.m_resource.getString("export_macro");
        s_import = this.m_resource.getString("import_macro");
        s_printLog = this.m_resource.getString("print_log");
        s_printGraph = this.m_resource.getString("print_graph");
        s_saveAs = this.m_resource.getString("save_as");
        s_about = this.m_resource.getString("about");
        s_host = this.m_resource.getString("host_name");
        s_browser = this.m_resource.getString("browser");
        s_help = this.m_resource.getString("help");
        s_cut = this.m_resource.getString("cut");
        s_copy = this.m_resource.getString("copy");
        s_paste = this.m_resource.getString("paste");
        s_history = this.m_resource.getString("history");
        s_exit = this.m_resource.getString("exit");
        s_clearHistory = this.m_resource.getString("clear_history");
        s_saveSettings = this.m_resource.getString("save_settings");
    }

    public MMFrame() {
        this("");
    }

    public MMFrame(String string) {
        this(string, "");
    }

    public MMFrame(String string, String string2) {
        this(string, string2, 2);
    }

    public MMFrame(String string, String string2, int n) {
        Object object;
        boolean bl = false;
        this.m_connectionType = n;
        this.m_resource = ResourceBundle.getBundle("mmguiclient.Resource", Locale.getDefault());
        this.m_os = MMFrame.getOS();
        if (this.m_os == 6 || this.m_os == 5) {
            bl = true;
        }
        this.setLayout(null);
        this.addNotify();
        ((Component)this).setBackground(IParameters.BACKGROUND_COLOR);
        this.m_menu = new MMmenu(this);
        this.setMenuBar(this.m_menu);
        try {
            this.setIconImage(new MMimageResource().getImage("logo.gif"));
        }
        catch (Exception exception) {}
        Insets insets = this.getInsets();
        this.m_left = insets.left;
        this.m_top = insets.top;
        ((Component)this).setSize(this.m_left + insets.right + 689, this.m_top + insets.bottom + 468);
        try {
            object = this.getParent().getBounds();
            Rectangle rectangle = this.getBounds();
            ((Component)this).setLocation(((Rectangle)object).x + (((Rectangle)object).width - rectangle.width) / 2, ((Rectangle)object).y + (((Rectangle)object).height - rectangle.height) / 2);
        }
        catch (Exception exception) {
            ((Component)this).setLocation(100, 60);
        }
        this.m_logo = new MMlogo(this);
        object = new MMlogoThread(this);
        ((Thread)object).start();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        this.getActionStrings();
        this.m_commandListener = new MMcommandListener(this);
        this.m_inputLine = new MMfield(this);
        ((Component)this.m_inputLine).setBackground(IParameters.WHITE);
        int n2 = 51;
        int n3 = 28;
        if (bl) {
            n2 -= 2;
            n3 += 4;
        }
        this.addit(this.m_inputLine, 90, n2, 591, n3);
        this.m_inputLine.addActionListener(this.m_commandListener);
        n2 = 106;
        if (bl) {
            n2 -= 2;
        }
        this.m_loLimit = new MMfield(this);
        this.m_loLimit.setVisible(false);
        ((Component)this.m_loLimit).setBackground(IParameters.WHITE);
        this.addit(this.m_loLimit, 8, n2, 108, n3);
        n2 = 4;
        if (bl) {
            n2 -= 2;
        }
        this.m_upLimit = new MMfield(this);
        this.m_upLimit.setVisible(false);
        ((Component)this.m_upLimit).setBackground(IParameters.WHITE);
        this.addit(this.m_upLimit, 8, n2, 108, n3);
        this.m_start = new Button(this.m_resource.getString("start"));
        this.m_start.setBackground(IParameters.BACKGROUND_COLOR);
        this.addit(this.m_start, 305, 95, 94, 26);
        this.m_start.addActionListener(this);
        this.m_precisionBox = new MMprecisionBox(this);
        this.addit(this.m_precisionBox, 505, 114, 175, 44);
        this.m_list = new MMlist(this);
        this.addit(this.m_list, 219, 138, 266, MMlist.m_height);
        this.m_picture = new MMpicture(this, IParameters.PICTURE[0]);
        this.addit(this.m_picture, 20, 36, 50, 66);
        this.m_macroManager = new MMmacroManager();
        this.m_funcpad = new MMfuncpad(this);
        this.addit(this.m_funcpad, 8, 138, 191, 229);
        MMconstpad mMconstpad = new MMconstpad(this);
        this.addit(mMconstpad, 8, 375, 191, 65);
        MMoperpad mMoperpad = new MMoperpad(this);
        this.addit(mMoperpad, 505, 166, 175, 92);
        this.m_keypad = new MMkeypad(this);
        this.addit(this.m_keypad, 505, 266, 176, 173);
        MMresult mMresult = new MMresult(this);
        n2 = MMlist.m_height - 216;
        this.addit(mMresult, 219, 362 + n2, 266, 78 - n2);
        this.m_resultWindow = mMresult.m_resultWindow;
        this.m_resultWindow.addFocusListener(this);
        this.m_toolbar = new MMtoolbar(this);
        this.addit(this.m_toolbar, 689 - MMtoolbar.WIDTH, 4, MMtoolbar.WIDTH, 28);
        this.m_hint = new MMhint(this);
        this.m_hintFlag = false;
        ((TextComponent)this.m_inputLine).setText(string);
        this.m_inputLine.requestFocus();
        this.m_focusHolder = this.m_inputLine;
        this.m_log = new MMlog(this);
        this.m_thinking = false;
        if (string2 == null) {
            this.m_host = "P150";
        } else {
            this.m_host = string2;
            this.m_menu.m_host.setEnabled(!this.m_host.equals(""));
        }
        this.m_expressions = new String[3];
        this.m_hList = new MMhistoryList();
        this.m_windowListener = new MMwindowListener();
        this.addWindowListener(this);
        this.m_browser = null;
        this.getBrowser();
        this.setResizable(false);
        this.m_graph = new MMgraph(this);
        this.m_macroFlag = false;
        this.m_macroSavedFlag = true;
        this.m_ini = new MMini(this);
        this.m_menu.m_autoSave.addItemListener(this.m_ini);
        this.m_ini.load();
    }

    void addit(Component component, int n, int n2, int n3, int n4) {
        component.setBounds(this.m_left + n, this.m_top + n2, n3, n4);
        this.add(component);
    }

    public abstract void startWatching();

    public String getHost() {
        return this.m_host;
    }

    int getSystem() {
        return this.m_menu.getSystem();
    }

    public int getPrecision() {
        return this.m_precisionBox.getPrecision();
    }

    int getMode() {
        return this.m_toolbar.getMode();
    }

    void resetMacros() throws Exception {
        this.showInfo(this.m_resource.getString("verifying"));
        this.m_server.setMacros(null);
        this.m_macroManager.verifyMacros();
        this.show(this.m_resource.getString("ready"));
        this.m_funcpad.processMacros();
        String[] stringArray = this.m_macroManager.getMacroList().toStrings();
        this.m_server.logMacros(stringArray);
        this.m_log.update();
        this.show("");
    }

    void setMode(int n) {
        if (n < 6) {
            this.endMacroMode();
        }
        if (n > 0) {
            this.m_upLimit.setVisible(true);
            if (n < 6) {
                this.m_loLimit.setVisible(true);
            } else {
                this.m_loLimit.setVisible(false);
            }
        } else {
            this.m_upLimit.setVisible(false);
            this.m_loLimit.setVisible(false);
        }
        this.m_hList.cleanup();
        this.m_list.changeMode(n);
        this.m_inputLine.requestFocus();
        this.m_focusHolder = this.m_inputLine;
        this.m_picture.display(IParameters.PICTURE[n]);
        if (n == 6) {
            this.setMacroMode();
        }
        if (this.m_focusHolder != null) {
            this.m_inputLine.requestFocus();
        }
    }

    void setMacroMode() {
        this.m_macroFlag = true;
        this.m_watcher.suspend();
        if (this.m_animImage == null) {
            this.m_animation = new MManimation(this, this.m_resource.getStringArray("animation"));
            this.m_animImage = this.m_animation.getImages();
        } else {
            this.m_animation = new MManimation(this, this.m_animImage);
        }
        this.m_animation.start();
        this.m_start.setLabel(this.m_resource.getString("record"));
        ((TextComponent)this.m_upLimit).setText("");
        this.show("");
    }

    void endMacroMode() {
        if (this.m_macroFlag) {
            this.m_animation.interrupt();
            this.m_list.processList(null);
            this.m_watcher.resume();
            this.m_start.setLabel(this.m_resource.getString("start"));
            ((TextComponent)this.m_upLimit).setText("");
            ((TextComponent)this.m_inputLine).setText(String.valueOf(this.m_inputLine.getText()) + " ");
            this.m_macroFlag = false;
            this.show("");
        }
    }

    public boolean getExpression() {
        this.m_expression = this.m_inputLine.getText();
        return this.m_inputLine.isNotTheSame();
    }

    public boolean getExpressions() {
        String string = "0";
        this.m_expressions[0] = this.m_inputLine.getText();
        boolean bl = this.m_inputLine.isNotTheSame();
        this.m_expressions[1] = this.m_loLimit.getText();
        boolean bl2 = this.m_loLimit.isNotTheSame();
        this.m_expressions[2] = this.m_upLimit.getText();
        boolean bl3 = this.m_upLimit.isNotTheSame();
        if (this.m_expressions[1].trim().equals("")) {
            this.m_expressions[1] = string;
        }
        if (!this.m_expressions[0].trim().equals("")) {
            if (this.m_expressions[1].trim().equals("")) {
                this.m_expressions[1] = string;
            }
            if (this.m_expressions[2].trim().equals("")) {
                this.m_expressions[2] = string;
            }
        }
        this.m_expression = this.m_expressions[0];
        return bl || bl2 || bl3;
    }

    public String getParameterValue(String string) {
        return this.m_hList.getValue(string);
    }

    public int getOperation() {
        return this.getMode();
    }

    public void exit() {
        if (this.m_watcher != null) {
            this.m_watcher.stop();
        }
        this.m_ini.saveAll();
        this.m_hint.setVisible(false);
        this.m_hint.dispose();
        ((Component)this.m_log).setVisible(false);
        this.m_log.dispose();
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.m_focusHolder = null;
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
        this.exitAction();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(s_start)) {
            if (!this.m_thinking) {
                this.compute();
            }
            return;
        }
        if (string.equals(s_stop)) {
            if (this.m_computer != null) {
                this.m_computer.stop();
            }
            this.m_thinking = false;
            this.startstop();
            this.showInfo(s_interrupted);
            return;
        }
        if (string.equals(s_record)) {
            this.record();
            return;
        }
        if (string.equals(s_view)) {
            this.m_log.show();
            return;
        }
        if (string.equals(s_cut)) {
            this.m_menu.cut();
            return;
        }
        if (string.equals(s_copy)) {
            this.m_menu.copy();
            return;
        }
        if (string.equals(s_paste)) {
            this.m_menu.paste();
            return;
        }
        if (string.equals(s_open)) {
            if (this.m_log.isSaved()) {
                this.m_log.open();
                return;
            }
            this.m_log.cancel(true);
            this.askAction();
            if (!this.m_log.isCancelled()) {
                this.m_log.open();
            }
            return;
        }
        if (string.equals(s_save)) {
            this.m_log.save();
            return;
        }
        if (string.equals(s_export)) {
            this.exportMacros();
            return;
        }
        if (string.equals(s_import)) {
            this.importMacros();
            return;
        }
        if (string.equals(s_printLog)) {
            this.m_log.printLog();
            return;
        }
        if (string.equals(s_printGraph)) {
            this.m_graph.printGraph();
            return;
        }
        if (string.equals(s_saveAs)) {
            this.m_log.saveAs();
            return;
        }
        if (string.equals(s_about)) {
            this.m_logo.setVisible(true);
            return;
        }
        if (string.equals(s_host)) {
            new MMhost(this, "host_name", this.m_windowListener).setVisible(true);
            return;
        }
        if (string.equals(s_browser)) {
            new MMbrowser(this, "browser", this.m_windowListener).setVisible(true);
            return;
        }
        if (string.equals(s_help)) {
            this.helpAction();
            return;
        }
        if (string.equals(s_history)) {
            return;
        }
        if (string.equals(s_clearHistory)) {
            this.m_menu.clearHistory();
            return;
        }
        if (string.equals(s_saveSettings)) {
            this.m_ini.save();
            return;
        }
        if (string.equals(s_exit)) {
            this.exitAction();
            return;
        }
        ((TextComponent)this.m_inputLine).setText(string);
    }

    void getBrowser() {
        try {
            File file = new File("browser");
            if (file.exists()) {
                this.m_browser = new BufferedReader(new FileReader(file)).readLine();
                return;
            }
        }
        catch (Exception exception) {}
    }

    void helpAction() {
        try {
            if (this.m_browser == null) {
                this.getBrowser();
                if (this.m_browser == null) {
                    new MMbrowser(this, "browser", this.m_windowListener).setVisible(true);
                }
            }
            String string = System.getProperties().getProperty("user.dir");
            StringBuffer stringBuffer = new StringBuffer(this.m_browser);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '\\') {
                    stringBuffer.setCharAt(n, '/');
                }
                ++n;
            }
            stringBuffer.append("/help/mmhelp.htm");
            Runtime.getRuntime().exec(stringBuffer.toString());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_hintFlag = itemEvent.getStateChange() == 1;
    }

    void exitAction() {
        if (this.m_log.isSaved()) {
            this.exit();
        }
        new MMquit(this, "quit", this.m_windowListener, true).setVisible(true);
    }

    void askAction() {
        new MMquit(this, "new_protocol", this.m_windowListener, false).show();
    }

    void importMacros() {
        if (!this.m_macroSavedFlag) {
            this.m_macroManager.saveMacros();
            this.m_macroSavedFlag = true;
        }
        MMfileDialog mMfileDialog = new MMfileDialog((Frame)this, this.m_resource.getString("open_macro"), 0, ".mac");
        mMfileDialog.show();
        String string = mMfileDialog.getFile();
        if (string != null) {
            try {
                this.m_macroManager.loadMacros(string);
                this.resetMacros();
                this.modifyTitle(string);
            }
            catch (Exception exception) {
                mMfileDialog.dispose();
                return;
            }
        }
        mMfileDialog.dispose();
    }

    void exportMacros() {
        MMfileDialog mMfileDialog = new MMfileDialog((Frame)this, this.m_resource.getString("save_macro"), 1, ".mac");
        mMfileDialog.show();
        String string = mMfileDialog.getFile();
        if (string != null) {
            this.m_macroManager.saveMacros(string);
            this.m_macroSavedFlag = true;
            this.modifyTitle(string);
        }
        mMfileDialog.dispose();
    }

    void modifyTitle(String string) {
        String string2 = " + ";
        String string3 = this.getTitle();
        int n = string3.indexOf(string2);
        if (n < 0) {
            this.setTitle(String.valueOf(string3) + string2 + string);
            return;
        }
        this.setTitle(String.valueOf(string3.substring(0, n)) + string2 + string);
    }

    void compute() {
        this.m_watcher.processList();
        this.m_watcher.suspend();
        if (this.getMode() == 5) {
            this.m_plotter = new MMplotter(this);
            this.m_plotter.start();
        } else {
            this.m_computer = new MMcomputer(this);
            this.m_computer.start();
        }
        this.m_watcher.resume();
    }

    void record() {
        this.show("");
        String string = this.m_resource.getString("invalid_name");
        String string2 = this.m_upLimit.getText().trim();
        if (string2.length() > 5) {
            this.showError(this.m_resource.getString("too_long"));
            return;
        }
        if (this.m_macroManager.macroExists(string2)) {
            this.checkDefinition(string2, false);
            return;
        }
        String[] stringArray = this.m_server.compile(string2);
        if (stringArray == null) {
            this.showError(string);
            return;
        }
        if (stringArray.length == 1 && stringArray[0].equals(string2)) {
            this.checkDefinition(string2, true);
            return;
        }
        this.showError(string);
    }

    void checkDefinition(String string, boolean bl) {
        String string2 = this.m_inputLine.getText().trim();
        Macro macro = new Macro(string, string2);
        try {
            if (string2.equals("")) {
                if (bl) {
                    this.showError(this.m_resource.getString("empty_body"));
                    return;
                }
                new MMmacroDialog(this, "add_macro", this.m_windowListener, false).setVisible(true);
                return;
            }
            if (macro.checkDefinition(this.m_server)) {
                if (bl) {
                    if (this.m_macroManager.numberOfMacros() >= 28) {
                        this.showError(this.m_resource.getString("many_macros"));
                        return;
                    }
                    this.addMacro(macro);
                    return;
                }
                new MMmacroDialog(this, "add_macro", this.m_windowListener, true).setVisible(true);
                return;
            }
            this.showError(macro.m_definition);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void addMacro() {
        this.addMacro(new Macro(this.m_upLimit.getText().trim(), this.m_inputLine.getText().trim()));
    }

    void addMacro(Macro macro) {
        this.m_macroManager.addMacro(macro);
        MacroList macroList = this.m_macroManager.getMacroList();
        this.showInfo(this.m_resource.getString("verifying"));
        this.m_server.setMacros(null);
        this.m_macroManager.verifyMacros();
        this.m_funcpad.processMacros();
        macroList = this.m_macroManager.getMacroList();
        if (macroList != null) {
            this.m_server.logMacros(macroList.toStrings());
        } else {
            this.m_server.logMacros(null);
        }
        this.m_log.update();
        this.show(this.m_resource.getString("macro_added"));
        this.m_list.processList();
        this.m_macroSavedFlag = false;
    }

    void show(String string) {
        this.m_resultWindow.setForeground(IParameters.SUCCESS_COLOR);
        int n = string.indexOf(" (");
        if (n < 0) {
            this.m_resultWindow.setText(string);
            return;
        }
        this.m_resultWindow.setText(string.substring(0, n));
        this.m_resultWindow.append("\n");
        this.m_resultWindow.append(string.substring(n + 1));
    }

    void showMore(String string) {
        this.m_resultWindow.append("\n");
        this.m_resultWindow.append(string);
    }

    void showWarning(String string) {
        this.m_resultWindow.setForeground(IParameters.WARNING_COLOR);
        this.m_resultWindow.setText(string);
    }

    void showError(String string) {
        this.m_resultWindow.setForeground(IParameters.ERROR_COLOR);
        this.m_resultWindow.setText(string);
    }

    void showInfo(String string) {
        this.m_resultWindow.setForeground(IParameters.INFO_COLOR);
        this.m_resultWindow.setText(string);
    }

    void startstop() {
        if (this.m_thinking) {
            this.m_start.setForeground(IParameters.RED);
            this.m_start.setLabel(this.m_resource.getString("stop"));
            return;
        }
        this.m_start.setForeground(IParameters.BLACK);
        this.m_start.setLabel(this.m_resource.getString("start"));
    }
}

