#include <stdio.h>
#include <string.h>
#include <process.h>
#define INCL_DOS
#define INCL_DOSFILEMGR
#define INCL_DOSSESMGR
#define INCL_DOSERRORS
#include <OS2.H>
#include "../retriever_mr.h"

int launchMR(char *prog,char*args);

LONG mrNPGetState(HPIPE pHandle)
{
   ULONG state, buffer, buffer2;
   AVAILDATA avail;

   DosPeekNPipe(pHandle, &buffer, 4, &buffer2, &avail, &state);
   return state;
}

int main (void)
{
HPIPE pipeHandle;
long action,cb,rc,i=1;
char pName[]="\\PIPE\\MRPIPE11_INFO";     //The base name would be MRPIPE11 see launchMR
char buffer[256];
  launchMR("retrievr.exe","-p MRPIPE11 http://hobbes.nmsu.edu/pub/os2/apps/internet/misc/pmdc060.wpi");
      // the space between the base pipename and -p is important
  DosSleep(500);

  printf("Trying to open");
  if(! (rc = DosOpen( pName,&pipeHandle,&action,0,FILE_NORMAL,FILE_OPEN,OPEN_ACCESS_READONLY/*WRITE*/ | OPEN_SHARE_DENYNONE ,NULL )) != 0)
  {         // we are opening the pipe like a normal file for readonly
     printf("\nGoing to read now");
     while (1)
     {
       rc=DosRead(pipeHandle, buffer,255,&cb );    // I am using message pipes, so we are
       if (rc)                                     //getting a whole string(message) at once
         printf("\nDosRead Error: %i",rc);
       else
       {
         if (!cb)    //cb is 0 then there wasn't any new message in the pipe or the pipe is closing
         {
           if( mrNPGetState(pipeHandle) == NP_STATE_CLOSING)
           {
             printf("\nPipe closed");
             break;
           }
         }
         else
         {
         char what[255];
           switch(buffer[0])              //in the first byte of the message is the "protocol" number
           {
             case MRIP_FROM:
               sprintf(what,"->Url: %s",&buffer[1]);
             break;
             case MRIP_LOCAL:
               sprintf(what,"->FileName: %s",&buffer[1]);
             break;
             case MRIP_LENGTH:
               sprintf(what,"->Length: %s",&buffer[1]);
             break;
             case MRIP_ERROR:
               sprintf(what,"->Error: %s",&buffer[1]);
             break;
             case MRIP_SIZE:
               sprintf(what,"->Size: %s",&buffer[1]);
               printf("\r");
             break;

             case MRIP_CONNECTED:
               sprintf(what,"->Connected to server: %s",&buffer[1]);
             break;
             case MRIP_RATE:
               sprintf(what,"->Transfer rate: %s",&buffer[1]);
             break;

             case MRIP_RATE_NOW:
               sprintf(what,"->Transfer rate right now: %s",&buffer[1]);
             break;
             case MRIP_TIME_REMAIN:
               sprintf(what,"->Remaining time: %s",&buffer[1]);
             break;
             case MRIP_REQUEST_OK:
               sprintf(what,"->Request to Server ok: %s",&buffer[1]);
             break;
             case MRIP_TIMEPAST:
               sprintf(what,"->Time Past: %s",&buffer[1]);
             break;
             case MRIP_FINISHED:
               sprintf(what,"->Finished download: %s",&buffer[1]);
             break;
             case MRIP_MR_DIE:
               sprintf(what,"->Marvin's Retriever ended: %s",&buffer[1]);
             break;



            }
            printf("\nmsg %i, %s",i++,what);
         }
         DosSleep(50);
       }
     }
     printf("\nByebye");
   }
   else printf("Error %i",rc);
   DosClose(pipeHandle);
 return 0;
}

int launchMR(char *prog,char*args)      //somehow spawnl didn't like me, so I had to do it the hard way
{
STARTDATA startData;
ULONG sessionID,rc;
PID   processID;
UCHAR PgmTitle[40];
UCHAR PgmName[80];
UCHAR ObjBuf[100];
UCHAR PgmInputs[100];
UCHAR buf[256];

  if (prog[1]==':')
    strcpy(PgmName,prog);
  else
  {
    getcwd( buf,255);
    PgmName[0]=_getdrive();
    strcpy(&PgmName[1],":");
    strcat(PgmName,buf);
    strcat(PgmName,"/");
    strcat(PgmName,prog);
    printf(PgmName);
  }
  strcpy(PgmInputs,args);

  startData.Length = sizeof(STARTDATA);                           /* Length of STARTDATA structure */
  startData.Related = SSF_RELATED_INDEPENDENT;                           /* Child session */
  startData.FgBg = SSF_FGBG_FORE;                        /* Start child session in background */
  startData.TraceOpt = SSF_TRACEOPT_NONE;                       /* Don't trace session */
  strcpy(PgmTitle,"Marvin's Retriever");
  startData.PgmTitle = PgmTitle;                       /* Session Title string */

  startData.PgmName = PgmName;            /* Program path-name string */
  startData.PgmInputs = PgmInputs;            /* Assume no input arguments need */    /*   be passed to the program     */
  startData.TermQ = 0;   /* Assume no termination queue */
  startData.Environment = 0;                         /* Assume no environment string */
  startData.InheritOpt = SSF_INHERTOPT_SHELL;    /* Inherit environment and open */      /*   file handles from parent   */
  startData.SessionType = SSF_TYPE_PM;        /* Allow the Shell to establish */        /*   the session type           */
  startData.IconFile = 0;   /* Assume no specific icon file */              /*   is provided                */
  startData.PgmHandle = 0;       /* Do not use the installation file */
  startData.PgmControl = SSF_CONTROL_VISIBLE ;// | SSF_CONTROL_MAXIMIZE;     /* Start the program as visible *//*   and maximized              */
  startData.InitXPos = 30;
  startData.InitYPos = 40;
  startData.InitXSize = 200;    /* Initial window coordinates */
  startData.InitYSize = 140;    /*   and size                 */
  startData.Reserved = 0;                    /* Reserved, must be zero */
  startData.ObjectBuffer = ObjBuf;/* Object buffer to hold DosExecPgm */   /*   failure causes                 */
  startData.ObjectBuffLen = 100;                           /* Size of object buffer */

  rc = DosStartSession(&startData, &sessionID, &processID);
  if (rc != 0)
  {
    printf("DosStartSession error: return code = %ld", rc);
    return rc;
  }
  return 0;
}

//     DosWaitNPipe("\\PIPE\\mypipe11"/*pipeHandle*/, 2000);// client.WaitForServer( "MarvinPipe0", 2000);

/*LONG XNamedPipeClient::Open(char *name, ULONG modeopen, char * server)
{
   ULONG aktion;
   XString n;
   if(server)
   {
      n += "\\";
      n += server;
   }
   n += "\\PIPE\\";
   n += name;
   ULONG rc = DosOpen((PSZ) (char*) n, &handle, &aktion, 0, FILE_NORMAL, FILE_OPEN, modeopen, NULL);
   if( rc )
      handle = -1;
   return rc;
}
LONG XNamedPipeClient::WaitForServer(char *name, ULONG timeOut, char * server)
{
   XString n;
   if(server)
   {
      n += "\\";
      n += server;
   }
   n += "\\PIPE\\";
   n += name;
   return DosWaitNPipe((PSZ) (char*) n, timeOut);
}
LONG XNamedPipeClient::GetState(void)
{
   ULONG state, buffer, buffer2;
   AVAILDATA avail;

   DosPeekNPipe(handle, &buffer, 4, &buffer2, &avail, &state);
   return state;
} */
