/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.JulianDate;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class EarthTime
extends JulianDate {
    private static final DecimalFormat FORMAT_20 = new DecimalFormat("00");
    private static final DecimalFormat FORMAT_30 = new DecimalFormat("000");
    private double rE = 0.0;
    private double lambdaE = 0.0;
    private GregorianCalendar calendar = new GregorianCalendar();
    private Date date = new Date();
    private static TimeZone localZone = TimeZone.getDefault();
    private static SimpleTimeZone utcZone = new SimpleTimeZone(0, "GMT+0:00");

    public EarthTime() {
        this(System.currentTimeMillis());
    }

    public EarthTime(long t) {
        super(t);
        this.calculate();
    }

    public void setTime(long t) {
        super.setTime(t);
        this.calculate();
    }

    private void calculate() {
        double g = 357.528 + 0.9856003 * this.delta2000;
        double gRad = g * Math.PI / 180.0;
        this.rE = 1.00014 - 0.01671 * Math.cos(gRad) - 1.4E-4 * Math.cos(2.0 * gRad);
        this.lambdaE = 102.944 + g + 1.915 * Math.sin(gRad) + 0.02 * Math.sin(2.0 * gRad);
        while (this.lambdaE < 0.0) {
            this.lambdaE += 360.0;
        }
        while (this.lambdaE > 360.0) {
            this.lambdaE -= 360.0;
        }
    }

    public double getHeliocentricLongitude() {
        return this.lambdaE;
    }

    public double getHeliocentricDistance() {
        return this.rE;
    }

    public String getTime() {
        return this.getTime(false);
    }

    public String getTime(boolean getLocal) {
        String append;
        this.date.setTime(this.unixMillis);
        this.calendar.setTime(this.date);
        if (getLocal) {
            ((Calendar)this.calendar).setTimeZone(localZone);
            append = localZone.getDisplayName(localZone.inDaylightTime(this.date), 0);
        } else {
            ((Calendar)this.calendar).setTimeZone(utcZone);
            append = "UTC";
        }
        return FORMAT_20.format(this.calendar.get(11)) + ":" + FORMAT_20.format(this.calendar.get(12)) + ":" + FORMAT_20.format(this.calendar.get(13)) + " " + append;
    }

    public String getDate(boolean getLocal, boolean asDOY) {
        this.date.setTime(this.unixMillis);
        this.calendar.setTime(this.date);
        if (getLocal) {
            ((Calendar)this.calendar).setTimeZone(localZone);
        } else {
            ((Calendar)this.calendar).setTimeZone(utcZone);
        }
        if (asDOY) {
            return this.calendar.get(1) + "-" + FORMAT_30.format(this.calendar.get(6));
        }
        return this.calendar.get(1) + "-" + FORMAT_20.format(this.calendar.get(2) + 1) + "-" + FORMAT_20.format(this.calendar.get(5));
    }
}

