/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.netcdf.NCTreeTableNode;
import java.util.List;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NCVariable
extends NCTreeTableNode {
    public static final int OTHER_VAR = 0;
    public static final int LON_LAT_VAR = 1;
    public static final int LON_LAT_VERT_VAR = 2;
    public static final int LAT_VERT_VAR = 3;
    private NCDataset dataset;
    private VariableDS varDS;

    public NCVariable(NCDataset dataset, String name) {
        this(dataset, dataset.findVariable(name));
    }

    public NCVariable(NCDataset d, VariableDS v) {
        this.dataset = d;
        this.varDS = v;
    }

    public NCDataset getDataset() {
        return this.dataset;
    }

    public String getName() {
        return this.varDS.getName();
    }

    public String getLongName() {
        StringBuffer sb = new StringBuffer();
        if (this.varDS.findAttribute("long_name") != null) {
            sb.append(this.varDS.findAttribute("long_name").getStringValue());
        } else if (this.varDS.findAttribute("standard_name") != null) {
            sb.append(this.varDS.findAttribute("standard_name").getStringValue().replace('_', ' '));
        } else {
            return "-";
        }
        if (sb.charAt(sb.length() - 1) != ' ') {
            return sb.toString();
        }
        int isize = sb.length();
        int i = 0;
        while (i < isize) {
            if (sb.charAt(sb.length() - 1) != ' ') {
                return sb.toString();
            }
            sb.deleteCharAt(sb.length() - 1);
            ++i;
        }
        if (sb.length() == 0) {
            return "-";
        }
        return sb.toString();
    }

    public String getDetail() {
        StringBuffer sb = new StringBuffer("");
        if (this.varDS.isCoordinateVariable()) {
            sb.append("coordinate variable");
        } else {
            sb.append("variable");
        }
        sb.append(" \"").append(this.getName()).append("\"\n");
        sb.append("--------\n");
        sb.append(this.varDS.toString());
        return sb.toString();
    }

    public int getChildCount() {
        return 0;
    }

    public Object[] getChildren() {
        return null;
    }

    public Object getObject() {
        return this.varDS;
    }

    public String toString() {
        return this.varDS.getName();
    }

    public NCTreeTableNode getParent() {
        return this.dataset;
    }

    public NCTreeTableNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public NCTreeTableNode[] getPathToRoot(NCTreeTableNode node, int depth) {
        NCTreeTableNode[] retNodes;
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new NCTreeTableNode[depth];
        } else {
            retNodes = this.getPathToRoot(node.getParent(), ++depth);
            retNodes[retNodes.length - depth] = node;
        }
        return retNodes;
    }

    public int getPlottingType() {
        return NCVariable.getPlottingType(this.varDS);
    }

    public static int getPlottingType(VariableDS v) {
        List l = v.getCoordinateSystems();
        if (l.size() < 1) {
            return 0;
        }
        CoordinateSystem cs = (CoordinateSystem)l.get(0);
        boolean hasLonLat = cs.isLatLon();
        boolean hasVert = cs.hasVerticalAxis();
        if (hasLonLat && hasVert) {
            return 2;
        }
        if (hasLonLat) {
            return 1;
        }
        if (hasVert && cs.getLatAxis() != null) {
            return 3;
        }
        return 0;
    }
}

