/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.AbsoluteTime;
import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.netcdf.RelativeTime;
import gov.nasa.giss.text.ScientificFormat;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.VariableDS;

public class NCDimension {
    private static ScientificFormat formatter = new ScientificFormat(9, 12, false);
    private String longName;
    private String units;
    private boolean isRelativeTime = false;
    private boolean isAbsoluteTime = false;
    private RelativeTime relTime;
    private AbsoluteTime absTime;
    private ArrayList values;

    public NCDimension(NCDataset dataset, String dimName) {
        this(dataset, dataset.findDimension(dimName));
    }

    public NCDimension(NCDataset dataset, Dimension dimension) {
        if (dataset == null) {
            throw new IllegalArgumentException("dataset must be set");
        }
        if (dimension == null) {
            throw new IllegalArgumentException("dimension must be set");
        }
        try {
            int[] shape;
            String dimName = dimension.getName();
            int numCoordinates = dimension.getLength();
            this.values = new ArrayList(numCoordinates);
            Variable dimVar = dimension.getCoordinateVariable();
            StringBuffer nameBuffer = new StringBuffer("");
            if (dimVar != null) {
                if (dimVar.findAttribute("long_name") != null) {
                    nameBuffer.append(dimVar.findAttribute("long_name").getStringValue().replace('_', ' '));
                } else if (dimVar.findAttribute("standard_name") != null) {
                    nameBuffer.append(dimVar.findAttribute("standard_name").getStringValue().replace('_', ' '));
                } else {
                    nameBuffer.append(dimName);
                }
                if (dimVar.findAttribute("units") != null) {
                    this.units = dimVar.findAttribute("units").getStringValue();
                    if (this.units.indexOf(" since ") > 0) {
                        try {
                            this.relTime = new RelativeTime(dataset, dimVar);
                            this.isRelativeTime = true;
                            this.units = "";
                        }
                        catch (Exception exc) {
                            this.isRelativeTime = false;
                        }
                    } else if (this.units.indexOf(" as ") > 0) {
                        try {
                            this.absTime = new AbsoluteTime(dimVar);
                            this.isAbsoluteTime = true;
                            this.units = this.absTime.getUnits();
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                            this.isAbsoluteTime = false;
                        }
                    }
                } else {
                    this.units = "";
                }
            } else {
                nameBuffer.append(dimName);
                this.units = "";
            }
            nameBuffer.setCharAt(0, Character.toUpperCase(nameBuffer.charAt(0)));
            this.longName = nameBuffer.toString();
            if (dimVar == null) {
                int i = 0;
                while (i < numCoordinates) {
                    this.values.add(i, i + 1 + " of " + numCoordinates);
                    ++i;
                }
            } else if (dimVar.getElementType() == Character.TYPE) {
                shape = dimVar.getShape();
                Array dimArray = dimVar.read();
                int i = 0;
                while (i < numCoordinates) {
                    StringBuffer coordinate = new StringBuffer("");
                    int ii = 0;
                    while (ii < shape[1]) {
                        char c = dimArray.getChar(dimArray.getIndex().set(i, ii));
                        if (c == '\u0000') break;
                        coordinate.append(c);
                        ++ii;
                    }
                    this.values.add(i, coordinate.toString());
                    ++i;
                }
            } else if (dimVar.getElementType() == Boolean.TYPE) {
                shape = dimVar.getShape();
                Array dimArray = dimVar.read();
                int i = 0;
                while (i < numCoordinates) {
                    if (dimArray.getBoolean(dimArray.getIndex().set(i))) {
                        this.values.add(i, "true");
                    } else {
                        this.values.add(i, "false");
                    }
                    ++i;
                }
            } else {
                int rank = dimVar.getRank();
                String boundsName = "";
                double modulo = 0.0;
                if (dimVar.findAttribute("bounds") != null) {
                    boundsName = dimVar.findAttribute("bounds").getStringValue();
                }
                if (dimVar.findAttribute("topology") != null && dimVar.findAttribute("topology").getStringValue().equals("circular") && dimVar.findAttribute("modulo") != null) {
                    modulo = dimVar.findAttribute("modulo").getNumericValue().doubleValue();
                }
                VariableDS boundsVar = null;
                if (!boundsName.equals("")) {
                    boundsVar = dataset.findVariable(boundsName);
                }
                if (boundsVar == null) {
                    Array dimArray = dimVar.read();
                    if (dimVar.getElementType() == Integer.TYPE) {
                        int i = 0;
                        while (i < numCoordinates) {
                            int value = dimArray.getInt(dimArray.getIndex().set(i));
                            if (this.isRelativeTime) {
                                this.values.add(i, this.relTime.add(value));
                            } else if (this.isAbsoluteTime) {
                                this.values.add(i, this.absTime.format(value));
                            } else {
                                if (modulo > 0.0) {
                                    value %= (int)modulo;
                                }
                                this.values.add(i, value + "");
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < numCoordinates) {
                            double value = dimArray.getDouble(dimArray.getIndex().set(i));
                            if (this.isRelativeTime) {
                                this.values.add(i, this.relTime.add(value));
                            } else if (this.isAbsoluteTime) {
                                this.values.add(i, this.absTime.format(value));
                            } else {
                                if (modulo > 0.0) {
                                    value %= modulo;
                                }
                                this.values.add(i, formatter.format(value));
                            }
                            ++i;
                        }
                    }
                } else {
                    Array boundsArray = boundsVar.read();
                    if (dimVar.getElementType() == Integer.TYPE) {
                        int i = 0;
                        while (i < numCoordinates) {
                            int v1 = boundsArray.getInt(boundsArray.getIndex().set(i, 0));
                            int v2 = boundsArray.getInt(boundsArray.getIndex().set(i, 1));
                            if (this.isRelativeTime) {
                                this.values.add(i, this.relTime.add(v1) + " / " + this.relTime.add(v2));
                            } else if (this.isAbsoluteTime) {
                                this.values.add(i, this.absTime.format(v1) + " / " + this.absTime.format(v2));
                            } else {
                                if (modulo > 0.0) {
                                    v1 %= (int)modulo;
                                    v2 %= (int)modulo;
                                }
                                this.values.add(i, v1 + " / " + v2);
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < numCoordinates) {
                            double v1 = boundsArray.getDouble(boundsArray.getIndex().set(i, 0));
                            double v2 = boundsArray.getDouble(boundsArray.getIndex().set(i, 1));
                            if (this.isRelativeTime) {
                                this.values.add(i, this.relTime.add(v1) + " / " + this.relTime.add(v2));
                            } else if (this.isAbsoluteTime) {
                                this.values.add(i, this.absTime.format(v1) + " / " + this.absTime.format(v2));
                            } else {
                                if (modulo > 0.0) {
                                    v1 %= modulo;
                                    v2 %= modulo;
                                }
                                this.values.add(i, formatter.format(v1) + " / " + formatter.format(v2));
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        catch (Exception exc) {
            System.out.println("NCDimension <init> : " + exc.toString());
            exc.printStackTrace();
            System.exit(0);
        }
    }

    public String getLongName() {
        return this.longName;
    }

    public String getUnits() {
        return this.units;
    }

    public int getItemCount() {
        return this.values.size();
    }

    public Object[] getValues() {
        return this.values.toArray();
    }
}

