/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.netcdf.NCTreeTableNode;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class NCDatasetList
extends NCTreeTableNode {
    private ArrayList childList = new ArrayList(5);
    private boolean listAllVars = true;

    public NCDatasetList() {
    }

    public NCDatasetList(NCDataset dataset) {
        this.childList.add(dataset);
        dataset.setListAllVariables(this.listAllVars);
    }

    public void setListAllVariables(boolean listAllVars) {
        this.listAllVars = listAllVars;
    }

    public Object getObject() {
        return this;
    }

    public String getName() {
        return "root";
    }

    public String getLongName() {
        return "dataset list";
    }

    public String getDetail() {
        return "";
    }

    public int getChildCount() {
        return this.childList.size();
    }

    public Object[] getChildren() {
        return this.childList.toArray();
    }

    public int add(URL url) throws IOException {
        int isize = this.childList.size();
        String urls = url.toString();
        int i = 0;
        while (i < isize) {
            if (urls.compareToIgnoreCase(((NCDataset)this.childList.get(i)).getURL().toString()) == 0) {
                throw new IOException("Dataset has already been opened");
            }
            ++i;
        }
        NCDataset child = new NCDataset(url);
        child.setListAllVariables(this.listAllVars);
        String name = child.getName();
        int i2 = 0;
        while (i2 < isize) {
            if (name.compareToIgnoreCase(((NCTreeTableNode)this.childList.get(i2)).getName()) < 0) {
                this.childList.add(i2, child);
                return i2;
            }
            ++i2;
        }
        this.childList.add(child);
        return isize;
    }

    public NCTreeTableNode remove(int index) {
        return (NCTreeTableNode)this.childList.remove(index);
    }
}

