/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import java.text.DecimalFormat;
import java.text.ParseException;
import ucar.nc2.Variable;

public class AbsoluteTime {
    private static final int SECOND = 1;
    private static final int MINUTE = 2;
    private static final int HOUR = 3;
    private static final int DAY = 4;
    private static final int YEAR = 6;
    private static final int MONTH = 5;
    private int biggestField;
    private int smallestField;
    private int incrementField;
    private boolean hasFraction = false;
    private String unitsName;
    private DecimalFormat nf = new DecimalFormat();

    public AbsoluteTime(String units) throws ParseException {
        this.init(units);
    }

    public AbsoluteTime(Variable dimVar) throws ParseException {
        String units;
        try {
            units = dimVar.findAttribute("units").getStringValue();
        }
        catch (Exception exc) {
            throw new ParseException("Variable has no units!", -1);
        }
        this.init(units);
    }

    private void init(String units) throws ParseException {
        int asIndex = units.indexOf(" as ");
        if (asIndex < 1) {
            throw new ParseException("Not absolute time units", -1);
        }
        this.unitsName = units.substring(0, asIndex);
        String formatString = units.substring(asIndex + 4);
        if (units.startsWith("year") || units.startsWith("calendar_year")) {
            this.incrementField = 6;
        } else if (units.startsWith("month") || units.startsWith("calendar_month")) {
            this.incrementField = 5;
        } else if (units.startsWith("day")) {
            this.incrementField = 4;
        } else if (units.startsWith("hour")) {
            this.incrementField = 3;
        } else if (units.startsWith("minute")) {
            this.incrementField = 2;
        } else if (units.startsWith("sec")) {
            this.incrementField = 1;
        } else {
            throw new ParseException("Unrecognized abs. time units '" + units + "'", -1);
        }
        if (formatString.indexOf("%f") > -1) {
            this.hasFraction = true;
        }
        if (formatString.indexOf("%Y") > -1) {
            this.biggestField = 6;
        } else if (formatString.indexOf("%m") > -1) {
            this.biggestField = 5;
        } else if (formatString.indexOf("%d") > -1) {
            this.biggestField = 4;
        } else if (formatString.indexOf("%H") > -1) {
            this.biggestField = 3;
        } else if (formatString.indexOf("%M") > -1) {
            this.biggestField = 2;
        } else if (formatString.indexOf("%S") > -1) {
            this.biggestField = 1;
        } else if (this.hasFraction) {
            this.biggestField = this.incrementField;
        } else {
            throw new ParseException("Unrecognized abs. time format '" + formatString + "'", -1);
        }
        if (formatString.indexOf("%S") > -1) {
            this.smallestField = 1;
        } else if (formatString.indexOf("%M") > -1) {
            this.smallestField = 2;
        } else if (formatString.indexOf("%H") > -1) {
            this.smallestField = 3;
        } else if (formatString.indexOf("%d") > -1) {
            this.smallestField = 4;
        } else if (formatString.indexOf("%m") > -1) {
            this.smallestField = 5;
        } else if (formatString.indexOf("%Y") > -1) {
            this.smallestField = 6;
        } else if (this.hasFraction) {
            this.smallestField = this.incrementField;
        } else {
            throw new ParseException("Unrecognized abs. time format '" + formatString + "'", -1);
        }
    }

    public String getUnits() {
        return this.unitsName;
    }

    public String format(int timeval) {
        return this.format((double)timeval);
    }

    public String format(double timeval) {
        StringBuffer sb = new StringBuffer();
        double thisOne = 0.0;
        switch (this.incrementField) {
            case 1: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction && this.smallestField == 1) {
                    this.nf.setMinimumFractionDigits(3);
                    this.nf.setMaximumFractionDigits(3);
                } else {
                    this.nf.setMinimumFractionDigits(0);
                    this.nf.setMaximumFractionDigits(0);
                }
                if (this.biggestField > 1) {
                    this.nf.setMinimumIntegerDigits(2);
                    this.nf.setMaximumIntegerDigits(2);
                } else {
                    this.nf.setMinimumIntegerDigits(1);
                    this.nf.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf.format(thisOne));
                if (this.biggestField <= 1) break;
                sb.insert(0, ":");
            }
            case 2: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction && this.smallestField == 2) {
                    this.nf.setMinimumFractionDigits(3);
                    this.nf.setMaximumFractionDigits(3);
                } else {
                    this.nf.setMinimumFractionDigits(0);
                    this.nf.setMaximumFractionDigits(0);
                }
                if (this.biggestField > 2) {
                    this.nf.setMinimumIntegerDigits(2);
                    this.nf.setMaximumIntegerDigits(2);
                } else {
                    this.nf.setMinimumIntegerDigits(1);
                    this.nf.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf.format(thisOne));
                if (this.biggestField <= 2) break;
                sb.insert(0, ":");
            }
            case 3: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction && this.smallestField == 3) {
                    this.nf.setMinimumFractionDigits(3);
                    this.nf.setMaximumFractionDigits(3);
                } else {
                    this.nf.setMinimumFractionDigits(0);
                    this.nf.setMaximumFractionDigits(0);
                }
                if (this.biggestField > 3) {
                    this.nf.setMinimumIntegerDigits(2);
                    this.nf.setMaximumIntegerDigits(2);
                } else {
                    this.nf.setMinimumIntegerDigits(1);
                    this.nf.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf.format(thisOne));
                if (this.biggestField <= 3) break;
                sb.insert(0, " ");
            }
            case 4: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction && this.smallestField == 4) {
                    this.nf.setMinimumFractionDigits(3);
                    this.nf.setMaximumFractionDigits(3);
                } else {
                    this.nf.setMinimumFractionDigits(0);
                    this.nf.setMaximumFractionDigits(0);
                }
                if (this.biggestField > 4) {
                    this.nf.setMinimumIntegerDigits(2);
                    this.nf.setMaximumIntegerDigits(2);
                } else {
                    this.nf.setMinimumIntegerDigits(1);
                    this.nf.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf.format(thisOne));
                if (this.biggestField <= 4) break;
                sb.insert(0, "-");
            }
            case 5: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction && this.smallestField == 5) {
                    this.nf.setMinimumFractionDigits(3);
                    this.nf.setMaximumFractionDigits(3);
                } else {
                    this.nf.setMinimumFractionDigits(0);
                    this.nf.setMaximumFractionDigits(0);
                }
                if (this.biggestField > 5) {
                    this.nf.setMinimumIntegerDigits(2);
                    this.nf.setMaximumIntegerDigits(2);
                } else {
                    this.nf.setMinimumIntegerDigits(1);
                    this.nf.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf.format(thisOne));
                if (this.biggestField <= 5) break;
                sb.insert(0, "-");
            }
            case 6: {
                if (this.hasFraction && this.smallestField == 6) {
                    this.nf.setMinimumFractionDigits(3);
                    this.nf.setMaximumFractionDigits(3);
                } else {
                    this.nf.setMinimumFractionDigits(0);
                    this.nf.setMaximumFractionDigits(0);
                }
                this.nf.setMinimumIntegerDigits(1);
                this.nf.setMaximumIntegerDigits(12);
                this.nf.setGroupingSize(12);
                sb.insert(0, this.nf.format(timeval));
            }
        }
        return sb.toString();
    }
}

