/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Winkel1
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Winkel I";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double FIT_WIDTH = 2.5707963267948966;
    private static final double FIT_HEIGHT = 1.5707963267948966;
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = 1.6366197723675813;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Winkel1(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Winkel1(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Winkel1(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / 1.5707963267948966, 0.5 * (double)this.useWidth / 2.5707963267948966);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.6366197723675813;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double phiRad = (double)y * this.oneOverRS;
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = this.oneOverRS * 2.0 / (0.6366197723675814 + Math.cos(phiRad));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double phiRad = AbstractProjection.toRadians(latitude);
        double x = -this.rS * AbstractProjection.toRadians(dlambda) * (0.6366197723675814 + Math.cos(phiRad)) * 0.5;
        double y = this.rS * phiRad;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

