/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.img.BitUtils;
import gov.nasa.giss.img.ImageDescriptor;
import gov.nasa.giss.img.LZWCompressor;
import gov.nasa.giss.img.ScreenDescriptor;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class GIF87aEncoder {
    short width_;
    short height_;
    int numColors_;
    byte[] pixels_;
    byte[] colors_;
    ScreenDescriptor sd_;
    ImageDescriptor id_;

    public GIF87aEncoder(Image image) throws AWTException {
        this.width_ = (short)image.getWidth(null);
        this.height_ = (short)image.getHeight(null);
        int[] values = new int[this.width_ * this.height_];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, (int)this.width_, (int)this.height_, values, 0, (int)this.width_);
        try {
            if (!grabber.grabPixels()) {
                throw new AWTException("Grabber returned false: " + grabber.status());
            }
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        byte[][] r = new byte[this.width_][this.height_];
        byte[][] g = new byte[this.width_][this.height_];
        byte[][] b = new byte[this.width_][this.height_];
        int index = 0;
        int y = 0;
        while (y < this.height_) {
            int x = 0;
            while (x < this.width_) {
                r[x][y] = (byte)(values[index] >> 16 & 0xFF);
                g[x][y] = (byte)(values[index] >> 8 & 0xFF);
                b[x][y] = (byte)(values[index] & 0xFF);
                ++index;
                ++x;
            }
            ++y;
        }
        this.indexColors(r, g, b);
    }

    public GIF87aEncoder(int[] values, int width, int height) throws AWTException {
        this.width_ = (short)width;
        this.height_ = (short)height;
        byte[][] r = new byte[this.width_][this.height_];
        byte[][] g = new byte[this.width_][this.height_];
        byte[][] b = new byte[this.width_][this.height_];
        int index = 0;
        int y = 0;
        while (y < this.height_) {
            int x = 0;
            while (x < this.width_) {
                r[x][y] = (byte)(values[index] >> 16 & 0xFF);
                g[x][y] = (byte)(values[index] >> 8 & 0xFF);
                b[x][y] = (byte)(values[index] & 0xFF);
                ++index;
                ++x;
            }
            ++y;
        }
        this.indexColors(r, g, b);
    }

    public GIF87aEncoder(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.width_ = (short)r.length;
        this.height_ = (short)r[0].length;
        this.indexColors(r, g, b);
    }

    public void write(OutputStream output) throws IOException {
        BitUtils.writeString(output, "GIF87a");
        ScreenDescriptor sd = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        sd.write(output);
        output.write(this.colors_, 0, this.colors_.length);
        ImageDescriptor id = new ImageDescriptor(this.width_, this.height_, ',');
        id.write(output);
        byte codesize = BitUtils.bitsNeeded(this.numColors_);
        if (codesize == 1) {
            codesize = (byte)(codesize + 1);
        }
        output.write(codesize);
        LZWCompressor.LZWCompress(output, codesize, this.pixels_);
        output.write(0);
        id = new ImageDescriptor(0, 0, ';');
        id.write(output);
        output.flush();
    }

    void indexColors(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.pixels_ = new byte[this.width_ * this.height_];
        this.colors_ = new byte[768];
        int colornum = 0;
        int x = 0;
        while (x < this.width_) {
            int y = 0;
            while (y < this.height_) {
                int search = 0;
                while (search < colornum) {
                    if (this.colors_[search * 3] == r[x][y] && this.colors_[search * 3 + 1] == g[x][y] && this.colors_[search * 3 + 2] == b[x][y]) break;
                    ++search;
                }
                if (search > 255) {
                    throw new AWTException("Too many colors.");
                }
                this.pixels_[y * this.width_ + x] = (byte)search;
                if (search == colornum) {
                    this.colors_[search * 3] = r[x][y];
                    this.colors_[search * 3 + 1] = g[x][y];
                    this.colors_[search * 3 + 2] = b[x][y];
                    ++colornum;
                }
                ++y;
            }
            ++x;
        }
        this.numColors_ = 1 << BitUtils.bitsNeeded(colornum);
        byte[] copy = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, copy, 0, this.numColors_ * 3);
        this.colors_ = copy;
    }
}

