/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PALColorbar
extends AbstractColorbar {
    public static final int GRAYSCALE = 1;
    public static final int BLUESCALE = 2;
    public static final int HOTSTREAK = 3;
    public static final int OLDGLORY = 4;
    public static final int GAEA = 5;
    public static final int CHRISTMAS = 6;
    public static final int HOTMETAL = 7;

    public PALColorbar(File f) throws IOException, FileNotFoundException {
        super(f);
        byte[] b = this.readBytes(f, 768, 768);
        this.fillColorTable(b);
    }

    public PALColorbar(URL url) throws IOException, FileNotFoundException {
        super(url);
        byte[] b = this.readBytes(url, 768, 768);
        this.fillColorTable(b);
    }

    public PALColorbar(byte[] b, String identifier) throws IOException {
        this.identifier = identifier;
        this.makeName(identifier);
        this.fillColorTable(b);
    }

    public PALColorbar(int preset) throws IOException {
        this.colorCount = 256;
        this.minBin = 0;
        this.maxBin = 255;
        this.minOutlierBin = 0;
        this.maxOutlierBin = 255;
        this.colors = new Color[256];
        this.rgbValues = new int[256];
        switch (preset) {
            case 1: {
                int i = 0;
                while (i < 256) {
                    this.colors[i] = new Color(i, i, i);
                    ++i;
                }
                this.name = "grayscale";
                break;
            }
            case 2: {
                int i = 0;
                while (i < 256) {
                    this.colors[i] = new Color(i, i, 255);
                    ++i;
                }
                this.name = "bluescale";
                break;
            }
            case 3: {
                int i = 0;
                while (i < 128) {
                    this.colors[i] = new Color(255, i * 2, 0);
                    ++i;
                }
                int i2 = 128;
                while (i2 < 256) {
                    this.colors[i2] = new Color(255, 255, i2 * 2 - 256);
                    ++i2;
                }
                this.name = "hotstreak";
                break;
            }
            case 4: {
                int blue;
                int green;
                int red;
                int i = 0;
                while (i < 128) {
                    red = 255;
                    blue = green = i * 2;
                    this.colors[i] = new Color(red, green, blue);
                    ++i;
                }
                int i3 = 128;
                while (i3 < 256) {
                    green = red = 511 - 2 * i3;
                    blue = 255;
                    this.colors[i3] = new Color(red, green, blue);
                    ++i3;
                }
                this.name = "oldglory";
                break;
            }
            case 5: {
                int blue;
                int green;
                int red;
                int i = 0;
                while (i < 256) {
                    if (i < 128) {
                        green = red = i * 2;
                        blue = 153 + i;
                    } else {
                        red = 511 - 2 * i;
                        green = 408 - i;
                        blue = red;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    this.colors[i] = new Color(red, green, blue);
                    ++i;
                }
                this.name = "gaea";
                break;
            }
            case 6: {
                int blue;
                int green;
                int red;
                int i = 0;
                while (i < 256) {
                    if (i < 128) {
                        red = i * 2;
                        green = 153 + i;
                        blue = 51 + i * 2;
                    } else {
                        red = 255;
                        blue = green = 511 - 2 * i;
                    }
                    if (red > 255) {
                        red = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    this.colors[i] = new Color(red, green, blue);
                    ++i;
                }
                this.name = "christmas";
                break;
            }
            case 7: {
                int blue;
                int green;
                int red;
                int i = 0;
                while (i < 256) {
                    if (i < 128) {
                        red = i * 2;
                        green = 0;
                        blue = 0;
                    } else {
                        red = 255;
                        green = (i - 127) * 2;
                        blue = 0;
                    }
                    if (red > 255) {
                        red = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    this.colors[i] = new Color(red, green, blue);
                    ++i;
                }
                this.name = "hotmetal";
            }
        }
        int i = 0;
        while (i < 256) {
            this.rgbValues[i] = this.colors[i].getRGB();
            ++i;
        }
        this.identifier = "[preset]///" + this.name;
    }

    private void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid PAL color table");
        }
        this.colorCount = 256;
        this.minBin = 0;
        this.maxBin = 255;
        this.minOutlierBin = 0;
        this.maxOutlierBin = 255;
        this.colors = new Color[this.colorCount];
        this.rgbValues = new int[this.colorCount];
        int i = 0;
        while (i < 256) {
            this.colors[i] = new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]);
            this.rgbValues[i] = this.colors[i].getRGB();
            ++i;
        }
    }

    public String getName() {
        return super.getName() + " PAL";
    }
}

