function utilAJAX(strReq, fnOnLoad, fnOnError = null)
{
  const oReq = new XMLHttpRequest();

  oReq.open( "GET", strReq, true );
  oReq.onload = function() {
    if ( oReq.status == 200 ) {
      if ( oReq.responseXML )
        fnOnLoad( oReq.responseXML.documentElement );
      else
      {
        const  strText = oReq.responseText.replace( /<\/?[^>]+(>|$)/g, "" );
        if ( ( fnOnError == null ) || !fnOnError( 0, strText ) )
          alert( "Unknown result: " + strText );
      }
    }
    else
      if ( ( fnOnError == null ) || !fnOnError( oReq.status, oReq.statusText ) )
        alert( "HTTP error: " + oReq.status + " " + oReq.statusText );
  }

  oReq.send();
}

function utilAJAXPost(strReq, fMultipart, strBody, fnOnLoad)
{
  const oReq = new XMLHttpRequest();

  oReq.open( "POST", strReq, true );
  oReq.setRequestHeader( "Content-Type",
                         fMultipart ? "multipart/form-data"
                                    : "application/x-www-form-urlencoded" );
//  oReq.setRequestHeader( "Content-Length", strBody.length );
  oReq.onload = function() {
    if ( oReq.status == 200 ) {
      if ( oReq.responseXML )
        fnOnLoad( oReq.responseXML.documentElement );
      else
        alert( "Unknown result: " +
               oReq.responseText.replace( /<\/?[^>]+(>|$)/g, "" ) );
    }
    else
      alert( "HTTP error: " + oReq.status + " " + oReq.statusText );
  }

  oReq.send( strBody );
}

function utilGetNodeText(node)
{
  return node && node.firstChild ? node.firstChild.textContent : "";
}

function utilRemoveNode(node)
{
  if ( node && node.parentNode )
    node.parentNode.removeChild( node );
}

function utilRemoveAllChildren(node)
{
  while( node.firstChild )
    node.removeChild( node.firstChild );
}

function utilInsert(fAfter, node, existingNode) {
  if ( fAfter )
    existingNode.parentNode.insertBefore(node, existingNode.nextSibling);
  else
    existingNode.parentNode.insertBefore(node, existingNode);
}

function utilIndexOfElement(el)
{
  return [].indexOf.call( el.parentNode.children, el );
}

function utilInputOnChange(el, fn) {
  if ( !el )
    return;

  if ( el.type == "text" || el.type == "number" ) {
    function onChange(e) {
      if ( this.value != this.dataset.prevVal ) {
        this.dataset.prevVal = this.value;
        fn.call(this,e);
      }
    }
    el.addEventListener( "keyup", onChange, true );
    el.addEventListener( "change", onChange, true );
    el.addEventListener( "paste",
      function(e)
        {setTimeout( function() { el.dispatchEvent(new Event("change")); }, 0 )},
      true );
  }
  else {
    el.addEventListener( "keyup", fn, true );
    el.addEventListener( "change", fn, true );
  }
}


/* Form validators */

aValidators = [];

function utilVldrtSet(fn)
{
  aValidators.push( fn );
}

function utilVldrtCheck()
{
  const  elApply = document.querySelector( "form input[type='submit']" );

  if ( !elApply ) {
    console.log( "input[type='submit'] not found" );
    return;
  }

  elApply.disabled = false;
  for(var fn of aValidators)
    if ( !fn() ) {
      elApply.disabled = true;
      break;
    }
}
