function confirmation(strText, onYesFn)
{
  var elConf = document.getElementById( "confirmation" );
  var elYesBtn = document.getElementById( "confirmation__btn-yes" );
  var elNoBtn = document.getElementById( "confirmation__btn-no" );
  var elSaveFocus;

  function docFocusEv(e) {
    if ( !elConf.contains( e.target ) ) {
      e.stopPropagation();
      elYesBtn.focus();
    }
  }

  function docKeydownEv(e) { if ( !e.keyCode || e.keyCode === 27 ) closeDlg(); }

  function clickYes() { closeDlg(); onYesFn(); }

  function closeDlg() {
    elConf.classList.remove( "confirmation_visible" );
    document.removeEventListener( "focus", docFocusEv, true );
    document.removeEventListener( "keydown", docKeydownEv, true );
    elYesBtn.removeEventListener( "click", clickYes, true );
    elNoBtn.removeEventListener( "click", closeDlg );
    elSaveFocus.focus();
  }

  if ( strText !== null )
    document.getElementById( "confirmation__text" ).textContent = strText;

  elYesBtn.addEventListener( "click", clickYes, true );
  elNoBtn.addEventListener( "click", closeDlg );
  document.addEventListener( "focus", docFocusEv, true );
  document.addEventListener( "keydown", docKeydownEv, true );

  elSaveFocus = document.activeElement;
  elConf.classList.add( "confirmation_visible" );
  elNoBtn.focus();
}
