/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.web.xmlrpc;

import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.StringProperty;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlRootElement(name="methodResponse")
public class XMLRPCResponse
implements Serializable {
    private static final long serialVersionUID = -6798575832607559657L;
    private Element fault;
    private List<Param> params;
    private transient IntegerProperty faultCodeCache;
    private transient StringProperty faultStringCache;

    @XmlElement(name="param")
    @XmlElementWrapper(name="params")
    public List<Param> getParams() {
        return this.params;
    }

    public void setParams(List<Param> list) {
        this.params = list;
    }

    @XmlAnyElement
    public synchronized Element getFault() {
        return this.fault;
    }

    public synchronized void setFault(Element element) {
        this.faultCodeCache = null;
        this.faultStringCache = null;
        this.fault = element;
    }

    @XmlTransient
    public synchronized Integer getFaultCode() {
        if (this.faultCodeCache == null) {
            String string = this.getFaultProperty("faultCode");
            if (string == null) {
                this.faultCodeCache = new IntegerProperty();
                this.faultCodeCache.set(null);
            } else {
                this.faultCodeCache = new IntegerProperty();
                try {
                    this.faultCodeCache.parse(string.toString());
                }
                catch (ParseException parseException) {
                    MLogger.exception(parseException);
                    this.faultCodeCache.set(null);
                }
            }
        }
        return (Integer)this.faultCodeCache.get();
    }

    @XmlTransient
    public synchronized String getFaultString() {
        if (this.faultStringCache == null) {
            this.faultStringCache = new StringProperty(this.getFaultProperty("faultString"));
        }
        return (String)this.faultStringCache.get();
    }

    @XmlTransient
    public Object getResult() {
        Element element = this.params.get(0).getValue();
        Node node = element.getFirstChild();
        return node == null ? element.getTextContent() : node.getTextContent();
    }

    @XmlTransient
    public boolean isOK() {
        return this.params != null;
    }

    protected String getFaultProperty(String string) {
        NodeList nodeList = this.fault.getElementsByTagName("member");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node = nodeList2.item(j);
                if (!bl && "name".equals(node.getLocalName()) && string.equals(node.getTextContent())) {
                    bl = true;
                    continue;
                }
                if (!bl || !"value".equals(node.getLocalName())) continue;
                return node.getTextContent();
            }
        }
        return null;
    }

    public static final class Param
    implements Serializable {
        private Element value;

        @XmlAnyElement
        public Element getValue() {
            return this.value;
        }

        public void setValue(Element element) {
            this.value = element;
        }
    }
}

