/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree.version;

import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Item;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MObject;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tree.version.VersionException;

public final class VersionInfo
extends Item<MetaInfo>
implements Comparable<VersionInfo> {
    private int number;
    private MDate date;
    private String name;
    private String path;

    @Override
    public int compareTo(VersionInfo versionInfo) {
        return TK.compare(this.number, versionInfo.number);
    }

    public boolean equals(Object object) {
        switch (MObject.maybeEquals(this, object)) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        return this.compareTo((VersionInfo)object) == 0;
    }

    public MDate getDate() {
        return this.date;
    }

    public int getNumber() {
        return this.number;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.number;
    }

    @Override
    public String toString() {
        String string;
        if (this.number == 0) {
            string = UI._("Previous Version");
        } else {
            string = Integer.toString(this.number);
            if (this.name != null) {
                string = string + " - " + this.name;
            }
        }
        if (this.date != null) {
            string = string + " - " + this.date.fancyFormat(1, true);
        }
        return string;
    }

    protected VersionInfo(MetaInfo metaInfo, String string) throws VersionException {
        super(metaInfo);
        this.number = this.getNumber(string);
        this.path = string;
        Config config = metaInfo.getConfig();
        this.date = config.readDate("Version.date." + this.number, null);
        if (this.date != null) {
            this.date.freeze();
        }
        this.name = config.read("Version.name." + this.number, null);
    }

    protected VersionInfo(MetaInfo metaInfo, String string, int n) {
        super(metaInfo);
        this.date = MDate.now().freeze();
        this.number = n;
        this.name = string;
        this.path = metaInfo.getFilePath() + "." + n + ".version";
    }

    private int getNumber(String string) throws VersionException {
        String string2 = FS.getBaseName(string);
        string2 = FS.getExtension(string2);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionException(numberFormatException);
        }
    }
}

