/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.tree.TreeNode;
import org.makagiga.MainWindow;
import org.makagiga.Vars;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.Property;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tree.Tree;
import org.makagiga.tree.TreePanel;

public final class LocationBar
extends MPanel {
    private boolean autohidden;
    private static LocationBar _instance = new LocationBar();

    public static LocationBar getInstance() {
        return _instance;
    }

    @Override
    public void setVisible(boolean bl) {
        int n = (int)((float)UI.getScreenSize().width * 0.7f);
        if (MApplication.getMainWindow().getWidth() < n) {
            this.autohidden = true;
            super.setVisible(false);
        } else {
            this.autohidden = false;
            super.setVisible(bl && (Boolean)Vars.treeLocationBarVisible.get() != false);
        }
    }

    public void update(MetaInfo metaInfo) {
        this.removeAll();
        MetaInfo metaInfo2 = metaInfo.isLink() ? metaInfo.getLink() : metaInfo;
        for (TreeNode treeNode : metaInfo2.getPathList()) {
            metaInfo2 = (MetaInfo)treeNode;
            if (metaInfo2.isRoot()) continue;
            this.add(new MenuButton(metaInfo2));
            this.add(new LinkButton(metaInfo2));
        }
        this.validate();
        this.repaint();
    }

    private LocationBar() {
        super(0);
        this.setOpaque(false);
        this.setVisible(false);
        MMainWindow mMainWindow = MApplication.getMainWindow();
        mMainWindow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                LocationBar locationBar = LocationBar.this;
                if (locationBar.autohidden || locationBar.isVisible()) {
                    locationBar.setVisible(true);
                }
            }
        });
        Vars.treeLocationBarVisible.addPropertyChangeListener(new Property.ValueChangeListener<Boolean>(){

            @Override
            protected void onChange(Boolean bl) {
                LocationBar.this.setVisible(bl);
            }
        });
    }

    private static final class MenuButton
    extends MSmallButton {
        private final MetaInfo metaInfo;

        public MenuButton(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            this.setPopupMenuArrowPainted(false);
            this.setPopupMenuEnabled(true);
            this.setText("/");
            this.setToolTipText(UI._("Properties for {0}", metaInfo));
            UI.changeFontSize(this, -1);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
            super.setComponentOrientation(componentOrientation);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        protected MMenu onPopupMenu() {
            MainWindow.showTree(this.metaInfo);
            MetaInfo[] metaInfoArray = Tree.getInstance().getSelectedItems();
            if (metaInfoArray.length == 1 && metaInfoArray[0] == this.metaInfo) {
                return TreePanel.getInstance().createTreeMenu(null, true);
            }
            return null;
        }
    }

    private static final class LinkButton
    extends MURLButton {
        private final MetaInfo metaInfo;

        public LinkButton(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            this.setShowLinkActions(false);
            this.setURL(metaInfo.getFilePath());
            if (metaInfo.isFSRoot()) {
                this.setIcon(metaInfo.getFS().getSmallIcon());
                this.setText(null);
                this.setToolTipText(metaInfo.toString());
            } else {
                this.setText(TK.centerSqueeze(metaInfo.toString(), 20));
                int n = 116;
                this.setToolTipText(metaInfo.getToolTipText(n));
            }
            UI.changeFontSize(this, -1);
        }

        @Override
        protected void onClick() {
            MainWindow.showTree(this.metaInfo);
        }
    }
}

