/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.stats;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.makagiga.Sidebar;
import org.makagiga.chart.ChartModel;
import org.makagiga.chart.ChartPainter;
import org.makagiga.chart.ChartPanel;
import org.makagiga.chart.ChartView;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MTabbedPane;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.Painter;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.EditorStats;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginType;
import org.makagiga.search.Query;
import org.makagiga.search.SearchBar;
import org.makagiga.search.SortMethod;
import org.makagiga.todo.TaskState;
import org.makagiga.tools.summary.SummaryData;
import org.makagiga.tools.summary.SummaryPanel;
import org.makagiga.tools.summary.SummaryTree;
import org.makagiga.tree.Tree;

public final class StatsPanel
extends ChartPanel<ChartModel> {
    private ChartView<ChartModel> oldChartView;
    private MTabbedPane<ChartView<ChartModel>> _tabs;

    public StatsPanel(String string) {
        super(string);
    }

    @Override
    public ChartView<ChartModel> getView() {
        if (this._tabs == null) {
            return super.getView();
        }
        return this._tabs.getSelectedTab();
    }

    @Override
    public void setTextVisible(boolean bl) {
        if (this._tabs == null) {
            super.setTextVisible(bl);
        } else {
            this.showText.setSelected(bl);
            for (ChartView<ChartModel> chartView : this._tabs) {
                chartView.getPainter().textVisible.set(bl);
            }
            this.getView().repaint();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupChart() {
        EditorStats editorStats;
        Object object;
        Serializable serializable;
        Lockable lockable;
        this.oldChartView = this.getView();
        Painter painter = this.getPainter();
        this.setupPainter((ChartPainter<?>)painter);
        Map<void, Integer> map = TK.newLinkedHashMap();
        String string = TK.createRandomUUID();
        Color color = new Color(0xE600E6);
        Color color2 = new Color(15102720);
        Map map2 = TK.newHashMap("{b5683a3f-8662-4345-844e-49f256c40e17}", new Color(29670), "{f997287e-4c08-4288-af73-6d3e1611637c}", new Color(230), "{33db72bc-a43f-4f26-981c-fe4fd3ab20ca}", new Color(0xE6E600), "{0f04e3a2-05a8-4c41-9d66-a6619479eafd}", new Color(7595520));
        for (Comparable<PropertyAccess<MetaInfo>> comparable : Query.all(SortMethod.UNSORTED)) {
            void object22;
            lockable = (MetaInfo)((Property)comparable).get();
            if (((MetaInfo)lockable).isLink()) continue;
            Object var10_11 = null;
            if (((MetaInfo)lockable).isFile()) {
                serializable = ((MetaInfo)lockable).getPluginInfo();
                if (serializable != null) {
                    String string2 = ((PluginInfo)serializable).getID();
                }
            } else if (((MetaInfo)lockable).isDynamicFolder() && "feeds".equals(((MetaInfo)lockable).getFS().getID())) {
                String string3 = string;
            }
            if (object22 == null) continue;
            serializable = (Integer)map.get(object22);
            Integer n = serializable == null ? Integer.valueOf(1) : Integer.valueOf((Integer)serializable + 1);
            map.put(object22, n);
        }
        Iterator<Object> iterator = this.getModel();
        for (Map.Entry entry : map.entrySet()) {
            Comparable<PropertyAccess<MetaInfo>> comparable;
            serializable = (String)entry.getKey();
            int n = (Integer)entry.getValue();
            if (((String)((Object)serializable)).equals(string) && n > 1) {
                ((ChartModel)((Object)iterator)).addItem(UI._("RSS Feeds"), n - 1, color2, "ui/feed").setProperty("id", string);
                continue;
            }
            comparable = PluginType.EDITOR.getByID((String)((Object)serializable));
            if (comparable == null) continue;
            object = (Color)map2.get(((PluginInfo)comparable).getID());
            if (object == null) {
                object = color;
            }
            String string4 = ((EditorPlugin)EditorPlugin.class.cast(((PluginInfo)comparable).getPluggable())).getDocumentDisplayName();
            ((ChartModel)((Object)iterator)).addItem(string4, n, (Color)object, ((PluginInfo)comparable).getIcon()).setProperty("id", comparable);
        }
        if (((AbstractListTableModel)((Object)iterator)).isEmpty()) {
            ((ChartModel)((Object)iterator)).addEmptyInfo(Color.LIGHT_GRAY);
        } else {
            ((ChartModel)((Object)iterator)).setFormat("${text} - ${number} (${percent-int})");
        }
        this.oldChartView.setInteractive(true);
        this.oldChartView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatsPanel.this.clickedTree();
            }
        });
        this.getTabs().addTab(UI._("Tree"), this.oldChartView);
        lockable = Editor.getCurrentEditor();
        if (lockable instanceof EditorStats && (serializable = (editorStats = (EditorStats)((Object)lockable)).getStatsChart()) != null) {
            ChartView chartView = new ChartView(serializable);
            object = editorStats.getStatsTitle();
            if (object == null) {
                object = UI._("Current Document");
            }
            this.getTabs().addTab((String)object, chartView);
            this.getTabs().setSelectedIndex(1);
        }
        SummaryData.Chart chart = SummaryData.getInstance().getChart();
        this.setupPainter(chart);
        serializable = new ChartView<ChartModel>(chart);
        ((ChartView)serializable).setInteractive(true);
        ((ChartView)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatsPanel.this.clickedSummary();
            }
        });
        this.getTabs().addTab(Sidebar.Tab.SUMMARY.getTitle(), (ChartView<ChartModel>)serializable);
    }

    private void clickedSummary() {
        Sidebar.getInstance().goTo(Sidebar.Tab.SUMMARY, true);
        ChartModel.Item item = this.getView().getActiveItem();
        TaskState taskState = item.getProperty("state", null);
        if (taskState == null) {
            this.doCloseWindow();
            return;
        }
        SummaryTree summaryTree = SummaryPanel.getInstance().getTree();
        SummaryData summaryData = SummaryData.getInstance();
        for (Map.Entry<TaskState, SummaryData.Node> entry : summaryData.getTaskStateMap().entrySet()) {
            if (entry.getKey() != taskState) continue;
            SummaryData.Node node = entry.getValue();
            summaryTree.selectItem(node, true);
            summaryTree.setExpanded(node, true);
            break;
        }
        this.doCloseWindow();
    }

    private void clickedTree() {
        ChartModel.Item item = this.getView().getActiveItem();
        Object var2_2 = item.getProperty("id", null);
        if (var2_2 instanceof PluginInfo) {
            PluginInfo pluginInfo = var2_2;
            EditorPlugin editorPlugin = (EditorPlugin)pluginInfo.getPluggable();
            StringBuilder stringBuilder = new StringBuilder();
            for (EditorPlugin.FileType fileType : editorPlugin.getFileTypes()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('|');
                }
                stringBuilder.append(TK.join(fileType.getExtensions(), "|"));
            }
            SearchBar.setQuery("type=\"" + stringBuilder + "\"");
        } else if (var2_2 instanceof String) {
            SearchBar.setQuery("");
            Tree tree = Tree.getInstance();
            AbstractFS abstractFS = tree.getFS("feeds");
            if (abstractFS != null) {
                tree.selectItem(abstractFS.getRoot(), true);
                tree.setExpanded(abstractFS.getRoot(), true);
            }
        }
        this.doCloseWindow();
    }

    private void doCloseWindow() {
        Window window = this.getWindowAncestor();
        if (window instanceof MDialog) {
            ((MDialog)MDialog.class.cast(window)).reject();
        }
    }

    private MTabbedPane<ChartView<ChartModel>> getTabs() {
        if (this._tabs == null) {
            this._tabs = new MTabbedPane();
            this.remove(this.oldChartView);
            this.addCenter(this._tabs);
        }
        return this._tabs;
    }

    private void setupPainter(ChartPainter<?> chartPainter) {
        chartPainter.fxShine.no();
        chartPainter.imageScale.no();
        chartPainter.outlineBorder.no();
        chartPainter.outlineColor.set(Color.WHITE);
        chartPainter.shadowVisible.no();
        chartPainter.textAlpha.set(Float.valueOf(1.0f));
        chartPainter.textBackground.set(Color.WHITE);
        chartPainter.textFont.set(UI.createDefaultFont());
        chartPainter.textForeground.set(Color.BLACK);
        chartPainter.textLineAutoColor.yes();
        chartPainter.textLineSize.set(2);
        chartPainter.textType.set(ChartPainter.TextType.RECT);
    }
}

