/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.presentation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenuBar;
import org.makagiga.commons.MSplitPane;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MV;
import org.makagiga.commons.MainView;
import org.makagiga.commons.UI;
import org.makagiga.editors.AnnotationBar;
import org.makagiga.editors.NavigationUtils;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tools.presentation.ControlPanel;
import org.makagiga.tools.presentation.Slideshow;
import org.makagiga.tree.PropertiesBar;
import org.makagiga.tree.Tree;

public final class Presentation {
    private static boolean active;
    private boolean oldAnnotationBarVisible;
    private boolean oldEditorToolBarVisible;
    private boolean oldMainToolBarVisible;
    private boolean oldMenuBarMinimized;
    private boolean oldPropertiesBarVisible;
    private boolean oldSidebarVisible;
    private boolean oldStatusBarClosed;
    private ControlPanel bottomControlPanel;
    private ControlPanel topControlPanel;
    private static EventListenerList listeners;
    private int oldDividerSize;
    private MLabel progressLabel;
    private static Presentation _instance;
    private final Slideshow slideshow = new Slideshow(this);

    public static synchronized void addToggleListener(ToggleListener toggleListener) {
        if (toggleListener != null) {
            if (listeners == null) {
                listeners = new EventListenerList();
            }
            listeners.add(ToggleListener.class, toggleListener);
            MLogger.debug("presentation", "Add listener: %d", listeners.getListenerCount());
        }
    }

    public static synchronized boolean isActive() {
        return active;
    }

    public static synchronized void removeToggleListener(ToggleListener toggleListener) {
        if (listeners != null) {
            listeners.remove(ToggleListener.class, toggleListener);
            MLogger.debug("presentation", "Remove listener: %d", listeners.getListenerCount());
        }
    }

    public static synchronized void setActive(boolean bl) {
        if (bl) {
            if (_instance != null) {
                return;
            }
            _instance = new Presentation();
            _instance.start();
            active = true;
            Presentation.fireToggleEvent(true);
        } else {
            if (_instance == null) {
                return;
            }
            _instance.stop();
            active = false;
            Presentation.fireToggleEvent(false);
            _instance = null;
        }
    }

    private Presentation() {
    }

    private static void fireToggleEvent(boolean bl) {
        if (listeners == null) {
            return;
        }
        ToggleEvent toggleEvent = new ToggleEvent(_instance, bl);
        for (ToggleListener toggleListener : (ToggleListener[])listeners.getListeners(ToggleListener.class)) {
            toggleListener.toggle(toggleEvent);
        }
    }

    private void start() {
        MLogger.debug("presentation", "Start");
        MainWindow mainWindow = MainWindow.getInstance();
        mainWindow.setFullScreen(true);
        MMenuBar mMenuBar = mainWindow.getMMenuBar();
        this.oldMenuBarMinimized = mMenuBar.isMinimized();
        mMenuBar.setMinimized(true);
        MToolBar mToolBar = (MToolBar)mainWindow.getElementById("main-tool-bar");
        this.oldMainToolBarVisible = mToolBar.isVisible();
        mToolBar.setVisible(false);
        AnnotationBar annotationBar = AnnotationBar.getInstance();
        this.oldAnnotationBarVisible = annotationBar.isVisible();
        annotationBar.setVisible(false);
        MToolBar mToolBar2 = (MToolBar)mainWindow.getElementById("editor-tool-bar");
        if (mToolBar2 != null) {
            this.oldEditorToolBarVisible = mToolBar2.isVisible();
            mToolBar2.setVisible(false);
        } else {
            this.oldEditorToolBarVisible = true;
        }
        boolean bl = this.oldPropertiesBarVisible = PropertiesBar.isInstance() && PropertiesBar.getInstance().isVisible();
        if (this.oldPropertiesBarVisible) {
            PropertiesBar.getInstance().setVisible(false);
        }
        MSplitPane mSplitPane = (MSplitPane)mainWindow.getElementById("main-split-pane");
        this.oldDividerSize = mSplitPane.getDividerSize();
        mSplitPane.setDividerSize(0);
        this.oldSidebarVisible = mSplitPane.isSidebarVisible();
        mSplitPane.setSidebarVisible(false);
        MStatusBar mStatusBar = MainView.getStatusBar();
        this.oldStatusBarClosed = mStatusBar.isClosed();
        mStatusBar.setClosed(true);
        Tabs.getInstance().setTabHeaderVisible(false);
        this.topControlPanel = new ControlPanel();
        MLabel mLabel = new MLabel(MApplication.getFullName(), "makagiga");
        mLabel.setStyle("margin: 0 5 0 5");
        this.topControlPanel.addLabel(mLabel);
        if (((Boolean)Vars.actionPresentation.get()).booleanValue()) {
            this.topControlPanel.addAction(new MAction(UI._("Exit Presentation Mode"), "ui/close"){

                @Override
                public void onAction() {
                    Presentation.setActive(false);
                }
            });
        }
        this.topControlPanel.readConfig("presentation-top");
        this.topControlPanel.showAtPosition(UI.VerticalPosition.TOP, UI.HorizontalPosition.RIGHT);
        this.bottomControlPanel = new ControlPanel();
        this.progressLabel = new MLabel();
        this.progressLabel.setStyle("margin: 0 5 0 5");
        this.bottomControlPanel.addLabel(this.progressLabel);
        this.slideshow.install(this.bottomControlPanel);
        this.bottomControlPanel.addAction(NavigationUtils.getPreviousAction()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Presentation.this.updateProgressLabel(-1);
                Presentation.this.bottomControlPanel.forceRepaint();
            }
        });
        this.bottomControlPanel.addAction(NavigationUtils.getNextAction(), 1).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Presentation.this.updateProgressLabel(1);
                Presentation.this.bottomControlPanel.forceRepaint();
            }
        });
        this.bottomControlPanel.readConfig("presentation-bottom");
        this.bottomControlPanel.showAtPosition(UI.VerticalPosition.BOTTOM, UI.HorizontalPosition.RIGHT);
        this.updateProgressLabel(0);
    }

    private void stop() {
        MLogger.debug("presentation", "Stop");
        this.slideshow.setActive(false);
        MainWindow mainWindow = MainWindow.getInstance();
        mainWindow.setFullScreen(false);
        MMenuBar mMenuBar = mainWindow.getMMenuBar();
        mMenuBar.setMinimized(this.oldMenuBarMinimized);
        MToolBar mToolBar = (MToolBar)mainWindow.getElementById("main-tool-bar");
        mToolBar.setVisible(this.oldMainToolBarVisible);
        AnnotationBar annotationBar = AnnotationBar.getInstance();
        annotationBar.setVisible(this.oldAnnotationBarVisible);
        MToolBar mToolBar2 = (MToolBar)mainWindow.getElementById("editor-tool-bar");
        if (mToolBar2 != null) {
            mToolBar2.setVisible(this.oldEditorToolBarVisible);
        }
        if (this.oldPropertiesBarVisible && PropertiesBar.isInstance()) {
            PropertiesBar.getInstance().setVisible(true);
        }
        MSplitPane mSplitPane = (MSplitPane)mainWindow.getElementById("main-split-pane");
        mSplitPane.setDividerSize(this.oldDividerSize);
        mSplitPane.setSidebarVisible(this.oldSidebarVisible);
        MainView.getStatusBar().setClosed(this.oldStatusBarClosed);
        Tabs.getInstance().setTabHeaderVisible(true);
        this.topControlPanel.dispose();
        this.bottomControlPanel.dispose();
    }

    void showControlPanels() {
        this.topControlPanel.doShow(false);
        this.bottomControlPanel.doShow(false);
    }

    void updateBounds() {
        this.bottomControlPanel.pack();
        this.bottomControlPanel.setHorizontalPosition(UI.HorizontalPosition.RIGHT);
    }

    void updateProgressLabel(int n) {
        MetaInfo metaInfo = Tabs.getInstance().getCurrentMetaInfo();
        if (metaInfo == null) {
            this.progressLabel.setVisible(false);
            return;
        }
        MetaInfo metaInfo2 = Tree.getInstance().getCurrentFolder(true);
        int n2 = 0;
        int n3 = 0;
        for (MetaInfo metaInfo3 : metaInfo2.list(MV.VIEW)) {
            if (metaInfo3.isAnyFile()) {
                ++n2;
            }
            if (metaInfo3 != metaInfo) continue;
            n3 = n2;
        }
        if (n2 == 0) {
            this.progressLabel.setVisible(false);
        } else {
            n3 += n;
            if (this.slideshow.stopIcon != null) {
                this.slideshow.stopIcon.setMaximum(n2);
                this.slideshow.stopIcon.setValue(n3);
            }
            this.progressLabel.setText(n3 + " / " + n2);
            this.progressLabel.setVisible(true);
        }
        this.updateBounds();
    }

    public static interface ToggleListener
    extends EventListener {
        public void toggle(ToggleEvent var1);
    }

    public static class ToggleEvent
    extends EventObject {
        private final boolean active;

        public ToggleEvent(Object object, boolean bl) {
            super(object);
            this.active = bl;
        }

        public boolean isActive() {
            return this.active;
        }
    }

    public static final class Action
    extends MAction {
        public Action() {
            super(UI._("Presentation"), "ui/presentation", 80, 3);
            if (!((Boolean)Vars.actionPresentation.get()).booleanValue()) {
                this.setEnabled(false);
            }
            this.setHTMLHelp(UI._("Switch to full screen \"presentation view\" or start Slideshow."));
        }

        @Override
        public void onAction() {
            if (((Boolean)Vars.actionPresentation.get()).booleanValue()) {
                Presentation.setActive(!Presentation.isActive());
            }
        }
    }
}

