/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.backup;

import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.makagiga.commons.Benchmark;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.Checksum;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileScanner;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MProgressBar;
import org.makagiga.commons.MTextLabel;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.MWizardDialog;
import org.makagiga.commons.MZip;
import org.makagiga.commons.OS;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.form.PropertyPanel;

public final class BackupDialog
extends MWizardDialog
implements ChangeListener {
    private final Benchmark benchmark = new Benchmark();
    private final BooleanProperty backupFeedArchive = new BooleanProperty(true);
    private File archiveFile;
    private int totalFiles;
    private JComponent backupFeedArchiveComponent;
    private final MDate backupDate;
    private MFileChooser fileChooser;
    private final MLogger log = MLogger.get("backup");
    private MPanel summaryPanel;
    private MProgressBar progress;
    private MTextLabel checksumSummaryMD5;
    private MTextLabel checksumSummarySHA1;
    private MTextLabel sizeSummary;
    private MURLButton fileSummary;
    private MURLButton folderSummary;
    private MZip zip;
    private final Object zipLock = new Object();
    private final Set<String> excludes = new HashSet<String>();
    private final String defaultName;
    private final StringList skipped = new StringList();
    private volatile transient SwingWorker<Object, Object> worker;

    public BackupDialog(Window window) {
        super(window, UI._("Backup"), MIcon.stock("ui/save"));
        this.backupDate = MDate.now();
        this.defaultName = String.format("%s-backup-%s", MApplication.getInternalName(), this.backupDate.format("yyyy-MM-dd_HHmm"));
        this.createFileChooserPage();
        this.addPage(UI._("Options"), MIcon.stock("ui/configure"), null, this.createOptionsPane());
        this.addPage(UI._("Destination File"), MIcon.stock("ui/save"), UI._("Choose a file in which you want to save the backup"), this.fileChooser);
        this.addPage(UI._("Progress"), MIcon.stock("ui/right"), UI._("Creating backup..."), this.createProgressPage());
        this.packFixed();
        this.backupFeedArchiveComponent.requestFocusInWindow();
        this.addChangeListener(this);
    }

    @Override
    @Deprecated
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.isDone()) {
            return;
        }
        FileChooserUI fileChooserUI = this.fileChooser.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            Action action = ((BasicFileChooserUI)BasicFileChooserUI.class.cast(fileChooserUI)).getApproveSelectionAction();
            MAction.fire(action, (Object)this.fileChooser);
        }
        this.fileChooser.saveConfig();
        this.archiveFile = this.fileChooser.getSelectedFile();
        if (this.archiveFile == null) {
            return;
        }
        if (this.archiveFile.exists() && !MMessage.confirmFileOverwrite(this, null, this.archiveFile, null)) {
            this.previousPage();
            return;
        }
        if (this.archiveFile.getPath().startsWith(FS.getConfigDir())) {
            MMessage.info(this, UI._("You cannot create backup in this directory"));
            return;
        }
        this.worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                BackupDialog.this.countTotalFiles();
                BackupDialog.this.createArchive();
                return null;
            }

            @Override
            protected void done() {
                BackupDialog.this.worker = null;
                BackupDialog.this.progress.setVisible(false);
                try {
                    if (this.isCancelled()) {
                        BackupDialog.this.doCancel();
                    } else {
                        this.get();
                        BackupDialog.this.log.info("Backup complete");
                        BackupDialog.this.setDescription(UI._("Backup complete."));
                        BackupDialog.this.showSummary();
                        if (BackupDialog.this.benchmark.elapsedSeconds() >= 10L) {
                            TK.beep();
                        }
                        Config config = Config.getDefault();
                        config.write("Backup.date", BackupDialog.this.backupDate);
                        config.write(Config.getPlatformKey("Backup.originalLocation"), FS.getConfigDir());
                        config.write("Backup.originalProfile", FS.getProfile());
                        config.sync();
                    }
                }
                catch (Exception exception) {
                    BackupDialog.this.doCancel();
                    MMessage.error((Window)BackupDialog.this, exception);
                }
                BackupDialog.this.complete();
            }
        };
        this.benchmark.begin();
        this.worker.execute();
    }

    @Override
    protected boolean onReject() {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.worker = null;
        }
        return true;
    }

    private void addExcludes(File file) {
        for (File file2 : FS.listFiles(file)) {
            String string = file2.getName();
            if (file2.isDirectory()) {
                if ((!"archive".equals(string) || ((Boolean)this.backupFeedArchive.get()).booleanValue()) && !"cache".equals(string) && !"index".equals(string)) continue;
                for (File file3 : FS.listFiles(file2)) {
                    this.excludes.add(file3.getPath());
                }
                continue;
            }
            if (!file2.isFile() || !"makagiga.lock".equals(string)) continue;
            this.excludes.add(file2.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File file) throws IOException {
        if (this.worker == null) {
            return;
        }
        String string = file.getPath();
        if (this.excludes.contains(string)) {
            this.log.debugFormat("Skipping: %s", string);
            return;
        }
        if (this.testUnreadable(file)) {
            this.log.debugFormat("Skipping unreadable: %s", string);
            return;
        }
        this.log.debugFormat("Adding: %s", string);
        String string2 = string.substring(FS.getConfigDir().length() + 1);
        Object object = this.zipLock;
        synchronized (object) {
            this.zip.addEntry(this.defaultName + "/" + string2, string);
        }
    }

    private void countTotalFiles() throws Exception {
        this.setDescription(UI._("Please Wait..."));
        this.excludes.clear();
        this.addExcludes(new File(FS.getConfigDir()));
        if (FS.getProfile() == null) {
            for (File file : FS.listFiles(FS.makeConfigFile("profiles"))) {
                this.addExcludes(file);
            }
        }
        this.totalFiles = 0;
        new FileScanner.Simple(FS.getConfigDir()){

            @Override
            public void processFile(File file) throws Exception {
                BackupDialog.this.totalFiles++;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackupDialog.this.progress.setMinimum(0);
                BackupDialog.this.progress.setMaximum(BackupDialog.this.totalFiles);
            }
        });
    }

    private void createArchive() throws Exception {
        this.setDescription(UI._("Creating backup..."));
        try {
            this.log.infoFormat("Creating archive: \"%s\"", this.archiveFile);
            this.zip = MZip.write(this.archiveFile);
            this.zip.beginEntry("MAKAGIGA BACKUP INFO.html");
            HTMLBuilder hTMLBuilder = new HTMLBuilder();
            hTMLBuilder.beginHTML(UI._("Backup"), "UTF-8");
            hTMLBuilder.beginStyle();
            hTMLBuilder.beginRule("table");
            hTMLBuilder.addAttr("border-collapse", "collapse");
            hTMLBuilder.endRule();
            hTMLBuilder.beginRule("td");
            hTMLBuilder.addAttr("border", "1px solid black");
            hTMLBuilder.addAttr("padding", "5px");
            hTMLBuilder.endRule();
            hTMLBuilder.beginRule("thead td");
            hTMLBuilder.addAttr("font-weight", "bold");
            hTMLBuilder.endRule();
            hTMLBuilder.endStyle();
            hTMLBuilder.beginDoc();
            hTMLBuilder.addHeader(1, HTMLBuilder.escape(UI._("Backup")));
            hTMLBuilder.beginTag("table");
            hTMLBuilder.beginTag("thead");
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(UI._("Name")), new Object[0]);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(UI._("Value")), new Object[0]);
            hTMLBuilder.endTag("tr");
            hTMLBuilder.endTag("thead");
            hTMLBuilder.beginTag("tbody");
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(UI._("Date")), new Object[0]);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(this.backupDate.formatDateTime(0, 3)), new Object[0]);
            hTMLBuilder.endTag("tr");
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(UI._("User")), new Object[0]);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(OS.getUserName()), new Object[0]);
            hTMLBuilder.endTag("tr");
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(UI._("Configuration & Data Directory")), new Object[0]);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(FS.getConfigDir()), new Object[0]);
            hTMLBuilder.endTag("tr");
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(UI._("Profile")), new Object[0]);
            if (FS.getProfile() == null) {
                hTMLBuilder.doubleTag("td", "<i>" + HTMLBuilder.escape(UI._("Default")) + "</i>", new Object[0]);
            } else {
                hTMLBuilder.doubleTag("td", HTMLBuilder.escape(FS.getProfile()), new Object[0]);
            }
            hTMLBuilder.endTag("tr");
            hTMLBuilder.endTag("tbody");
            hTMLBuilder.endTag("table");
            hTMLBuilder.endDoc();
            hTMLBuilder.save(this.zip.getOutputStream(), false);
            new FileScanner.Simple(FS.getConfigDir()){

                @Override
                public void processDir(File file) throws Exception {
                    BackupDialog.this.testUnreadable(file);
                }

                @Override
                public void processFile(final File file) throws Exception {
                    BackupDialog.this.addFile(file);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BackupDialog.this.progress.setString(TK.centerSqueeze(file.getPath()));
                            BackupDialog.this.progress.step();
                        }
                    });
                }
            };
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            throw new Exception(UI._("Could not save file"), iOException);
        }
        finally {
            FS.close(this.zip);
        }
    }

    private void createFileChooserPage() {
        this.fileChooser = new MFileChooser();
        this.fileChooser.addFilter(UI._("Zip Archive"), "zip");
        this.fileChooser.setApproveText(UI._("Create"));
        this.fileChooser.setConfigKey("backup");
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.setSelectedPath(FS.makePath(this.fileChooser.getCurrentDir(), this.defaultName + ".zip"));
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                File file;
                String string = propertyChangeEvent.getPropertyName();
                if ("directoryChanged".equals(string)) {
                    File file2 = (File)propertyChangeEvent.getNewValue();
                    if (file2 != null && file2.isDirectory() && !file2.equals(BackupDialog.this.fileChooser.getSelectedFile())) {
                        BackupDialog.this.fileChooser.setSelectedPath(FS.makePath(file2.getPath(), BackupDialog.this.defaultName + ".zip"));
                    }
                } else if ("SelectedFileChangedProperty".equals(string) && (file = (File)propertyChangeEvent.getNewValue()) != null && file.isFile() && !file.equals(BackupDialog.this.fileChooser.getSelectedFile())) {
                    BackupDialog.this.fileChooser.setSelectedFile(file);
                }
            }
        });
    }

    private MPanel createOptionsPane() {
        PropertyPanel propertyPanel = new PropertyPanel(10);
        propertyPanel.addStretch();
        this.backupFeedArchiveComponent = propertyPanel.bind(this.backupFeedArchive, UI._("Backup RSS feed archive"));
        propertyPanel.addStretch();
        Config config = Config.getDefault();
        MDate mDate = config.readDate("Backup.date", null);
        if (mDate.isValid()) {
            String string = mDate.fancyFormat(0, true);
            propertyPanel.add(MLabel.createSmall(UI._("Last Backup Date: {0}", string), MIcon.small("ui/calendar")));
        }
        return propertyPanel;
    }

    private MPanel createProgressPage() {
        MPanel mPanel = MPanel.createVBoxPanel();
        mPanel.setContentMargin();
        mPanel.addStretch();
        this.progress = new MProgressBar();
        this.progress.setString("");
        this.progress.setStringPainted(true);
        mPanel.add(this.progress);
        this.createSummaryPanel();
        mPanel.add(this.summaryPanel);
        mPanel.addStretch();
        return mPanel;
    }

    private void createSummaryPanel() {
        this.summaryPanel = MPanel.createVBoxPanel();
        this.summaryPanel.addSeparator(UI._("Summary"));
        this.fileSummary = new MURLButton();
        this.fileSummary.setShowLinkActions(false);
        this.summaryPanel.add(MPanel.createHLabelPanel(this.fileSummary, UI._("File:")));
        this.folderSummary = new MURLButton();
        this.folderSummary.setShowLinkActions(false);
        this.summaryPanel.add(MPanel.createHLabelPanel(this.folderSummary, UI._("Folder:")));
        this.sizeSummary = new MTextLabel();
        this.summaryPanel.add(MPanel.createHLabelPanel(this.sizeSummary, UI._("Size:")));
        this.summaryPanel.addSeparator(UI._("Advanced"));
        this.checksumSummaryMD5 = new MTextLabel();
        this.summaryPanel.add(MPanel.createHLabelPanel(this.checksumSummaryMD5, UI._("{0} checksum:", "MD5")));
        this.checksumSummarySHA1 = new MTextLabel();
        this.summaryPanel.add(MPanel.createHLabelPanel(this.checksumSummarySHA1, UI._("{0} checksum:", "SHA1")));
        this.summaryPanel.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel() {
        this.log.warning("Backup cancelled");
        this.setDescription(UI._("Backup cancelled."));
        Object object = this.zipLock;
        synchronized (object) {
            if (this.zip != null) {
                FS.close(this.zip);
            }
        }
        this.archiveFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSummary() {
        this.fileSummary.setURLAndText(this.archiveFile.getPath());
        File file = this.archiveFile.getParentFile();
        if (file == null) {
            this.folderSummary.setVisible(false);
        } else {
            this.folderSummary.setURLAndText(file.getPath());
            this.folderSummary.setVisible(true);
        }
        this.sizeSummary.setText(MFormat.toAutoSize(this.archiveFile.length()));
        try {
            UI.setWaitCursor(this, true);
            this.checksumSummaryMD5.setText(Checksum.get("md5", this.archiveFile).toString());
            this.checksumSummarySHA1.setText(Checksum.get("sha1", this.archiveFile).toString());
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            this.checksumSummaryMD5.setVisible(false);
            this.checksumSummarySHA1.setVisible(false);
        }
        finally {
            UI.setWaitCursor(this, false);
        }
        if (!this.skipped.isEmpty()) {
            this.summaryPanel.addGap();
            MList<String> mList = new MList<String>();
            mList.addAllItems(this.skipped);
            this.summaryPanel.add(MPanel.createVLabelPanel(mList, UI._("Skipped files:")));
        }
        this.summaryPanel.alignLabels();
        this.summaryPanel.limitHeight();
        this.summaryPanel.setVisible(true);
    }

    private boolean testUnreadable(File file) {
        if (!file.canRead()) {
            this.skipped.add(UI._("{0} (no permissions to read)", file));
            return true;
        }
        return false;
    }
}

