/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import org.makagiga.Tabs;
import org.makagiga.commons.HistoryManager;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.UI;
import org.makagiga.commons.WebBrowser;
import org.makagiga.editors.WebBrowserEditor;

public final class Browser
extends WebBrowserEditor {
    private WebBrowser.LinkListener linkListener;

    @Override
    public void onClose() {
        if (this.browser != null) {
            this.browser.removeLinkListener(this.linkListener);
            this.linkListener = null;
        }
        super.onClose();
    }

    public static Browser getInstance() {
        Tabs tabs = Tabs.getInstance();
        Browser browser = tabs.findEditor(Browser.class);
        if (browser == null) {
            browser = new Browser();
            tabs.addEditor(browser);
        } else {
            tabs.selectEditor(browser);
            tabs.fireStateChanged();
        }
        return browser;
    }

    public static void openURL(String string) {
        try {
            Browser.getInstance().getWebBrowser().setDocument(string);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
    }

    @Override
    public int getPrintingCapabilities() {
        return super.getPrintingCapabilities();
    }

    private Browser() {
        this.setMetaInfo(UI._("Browser"), MIcon.stock("ui/misc"));
        this.linkListener = new WebBrowser.LinkListener(){

            @Override
            public boolean linkEvent(HyperlinkEvent hyperlinkEvent) {
                String string = hyperlinkEvent.getDescription();
                URL uRL = hyperlinkEvent.getURL();
                if (string != null && string.startsWith("#")) {
                    HistoryManager historyManager;
                    if (uRL != null && (historyManager = (HistoryManager)Browser.this.browser.getProperty("org.makagiga.commons.WebBrowser.HISTORY_MANAGER")) != null) {
                        historyManager.add(uRL.toString());
                    }
                    return true;
                }
                if (uRL == null) {
                    Browser.this.browser.setDocument(string);
                    return true;
                }
                if (uRL.getProtocol().equals("file")) {
                    Browser.this.browser.setDocument(uRL.toString());
                    return true;
                }
                return false;
            }
        };
        this.browser.addLinkListener(this.linkListener);
    }
}

