/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import javax.swing.JTable;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.MDate;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.it.I;
import org.makagiga.todo.Task;

public enum Column {
    DONE(UI._("Done"), 30, Boolean.class),
    SUMMARY(UI._("Summary"), 350, String.class),
    PRIORITY(UI._("Priority"), 100, Integer.class),
    COMPLETE(UI._("Complete"), 50, Integer.class),
    DATE_TIME(UI._("Due Date/Time"), 200, MDate.class),
    START_DATE_TIME(UI._("Start Date/Time"), 200, MDate.class),
    COMPLETE_DATE_TIME(UI._("Completed Date/Time"), 200, MDate.class),
    CATEGORY(UI._("Category"), 200, String.class),
    CIRCLE(UI._("Circle"), 40, Task.class);

    private final Class<?> clazz;
    private final int preferredWidth;
    private final String name;
    private static AbstractListTableModel.ColumnInfo[] columnInfo;

    public Class<?> getColumnClass() {
        return this.clazz;
    }

    public static synchronized AbstractListTableModel.ColumnInfo[] getColumnInfo() {
        if (columnInfo == null) {
            Column[] columnArray = Column.values();
            columnInfo = new AbstractListTableModel.ColumnInfo[columnArray.length];
            for (I<Column> i : I.of(columnArray)) {
                Column column = i.v();
                Column.columnInfo[i.i()] = new AbstractListTableModel.ColumnInfo(i.toString(), column.getColumnClass(), column != COMPLETE_DATE_TIME, column.name());
                columnInfo[i.i()].setPreferredWidth(column.preferredWidth);
            }
        }
        return TK.copyOf(columnInfo);
    }

    public String getHTMLAlign() {
        switch (this) {
            case DONE: 
            case COMPLETE: 
            case CIRCLE: {
                return "center";
            }
        }
        return "left";
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public boolean isLast() {
        return this.ordinal() == Column.values().length - 1;
    }

    public String toString() {
        return this.name;
    }

    public int toView(JTable jTable) {
        return jTable.convertColumnIndexToView(this.ordinal());
    }

    private Column(String string2, int n2, Class<?> clazz) {
        this.clazz = clazz;
        this.preferredWidth = n2;
        this.name = string2;
    }
}

